/*
 * Decompiled with CFR 0.152.
 */
package io.smartcat.cassandra.diagnostics.connector;

import com.datastax.driver.core.BatchStatement;
import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.ResultSetFuture;
import com.datastax.driver.core.Statement;
import io.smartcat.cassandra.diagnostics.GlobalConfiguration;
import io.smartcat.cassandra.diagnostics.Query;
import io.smartcat.cassandra.diagnostics.connector.AbstractEventProcessor;
import io.smartcat.cassandra.diagnostics.connector.ConnectorConfiguration;
import io.smartcat.cassandra.diagnostics.connector.QueryReporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecuteStatementWrapper
extends AbstractEventProcessor {
    private static final Logger logger = LoggerFactory.getLogger(ExecuteStatementWrapper.class);
    private final String host;

    public ExecuteStatementWrapper(QueryReporter queryReporter, ConnectorConfiguration configuration, GlobalConfiguration globalConfiguration) {
        super(queryReporter, configuration);
        this.host = globalConfiguration.hostname;
    }

    public void processStatement(Statement statement, long startTime, ResultSetFuture result) {
        this.report(startTime, statement, result);
    }

    private void report(final long startTime, final Statement statement, final ResultSetFuture result) {
        this.report(new Runnable(){

            @Override
            public void run() {
                try {
                    result.getUninterruptibly();
                    long execTime = System.currentTimeMillis() - startTime;
                    Query query = ExecuteStatementWrapper.this.extractQuery(startTime, execTime, statement);
                    logger.trace("Reporting query: {}.", (Object)query);
                    ExecuteStatementWrapper.this.queryReporter.report(query);
                }
                catch (Exception e) {
                    logger.warn("An error occured while reporting query", (Throwable)e);
                }
            }
        });
    }

    private Query extractQuery(long startTime, long execTime, Statement statement) {
        String queryString = this.statementQueryString(statement);
        Query.StatementType queryType = this.queryType(queryString);
        return Query.create(startTime, execTime, this.host, queryType, statement.getKeyspace(), "", queryString, this.extractConsistencyLevel(statement));
    }

    private String statementQueryString(Statement statement) {
        String query = statement instanceof RegularStatement ? this.statementQueryString((RegularStatement)statement) : (statement instanceof BoundStatement ? this.statementQueryString((BoundStatement)statement) : (statement instanceof BatchStatement ? this.statementQueryString((BatchStatement)statement) : "unknown;"));
        return query;
    }

    private String statementQueryString(RegularStatement statement) {
        return statement.getQueryString() + ";";
    }

    private String statementQueryString(BoundStatement statement) {
        return statement.preparedStatement().getQueryString() + ";";
    }

    private String statementQueryString(BatchStatement batchStatement) {
        StringBuffer sb = new StringBuffer();
        sb.append("BEGIN BATCH ");
        for (Statement statement : batchStatement.getStatements()) {
            sb.append(this.statementQueryString(statement));
        }
        sb.append(" APPLY BATCH;");
        return sb.toString();
    }

    private Query.StatementType queryType(String query) {
        String normalizedQuery = query.toUpperCase();
        Query.StatementType type = normalizedQuery.toUpperCase().startsWith("SELECT") ? Query.StatementType.SELECT : (normalizedQuery.startsWith("INSERT") || normalizedQuery.startsWith("UPDATE") || normalizedQuery.startsWith("BEGIN") ? Query.StatementType.UPDATE : Query.StatementType.UNKNOWN);
        return type;
    }

    private Query.ConsistencyLevel extractConsistencyLevel(Statement statement) {
        if (statement.getConsistencyLevel() == null) {
            return Query.ConsistencyLevel.UNKNOWN;
        }
        Query.ConsistencyLevel queryConsistencyLevel = Query.ConsistencyLevel.UNKNOWN;
        for (Query.ConsistencyLevel consistencyLevel : Query.ConsistencyLevel.values()) {
            if (!consistencyLevel.name().equals(statement.getConsistencyLevel().name())) continue;
            queryConsistencyLevel = consistencyLevel;
            break;
        }
        return queryConsistencyLevel;
    }
}

