/*
 * Decompiled with CFR 0.152.
 */
package io.smartcat.cassandra.diagnostics.utils;

import java.util.NoSuchElementException;
import java.util.Objects;

public class Option<T> {
    private static final Option<?> EMPTY = new Option();
    public final T value;

    private Option() {
        this.value = null;
    }

    public static <T> Option<T> empty() {
        Option<?> val = EMPTY;
        return val;
    }

    private Option(T value) {
        this.value = Objects.requireNonNull(value);
    }

    public static <T> Option<T> of(T value) {
        return new Option<T>(value);
    }

    public static <T> Option<T> ofNullable(T value) {
        return value == null ? Option.empty() : Option.of(value);
    }

    public T getValue() {
        if (this.value == null) {
            throw new NoSuchElementException("No value present");
        }
        return this.value;
    }

    public boolean hasValue() {
        return this.value != null;
    }

    public T getOrDefault(T defaultValue) {
        return this.value != null ? this.value : defaultValue;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Option)) {
            return false;
        }
        Option other = (Option)obj;
        return Objects.equals(this.value, other.value);
    }

    public int hashCode() {
        return Objects.hashCode(this.value);
    }

    public String toString() {
        return this.value != null ? String.format("Option[%s]", this.value) : "Option.empty";
    }
}

