/*
 * Decompiled with CFR 0.152.
 */
package io.smartup.localstack;

import com.amazon.sqs.javamessaging.SQSConnectionFactory;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBStreams;
import com.amazonaws.services.kinesis.AmazonKinesis;
import com.amazonaws.services.lambda.AWSLambda;
import com.amazonaws.services.route53.AmazonRoute53;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.simpleemail.AmazonSimpleEmailService;
import com.amazonaws.services.simplesystemsmanagement.AWSSimpleSystemsManagement;
import io.smartup.localstack.LocalStackHostProvider;
import io.smartup.localstack.configurator.AmazonDynamoDbConfigurator;
import io.smartup.localstack.configurator.AmazonDynamoDbStreamsConfigurator;
import io.smartup.localstack.configurator.AmazonKinesisConfigurator;
import io.smartup.localstack.configurator.AmazonLambdaConfigurator;
import io.smartup.localstack.configurator.AmazonRoute53Configurator;
import io.smartup.localstack.configurator.AmazonS3Configurator;
import io.smartup.localstack.configurator.AmazonSESConfigurator;
import io.smartup.localstack.configurator.AmazonSNSConfigurator;
import io.smartup.localstack.configurator.AmazonSQSConfigurator;
import io.smartup.localstack.configurator.AmazonSSMConfigurator;
import io.smartup.localstack.configurator.SQSConnectionFactoryConfigurator;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(prefix="localstack", name={"enabled"}, havingValue="true")
public class LocalStackAutoConfiguration {
    @Bean
    public LocalStackHostProvider localStackHostProvider() {
        return new LocalStackHostProvider();
    }

    @Configuration
    @ConditionalOnProperty(prefix="localstack", name={"lambda.enabled"}, havingValue="true")
    @ConditionalOnBean(value={AWSLambda.class})
    public static class AmazonLambdaConfiguration {
        @Bean
        public AmazonLambdaConfigurator amazonLambdaConfigurator() {
            return new AmazonLambdaConfigurator();
        }
    }

    @Configuration
    @ConditionalOnProperty(prefix="localstack", name={"ssm.enabled"}, havingValue="true")
    @ConditionalOnBean(value={AWSSimpleSystemsManagement.class})
    public static class AmazonSSMConfiguration {
        @Bean
        public AmazonSSMConfigurator amazonSSMConfigurator() {
            return new AmazonSSMConfigurator();
        }
    }

    @Configuration
    @ConditionalOnProperty(prefix="localstack", name={"kinesis.enabled"}, havingValue="true")
    @ConditionalOnBean(value={AmazonKinesis.class})
    public static class AmazonKinesisConfiguration {
        @Bean
        public AmazonKinesisConfigurator amazonKinesisConfigurator() {
            return new AmazonKinesisConfigurator();
        }
    }

    @Configuration
    @ConditionalOnProperty(prefix="localstack", name={"dynamodb-streams.enabled"}, havingValue="true")
    @ConditionalOnBean(value={AmazonDynamoDBStreams.class})
    public static class AmazonDynamoDbStreamsConfiguration {
        @Bean
        public AmazonDynamoDbStreamsConfigurator amazonDynamoDbStreamsConfigurator() {
            return new AmazonDynamoDbStreamsConfigurator();
        }
    }

    @Configuration
    @ConditionalOnProperty(prefix="localstack", name={"sqs.enabled"}, havingValue="true")
    @ConditionalOnBean(value={SQSConnectionFactory.class})
    public static class SQSConnectionFactoryConfiguration {
        @Bean
        public SQSConnectionFactoryConfigurator sqsConnectionFactoryConfigurator() {
            return new SQSConnectionFactoryConfigurator();
        }
    }

    @Configuration
    @ConditionalOnProperty(prefix="localstack", name={"ses.enabled"}, havingValue="true")
    @ConditionalOnBean(value={AmazonSimpleEmailService.class})
    public static class AmazonSESConfiguration {
        @Bean
        public AmazonSESConfigurator amazonSESConfigurator() {
            return new AmazonSESConfigurator();
        }
    }

    @Configuration
    @ConditionalOnProperty(prefix="localstack", name={"route53.enabled"}, havingValue="true")
    @ConditionalOnBean(value={AmazonRoute53.class})
    public static class AmazonRoute53Configuration {
        @Bean
        public AmazonRoute53Configurator amazonRoute53Configurator() {
            return new AmazonRoute53Configurator();
        }
    }

    @Configuration
    @ConditionalOnProperty(prefix="localstack", name={"sns.enabled"}, havingValue="true")
    public static class AmazonSNSConfiguration {
        @Bean
        public AmazonSNSConfigurator amazonSNSConfigurator() {
            return new AmazonSNSConfigurator();
        }
    }

    @Configuration
    @ConditionalOnProperty(prefix="localstack", name={"dynamodb.enabled"}, havingValue="true")
    @ConditionalOnBean(value={AmazonDynamoDB.class})
    public static class AmazonDynamoDbConfiguration {
        @Bean
        public AmazonDynamoDbConfigurator amazonDynamoDbConfigurator() {
            return new AmazonDynamoDbConfigurator();
        }
    }

    @Configuration
    @ConditionalOnProperty(prefix="localstack", name={"sqs.enabled"}, havingValue="true")
    public static class AmazonSQSConfiguration {
        @Bean
        public AmazonSQSConfigurator amazonSQSConfigurator() {
            return new AmazonSQSConfigurator();
        }
    }

    @Configuration
    @ConditionalOnProperty(prefix="localstack", name={"s3.enabled"}, havingValue="true")
    @ConditionalOnClass(value={AmazonS3.class})
    public static class AmazonS3Configuration {
        @Bean
        public AmazonS3Configurator amazonS3Configurator() {
            return new AmazonS3Configurator();
        }
    }
}

