/*
 * Decompiled with CFR 0.152.
 */
package io.smartup.localstack;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalStackHostProvider {
    private static final Logger log = LoggerFactory.getLogger(LocalStackHostProvider.class);
    private static final String LOCALSTACK_ADDRESS = "localstack";
    private static final String FALLBACK_ADDRESS = "localhost";

    public String provideLocalStackHost() {
        String localStackAddress = null;
        try {
            log.info("Trying to resolve localstack hostname=localstack");
            InetAddress inetAddress = InetAddress.getByName(LOCALSTACK_ADDRESS);
            log.info("Successfully resolved localstack hostname=localstack");
            localStackAddress = LOCALSTACK_ADDRESS;
        }
        catch (UnknownHostException e) {
            log.info("Unable to resolve 'localstack' as hostname");
        }
        if (localStackAddress == null) {
            log.info("Falling back to fallback hostname=localhost");
            return FALLBACK_ADDRESS;
        }
        log.info("Providing localstack hostname=" + localStackAddress);
        return localStackAddress;
    }
}

