/*
 * Decompiled with CFR 0.152.
 */
package io.smartup.localstack.configurator;

import com.amazonaws.regions.Region;
import io.smartup.localstack.LocalStackHostProvider;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.annotation.PostConstruct;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.util.ReflectionUtils;

public abstract class AbstractAmazonClientConfigurator<T>
implements ApplicationContextAware,
BeanPostProcessor {
    private ApplicationContext applicationContext;
    protected boolean immutable;
    @Autowired
    private LocalStackHostProvider localStackHostProvider;
    @Value(value="${localstack.use-ssl:false}")
    private boolean useSsl;

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    protected final String getLocalStackHost(int port) {
        String protocol = this.useSsl ? "https://" : "http://";
        return protocol + this.localStackHostProvider.provideLocalStackHost() + ":" + port;
    }

    protected T getBean() {
        return (T)this.applicationContext.getBean(this.getAmazonClientClass());
    }

    public abstract Class<T> getAmazonClientClass();

    public abstract String getEndpoint();

    public abstract Region getRegion();

    @PostConstruct
    protected T setup() {
        T amazonBean = this.getBean();
        Method setRegion = ReflectionUtils.findMethod(amazonBean.getClass(), (String)"setRegion", (Class[])new Class[]{Region.class});
        Method setEndpoint = ReflectionUtils.findMethod(amazonBean.getClass(), (String)"setEndpoint", (Class[])new Class[]{String.class});
        this.preProcessBean(amazonBean);
        if (setRegion != null && setEndpoint != null) {
            ReflectionUtils.invokeMethod((Method)setRegion, amazonBean, (Object[])new Object[]{this.getRegion()});
            ReflectionUtils.invokeMethod((Method)setEndpoint, amazonBean, (Object[])new Object[]{this.getEndpoint()});
        }
        this.postProcessBean(amazonBean);
        return amazonBean;
    }

    protected void preProcessBean(T amazonBean) {
        Field isImmutable = ReflectionUtils.findField(amazonBean.getClass(), (String)"isImmutable");
        if (isImmutable != null) {
            isImmutable.setAccessible(true);
            this.immutable = (Boolean)ReflectionUtils.getField((Field)isImmutable, amazonBean);
            ReflectionUtils.setField((Field)isImmutable, amazonBean, (Object)false);
            isImmutable.setAccessible(false);
        }
    }

    protected void postProcessBean(T amazonBean) {
        Field isImmutable = ReflectionUtils.findField(amazonBean.getClass(), (String)"isImmutable");
        if (isImmutable != null) {
            isImmutable.setAccessible(true);
            ReflectionUtils.setField((Field)isImmutable, amazonBean, (Object)this.immutable);
            isImmutable.setAccessible(false);
        }
    }
}

