/*
 * Decompiled with CFR 0.152.
 */
package io.smartup.localstack.configurator;

import com.amazonaws.regions.Region;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.sqs.AmazonSQS;
import com.amazonaws.services.sqs.buffered.AmazonSQSBufferedAsyncClient;
import io.smartup.localstack.configurator.AbstractAmazonClientConfigurator;
import java.lang.reflect.Field;
import org.springframework.util.ReflectionUtils;

public class AmazonSQSConfigurator
extends AbstractAmazonClientConfigurator<AmazonSQS> {
    @Override
    public Class<AmazonSQS> getAmazonClientClass() {
        return AmazonSQS.class;
    }

    @Override
    public String getEndpoint() {
        return this.getLocalStackHost(4576);
    }

    @Override
    public Region getRegion() {
        return Region.getRegion((Regions)Regions.DEFAULT_REGION);
    }

    @Override
    protected void preProcessBean(AmazonSQS amazonBean) {
        if (amazonBean instanceof AmazonSQSBufferedAsyncClient) {
            this.setImmutable((AmazonSQSBufferedAsyncClient)amazonBean, false);
        } else {
            super.preProcessBean(amazonBean);
        }
    }

    @Override
    protected void postProcessBean(AmazonSQS amazonBean) {
        if (amazonBean instanceof AmazonSQSBufferedAsyncClient) {
            this.setImmutable((AmazonSQSBufferedAsyncClient)amazonBean, this.immutable);
        } else {
            super.postProcessBean(amazonBean);
        }
    }

    private boolean setImmutable(AmazonSQSBufferedAsyncClient amazonBean, boolean immutable) {
        try {
            Field fieldRealSqs = ReflectionUtils.findField(AmazonSQSBufferedAsyncClient.class, (String)"realSQS");
            fieldRealSqs.setAccessible(true);
            AmazonSQS realSqs = (AmazonSQS)fieldRealSqs.get(amazonBean);
            Field isImmutable = ReflectionUtils.findField(realSqs.getClass(), (String)"isImmutable");
            if (isImmutable != null) {
                isImmutable.setAccessible(true);
                Boolean field = (Boolean)ReflectionUtils.getField((Field)isImmutable, (Object)realSqs);
                ReflectionUtils.setField((Field)isImmutable, (Object)realSqs, (Object)immutable);
                return field;
            }
            return false;
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Can not access field from realSQS", e);
        }
    }
}

