/*
 * Smooch
 * The Smooch API is a unified interface for powering messaging in your customer experiences across every channel. Our API speeds access to new markets, reduces time to ship, eliminates complexity, and helps you build the best experiences for your customers. For more information, visit our [official documentation](https://docs.smooch.io).
 *
 * OpenAPI spec version: 3.15
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package io.smooch.client.api;

import io.smooch.client.ApiCallback;
import io.smooch.client.ApiClient;
import io.smooch.client.ApiException;
import io.smooch.client.ApiResponse;
import io.smooch.client.Configuration;
import io.smooch.client.Pair;
import io.smooch.client.ProgressRequestBody;
import io.smooch.client.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import io.smooch.client.model.AppUserBusinessSystemsResponse;
import io.smooch.client.model.AppUserChannelsResponse;
import io.smooch.client.model.AppUserLink;
import io.smooch.client.model.AppUserPreCreate;
import io.smooch.client.model.AppUserResponse;
import io.smooch.client.model.AppUserUpdate;
import io.smooch.client.model.AuthCodeResponse;
import java.io.File;
import io.smooch.client.model.LinkRequestResponse;
import io.smooch.client.model.MessageResponse;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AppUserApi {
    private ApiClient apiClient;

    public AppUserApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AppUserApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Build call for deleteAppUser
     * @param appId Identifies the app. (required)
     * @param userId Identifies the user. Can be either the smoochId or the userId. (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call deleteAppUserCall(String appId, String userId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        
        // create path and map variables
        String localVarPath = "/v1/apps/{appId}/appusers/{userId}"
            .replaceAll("\\{" + "appId" + "\\}", apiClient.escapeString(appId.toString()))
            .replaceAll("\\{" + "userId" + "\\}", apiClient.escapeString(userId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "jwt" };
        return apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
    
    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call deleteAppUserValidateBeforeCall(String appId, String userId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'appId' is set
        if (appId == null) {
            throw new ApiException("Missing the required parameter 'appId' when calling deleteAppUser(Async)");
        }
        
        // verify the required parameter 'userId' is set
        if (userId == null) {
            throw new ApiException("Missing the required parameter 'userId' when calling deleteAppUser(Async)");
        }
        
        
        com.squareup.okhttp.Call call = deleteAppUserCall(appId, userId, progressListener, progressRequestListener);
        return call;

        
        
        
        
    }

    /**
     * 
     * Delete specified app user.
     * @param appId Identifies the app. (required)
     * @param userId Identifies the user. Can be either the smoochId or the userId. (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public void deleteAppUser(String appId, String userId) throws ApiException {
        deleteAppUserWithHttpInfo(appId, userId);
    }

    /**
     * 
     * Delete specified app user.
     * @param appId Identifies the app. (required)
     * @param userId Identifies the user. Can be either the smoochId or the userId. (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Void> deleteAppUserWithHttpInfo(String appId, String userId) throws ApiException {
        com.squareup.okhttp.Call call = deleteAppUserValidateBeforeCall(appId, userId, null, null);
        return apiClient.execute(call);
    }

    /**
     *  (asynchronously)
     * Delete specified app user.
     * @param appId Identifies the app. (required)
     * @param userId Identifies the user. Can be either the smoochId or the userId. (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call deleteAppUserAsync(String appId, String userId, final ApiCallback<Void> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = deleteAppUserValidateBeforeCall(appId, userId, progressListener, progressRequestListener);
        apiClient.executeAsync(call, callback);
        return call;
    }
    /**
     * Build call for deleteAppUserProfile
     * @param appId Identifies the app. (required)
     * @param userId Identifies the user. Can be either the smoochId or the userId. (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call deleteAppUserProfileCall(String appId, String userId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        
        // create path and map variables
        String localVarPath = "/v1/apps/{appId}/appusers/{userId}/profile"
            .replaceAll("\\{" + "appId" + "\\}", apiClient.escapeString(appId.toString()))
            .replaceAll("\\{" + "userId" + "\\}", apiClient.escapeString(userId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "jwt" };
        return apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
    
    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call deleteAppUserProfileValidateBeforeCall(String appId, String userId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'appId' is set
        if (appId == null) {
            throw new ApiException("Missing the required parameter 'appId' when calling deleteAppUserProfile(Async)");
        }
        
        // verify the required parameter 'userId' is set
        if (userId == null) {
            throw new ApiException("Missing the required parameter 'userId' when calling deleteAppUserProfile(Async)");
        }
        
        
        com.squareup.okhttp.Call call = deleteAppUserProfileCall(appId, userId, progressListener, progressRequestListener);
        return call;

        
        
        
        
    }

    /**
     * 
     * Delete specified app user&#39;s profile.
     * @param appId Identifies the app. (required)
     * @param userId Identifies the user. Can be either the smoochId or the userId. (required)
     * @return AppUserResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public AppUserResponse deleteAppUserProfile(String appId, String userId) throws ApiException {
        ApiResponse<AppUserResponse> resp = deleteAppUserProfileWithHttpInfo(appId, userId);
        return resp.getData();
    }

    /**
     * 
     * Delete specified app user&#39;s profile.
     * @param appId Identifies the app. (required)
     * @param userId Identifies the user. Can be either the smoochId or the userId. (required)
     * @return ApiResponse&lt;AppUserResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<AppUserResponse> deleteAppUserProfileWithHttpInfo(String appId, String userId) throws ApiException {
        com.squareup.okhttp.Call call = deleteAppUserProfileValidateBeforeCall(appId, userId, null, null);
        Type localVarReturnType = new TypeToken<AppUserResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     *  (asynchronously)
     * Delete specified app user&#39;s profile.
     * @param appId Identifies the app. (required)
     * @param userId Identifies the user. Can be either the smoochId or the userId. (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call deleteAppUserProfileAsync(String appId, String userId, final ApiCallback<AppUserResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = deleteAppUserProfileValidateBeforeCall(appId, userId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<AppUserResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getAppUser
     * @param appId Identifies the app. (required)
     * @param userId Identifies the user. Can be either the smoochId or the userId. (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getAppUserCall(String appId, String userId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        
        // create path and map variables
        String localVarPath = "/v1/apps/{appId}/appusers/{userId}"
            .replaceAll("\\{" + "appId" + "\\}", apiClient.escapeString(appId.toString()))
            .replaceAll("\\{" + "userId" + "\\}", apiClient.escapeString(userId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "jwt" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
    
    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getAppUserValidateBeforeCall(String appId, String userId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'appId' is set
        if (appId == null) {
            throw new ApiException("Missing the required parameter 'appId' when calling getAppUser(Async)");
        }
        
        // verify the required parameter 'userId' is set
        if (userId == null) {
            throw new ApiException("Missing the required parameter 'userId' when calling getAppUser(Async)");
        }
        
        
        com.squareup.okhttp.Call call = getAppUserCall(appId, userId, progressListener, progressRequestListener);
        return call;

        
        
        
        
    }

    /**
     * 
     * Get the specified app user.
     * @param appId Identifies the app. (required)
     * @param userId Identifies the user. Can be either the smoochId or the userId. (required)
     * @return AppUserResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public AppUserResponse getAppUser(String appId, String userId) throws ApiException {
        ApiResponse<AppUserResponse> resp = getAppUserWithHttpInfo(appId, userId);
        return resp.getData();
    }

    /**
     * 
     * Get the specified app user.
     * @param appId Identifies the app. (required)
     * @param userId Identifies the user. Can be either the smoochId or the userId. (required)
     * @return ApiResponse&lt;AppUserResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<AppUserResponse> getAppUserWithHttpInfo(String appId, String userId) throws ApiException {
        com.squareup.okhttp.Call call = getAppUserValidateBeforeCall(appId, userId, null, null);
        Type localVarReturnType = new TypeToken<AppUserResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     *  (asynchronously)
     * Get the specified app user.
     * @param appId Identifies the app. (required)
     * @param userId Identifies the user. Can be either the smoochId or the userId. (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getAppUserAsync(String appId, String userId, final ApiCallback<AppUserResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getAppUserValidateBeforeCall(appId, userId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<AppUserResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getAppUserAuthCode
     * @param appId Identifies the app. (required)
     * @param userId Identifies the user. Can be either the smoochId or the userId. (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getAppUserAuthCodeCall(String appId, String userId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        
        // create path and map variables
        String localVarPath = "/v1/apps/{appId}/appusers/{userId}/authcode"
            .replaceAll("\\{" + "appId" + "\\}", apiClient.escapeString(appId.toString()))
            .replaceAll("\\{" + "userId" + "\\}", apiClient.escapeString(userId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "jwt" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
    
    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getAppUserAuthCodeValidateBeforeCall(String appId, String userId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'appId' is set
        if (appId == null) {
            throw new ApiException("Missing the required parameter 'appId' when calling getAppUserAuthCode(Async)");
        }
        
        // verify the required parameter 'userId' is set
        if (userId == null) {
            throw new ApiException("Missing the required parameter 'userId' when calling getAppUserAuthCode(Async)");
        }
        
        
        com.squareup.okhttp.Call call = getAppUserAuthCodeCall(appId, userId, progressListener, progressRequestListener);
        return call;

        
        
        
        
    }

    /**
     * 
     * Get an auth code for facilitating a channel transfer
     * @param appId Identifies the app. (required)
     * @param userId Identifies the user. Can be either the smoochId or the userId. (required)
     * @return AuthCodeResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public AuthCodeResponse getAppUserAuthCode(String appId, String userId) throws ApiException {
        ApiResponse<AuthCodeResponse> resp = getAppUserAuthCodeWithHttpInfo(appId, userId);
        return resp.getData();
    }

    /**
     * 
     * Get an auth code for facilitating a channel transfer
     * @param appId Identifies the app. (required)
     * @param userId Identifies the user. Can be either the smoochId or the userId. (required)
     * @return ApiResponse&lt;AuthCodeResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<AuthCodeResponse> getAppUserAuthCodeWithHttpInfo(String appId, String userId) throws ApiException {
        com.squareup.okhttp.Call call = getAppUserAuthCodeValidateBeforeCall(appId, userId, null, null);
        Type localVarReturnType = new TypeToken<AuthCodeResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     *  (asynchronously)
     * Get an auth code for facilitating a channel transfer
     * @param appId Identifies the app. (required)
     * @param userId Identifies the user. Can be either the smoochId or the userId. (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getAppUserAuthCodeAsync(String appId, String userId, final ApiCallback<AuthCodeResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getAppUserAuthCodeValidateBeforeCall(appId, userId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<AuthCodeResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getAppUserBusinessSystemIds
     * @param appId Identifies the app. (required)
     * @param userId Identifies the user. Can be either the smoochId or the userId. (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getAppUserBusinessSystemIdsCall(String appId, String userId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        
        // create path and map variables
        String localVarPath = "/v1/apps/{appId}/appusers/{userId}/businesssystems"
            .replaceAll("\\{" + "appId" + "\\}", apiClient.escapeString(appId.toString()))
            .replaceAll("\\{" + "userId" + "\\}", apiClient.escapeString(userId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "jwt" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
    
    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getAppUserBusinessSystemIdsValidateBeforeCall(String appId, String userId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'appId' is set
        if (appId == null) {
            throw new ApiException("Missing the required parameter 'appId' when calling getAppUserBusinessSystemIds(Async)");
        }
        
        // verify the required parameter 'userId' is set
        if (userId == null) {
            throw new ApiException("Missing the required parameter 'userId' when calling getAppUserBusinessSystemIds(Async)");
        }
        
        
        com.squareup.okhttp.Call call = getAppUserBusinessSystemIdsCall(appId, userId, progressListener, progressRequestListener);
        return call;

        
        
        
        
    }

    /**
     * 
     * Get specified app user&#39;s business system IDs.
     * @param appId Identifies the app. (required)
     * @param userId Identifies the user. Can be either the smoochId or the userId. (required)
     * @return AppUserBusinessSystemsResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public AppUserBusinessSystemsResponse getAppUserBusinessSystemIds(String appId, String userId) throws ApiException {
        ApiResponse<AppUserBusinessSystemsResponse> resp = getAppUserBusinessSystemIdsWithHttpInfo(appId, userId);
        return resp.getData();
    }

    /**
     * 
     * Get specified app user&#39;s business system IDs.
     * @param appId Identifies the app. (required)
     * @param userId Identifies the user. Can be either the smoochId or the userId. (required)
     * @return ApiResponse&lt;AppUserBusinessSystemsResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<AppUserBusinessSystemsResponse> getAppUserBusinessSystemIdsWithHttpInfo(String appId, String userId) throws ApiException {
        com.squareup.okhttp.Call call = getAppUserBusinessSystemIdsValidateBeforeCall(appId, userId, null, null);
        Type localVarReturnType = new TypeToken<AppUserBusinessSystemsResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     *  (asynchronously)
     * Get specified app user&#39;s business system IDs.
     * @param appId Identifies the app. (required)
     * @param userId Identifies the user. Can be either the smoochId or the userId. (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getAppUserBusinessSystemIdsAsync(String appId, String userId, final ApiCallback<AppUserBusinessSystemsResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getAppUserBusinessSystemIdsValidateBeforeCall(appId, userId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<AppUserBusinessSystemsResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getAppUserEntityIds
     * @param appId Identifies the app. (required)
     * @param userId Identifies the user. Can be either the smoochId or the userId. (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getAppUserEntityIdsCall(String appId, String userId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        
        // create path and map variables
        String localVarPath = "/v1/apps/{appId}/appusers/{userId}/channels"
            .replaceAll("\\{" + "appId" + "\\}", apiClient.escapeString(appId.toString()))
            .replaceAll("\\{" + "userId" + "\\}", apiClient.escapeString(userId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "jwt" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
    
    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getAppUserEntityIdsValidateBeforeCall(String appId, String userId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'appId' is set
        if (appId == null) {
            throw new ApiException("Missing the required parameter 'appId' when calling getAppUserEntityIds(Async)");
        }
        
        // verify the required parameter 'userId' is set
        if (userId == null) {
            throw new ApiException("Missing the required parameter 'userId' when calling getAppUserEntityIds(Async)");
        }
        
        
        com.squareup.okhttp.Call call = getAppUserEntityIdsCall(appId, userId, progressListener, progressRequestListener);
        return call;

        
        
        
        
    }

    /**
     * 
     * Get specified app user&#39;s channel entity IDs.
     * @param appId Identifies the app. (required)
     * @param userId Identifies the user. Can be either the smoochId or the userId. (required)
     * @return AppUserChannelsResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public AppUserChannelsResponse getAppUserEntityIds(String appId, String userId) throws ApiException {
        ApiResponse<AppUserChannelsResponse> resp = getAppUserEntityIdsWithHttpInfo(appId, userId);
        return resp.getData();
    }

    /**
     * 
     * Get specified app user&#39;s channel entity IDs.
     * @param appId Identifies the app. (required)
     * @param userId Identifies the user. Can be either the smoochId or the userId. (required)
     * @return ApiResponse&lt;AppUserChannelsResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<AppUserChannelsResponse> getAppUserEntityIdsWithHttpInfo(String appId, String userId) throws ApiException {
        com.squareup.okhttp.Call call = getAppUserEntityIdsValidateBeforeCall(appId, userId, null, null);
        Type localVarReturnType = new TypeToken<AppUserChannelsResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     *  (asynchronously)
     * Get specified app user&#39;s channel entity IDs.
     * @param appId Identifies the app. (required)
     * @param userId Identifies the user. Can be either the smoochId or the userId. (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getAppUserEntityIdsAsync(String appId, String userId, final ApiCallback<AppUserChannelsResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getAppUserEntityIdsValidateBeforeCall(appId, userId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<AppUserChannelsResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getLinkRequests
     * @param appId Identifies the app. (required)
     * @param userId Identifies the user. Can be either the smoochId or the userId. (required)
     * @param integrationIds List of integration IDs (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getLinkRequestsCall(String appId, String userId, List<String> integrationIds, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        
        // create path and map variables
        String localVarPath = "/v1/apps/{appId}/appusers/{userId}/linkrequest"
            .replaceAll("\\{" + "appId" + "\\}", apiClient.escapeString(appId.toString()))
            .replaceAll("\\{" + "userId" + "\\}", apiClient.escapeString(userId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (integrationIds != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("csv", "integrationIds", integrationIds));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "jwt" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
    
    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getLinkRequestsValidateBeforeCall(String appId, String userId, List<String> integrationIds, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'appId' is set
        if (appId == null) {
            throw new ApiException("Missing the required parameter 'appId' when calling getLinkRequests(Async)");
        }
        
        // verify the required parameter 'userId' is set
        if (userId == null) {
            throw new ApiException("Missing the required parameter 'userId' when calling getLinkRequests(Async)");
        }
        
        // verify the required parameter 'integrationIds' is set
        if (integrationIds == null) {
            throw new ApiException("Missing the required parameter 'integrationIds' when calling getLinkRequests(Async)");
        }
        
        
        com.squareup.okhttp.Call call = getLinkRequestsCall(appId, userId, integrationIds, progressListener, progressRequestListener);
        return call;

        
        
        
        
    }

    /**
     * 
     * Fetch link requests for the specified app user.
     * @param appId Identifies the app. (required)
     * @param userId Identifies the user. Can be either the smoochId or the userId. (required)
     * @param integrationIds List of integration IDs (required)
     * @return LinkRequestResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public LinkRequestResponse getLinkRequests(String appId, String userId, List<String> integrationIds) throws ApiException {
        ApiResponse<LinkRequestResponse> resp = getLinkRequestsWithHttpInfo(appId, userId, integrationIds);
        return resp.getData();
    }

    /**
     * 
     * Fetch link requests for the specified app user.
     * @param appId Identifies the app. (required)
     * @param userId Identifies the user. Can be either the smoochId or the userId. (required)
     * @param integrationIds List of integration IDs (required)
     * @return ApiResponse&lt;LinkRequestResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<LinkRequestResponse> getLinkRequestsWithHttpInfo(String appId, String userId, List<String> integrationIds) throws ApiException {
        com.squareup.okhttp.Call call = getLinkRequestsValidateBeforeCall(appId, userId, integrationIds, null, null);
        Type localVarReturnType = new TypeToken<LinkRequestResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     *  (asynchronously)
     * Fetch link requests for the specified app user.
     * @param appId Identifies the app. (required)
     * @param userId Identifies the user. Can be either the smoochId or the userId. (required)
     * @param integrationIds List of integration IDs (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getLinkRequestsAsync(String appId, String userId, List<String> integrationIds, final ApiCallback<LinkRequestResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getLinkRequestsValidateBeforeCall(appId, userId, integrationIds, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<LinkRequestResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for linkAppUser
     * @param appId Identifies the app. (required)
     * @param userId Identifies the user. Can be either the smoochId or the userId. (required)
     * @param appUserLinkBody Body for a linkAppUser request. (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call linkAppUserCall(String appId, String userId, AppUserLink appUserLinkBody, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = appUserLinkBody;
        
        // create path and map variables
        String localVarPath = "/v1/apps/{appId}/appusers/{userId}/channels"
            .replaceAll("\\{" + "appId" + "\\}", apiClient.escapeString(appId.toString()))
            .replaceAll("\\{" + "userId" + "\\}", apiClient.escapeString(userId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "jwt" };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
    
    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call linkAppUserValidateBeforeCall(String appId, String userId, AppUserLink appUserLinkBody, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'appId' is set
        if (appId == null) {
            throw new ApiException("Missing the required parameter 'appId' when calling linkAppUser(Async)");
        }
        
        // verify the required parameter 'userId' is set
        if (userId == null) {
            throw new ApiException("Missing the required parameter 'userId' when calling linkAppUser(Async)");
        }
        
        // verify the required parameter 'appUserLinkBody' is set
        if (appUserLinkBody == null) {
            throw new ApiException("Missing the required parameter 'appUserLinkBody' when calling linkAppUser(Async)");
        }
        
        
        com.squareup.okhttp.Call call = linkAppUserCall(appId, userId, appUserLinkBody, progressListener, progressRequestListener);
        return call;

        
        
        
        
    }

    /**
     * 
     * Link specified app user to given channel.
     * @param appId Identifies the app. (required)
     * @param userId Identifies the user. Can be either the smoochId or the userId. (required)
     * @param appUserLinkBody Body for a linkAppUser request. (required)
     * @return AppUserResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public AppUserResponse linkAppUser(String appId, String userId, AppUserLink appUserLinkBody) throws ApiException {
        ApiResponse<AppUserResponse> resp = linkAppUserWithHttpInfo(appId, userId, appUserLinkBody);
        return resp.getData();
    }

    /**
     * 
     * Link specified app user to given channel.
     * @param appId Identifies the app. (required)
     * @param userId Identifies the user. Can be either the smoochId or the userId. (required)
     * @param appUserLinkBody Body for a linkAppUser request. (required)
     * @return ApiResponse&lt;AppUserResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<AppUserResponse> linkAppUserWithHttpInfo(String appId, String userId, AppUserLink appUserLinkBody) throws ApiException {
        com.squareup.okhttp.Call call = linkAppUserValidateBeforeCall(appId, userId, appUserLinkBody, null, null);
        Type localVarReturnType = new TypeToken<AppUserResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     *  (asynchronously)
     * Link specified app user to given channel.
     * @param appId Identifies the app. (required)
     * @param userId Identifies the user. Can be either the smoochId or the userId. (required)
     * @param appUserLinkBody Body for a linkAppUser request. (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call linkAppUserAsync(String appId, String userId, AppUserLink appUserLinkBody, final ApiCallback<AppUserResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = linkAppUserValidateBeforeCall(appId, userId, appUserLinkBody, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<AppUserResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for postImageMessage
     * @param appId Identifies the app. (required)
     * @param userId Identifies the user. Can be either the smoochId or the userId. (required)
     * @param source Image to be uploaded (required)
     * @param role Role of the sender (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call postImageMessageCall(String appId, String userId, File source, String role, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        
        // create path and map variables
        String localVarPath = "/v1/apps/{appId}/appusers/{userId}/images"
            .replaceAll("\\{" + "appId" + "\\}", apiClient.escapeString(appId.toString()))
            .replaceAll("\\{" + "userId" + "\\}", apiClient.escapeString(userId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (source != null)
        localVarFormParams.put("source", source);
        if (role != null)
        localVarFormParams.put("role", role);

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "multipart/form-data"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "jwt" };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
    
    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call postImageMessageValidateBeforeCall(String appId, String userId, File source, String role, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'appId' is set
        if (appId == null) {
            throw new ApiException("Missing the required parameter 'appId' when calling postImageMessage(Async)");
        }
        
        // verify the required parameter 'userId' is set
        if (userId == null) {
            throw new ApiException("Missing the required parameter 'userId' when calling postImageMessage(Async)");
        }
        
        // verify the required parameter 'source' is set
        if (source == null) {
            throw new ApiException("Missing the required parameter 'source' when calling postImageMessage(Async)");
        }
        
        // verify the required parameter 'role' is set
        if (role == null) {
            throw new ApiException("Missing the required parameter 'role' when calling postImageMessage(Async)");
        }
        
        
        com.squareup.okhttp.Call call = postImageMessageCall(appId, userId, source, role, progressListener, progressRequestListener);
        return call;

        
        
        
        
    }

    /**
     * 
     * Send an image message to the conversation.
     * @param appId Identifies the app. (required)
     * @param userId Identifies the user. Can be either the smoochId or the userId. (required)
     * @param source Image to be uploaded (required)
     * @param role Role of the sender (required)
     * @return MessageResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public MessageResponse postImageMessage(String appId, String userId, File source, String role) throws ApiException {
        ApiResponse<MessageResponse> resp = postImageMessageWithHttpInfo(appId, userId, source, role);
        return resp.getData();
    }

    /**
     * 
     * Send an image message to the conversation.
     * @param appId Identifies the app. (required)
     * @param userId Identifies the user. Can be either the smoochId or the userId. (required)
     * @param source Image to be uploaded (required)
     * @param role Role of the sender (required)
     * @return ApiResponse&lt;MessageResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<MessageResponse> postImageMessageWithHttpInfo(String appId, String userId, File source, String role) throws ApiException {
        com.squareup.okhttp.Call call = postImageMessageValidateBeforeCall(appId, userId, source, role, null, null);
        Type localVarReturnType = new TypeToken<MessageResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     *  (asynchronously)
     * Send an image message to the conversation.
     * @param appId Identifies the app. (required)
     * @param userId Identifies the user. Can be either the smoochId or the userId. (required)
     * @param source Image to be uploaded (required)
     * @param role Role of the sender (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call postImageMessageAsync(String appId, String userId, File source, String role, final ApiCallback<MessageResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = postImageMessageValidateBeforeCall(appId, userId, source, role, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<MessageResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for preCreateAppUser
     * @param appId Identifies the app. (required)
     * @param appUserPreCreateBody Body for a preCreateAppUser request. (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call preCreateAppUserCall(String appId, AppUserPreCreate appUserPreCreateBody, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = appUserPreCreateBody;
        
        // create path and map variables
        String localVarPath = "/v1/apps/{appId}/appusers"
            .replaceAll("\\{" + "appId" + "\\}", apiClient.escapeString(appId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "jwt" };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
    
    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call preCreateAppUserValidateBeforeCall(String appId, AppUserPreCreate appUserPreCreateBody, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'appId' is set
        if (appId == null) {
            throw new ApiException("Missing the required parameter 'appId' when calling preCreateAppUser(Async)");
        }
        
        // verify the required parameter 'appUserPreCreateBody' is set
        if (appUserPreCreateBody == null) {
            throw new ApiException("Missing the required parameter 'appUserPreCreateBody' when calling preCreateAppUser(Async)");
        }
        
        
        com.squareup.okhttp.Call call = preCreateAppUserCall(appId, appUserPreCreateBody, progressListener, progressRequestListener);
        return call;

        
        
        
        
    }

    /**
     * 
     * Pre-create an app user.
     * @param appId Identifies the app. (required)
     * @param appUserPreCreateBody Body for a preCreateAppUser request. (required)
     * @return AppUserResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public AppUserResponse preCreateAppUser(String appId, AppUserPreCreate appUserPreCreateBody) throws ApiException {
        ApiResponse<AppUserResponse> resp = preCreateAppUserWithHttpInfo(appId, appUserPreCreateBody);
        return resp.getData();
    }

    /**
     * 
     * Pre-create an app user.
     * @param appId Identifies the app. (required)
     * @param appUserPreCreateBody Body for a preCreateAppUser request. (required)
     * @return ApiResponse&lt;AppUserResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<AppUserResponse> preCreateAppUserWithHttpInfo(String appId, AppUserPreCreate appUserPreCreateBody) throws ApiException {
        com.squareup.okhttp.Call call = preCreateAppUserValidateBeforeCall(appId, appUserPreCreateBody, null, null);
        Type localVarReturnType = new TypeToken<AppUserResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     *  (asynchronously)
     * Pre-create an app user.
     * @param appId Identifies the app. (required)
     * @param appUserPreCreateBody Body for a preCreateAppUser request. (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call preCreateAppUserAsync(String appId, AppUserPreCreate appUserPreCreateBody, final ApiCallback<AppUserResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = preCreateAppUserValidateBeforeCall(appId, appUserPreCreateBody, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<AppUserResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for unlinkAppUser
     * @param appId Identifies the app. (required)
     * @param userId Identifies the user. Can be either the smoochId or the userId. (required)
     * @param channel Name of the channel. (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call unlinkAppUserCall(String appId, String userId, String channel, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        
        // create path and map variables
        String localVarPath = "/v1/apps/{appId}/appusers/{userId}/channels/{channel}"
            .replaceAll("\\{" + "appId" + "\\}", apiClient.escapeString(appId.toString()))
            .replaceAll("\\{" + "userId" + "\\}", apiClient.escapeString(userId.toString()))
            .replaceAll("\\{" + "channel" + "\\}", apiClient.escapeString(channel.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "jwt" };
        return apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
    
    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call unlinkAppUserValidateBeforeCall(String appId, String userId, String channel, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'appId' is set
        if (appId == null) {
            throw new ApiException("Missing the required parameter 'appId' when calling unlinkAppUser(Async)");
        }
        
        // verify the required parameter 'userId' is set
        if (userId == null) {
            throw new ApiException("Missing the required parameter 'userId' when calling unlinkAppUser(Async)");
        }
        
        // verify the required parameter 'channel' is set
        if (channel == null) {
            throw new ApiException("Missing the required parameter 'channel' when calling unlinkAppUser(Async)");
        }
        
        
        com.squareup.okhttp.Call call = unlinkAppUserCall(appId, userId, channel, progressListener, progressRequestListener);
        return call;

        
        
        
        
    }

    /**
     * 
     * Unlink specified app user from given channel.
     * @param appId Identifies the app. (required)
     * @param userId Identifies the user. Can be either the smoochId or the userId. (required)
     * @param channel Name of the channel. (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public void unlinkAppUser(String appId, String userId, String channel) throws ApiException {
        unlinkAppUserWithHttpInfo(appId, userId, channel);
    }

    /**
     * 
     * Unlink specified app user from given channel.
     * @param appId Identifies the app. (required)
     * @param userId Identifies the user. Can be either the smoochId or the userId. (required)
     * @param channel Name of the channel. (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Void> unlinkAppUserWithHttpInfo(String appId, String userId, String channel) throws ApiException {
        com.squareup.okhttp.Call call = unlinkAppUserValidateBeforeCall(appId, userId, channel, null, null);
        return apiClient.execute(call);
    }

    /**
     *  (asynchronously)
     * Unlink specified app user from given channel.
     * @param appId Identifies the app. (required)
     * @param userId Identifies the user. Can be either the smoochId or the userId. (required)
     * @param channel Name of the channel. (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call unlinkAppUserAsync(String appId, String userId, String channel, final ApiCallback<Void> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = unlinkAppUserValidateBeforeCall(appId, userId, channel, progressListener, progressRequestListener);
        apiClient.executeAsync(call, callback);
        return call;
    }
    /**
     * Build call for updateAppUser
     * @param appId Identifies the app. (required)
     * @param userId Identifies the user. Can be either the smoochId or the userId. (required)
     * @param appUserUpdateBody Body for an updateAppUser request. (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call updateAppUserCall(String appId, String userId, AppUserUpdate appUserUpdateBody, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = appUserUpdateBody;
        
        // create path and map variables
        String localVarPath = "/v1/apps/{appId}/appusers/{userId}"
            .replaceAll("\\{" + "appId" + "\\}", apiClient.escapeString(appId.toString()))
            .replaceAll("\\{" + "userId" + "\\}", apiClient.escapeString(userId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "jwt" };
        return apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
    
    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call updateAppUserValidateBeforeCall(String appId, String userId, AppUserUpdate appUserUpdateBody, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'appId' is set
        if (appId == null) {
            throw new ApiException("Missing the required parameter 'appId' when calling updateAppUser(Async)");
        }
        
        // verify the required parameter 'userId' is set
        if (userId == null) {
            throw new ApiException("Missing the required parameter 'userId' when calling updateAppUser(Async)");
        }
        
        // verify the required parameter 'appUserUpdateBody' is set
        if (appUserUpdateBody == null) {
            throw new ApiException("Missing the required parameter 'appUserUpdateBody' when calling updateAppUser(Async)");
        }
        
        
        com.squareup.okhttp.Call call = updateAppUserCall(appId, userId, appUserUpdateBody, progressListener, progressRequestListener);
        return call;

        
        
        
        
    }

    /**
     * 
     * Update the specified app user.
     * @param appId Identifies the app. (required)
     * @param userId Identifies the user. Can be either the smoochId or the userId. (required)
     * @param appUserUpdateBody Body for an updateAppUser request. (required)
     * @return AppUserResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public AppUserResponse updateAppUser(String appId, String userId, AppUserUpdate appUserUpdateBody) throws ApiException {
        ApiResponse<AppUserResponse> resp = updateAppUserWithHttpInfo(appId, userId, appUserUpdateBody);
        return resp.getData();
    }

    /**
     * 
     * Update the specified app user.
     * @param appId Identifies the app. (required)
     * @param userId Identifies the user. Can be either the smoochId or the userId. (required)
     * @param appUserUpdateBody Body for an updateAppUser request. (required)
     * @return ApiResponse&lt;AppUserResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<AppUserResponse> updateAppUserWithHttpInfo(String appId, String userId, AppUserUpdate appUserUpdateBody) throws ApiException {
        com.squareup.okhttp.Call call = updateAppUserValidateBeforeCall(appId, userId, appUserUpdateBody, null, null);
        Type localVarReturnType = new TypeToken<AppUserResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     *  (asynchronously)
     * Update the specified app user.
     * @param appId Identifies the app. (required)
     * @param userId Identifies the user. Can be either the smoochId or the userId. (required)
     * @param appUserUpdateBody Body for an updateAppUser request. (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call updateAppUserAsync(String appId, String userId, AppUserUpdate appUserUpdateBody, final ApiCallback<AppUserResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = updateAppUserValidateBeforeCall(appId, userId, appUserUpdateBody, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<AppUserResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}
