/*
 * Smooch
 * The Smooch API is a unified interface for powering messaging in your customer experiences across every channel. Our API speeds access to new markets, reduces time to ship, eliminates complexity, and helps you build the best experiences for your customers. For more information, visit our [official documentation](https://docs.smooch.io).
 *
 * OpenAPI spec version: 3.15
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package io.smooch.client.api;

import io.smooch.client.ApiCallback;
import io.smooch.client.ApiClient;
import io.smooch.client.ApiException;
import io.smooch.client.ApiResponse;
import io.smooch.client.Configuration;
import io.smooch.client.Pair;
import io.smooch.client.ProgressRequestBody;
import io.smooch.client.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import io.smooch.client.model.JwtResponse;
import io.smooch.client.model.ListSecretKeysResponse;
import io.smooch.client.model.ListServiceAccountsResponse;
import io.smooch.client.model.SecretKeyCreate;
import io.smooch.client.model.SecretKeyResponse;
import io.smooch.client.model.ServiceAccountCreate;
import io.smooch.client.model.ServiceAccountResponse;
import io.smooch.client.model.ServiceAccountUpdate;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ServiceAccountApi {
    private ApiClient apiClient;

    public ServiceAccountApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ServiceAccountApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Build call for createSecretKey
     * @param serviceAccountId Identifies the service account. (required)
     * @param secretKeyCreateBody Body for a createSecretKey request. (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call createSecretKeyCall(String serviceAccountId, SecretKeyCreate secretKeyCreateBody, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = secretKeyCreateBody;
        
        // create path and map variables
        String localVarPath = "/v1/serviceaccounts/{serviceAccountId}/keys"
            .replaceAll("\\{" + "serviceAccountId" + "\\}", apiClient.escapeString(serviceAccountId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "jwt" };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
    
    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call createSecretKeyValidateBeforeCall(String serviceAccountId, SecretKeyCreate secretKeyCreateBody, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'serviceAccountId' is set
        if (serviceAccountId == null) {
            throw new ApiException("Missing the required parameter 'serviceAccountId' when calling createSecretKey(Async)");
        }
        
        // verify the required parameter 'secretKeyCreateBody' is set
        if (secretKeyCreateBody == null) {
            throw new ApiException("Missing the required parameter 'secretKeyCreateBody' when calling createSecretKey(Async)");
        }
        
        
        com.squareup.okhttp.Call call = createSecretKeyCall(serviceAccountId, secretKeyCreateBody, progressListener, progressRequestListener);
        return call;

        
        
        
        
    }

    /**
     * 
     * Create a secret key for the specified service account.
     * @param serviceAccountId Identifies the service account. (required)
     * @param secretKeyCreateBody Body for a createSecretKey request. (required)
     * @return SecretKeyResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public SecretKeyResponse createSecretKey(String serviceAccountId, SecretKeyCreate secretKeyCreateBody) throws ApiException {
        ApiResponse<SecretKeyResponse> resp = createSecretKeyWithHttpInfo(serviceAccountId, secretKeyCreateBody);
        return resp.getData();
    }

    /**
     * 
     * Create a secret key for the specified service account.
     * @param serviceAccountId Identifies the service account. (required)
     * @param secretKeyCreateBody Body for a createSecretKey request. (required)
     * @return ApiResponse&lt;SecretKeyResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<SecretKeyResponse> createSecretKeyWithHttpInfo(String serviceAccountId, SecretKeyCreate secretKeyCreateBody) throws ApiException {
        com.squareup.okhttp.Call call = createSecretKeyValidateBeforeCall(serviceAccountId, secretKeyCreateBody, null, null);
        Type localVarReturnType = new TypeToken<SecretKeyResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     *  (asynchronously)
     * Create a secret key for the specified service account.
     * @param serviceAccountId Identifies the service account. (required)
     * @param secretKeyCreateBody Body for a createSecretKey request. (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call createSecretKeyAsync(String serviceAccountId, SecretKeyCreate secretKeyCreateBody, final ApiCallback<SecretKeyResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = createSecretKeyValidateBeforeCall(serviceAccountId, secretKeyCreateBody, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<SecretKeyResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for createServiceAccount
     * @param serviceAccountCreateBody Body for a createServiceAccount request. (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call createServiceAccountCall(ServiceAccountCreate serviceAccountCreateBody, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = serviceAccountCreateBody;
        
        // create path and map variables
        String localVarPath = "/v1/serviceaccounts";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "jwt" };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
    
    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call createServiceAccountValidateBeforeCall(ServiceAccountCreate serviceAccountCreateBody, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'serviceAccountCreateBody' is set
        if (serviceAccountCreateBody == null) {
            throw new ApiException("Missing the required parameter 'serviceAccountCreateBody' when calling createServiceAccount(Async)");
        }
        
        
        com.squareup.okhttp.Call call = createServiceAccountCall(serviceAccountCreateBody, progressListener, progressRequestListener);
        return call;

        
        
        
        
    }

    /**
     * 
     * Create a new service account.
     * @param serviceAccountCreateBody Body for a createServiceAccount request. (required)
     * @return ServiceAccountResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ServiceAccountResponse createServiceAccount(ServiceAccountCreate serviceAccountCreateBody) throws ApiException {
        ApiResponse<ServiceAccountResponse> resp = createServiceAccountWithHttpInfo(serviceAccountCreateBody);
        return resp.getData();
    }

    /**
     * 
     * Create a new service account.
     * @param serviceAccountCreateBody Body for a createServiceAccount request. (required)
     * @return ApiResponse&lt;ServiceAccountResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<ServiceAccountResponse> createServiceAccountWithHttpInfo(ServiceAccountCreate serviceAccountCreateBody) throws ApiException {
        com.squareup.okhttp.Call call = createServiceAccountValidateBeforeCall(serviceAccountCreateBody, null, null);
        Type localVarReturnType = new TypeToken<ServiceAccountResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     *  (asynchronously)
     * Create a new service account.
     * @param serviceAccountCreateBody Body for a createServiceAccount request. (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call createServiceAccountAsync(ServiceAccountCreate serviceAccountCreateBody, final ApiCallback<ServiceAccountResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = createServiceAccountValidateBeforeCall(serviceAccountCreateBody, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ServiceAccountResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for deleteSecretKey
     * @param serviceAccountId Identifies the service account. (required)
     * @param keyId Identifies the secret key. (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call deleteSecretKeyCall(String serviceAccountId, String keyId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        
        // create path and map variables
        String localVarPath = "/v1/serviceaccounts/{serviceAccountId}/keys/{keyId}"
            .replaceAll("\\{" + "serviceAccountId" + "\\}", apiClient.escapeString(serviceAccountId.toString()))
            .replaceAll("\\{" + "keyId" + "\\}", apiClient.escapeString(keyId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "jwt" };
        return apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
    
    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call deleteSecretKeyValidateBeforeCall(String serviceAccountId, String keyId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'serviceAccountId' is set
        if (serviceAccountId == null) {
            throw new ApiException("Missing the required parameter 'serviceAccountId' when calling deleteSecretKey(Async)");
        }
        
        // verify the required parameter 'keyId' is set
        if (keyId == null) {
            throw new ApiException("Missing the required parameter 'keyId' when calling deleteSecretKey(Async)");
        }
        
        
        com.squareup.okhttp.Call call = deleteSecretKeyCall(serviceAccountId, keyId, progressListener, progressRequestListener);
        return call;

        
        
        
        
    }

    /**
     * 
     * Delete the specified service account secret key.
     * @param serviceAccountId Identifies the service account. (required)
     * @param keyId Identifies the secret key. (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public void deleteSecretKey(String serviceAccountId, String keyId) throws ApiException {
        deleteSecretKeyWithHttpInfo(serviceAccountId, keyId);
    }

    /**
     * 
     * Delete the specified service account secret key.
     * @param serviceAccountId Identifies the service account. (required)
     * @param keyId Identifies the secret key. (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Void> deleteSecretKeyWithHttpInfo(String serviceAccountId, String keyId) throws ApiException {
        com.squareup.okhttp.Call call = deleteSecretKeyValidateBeforeCall(serviceAccountId, keyId, null, null);
        return apiClient.execute(call);
    }

    /**
     *  (asynchronously)
     * Delete the specified service account secret key.
     * @param serviceAccountId Identifies the service account. (required)
     * @param keyId Identifies the secret key. (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call deleteSecretKeyAsync(String serviceAccountId, String keyId, final ApiCallback<Void> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = deleteSecretKeyValidateBeforeCall(serviceAccountId, keyId, progressListener, progressRequestListener);
        apiClient.executeAsync(call, callback);
        return call;
    }
    /**
     * Build call for deleteServiceAccount
     * @param serviceAccountId Identifies the service account. (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call deleteServiceAccountCall(String serviceAccountId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        
        // create path and map variables
        String localVarPath = "/v1/serviceaccounts/{serviceAccountId}"
            .replaceAll("\\{" + "serviceAccountId" + "\\}", apiClient.escapeString(serviceAccountId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "jwt" };
        return apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
    
    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call deleteServiceAccountValidateBeforeCall(String serviceAccountId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'serviceAccountId' is set
        if (serviceAccountId == null) {
            throw new ApiException("Missing the required parameter 'serviceAccountId' when calling deleteServiceAccount(Async)");
        }
        
        
        com.squareup.okhttp.Call call = deleteServiceAccountCall(serviceAccountId, progressListener, progressRequestListener);
        return call;

        
        
        
        
    }

    /**
     * 
     * Delete the specified service account.
     * @param serviceAccountId Identifies the service account. (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public void deleteServiceAccount(String serviceAccountId) throws ApiException {
        deleteServiceAccountWithHttpInfo(serviceAccountId);
    }

    /**
     * 
     * Delete the specified service account.
     * @param serviceAccountId Identifies the service account. (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Void> deleteServiceAccountWithHttpInfo(String serviceAccountId) throws ApiException {
        com.squareup.okhttp.Call call = deleteServiceAccountValidateBeforeCall(serviceAccountId, null, null);
        return apiClient.execute(call);
    }

    /**
     *  (asynchronously)
     * Delete the specified service account.
     * @param serviceAccountId Identifies the service account. (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call deleteServiceAccountAsync(String serviceAccountId, final ApiCallback<Void> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = deleteServiceAccountValidateBeforeCall(serviceAccountId, progressListener, progressRequestListener);
        apiClient.executeAsync(call, callback);
        return call;
    }
    /**
     * Build call for getJwt
     * @param serviceAccountId Identifies the service account. (required)
     * @param keyId Identifies the secret key. (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getJwtCall(String serviceAccountId, String keyId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        
        // create path and map variables
        String localVarPath = "/v1/serviceaccounts/{serviceAccountId}/keys/{keyId}/jwt"
            .replaceAll("\\{" + "serviceAccountId" + "\\}", apiClient.escapeString(serviceAccountId.toString()))
            .replaceAll("\\{" + "keyId" + "\\}", apiClient.escapeString(keyId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "jwt" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
    
    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getJwtValidateBeforeCall(String serviceAccountId, String keyId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'serviceAccountId' is set
        if (serviceAccountId == null) {
            throw new ApiException("Missing the required parameter 'serviceAccountId' when calling getJwt(Async)");
        }
        
        // verify the required parameter 'keyId' is set
        if (keyId == null) {
            throw new ApiException("Missing the required parameter 'keyId' when calling getJwt(Async)");
        }
        
        
        com.squareup.okhttp.Call call = getJwtCall(serviceAccountId, keyId, progressListener, progressRequestListener);
        return call;

        
        
        
        
    }

    /**
     * 
     * Get an account-scoped JWT for the specified service account secret key.
     * @param serviceAccountId Identifies the service account. (required)
     * @param keyId Identifies the secret key. (required)
     * @return JwtResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public JwtResponse getJwt(String serviceAccountId, String keyId) throws ApiException {
        ApiResponse<JwtResponse> resp = getJwtWithHttpInfo(serviceAccountId, keyId);
        return resp.getData();
    }

    /**
     * 
     * Get an account-scoped JWT for the specified service account secret key.
     * @param serviceAccountId Identifies the service account. (required)
     * @param keyId Identifies the secret key. (required)
     * @return ApiResponse&lt;JwtResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<JwtResponse> getJwtWithHttpInfo(String serviceAccountId, String keyId) throws ApiException {
        com.squareup.okhttp.Call call = getJwtValidateBeforeCall(serviceAccountId, keyId, null, null);
        Type localVarReturnType = new TypeToken<JwtResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     *  (asynchronously)
     * Get an account-scoped JWT for the specified service account secret key.
     * @param serviceAccountId Identifies the service account. (required)
     * @param keyId Identifies the secret key. (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getJwtAsync(String serviceAccountId, String keyId, final ApiCallback<JwtResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getJwtValidateBeforeCall(serviceAccountId, keyId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<JwtResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getSecretKey
     * @param serviceAccountId Identifies the service account. (required)
     * @param keyId Identifies the secret key. (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getSecretKeyCall(String serviceAccountId, String keyId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        
        // create path and map variables
        String localVarPath = "/v1/serviceaccounts/{serviceAccountId}/keys/{keyId}"
            .replaceAll("\\{" + "serviceAccountId" + "\\}", apiClient.escapeString(serviceAccountId.toString()))
            .replaceAll("\\{" + "keyId" + "\\}", apiClient.escapeString(keyId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "jwt" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
    
    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getSecretKeyValidateBeforeCall(String serviceAccountId, String keyId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'serviceAccountId' is set
        if (serviceAccountId == null) {
            throw new ApiException("Missing the required parameter 'serviceAccountId' when calling getSecretKey(Async)");
        }
        
        // verify the required parameter 'keyId' is set
        if (keyId == null) {
            throw new ApiException("Missing the required parameter 'keyId' when calling getSecretKey(Async)");
        }
        
        
        com.squareup.okhttp.Call call = getSecretKeyCall(serviceAccountId, keyId, progressListener, progressRequestListener);
        return call;

        
        
        
        
    }

    /**
     * 
     * Get the specified service account secret key.
     * @param serviceAccountId Identifies the service account. (required)
     * @param keyId Identifies the secret key. (required)
     * @return SecretKeyResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public SecretKeyResponse getSecretKey(String serviceAccountId, String keyId) throws ApiException {
        ApiResponse<SecretKeyResponse> resp = getSecretKeyWithHttpInfo(serviceAccountId, keyId);
        return resp.getData();
    }

    /**
     * 
     * Get the specified service account secret key.
     * @param serviceAccountId Identifies the service account. (required)
     * @param keyId Identifies the secret key. (required)
     * @return ApiResponse&lt;SecretKeyResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<SecretKeyResponse> getSecretKeyWithHttpInfo(String serviceAccountId, String keyId) throws ApiException {
        com.squareup.okhttp.Call call = getSecretKeyValidateBeforeCall(serviceAccountId, keyId, null, null);
        Type localVarReturnType = new TypeToken<SecretKeyResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     *  (asynchronously)
     * Get the specified service account secret key.
     * @param serviceAccountId Identifies the service account. (required)
     * @param keyId Identifies the secret key. (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getSecretKeyAsync(String serviceAccountId, String keyId, final ApiCallback<SecretKeyResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getSecretKeyValidateBeforeCall(serviceAccountId, keyId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<SecretKeyResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getServiceAccount
     * @param serviceAccountId Identifies the service account. (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getServiceAccountCall(String serviceAccountId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        
        // create path and map variables
        String localVarPath = "/v1/serviceaccounts/{serviceAccountId}"
            .replaceAll("\\{" + "serviceAccountId" + "\\}", apiClient.escapeString(serviceAccountId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "jwt" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
    
    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getServiceAccountValidateBeforeCall(String serviceAccountId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'serviceAccountId' is set
        if (serviceAccountId == null) {
            throw new ApiException("Missing the required parameter 'serviceAccountId' when calling getServiceAccount(Async)");
        }
        
        
        com.squareup.okhttp.Call call = getServiceAccountCall(serviceAccountId, progressListener, progressRequestListener);
        return call;

        
        
        
        
    }

    /**
     * 
     * Get the specified service account.
     * @param serviceAccountId Identifies the service account. (required)
     * @return ServiceAccountResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ServiceAccountResponse getServiceAccount(String serviceAccountId) throws ApiException {
        ApiResponse<ServiceAccountResponse> resp = getServiceAccountWithHttpInfo(serviceAccountId);
        return resp.getData();
    }

    /**
     * 
     * Get the specified service account.
     * @param serviceAccountId Identifies the service account. (required)
     * @return ApiResponse&lt;ServiceAccountResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<ServiceAccountResponse> getServiceAccountWithHttpInfo(String serviceAccountId) throws ApiException {
        com.squareup.okhttp.Call call = getServiceAccountValidateBeforeCall(serviceAccountId, null, null);
        Type localVarReturnType = new TypeToken<ServiceAccountResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     *  (asynchronously)
     * Get the specified service account.
     * @param serviceAccountId Identifies the service account. (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getServiceAccountAsync(String serviceAccountId, final ApiCallback<ServiceAccountResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getServiceAccountValidateBeforeCall(serviceAccountId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ServiceAccountResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for listSecretKeys
     * @param serviceAccountId Identifies the service account. (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call listSecretKeysCall(String serviceAccountId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        
        // create path and map variables
        String localVarPath = "/v1/serviceaccounts/{serviceAccountId}/keys"
            .replaceAll("\\{" + "serviceAccountId" + "\\}", apiClient.escapeString(serviceAccountId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "jwt" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
    
    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call listSecretKeysValidateBeforeCall(String serviceAccountId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'serviceAccountId' is set
        if (serviceAccountId == null) {
            throw new ApiException("Missing the required parameter 'serviceAccountId' when calling listSecretKeys(Async)");
        }
        
        
        com.squareup.okhttp.Call call = listSecretKeysCall(serviceAccountId, progressListener, progressRequestListener);
        return call;

        
        
        
        
    }

    /**
     * 
     * List the secret keys for the specified service account.
     * @param serviceAccountId Identifies the service account. (required)
     * @return ListSecretKeysResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ListSecretKeysResponse listSecretKeys(String serviceAccountId) throws ApiException {
        ApiResponse<ListSecretKeysResponse> resp = listSecretKeysWithHttpInfo(serviceAccountId);
        return resp.getData();
    }

    /**
     * 
     * List the secret keys for the specified service account.
     * @param serviceAccountId Identifies the service account. (required)
     * @return ApiResponse&lt;ListSecretKeysResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<ListSecretKeysResponse> listSecretKeysWithHttpInfo(String serviceAccountId) throws ApiException {
        com.squareup.okhttp.Call call = listSecretKeysValidateBeforeCall(serviceAccountId, null, null);
        Type localVarReturnType = new TypeToken<ListSecretKeysResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     *  (asynchronously)
     * List the secret keys for the specified service account.
     * @param serviceAccountId Identifies the service account. (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call listSecretKeysAsync(String serviceAccountId, final ApiCallback<ListSecretKeysResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = listSecretKeysValidateBeforeCall(serviceAccountId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ListSecretKeysResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for listServiceAccounts
     * @param limit The number of records to return. (optional, default to 25)
     * @param offset The number of initial records to skip before picking records to return. (optional, default to 0)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call listServiceAccountsCall(Integer limit, Integer offset, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        
        // create path and map variables
        String localVarPath = "/v1/serviceaccounts";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (limit != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "limit", limit));
        if (offset != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "offset", offset));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "jwt" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
    
    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call listServiceAccountsValidateBeforeCall(Integer limit, Integer offset, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        
        com.squareup.okhttp.Call call = listServiceAccountsCall(limit, offset, progressListener, progressRequestListener);
        return call;

        
        
        
        
    }

    /**
     * 
     * List all service accounts configured.
     * @param limit The number of records to return. (optional, default to 25)
     * @param offset The number of initial records to skip before picking records to return. (optional, default to 0)
     * @return ListServiceAccountsResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ListServiceAccountsResponse listServiceAccounts(Integer limit, Integer offset) throws ApiException {
        ApiResponse<ListServiceAccountsResponse> resp = listServiceAccountsWithHttpInfo(limit, offset);
        return resp.getData();
    }

    /**
     * 
     * List all service accounts configured.
     * @param limit The number of records to return. (optional, default to 25)
     * @param offset The number of initial records to skip before picking records to return. (optional, default to 0)
     * @return ApiResponse&lt;ListServiceAccountsResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<ListServiceAccountsResponse> listServiceAccountsWithHttpInfo(Integer limit, Integer offset) throws ApiException {
        com.squareup.okhttp.Call call = listServiceAccountsValidateBeforeCall(limit, offset, null, null);
        Type localVarReturnType = new TypeToken<ListServiceAccountsResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     *  (asynchronously)
     * List all service accounts configured.
     * @param limit The number of records to return. (optional, default to 25)
     * @param offset The number of initial records to skip before picking records to return. (optional, default to 0)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call listServiceAccountsAsync(Integer limit, Integer offset, final ApiCallback<ListServiceAccountsResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = listServiceAccountsValidateBeforeCall(limit, offset, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ListServiceAccountsResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for updateServiceAccount
     * @param serviceAccountId Identifies the service account. (required)
     * @param serviceAccountUpdateBody Body for an updateServiceAccount request. (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call updateServiceAccountCall(String serviceAccountId, ServiceAccountUpdate serviceAccountUpdateBody, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = serviceAccountUpdateBody;
        
        // create path and map variables
        String localVarPath = "/v1/serviceaccounts/{serviceAccountId}"
            .replaceAll("\\{" + "serviceAccountId" + "\\}", apiClient.escapeString(serviceAccountId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "jwt" };
        return apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
    
    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call updateServiceAccountValidateBeforeCall(String serviceAccountId, ServiceAccountUpdate serviceAccountUpdateBody, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'serviceAccountId' is set
        if (serviceAccountId == null) {
            throw new ApiException("Missing the required parameter 'serviceAccountId' when calling updateServiceAccount(Async)");
        }
        
        // verify the required parameter 'serviceAccountUpdateBody' is set
        if (serviceAccountUpdateBody == null) {
            throw new ApiException("Missing the required parameter 'serviceAccountUpdateBody' when calling updateServiceAccount(Async)");
        }
        
        
        com.squareup.okhttp.Call call = updateServiceAccountCall(serviceAccountId, serviceAccountUpdateBody, progressListener, progressRequestListener);
        return call;

        
        
        
        
    }

    /**
     * 
     * Update the specified service account.
     * @param serviceAccountId Identifies the service account. (required)
     * @param serviceAccountUpdateBody Body for an updateServiceAccount request. (required)
     * @return ServiceAccountResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ServiceAccountResponse updateServiceAccount(String serviceAccountId, ServiceAccountUpdate serviceAccountUpdateBody) throws ApiException {
        ApiResponse<ServiceAccountResponse> resp = updateServiceAccountWithHttpInfo(serviceAccountId, serviceAccountUpdateBody);
        return resp.getData();
    }

    /**
     * 
     * Update the specified service account.
     * @param serviceAccountId Identifies the service account. (required)
     * @param serviceAccountUpdateBody Body for an updateServiceAccount request. (required)
     * @return ApiResponse&lt;ServiceAccountResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<ServiceAccountResponse> updateServiceAccountWithHttpInfo(String serviceAccountId, ServiceAccountUpdate serviceAccountUpdateBody) throws ApiException {
        com.squareup.okhttp.Call call = updateServiceAccountValidateBeforeCall(serviceAccountId, serviceAccountUpdateBody, null, null);
        Type localVarReturnType = new TypeToken<ServiceAccountResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     *  (asynchronously)
     * Update the specified service account.
     * @param serviceAccountId Identifies the service account. (required)
     * @param serviceAccountUpdateBody Body for an updateServiceAccount request. (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call updateServiceAccountAsync(String serviceAccountId, ServiceAccountUpdate serviceAccountUpdateBody, final ApiCallback<ServiceAccountResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = updateServiceAccountValidateBeforeCall(serviceAccountId, serviceAccountUpdateBody, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ServiceAccountResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}
