/*
 * Decompiled with CFR 0.152.
 */
package io.smooch.client;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import com.google.gson.stream.JsonReader;
import io.smooch.client.ApiClient;
import io.smooch.client.DateAdapter;
import io.smooch.client.DateTimeTypeAdapter;
import io.smooch.client.LocalDateTypeAdapter;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Type;
import java.util.Date;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;

public class JSON {
    private ApiClient apiClient;
    private Gson gson;

    public JSON(ApiClient apiClient) {
        this.apiClient = apiClient;
        this.gson = new GsonBuilder().registerTypeAdapter(Date.class, (Object)new DateAdapter(apiClient)).registerTypeAdapter(DateTime.class, (Object)new DateTimeTypeAdapter()).registerTypeAdapter(LocalDate.class, (Object)new LocalDateTypeAdapter()).create();
    }

    public Gson getGson() {
        return this.gson;
    }

    public void setGson(Gson gson) {
        this.gson = gson;
    }

    public String serialize(Object obj) {
        return this.gson.toJson(obj);
    }

    public <T> T deserialize(String body, Type returnType) {
        try {
            if (this.apiClient.isLenientOnJson()) {
                JsonReader jsonReader = new JsonReader((Reader)new StringReader(body));
                jsonReader.setLenient(true);
                return (T)this.gson.fromJson(jsonReader, returnType);
            }
            return (T)this.gson.fromJson(body, returnType);
        }
        catch (JsonParseException e) {
            if (returnType.equals(String.class)) {
                return (T)body;
            }
            if (returnType.equals(Date.class)) {
                return (T)this.apiClient.parseDateOrDatetime(body);
            }
            throw e;
        }
    }
}

