/*
 * Decompiled with CFR 0.152.
 */
package io.smooch.client.api;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import io.smooch.client.ApiCallback;
import io.smooch.client.ApiClient;
import io.smooch.client.ApiException;
import io.smooch.client.ApiResponse;
import io.smooch.client.Configuration;
import io.smooch.client.Pair;
import io.smooch.client.ProgressRequestBody;
import io.smooch.client.ProgressResponseBody;
import io.smooch.client.model.AppCreate;
import io.smooch.client.model.AppResponse;
import io.smooch.client.model.AppUpdate;
import io.smooch.client.model.JwtResponse;
import io.smooch.client.model.ListAppsResponse;
import io.smooch.client.model.ListSecretKeysResponse;
import io.smooch.client.model.SecretKeyCreate;
import io.smooch.client.model.SecretKeyResponse;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;

public class AppApi {
    private ApiClient apiClient;

    public AppApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AppApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call createAppCall(AppCreate appCreateBody, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        AppCreate localVarPostBody = appCreateBody;
        String localVarPath = "/v1/apps";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"jwt"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call createAppValidateBeforeCall(AppCreate appCreateBody, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (appCreateBody == null) {
            throw new ApiException("Missing the required parameter 'appCreateBody' when calling createApp(Async)");
        }
        Call call = this.createAppCall(appCreateBody, progressListener, progressRequestListener);
        return call;
    }

    public AppResponse createApp(AppCreate appCreateBody) throws ApiException {
        ApiResponse<AppResponse> resp = this.createAppWithHttpInfo(appCreateBody);
        return resp.getData();
    }

    public ApiResponse<AppResponse> createAppWithHttpInfo(AppCreate appCreateBody) throws ApiException {
        Call call = this.createAppValidateBeforeCall(appCreateBody, null, null);
        Type localVarReturnType = new TypeToken<AppResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call createAppAsync(AppCreate appCreateBody, final ApiCallback<AppResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.createAppValidateBeforeCall(appCreateBody, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<AppResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call createSecretKeyCall(String appId, SecretKeyCreate secretKeyCreateBody, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        SecretKeyCreate localVarPostBody = secretKeyCreateBody;
        String localVarPath = "/v1/apps/{appId}/keys".replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"jwt"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call createSecretKeyValidateBeforeCall(String appId, SecretKeyCreate secretKeyCreateBody, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (appId == null) {
            throw new ApiException("Missing the required parameter 'appId' when calling createSecretKey(Async)");
        }
        if (secretKeyCreateBody == null) {
            throw new ApiException("Missing the required parameter 'secretKeyCreateBody' when calling createSecretKey(Async)");
        }
        Call call = this.createSecretKeyCall(appId, secretKeyCreateBody, progressListener, progressRequestListener);
        return call;
    }

    public SecretKeyResponse createSecretKey(String appId, SecretKeyCreate secretKeyCreateBody) throws ApiException {
        ApiResponse<SecretKeyResponse> resp = this.createSecretKeyWithHttpInfo(appId, secretKeyCreateBody);
        return resp.getData();
    }

    public ApiResponse<SecretKeyResponse> createSecretKeyWithHttpInfo(String appId, SecretKeyCreate secretKeyCreateBody) throws ApiException {
        Call call = this.createSecretKeyValidateBeforeCall(appId, secretKeyCreateBody, null, null);
        Type localVarReturnType = new TypeToken<SecretKeyResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call createSecretKeyAsync(String appId, SecretKeyCreate secretKeyCreateBody, final ApiCallback<SecretKeyResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.createSecretKeyValidateBeforeCall(appId, secretKeyCreateBody, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<SecretKeyResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call deleteAppCall(String appId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v1/apps/{appId}".replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"jwt"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deleteAppValidateBeforeCall(String appId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (appId == null) {
            throw new ApiException("Missing the required parameter 'appId' when calling deleteApp(Async)");
        }
        Call call = this.deleteAppCall(appId, progressListener, progressRequestListener);
        return call;
    }

    public void deleteApp(String appId) throws ApiException {
        this.deleteAppWithHttpInfo(appId);
    }

    public ApiResponse<Void> deleteAppWithHttpInfo(String appId) throws ApiException {
        Call call = this.deleteAppValidateBeforeCall(appId, null, null);
        return this.apiClient.execute(call);
    }

    public Call deleteAppAsync(String appId, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteAppValidateBeforeCall(appId, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call deleteSecretKeyCall(String appId, String keyId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v1/apps/{appId}/keys/{keyId}".replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString())).replaceAll("\\{keyId\\}", this.apiClient.escapeString(keyId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"jwt"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deleteSecretKeyValidateBeforeCall(String appId, String keyId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (appId == null) {
            throw new ApiException("Missing the required parameter 'appId' when calling deleteSecretKey(Async)");
        }
        if (keyId == null) {
            throw new ApiException("Missing the required parameter 'keyId' when calling deleteSecretKey(Async)");
        }
        Call call = this.deleteSecretKeyCall(appId, keyId, progressListener, progressRequestListener);
        return call;
    }

    public void deleteSecretKey(String appId, String keyId) throws ApiException {
        this.deleteSecretKeyWithHttpInfo(appId, keyId);
    }

    public ApiResponse<Void> deleteSecretKeyWithHttpInfo(String appId, String keyId) throws ApiException {
        Call call = this.deleteSecretKeyValidateBeforeCall(appId, keyId, null, null);
        return this.apiClient.execute(call);
    }

    public Call deleteSecretKeyAsync(String appId, String keyId, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteSecretKeyValidateBeforeCall(appId, keyId, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call getAppCall(String appId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v1/apps/{appId}".replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"jwt"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getAppValidateBeforeCall(String appId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (appId == null) {
            throw new ApiException("Missing the required parameter 'appId' when calling getApp(Async)");
        }
        Call call = this.getAppCall(appId, progressListener, progressRequestListener);
        return call;
    }

    public AppResponse getApp(String appId) throws ApiException {
        ApiResponse<AppResponse> resp = this.getAppWithHttpInfo(appId);
        return resp.getData();
    }

    public ApiResponse<AppResponse> getAppWithHttpInfo(String appId) throws ApiException {
        Call call = this.getAppValidateBeforeCall(appId, null, null);
        Type localVarReturnType = new TypeToken<AppResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getAppAsync(String appId, final ApiCallback<AppResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getAppValidateBeforeCall(appId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<AppResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getAppJwtCall(String appId, String keyId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v1/apps/{appId}/keys/{keyId}/jwt".replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString())).replaceAll("\\{keyId\\}", this.apiClient.escapeString(keyId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"jwt"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getAppJwtValidateBeforeCall(String appId, String keyId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (appId == null) {
            throw new ApiException("Missing the required parameter 'appId' when calling getAppJwt(Async)");
        }
        if (keyId == null) {
            throw new ApiException("Missing the required parameter 'keyId' when calling getAppJwt(Async)");
        }
        Call call = this.getAppJwtCall(appId, keyId, progressListener, progressRequestListener);
        return call;
    }

    public JwtResponse getAppJwt(String appId, String keyId) throws ApiException {
        ApiResponse<JwtResponse> resp = this.getAppJwtWithHttpInfo(appId, keyId);
        return resp.getData();
    }

    public ApiResponse<JwtResponse> getAppJwtWithHttpInfo(String appId, String keyId) throws ApiException {
        Call call = this.getAppJwtValidateBeforeCall(appId, keyId, null, null);
        Type localVarReturnType = new TypeToken<JwtResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getAppJwtAsync(String appId, String keyId, final ApiCallback<JwtResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getAppJwtValidateBeforeCall(appId, keyId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<JwtResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getSecretKeyCall(String appId, String keyId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v1/apps/{appId}/keys/{keyId}".replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString())).replaceAll("\\{keyId\\}", this.apiClient.escapeString(keyId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"jwt"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getSecretKeyValidateBeforeCall(String appId, String keyId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (appId == null) {
            throw new ApiException("Missing the required parameter 'appId' when calling getSecretKey(Async)");
        }
        if (keyId == null) {
            throw new ApiException("Missing the required parameter 'keyId' when calling getSecretKey(Async)");
        }
        Call call = this.getSecretKeyCall(appId, keyId, progressListener, progressRequestListener);
        return call;
    }

    public SecretKeyResponse getSecretKey(String appId, String keyId) throws ApiException {
        ApiResponse<SecretKeyResponse> resp = this.getSecretKeyWithHttpInfo(appId, keyId);
        return resp.getData();
    }

    public ApiResponse<SecretKeyResponse> getSecretKeyWithHttpInfo(String appId, String keyId) throws ApiException {
        Call call = this.getSecretKeyValidateBeforeCall(appId, keyId, null, null);
        Type localVarReturnType = new TypeToken<SecretKeyResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getSecretKeyAsync(String appId, String keyId, final ApiCallback<SecretKeyResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getSecretKeyValidateBeforeCall(appId, keyId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<SecretKeyResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call listAppsCall(Integer limit, Integer offset, String serviceAccountId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v1/apps";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (limit != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "offset", offset));
        }
        if (serviceAccountId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "serviceAccountId", serviceAccountId));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"jwt"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call listAppsValidateBeforeCall(Integer limit, Integer offset, String serviceAccountId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.listAppsCall(limit, offset, serviceAccountId, progressListener, progressRequestListener);
        return call;
    }

    public ListAppsResponse listApps(Integer limit, Integer offset, String serviceAccountId) throws ApiException {
        ApiResponse<ListAppsResponse> resp = this.listAppsWithHttpInfo(limit, offset, serviceAccountId);
        return resp.getData();
    }

    public ApiResponse<ListAppsResponse> listAppsWithHttpInfo(Integer limit, Integer offset, String serviceAccountId) throws ApiException {
        Call call = this.listAppsValidateBeforeCall(limit, offset, serviceAccountId, null, null);
        Type localVarReturnType = new TypeToken<ListAppsResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call listAppsAsync(Integer limit, Integer offset, String serviceAccountId, final ApiCallback<ListAppsResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.listAppsValidateBeforeCall(limit, offset, serviceAccountId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ListAppsResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call listSecretKeysCall(String appId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v1/apps/{appId}/keys".replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"jwt"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call listSecretKeysValidateBeforeCall(String appId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (appId == null) {
            throw new ApiException("Missing the required parameter 'appId' when calling listSecretKeys(Async)");
        }
        Call call = this.listSecretKeysCall(appId, progressListener, progressRequestListener);
        return call;
    }

    public ListSecretKeysResponse listSecretKeys(String appId) throws ApiException {
        ApiResponse<ListSecretKeysResponse> resp = this.listSecretKeysWithHttpInfo(appId);
        return resp.getData();
    }

    public ApiResponse<ListSecretKeysResponse> listSecretKeysWithHttpInfo(String appId) throws ApiException {
        Call call = this.listSecretKeysValidateBeforeCall(appId, null, null);
        Type localVarReturnType = new TypeToken<ListSecretKeysResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call listSecretKeysAsync(String appId, final ApiCallback<ListSecretKeysResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.listSecretKeysValidateBeforeCall(appId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ListSecretKeysResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call updateAppCall(String appId, AppUpdate appUpdateBody, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        AppUpdate localVarPostBody = appUpdateBody;
        String localVarPath = "/v1/apps/{appId}".replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"jwt"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call updateAppValidateBeforeCall(String appId, AppUpdate appUpdateBody, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (appId == null) {
            throw new ApiException("Missing the required parameter 'appId' when calling updateApp(Async)");
        }
        if (appUpdateBody == null) {
            throw new ApiException("Missing the required parameter 'appUpdateBody' when calling updateApp(Async)");
        }
        Call call = this.updateAppCall(appId, appUpdateBody, progressListener, progressRequestListener);
        return call;
    }

    public AppResponse updateApp(String appId, AppUpdate appUpdateBody) throws ApiException {
        ApiResponse<AppResponse> resp = this.updateAppWithHttpInfo(appId, appUpdateBody);
        return resp.getData();
    }

    public ApiResponse<AppResponse> updateAppWithHttpInfo(String appId, AppUpdate appUpdateBody) throws ApiException {
        Call call = this.updateAppValidateBeforeCall(appId, appUpdateBody, null, null);
        Type localVarReturnType = new TypeToken<AppResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call updateAppAsync(String appId, AppUpdate appUpdateBody, final ApiCallback<AppResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.updateAppValidateBeforeCall(appId, appUpdateBody, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<AppResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

