/*
 * Decompiled with CFR 0.152.
 */
package io.smooch.client.api;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import io.smooch.client.ApiCallback;
import io.smooch.client.ApiClient;
import io.smooch.client.ApiException;
import io.smooch.client.ApiResponse;
import io.smooch.client.Configuration;
import io.smooch.client.Pair;
import io.smooch.client.ProgressRequestBody;
import io.smooch.client.ProgressResponseBody;
import io.smooch.client.model.AppUserBusinessSystemsResponse;
import io.smooch.client.model.AppUserChannelsResponse;
import io.smooch.client.model.AppUserLink;
import io.smooch.client.model.AppUserPreCreate;
import io.smooch.client.model.AppUserResponse;
import io.smooch.client.model.AppUserUpdate;
import io.smooch.client.model.AuthCodeResponse;
import io.smooch.client.model.LinkRequestResponse;
import io.smooch.client.model.MessageResponse;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class AppUserApi {
    private ApiClient apiClient;

    public AppUserApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AppUserApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call deleteAppUserCall(String appId, String userId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v1/apps/{appId}/appusers/{userId}".replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString())).replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"jwt"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deleteAppUserValidateBeforeCall(String appId, String userId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (appId == null) {
            throw new ApiException("Missing the required parameter 'appId' when calling deleteAppUser(Async)");
        }
        if (userId == null) {
            throw new ApiException("Missing the required parameter 'userId' when calling deleteAppUser(Async)");
        }
        Call call = this.deleteAppUserCall(appId, userId, progressListener, progressRequestListener);
        return call;
    }

    public void deleteAppUser(String appId, String userId) throws ApiException {
        this.deleteAppUserWithHttpInfo(appId, userId);
    }

    public ApiResponse<Void> deleteAppUserWithHttpInfo(String appId, String userId) throws ApiException {
        Call call = this.deleteAppUserValidateBeforeCall(appId, userId, null, null);
        return this.apiClient.execute(call);
    }

    public Call deleteAppUserAsync(String appId, String userId, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteAppUserValidateBeforeCall(appId, userId, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call deleteAppUserProfileCall(String appId, String userId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v1/apps/{appId}/appusers/{userId}/profile".replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString())).replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"jwt"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deleteAppUserProfileValidateBeforeCall(String appId, String userId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (appId == null) {
            throw new ApiException("Missing the required parameter 'appId' when calling deleteAppUserProfile(Async)");
        }
        if (userId == null) {
            throw new ApiException("Missing the required parameter 'userId' when calling deleteAppUserProfile(Async)");
        }
        Call call = this.deleteAppUserProfileCall(appId, userId, progressListener, progressRequestListener);
        return call;
    }

    public AppUserResponse deleteAppUserProfile(String appId, String userId) throws ApiException {
        ApiResponse<AppUserResponse> resp = this.deleteAppUserProfileWithHttpInfo(appId, userId);
        return resp.getData();
    }

    public ApiResponse<AppUserResponse> deleteAppUserProfileWithHttpInfo(String appId, String userId) throws ApiException {
        Call call = this.deleteAppUserProfileValidateBeforeCall(appId, userId, null, null);
        Type localVarReturnType = new TypeToken<AppUserResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call deleteAppUserProfileAsync(String appId, String userId, final ApiCallback<AppUserResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteAppUserProfileValidateBeforeCall(appId, userId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<AppUserResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getAppUserCall(String appId, String userId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v1/apps/{appId}/appusers/{userId}".replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString())).replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"jwt"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getAppUserValidateBeforeCall(String appId, String userId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (appId == null) {
            throw new ApiException("Missing the required parameter 'appId' when calling getAppUser(Async)");
        }
        if (userId == null) {
            throw new ApiException("Missing the required parameter 'userId' when calling getAppUser(Async)");
        }
        Call call = this.getAppUserCall(appId, userId, progressListener, progressRequestListener);
        return call;
    }

    public AppUserResponse getAppUser(String appId, String userId) throws ApiException {
        ApiResponse<AppUserResponse> resp = this.getAppUserWithHttpInfo(appId, userId);
        return resp.getData();
    }

    public ApiResponse<AppUserResponse> getAppUserWithHttpInfo(String appId, String userId) throws ApiException {
        Call call = this.getAppUserValidateBeforeCall(appId, userId, null, null);
        Type localVarReturnType = new TypeToken<AppUserResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getAppUserAsync(String appId, String userId, final ApiCallback<AppUserResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getAppUserValidateBeforeCall(appId, userId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<AppUserResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getAppUserAuthCodeCall(String appId, String userId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v1/apps/{appId}/appusers/{userId}/authcode".replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString())).replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"jwt"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getAppUserAuthCodeValidateBeforeCall(String appId, String userId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (appId == null) {
            throw new ApiException("Missing the required parameter 'appId' when calling getAppUserAuthCode(Async)");
        }
        if (userId == null) {
            throw new ApiException("Missing the required parameter 'userId' when calling getAppUserAuthCode(Async)");
        }
        Call call = this.getAppUserAuthCodeCall(appId, userId, progressListener, progressRequestListener);
        return call;
    }

    public AuthCodeResponse getAppUserAuthCode(String appId, String userId) throws ApiException {
        ApiResponse<AuthCodeResponse> resp = this.getAppUserAuthCodeWithHttpInfo(appId, userId);
        return resp.getData();
    }

    public ApiResponse<AuthCodeResponse> getAppUserAuthCodeWithHttpInfo(String appId, String userId) throws ApiException {
        Call call = this.getAppUserAuthCodeValidateBeforeCall(appId, userId, null, null);
        Type localVarReturnType = new TypeToken<AuthCodeResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getAppUserAuthCodeAsync(String appId, String userId, final ApiCallback<AuthCodeResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getAppUserAuthCodeValidateBeforeCall(appId, userId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<AuthCodeResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getAppUserBusinessSystemIdsCall(String appId, String userId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v1/apps/{appId}/appusers/{userId}/businesssystems".replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString())).replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"jwt"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getAppUserBusinessSystemIdsValidateBeforeCall(String appId, String userId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (appId == null) {
            throw new ApiException("Missing the required parameter 'appId' when calling getAppUserBusinessSystemIds(Async)");
        }
        if (userId == null) {
            throw new ApiException("Missing the required parameter 'userId' when calling getAppUserBusinessSystemIds(Async)");
        }
        Call call = this.getAppUserBusinessSystemIdsCall(appId, userId, progressListener, progressRequestListener);
        return call;
    }

    public AppUserBusinessSystemsResponse getAppUserBusinessSystemIds(String appId, String userId) throws ApiException {
        ApiResponse<AppUserBusinessSystemsResponse> resp = this.getAppUserBusinessSystemIdsWithHttpInfo(appId, userId);
        return resp.getData();
    }

    public ApiResponse<AppUserBusinessSystemsResponse> getAppUserBusinessSystemIdsWithHttpInfo(String appId, String userId) throws ApiException {
        Call call = this.getAppUserBusinessSystemIdsValidateBeforeCall(appId, userId, null, null);
        Type localVarReturnType = new TypeToken<AppUserBusinessSystemsResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getAppUserBusinessSystemIdsAsync(String appId, String userId, final ApiCallback<AppUserBusinessSystemsResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getAppUserBusinessSystemIdsValidateBeforeCall(appId, userId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<AppUserBusinessSystemsResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getAppUserEntityIdsCall(String appId, String userId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v1/apps/{appId}/appusers/{userId}/channels".replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString())).replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"jwt"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getAppUserEntityIdsValidateBeforeCall(String appId, String userId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (appId == null) {
            throw new ApiException("Missing the required parameter 'appId' when calling getAppUserEntityIds(Async)");
        }
        if (userId == null) {
            throw new ApiException("Missing the required parameter 'userId' when calling getAppUserEntityIds(Async)");
        }
        Call call = this.getAppUserEntityIdsCall(appId, userId, progressListener, progressRequestListener);
        return call;
    }

    public AppUserChannelsResponse getAppUserEntityIds(String appId, String userId) throws ApiException {
        ApiResponse<AppUserChannelsResponse> resp = this.getAppUserEntityIdsWithHttpInfo(appId, userId);
        return resp.getData();
    }

    public ApiResponse<AppUserChannelsResponse> getAppUserEntityIdsWithHttpInfo(String appId, String userId) throws ApiException {
        Call call = this.getAppUserEntityIdsValidateBeforeCall(appId, userId, null, null);
        Type localVarReturnType = new TypeToken<AppUserChannelsResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getAppUserEntityIdsAsync(String appId, String userId, final ApiCallback<AppUserChannelsResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getAppUserEntityIdsValidateBeforeCall(appId, userId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<AppUserChannelsResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getLinkRequestsCall(String appId, String userId, List<String> integrationIds, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v1/apps/{appId}/appusers/{userId}/linkrequest".replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString())).replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (integrationIds != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("csv", "integrationIds", integrationIds));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"jwt"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getLinkRequestsValidateBeforeCall(String appId, String userId, List<String> integrationIds, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (appId == null) {
            throw new ApiException("Missing the required parameter 'appId' when calling getLinkRequests(Async)");
        }
        if (userId == null) {
            throw new ApiException("Missing the required parameter 'userId' when calling getLinkRequests(Async)");
        }
        if (integrationIds == null) {
            throw new ApiException("Missing the required parameter 'integrationIds' when calling getLinkRequests(Async)");
        }
        Call call = this.getLinkRequestsCall(appId, userId, integrationIds, progressListener, progressRequestListener);
        return call;
    }

    public LinkRequestResponse getLinkRequests(String appId, String userId, List<String> integrationIds) throws ApiException {
        ApiResponse<LinkRequestResponse> resp = this.getLinkRequestsWithHttpInfo(appId, userId, integrationIds);
        return resp.getData();
    }

    public ApiResponse<LinkRequestResponse> getLinkRequestsWithHttpInfo(String appId, String userId, List<String> integrationIds) throws ApiException {
        Call call = this.getLinkRequestsValidateBeforeCall(appId, userId, integrationIds, null, null);
        Type localVarReturnType = new TypeToken<LinkRequestResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getLinkRequestsAsync(String appId, String userId, List<String> integrationIds, final ApiCallback<LinkRequestResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getLinkRequestsValidateBeforeCall(appId, userId, integrationIds, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<LinkRequestResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call linkAppUserCall(String appId, String userId, AppUserLink appUserLinkBody, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        AppUserLink localVarPostBody = appUserLinkBody;
        String localVarPath = "/v1/apps/{appId}/appusers/{userId}/channels".replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString())).replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"jwt"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call linkAppUserValidateBeforeCall(String appId, String userId, AppUserLink appUserLinkBody, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (appId == null) {
            throw new ApiException("Missing the required parameter 'appId' when calling linkAppUser(Async)");
        }
        if (userId == null) {
            throw new ApiException("Missing the required parameter 'userId' when calling linkAppUser(Async)");
        }
        if (appUserLinkBody == null) {
            throw new ApiException("Missing the required parameter 'appUserLinkBody' when calling linkAppUser(Async)");
        }
        Call call = this.linkAppUserCall(appId, userId, appUserLinkBody, progressListener, progressRequestListener);
        return call;
    }

    public AppUserResponse linkAppUser(String appId, String userId, AppUserLink appUserLinkBody) throws ApiException {
        ApiResponse<AppUserResponse> resp = this.linkAppUserWithHttpInfo(appId, userId, appUserLinkBody);
        return resp.getData();
    }

    public ApiResponse<AppUserResponse> linkAppUserWithHttpInfo(String appId, String userId, AppUserLink appUserLinkBody) throws ApiException {
        Call call = this.linkAppUserValidateBeforeCall(appId, userId, appUserLinkBody, null, null);
        Type localVarReturnType = new TypeToken<AppUserResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call linkAppUserAsync(String appId, String userId, AppUserLink appUserLinkBody, final ApiCallback<AppUserResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.linkAppUserValidateBeforeCall(appId, userId, appUserLinkBody, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<AppUserResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call postImageMessageCall(String appId, String userId, File source, String role, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/v1/apps/{appId}/appusers/{userId}/images".replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString())).replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (source != null) {
            localVarFormParams.put("source", source);
        }
        if (role != null) {
            localVarFormParams.put("role", role);
        }
        if ((localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"jwt"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call postImageMessageValidateBeforeCall(String appId, String userId, File source, String role, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (appId == null) {
            throw new ApiException("Missing the required parameter 'appId' when calling postImageMessage(Async)");
        }
        if (userId == null) {
            throw new ApiException("Missing the required parameter 'userId' when calling postImageMessage(Async)");
        }
        if (source == null) {
            throw new ApiException("Missing the required parameter 'source' when calling postImageMessage(Async)");
        }
        if (role == null) {
            throw new ApiException("Missing the required parameter 'role' when calling postImageMessage(Async)");
        }
        Call call = this.postImageMessageCall(appId, userId, source, role, progressListener, progressRequestListener);
        return call;
    }

    public MessageResponse postImageMessage(String appId, String userId, File source, String role) throws ApiException {
        ApiResponse<MessageResponse> resp = this.postImageMessageWithHttpInfo(appId, userId, source, role);
        return resp.getData();
    }

    public ApiResponse<MessageResponse> postImageMessageWithHttpInfo(String appId, String userId, File source, String role) throws ApiException {
        Call call = this.postImageMessageValidateBeforeCall(appId, userId, source, role, null, null);
        Type localVarReturnType = new TypeToken<MessageResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call postImageMessageAsync(String appId, String userId, File source, String role, final ApiCallback<MessageResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.postImageMessageValidateBeforeCall(appId, userId, source, role, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<MessageResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call preCreateAppUserCall(String appId, AppUserPreCreate appUserPreCreateBody, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        AppUserPreCreate localVarPostBody = appUserPreCreateBody;
        String localVarPath = "/v1/apps/{appId}/appusers".replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"jwt"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call preCreateAppUserValidateBeforeCall(String appId, AppUserPreCreate appUserPreCreateBody, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (appId == null) {
            throw new ApiException("Missing the required parameter 'appId' when calling preCreateAppUser(Async)");
        }
        if (appUserPreCreateBody == null) {
            throw new ApiException("Missing the required parameter 'appUserPreCreateBody' when calling preCreateAppUser(Async)");
        }
        Call call = this.preCreateAppUserCall(appId, appUserPreCreateBody, progressListener, progressRequestListener);
        return call;
    }

    public AppUserResponse preCreateAppUser(String appId, AppUserPreCreate appUserPreCreateBody) throws ApiException {
        ApiResponse<AppUserResponse> resp = this.preCreateAppUserWithHttpInfo(appId, appUserPreCreateBody);
        return resp.getData();
    }

    public ApiResponse<AppUserResponse> preCreateAppUserWithHttpInfo(String appId, AppUserPreCreate appUserPreCreateBody) throws ApiException {
        Call call = this.preCreateAppUserValidateBeforeCall(appId, appUserPreCreateBody, null, null);
        Type localVarReturnType = new TypeToken<AppUserResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call preCreateAppUserAsync(String appId, AppUserPreCreate appUserPreCreateBody, final ApiCallback<AppUserResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.preCreateAppUserValidateBeforeCall(appId, appUserPreCreateBody, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<AppUserResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call unlinkAppUserCall(String appId, String userId, String channel, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v1/apps/{appId}/appusers/{userId}/channels/{channel}".replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString())).replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString())).replaceAll("\\{channel\\}", this.apiClient.escapeString(channel.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"jwt"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call unlinkAppUserValidateBeforeCall(String appId, String userId, String channel, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (appId == null) {
            throw new ApiException("Missing the required parameter 'appId' when calling unlinkAppUser(Async)");
        }
        if (userId == null) {
            throw new ApiException("Missing the required parameter 'userId' when calling unlinkAppUser(Async)");
        }
        if (channel == null) {
            throw new ApiException("Missing the required parameter 'channel' when calling unlinkAppUser(Async)");
        }
        Call call = this.unlinkAppUserCall(appId, userId, channel, progressListener, progressRequestListener);
        return call;
    }

    public void unlinkAppUser(String appId, String userId, String channel) throws ApiException {
        this.unlinkAppUserWithHttpInfo(appId, userId, channel);
    }

    public ApiResponse<Void> unlinkAppUserWithHttpInfo(String appId, String userId, String channel) throws ApiException {
        Call call = this.unlinkAppUserValidateBeforeCall(appId, userId, channel, null, null);
        return this.apiClient.execute(call);
    }

    public Call unlinkAppUserAsync(String appId, String userId, String channel, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.unlinkAppUserValidateBeforeCall(appId, userId, channel, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call updateAppUserCall(String appId, String userId, AppUserUpdate appUserUpdateBody, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        AppUserUpdate localVarPostBody = appUserUpdateBody;
        String localVarPath = "/v1/apps/{appId}/appusers/{userId}".replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString())).replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"jwt"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call updateAppUserValidateBeforeCall(String appId, String userId, AppUserUpdate appUserUpdateBody, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (appId == null) {
            throw new ApiException("Missing the required parameter 'appId' when calling updateAppUser(Async)");
        }
        if (userId == null) {
            throw new ApiException("Missing the required parameter 'userId' when calling updateAppUser(Async)");
        }
        if (appUserUpdateBody == null) {
            throw new ApiException("Missing the required parameter 'appUserUpdateBody' when calling updateAppUser(Async)");
        }
        Call call = this.updateAppUserCall(appId, userId, appUserUpdateBody, progressListener, progressRequestListener);
        return call;
    }

    public AppUserResponse updateAppUser(String appId, String userId, AppUserUpdate appUserUpdateBody) throws ApiException {
        ApiResponse<AppUserResponse> resp = this.updateAppUserWithHttpInfo(appId, userId, appUserUpdateBody);
        return resp.getData();
    }

    public ApiResponse<AppUserResponse> updateAppUserWithHttpInfo(String appId, String userId, AppUserUpdate appUserUpdateBody) throws ApiException {
        Call call = this.updateAppUserValidateBeforeCall(appId, userId, appUserUpdateBody, null, null);
        Type localVarReturnType = new TypeToken<AppUserResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call updateAppUserAsync(String appId, String userId, AppUserUpdate appUserUpdateBody, final ApiCallback<AppUserResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.updateAppUserValidateBeforeCall(appId, userId, appUserUpdateBody, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<AppUserResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

