/*
 * Decompiled with CFR 0.152.
 */
package io.smooch.client.api;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import io.smooch.client.ApiCallback;
import io.smooch.client.ApiClient;
import io.smooch.client.ApiException;
import io.smooch.client.ApiResponse;
import io.smooch.client.Configuration;
import io.smooch.client.Pair;
import io.smooch.client.ProgressRequestBody;
import io.smooch.client.ProgressResponseBody;
import io.smooch.client.model.AttachmentRemove;
import io.smooch.client.model.AttachmentResponse;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;

public class AttachmentsApi {
    private ApiClient apiClient;

    public AttachmentsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AttachmentsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call removeAttachmentCall(String appId, AttachmentRemove attachmentRemoveBody, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        AttachmentRemove localVarPostBody = attachmentRemoveBody;
        String localVarPath = "/v1/apps/{appId}/attachments/remove".replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"jwt"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call removeAttachmentValidateBeforeCall(String appId, AttachmentRemove attachmentRemoveBody, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (appId == null) {
            throw new ApiException("Missing the required parameter 'appId' when calling removeAttachment(Async)");
        }
        if (attachmentRemoveBody == null) {
            throw new ApiException("Missing the required parameter 'attachmentRemoveBody' when calling removeAttachment(Async)");
        }
        Call call = this.removeAttachmentCall(appId, attachmentRemoveBody, progressListener, progressRequestListener);
        return call;
    }

    public void removeAttachment(String appId, AttachmentRemove attachmentRemoveBody) throws ApiException {
        this.removeAttachmentWithHttpInfo(appId, attachmentRemoveBody);
    }

    public ApiResponse<Void> removeAttachmentWithHttpInfo(String appId, AttachmentRemove attachmentRemoveBody) throws ApiException {
        Call call = this.removeAttachmentValidateBeforeCall(appId, attachmentRemoveBody, null, null);
        return this.apiClient.execute(call);
    }

    public Call removeAttachmentAsync(String appId, AttachmentRemove attachmentRemoveBody, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.removeAttachmentValidateBeforeCall(appId, attachmentRemoveBody, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call uploadAttachmentCall(String appId, File source, String access, String _for, String appUserId, String userId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/v1/apps/{appId}/attachments".replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (access != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "access", access));
        }
        if (_for != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "for", _for));
        }
        if (appUserId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "appUserId", appUserId));
        }
        if (userId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "userId", userId));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (source != null) {
            localVarFormParams.put("source", source);
        }
        if ((localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"jwt"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call uploadAttachmentValidateBeforeCall(String appId, File source, String access, String _for, String appUserId, String userId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (appId == null) {
            throw new ApiException("Missing the required parameter 'appId' when calling uploadAttachment(Async)");
        }
        if (source == null) {
            throw new ApiException("Missing the required parameter 'source' when calling uploadAttachment(Async)");
        }
        if (access == null) {
            throw new ApiException("Missing the required parameter 'access' when calling uploadAttachment(Async)");
        }
        Call call = this.uploadAttachmentCall(appId, source, access, _for, appUserId, userId, progressListener, progressRequestListener);
        return call;
    }

    public AttachmentResponse uploadAttachment(String appId, File source, String access, String _for, String appUserId, String userId) throws ApiException {
        ApiResponse<AttachmentResponse> resp = this.uploadAttachmentWithHttpInfo(appId, source, access, _for, appUserId, userId);
        return resp.getData();
    }

    public ApiResponse<AttachmentResponse> uploadAttachmentWithHttpInfo(String appId, File source, String access, String _for, String appUserId, String userId) throws ApiException {
        Call call = this.uploadAttachmentValidateBeforeCall(appId, source, access, _for, appUserId, userId, null, null);
        Type localVarReturnType = new TypeToken<AttachmentResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call uploadAttachmentAsync(String appId, File source, String access, String _for, String appUserId, String userId, final ApiCallback<AttachmentResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.uploadAttachmentValidateBeforeCall(appId, source, access, _for, appUserId, userId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<AttachmentResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

