/*
 * Decompiled with CFR 0.152.
 */
package io.smooch.client.api;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import io.smooch.client.ApiCallback;
import io.smooch.client.ApiClient;
import io.smooch.client.ApiException;
import io.smooch.client.ApiResponse;
import io.smooch.client.Configuration;
import io.smooch.client.Pair;
import io.smooch.client.ProgressRequestBody;
import io.smooch.client.ProgressResponseBody;
import io.smooch.client.model.GetMessagesResponse;
import io.smooch.client.model.MessagePost;
import io.smooch.client.model.MessageResponse;
import io.smooch.client.model.TypingActivityTrigger;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;

public class ConversationApi {
    private ApiClient apiClient;

    public ConversationApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ConversationApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call deleteMessageCall(String appId, String userId, String messageId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v1/apps/{appId}/appusers/{userId}/messages/{messageId}".replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString())).replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString())).replaceAll("\\{messageId\\}", this.apiClient.escapeString(messageId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"jwt"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deleteMessageValidateBeforeCall(String appId, String userId, String messageId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (appId == null) {
            throw new ApiException("Missing the required parameter 'appId' when calling deleteMessage(Async)");
        }
        if (userId == null) {
            throw new ApiException("Missing the required parameter 'userId' when calling deleteMessage(Async)");
        }
        if (messageId == null) {
            throw new ApiException("Missing the required parameter 'messageId' when calling deleteMessage(Async)");
        }
        Call call = this.deleteMessageCall(appId, userId, messageId, progressListener, progressRequestListener);
        return call;
    }

    public void deleteMessage(String appId, String userId, String messageId) throws ApiException {
        this.deleteMessageWithHttpInfo(appId, userId, messageId);
    }

    public ApiResponse<Void> deleteMessageWithHttpInfo(String appId, String userId, String messageId) throws ApiException {
        Call call = this.deleteMessageValidateBeforeCall(appId, userId, messageId, null, null);
        return this.apiClient.execute(call);
    }

    public Call deleteMessageAsync(String appId, String userId, String messageId, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteMessageValidateBeforeCall(appId, userId, messageId, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call deleteMessagesCall(String appId, String userId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v1/apps/{appId}/appusers/{userId}/messages".replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString())).replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"jwt"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deleteMessagesValidateBeforeCall(String appId, String userId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (appId == null) {
            throw new ApiException("Missing the required parameter 'appId' when calling deleteMessages(Async)");
        }
        if (userId == null) {
            throw new ApiException("Missing the required parameter 'userId' when calling deleteMessages(Async)");
        }
        Call call = this.deleteMessagesCall(appId, userId, progressListener, progressRequestListener);
        return call;
    }

    public void deleteMessages(String appId, String userId) throws ApiException {
        this.deleteMessagesWithHttpInfo(appId, userId);
    }

    public ApiResponse<Void> deleteMessagesWithHttpInfo(String appId, String userId) throws ApiException {
        Call call = this.deleteMessagesValidateBeforeCall(appId, userId, null, null);
        return this.apiClient.execute(call);
    }

    public Call deleteMessagesAsync(String appId, String userId, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteMessagesValidateBeforeCall(appId, userId, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call getMessagesCall(String appId, String userId, String before, String after, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v1/apps/{appId}/appusers/{userId}/messages".replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString())).replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (before != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "before", before));
        }
        if (after != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "after", after));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"jwt"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getMessagesValidateBeforeCall(String appId, String userId, String before, String after, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (appId == null) {
            throw new ApiException("Missing the required parameter 'appId' when calling getMessages(Async)");
        }
        if (userId == null) {
            throw new ApiException("Missing the required parameter 'userId' when calling getMessages(Async)");
        }
        Call call = this.getMessagesCall(appId, userId, before, after, progressListener, progressRequestListener);
        return call;
    }

    public GetMessagesResponse getMessages(String appId, String userId, String before, String after) throws ApiException {
        ApiResponse<GetMessagesResponse> resp = this.getMessagesWithHttpInfo(appId, userId, before, after);
        return resp.getData();
    }

    public ApiResponse<GetMessagesResponse> getMessagesWithHttpInfo(String appId, String userId, String before, String after) throws ApiException {
        Call call = this.getMessagesValidateBeforeCall(appId, userId, before, after, null, null);
        Type localVarReturnType = new TypeToken<GetMessagesResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getMessagesAsync(String appId, String userId, String before, String after, final ApiCallback<GetMessagesResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getMessagesValidateBeforeCall(appId, userId, before, after, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<GetMessagesResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call postMessageCall(String appId, String userId, MessagePost messagePostBody, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        MessagePost localVarPostBody = messagePostBody;
        String localVarPath = "/v1/apps/{appId}/appusers/{userId}/messages".replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString())).replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"jwt"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call postMessageValidateBeforeCall(String appId, String userId, MessagePost messagePostBody, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (appId == null) {
            throw new ApiException("Missing the required parameter 'appId' when calling postMessage(Async)");
        }
        if (userId == null) {
            throw new ApiException("Missing the required parameter 'userId' when calling postMessage(Async)");
        }
        if (messagePostBody == null) {
            throw new ApiException("Missing the required parameter 'messagePostBody' when calling postMessage(Async)");
        }
        Call call = this.postMessageCall(appId, userId, messagePostBody, progressListener, progressRequestListener);
        return call;
    }

    public MessageResponse postMessage(String appId, String userId, MessagePost messagePostBody) throws ApiException {
        ApiResponse<MessageResponse> resp = this.postMessageWithHttpInfo(appId, userId, messagePostBody);
        return resp.getData();
    }

    public ApiResponse<MessageResponse> postMessageWithHttpInfo(String appId, String userId, MessagePost messagePostBody) throws ApiException {
        Call call = this.postMessageValidateBeforeCall(appId, userId, messagePostBody, null, null);
        Type localVarReturnType = new TypeToken<MessageResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call postMessageAsync(String appId, String userId, MessagePost messagePostBody, final ApiCallback<MessageResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.postMessageValidateBeforeCall(appId, userId, messagePostBody, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<MessageResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call resetUnreadCountCall(String appId, String userId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v1/apps/{appId}/appusers/{userId}/conversation/read".replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString())).replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"jwt"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call resetUnreadCountValidateBeforeCall(String appId, String userId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (appId == null) {
            throw new ApiException("Missing the required parameter 'appId' when calling resetUnreadCount(Async)");
        }
        if (userId == null) {
            throw new ApiException("Missing the required parameter 'userId' when calling resetUnreadCount(Async)");
        }
        Call call = this.resetUnreadCountCall(appId, userId, progressListener, progressRequestListener);
        return call;
    }

    public void resetUnreadCount(String appId, String userId) throws ApiException {
        this.resetUnreadCountWithHttpInfo(appId, userId);
    }

    public ApiResponse<Void> resetUnreadCountWithHttpInfo(String appId, String userId) throws ApiException {
        Call call = this.resetUnreadCountValidateBeforeCall(appId, userId, null, null);
        return this.apiClient.execute(call);
    }

    public Call resetUnreadCountAsync(String appId, String userId, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.resetUnreadCountValidateBeforeCall(appId, userId, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call triggerTypingActivityCall(String appId, String userId, TypingActivityTrigger typingActivityTriggerBody, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        TypingActivityTrigger localVarPostBody = typingActivityTriggerBody;
        String localVarPath = "/v1/apps/{appId}/appusers/{userId}/conversation/activity".replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString())).replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"jwt"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call triggerTypingActivityValidateBeforeCall(String appId, String userId, TypingActivityTrigger typingActivityTriggerBody, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (appId == null) {
            throw new ApiException("Missing the required parameter 'appId' when calling triggerTypingActivity(Async)");
        }
        if (userId == null) {
            throw new ApiException("Missing the required parameter 'userId' when calling triggerTypingActivity(Async)");
        }
        if (typingActivityTriggerBody == null) {
            throw new ApiException("Missing the required parameter 'typingActivityTriggerBody' when calling triggerTypingActivity(Async)");
        }
        Call call = this.triggerTypingActivityCall(appId, userId, typingActivityTriggerBody, progressListener, progressRequestListener);
        return call;
    }

    public void triggerTypingActivity(String appId, String userId, TypingActivityTrigger typingActivityTriggerBody) throws ApiException {
        this.triggerTypingActivityWithHttpInfo(appId, userId, typingActivityTriggerBody);
    }

    public ApiResponse<Void> triggerTypingActivityWithHttpInfo(String appId, String userId, TypingActivityTrigger typingActivityTriggerBody) throws ApiException {
        Call call = this.triggerTypingActivityValidateBeforeCall(appId, userId, typingActivityTriggerBody, null, null);
        return this.apiClient.execute(call);
    }

    public Call triggerTypingActivityAsync(String appId, String userId, TypingActivityTrigger typingActivityTriggerBody, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.triggerTypingActivityValidateBeforeCall(appId, userId, typingActivityTriggerBody, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }
}

