/*
 * Decompiled with CFR 0.152.
 */
package io.smooch.client.api;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import io.smooch.client.ApiCallback;
import io.smooch.client.ApiClient;
import io.smooch.client.ApiException;
import io.smooch.client.ApiResponse;
import io.smooch.client.Configuration;
import io.smooch.client.Pair;
import io.smooch.client.ProgressRequestBody;
import io.smooch.client.ProgressResponseBody;
import io.smooch.client.model.IntegrationCreate;
import io.smooch.client.model.IntegrationResponse;
import io.smooch.client.model.IntegrationUpdate;
import io.smooch.client.model.ListIntegrationsResponse;
import io.smooch.client.model.Menu;
import io.smooch.client.model.MenuResponse;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;

public class IntegrationApi {
    private ApiClient apiClient;

    public IntegrationApi() {
        this(Configuration.getDefaultApiClient());
    }

    public IntegrationApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call createIntegrationCall(String appId, IntegrationCreate integrationCreateBody, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        IntegrationCreate localVarPostBody = integrationCreateBody;
        String localVarPath = "/v1/apps/{appId}/integrations".replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"jwt"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call createIntegrationValidateBeforeCall(String appId, IntegrationCreate integrationCreateBody, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (appId == null) {
            throw new ApiException("Missing the required parameter 'appId' when calling createIntegration(Async)");
        }
        if (integrationCreateBody == null) {
            throw new ApiException("Missing the required parameter 'integrationCreateBody' when calling createIntegration(Async)");
        }
        Call call = this.createIntegrationCall(appId, integrationCreateBody, progressListener, progressRequestListener);
        return call;
    }

    public IntegrationResponse createIntegration(String appId, IntegrationCreate integrationCreateBody) throws ApiException {
        ApiResponse<IntegrationResponse> resp = this.createIntegrationWithHttpInfo(appId, integrationCreateBody);
        return resp.getData();
    }

    public ApiResponse<IntegrationResponse> createIntegrationWithHttpInfo(String appId, IntegrationCreate integrationCreateBody) throws ApiException {
        Call call = this.createIntegrationValidateBeforeCall(appId, integrationCreateBody, null, null);
        Type localVarReturnType = new TypeToken<IntegrationResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call createIntegrationAsync(String appId, IntegrationCreate integrationCreateBody, final ApiCallback<IntegrationResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.createIntegrationValidateBeforeCall(appId, integrationCreateBody, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<IntegrationResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call createIntegrationMenuCall(String appId, String integrationId, Menu menuCreateBody, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Menu localVarPostBody = menuCreateBody;
        String localVarPath = "/v1/apps/{appId}/integrations/{integrationId}/menu".replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString())).replaceAll("\\{integrationId\\}", this.apiClient.escapeString(integrationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"jwt"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call createIntegrationMenuValidateBeforeCall(String appId, String integrationId, Menu menuCreateBody, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (appId == null) {
            throw new ApiException("Missing the required parameter 'appId' when calling createIntegrationMenu(Async)");
        }
        if (integrationId == null) {
            throw new ApiException("Missing the required parameter 'integrationId' when calling createIntegrationMenu(Async)");
        }
        if (menuCreateBody == null) {
            throw new ApiException("Missing the required parameter 'menuCreateBody' when calling createIntegrationMenu(Async)");
        }
        Call call = this.createIntegrationMenuCall(appId, integrationId, menuCreateBody, progressListener, progressRequestListener);
        return call;
    }

    public MenuResponse createIntegrationMenu(String appId, String integrationId, Menu menuCreateBody) throws ApiException {
        ApiResponse<MenuResponse> resp = this.createIntegrationMenuWithHttpInfo(appId, integrationId, menuCreateBody);
        return resp.getData();
    }

    public ApiResponse<MenuResponse> createIntegrationMenuWithHttpInfo(String appId, String integrationId, Menu menuCreateBody) throws ApiException {
        Call call = this.createIntegrationMenuValidateBeforeCall(appId, integrationId, menuCreateBody, null, null);
        Type localVarReturnType = new TypeToken<MenuResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call createIntegrationMenuAsync(String appId, String integrationId, Menu menuCreateBody, final ApiCallback<MenuResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.createIntegrationMenuValidateBeforeCall(appId, integrationId, menuCreateBody, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<MenuResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call deleteIntegrationCall(String appId, String integrationId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v1/apps/{appId}/integrations/{integrationId}".replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString())).replaceAll("\\{integrationId\\}", this.apiClient.escapeString(integrationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"jwt"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deleteIntegrationValidateBeforeCall(String appId, String integrationId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (appId == null) {
            throw new ApiException("Missing the required parameter 'appId' when calling deleteIntegration(Async)");
        }
        if (integrationId == null) {
            throw new ApiException("Missing the required parameter 'integrationId' when calling deleteIntegration(Async)");
        }
        Call call = this.deleteIntegrationCall(appId, integrationId, progressListener, progressRequestListener);
        return call;
    }

    public void deleteIntegration(String appId, String integrationId) throws ApiException {
        this.deleteIntegrationWithHttpInfo(appId, integrationId);
    }

    public ApiResponse<Void> deleteIntegrationWithHttpInfo(String appId, String integrationId) throws ApiException {
        Call call = this.deleteIntegrationValidateBeforeCall(appId, integrationId, null, null);
        return this.apiClient.execute(call);
    }

    public Call deleteIntegrationAsync(String appId, String integrationId, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteIntegrationValidateBeforeCall(appId, integrationId, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call deleteIntegrationMenuCall(String appId, String integrationId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v1/apps/{appId}/integrations/{integrationId}/menu".replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString())).replaceAll("\\{integrationId\\}", this.apiClient.escapeString(integrationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"jwt"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deleteIntegrationMenuValidateBeforeCall(String appId, String integrationId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (appId == null) {
            throw new ApiException("Missing the required parameter 'appId' when calling deleteIntegrationMenu(Async)");
        }
        if (integrationId == null) {
            throw new ApiException("Missing the required parameter 'integrationId' when calling deleteIntegrationMenu(Async)");
        }
        Call call = this.deleteIntegrationMenuCall(appId, integrationId, progressListener, progressRequestListener);
        return call;
    }

    public void deleteIntegrationMenu(String appId, String integrationId) throws ApiException {
        this.deleteIntegrationMenuWithHttpInfo(appId, integrationId);
    }

    public ApiResponse<Void> deleteIntegrationMenuWithHttpInfo(String appId, String integrationId) throws ApiException {
        Call call = this.deleteIntegrationMenuValidateBeforeCall(appId, integrationId, null, null);
        return this.apiClient.execute(call);
    }

    public Call deleteIntegrationMenuAsync(String appId, String integrationId, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteIntegrationMenuValidateBeforeCall(appId, integrationId, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call getIntegrationCall(String appId, String integrationId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v1/apps/{appId}/integrations/{integrationId}".replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString())).replaceAll("\\{integrationId\\}", this.apiClient.escapeString(integrationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"jwt"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getIntegrationValidateBeforeCall(String appId, String integrationId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (appId == null) {
            throw new ApiException("Missing the required parameter 'appId' when calling getIntegration(Async)");
        }
        if (integrationId == null) {
            throw new ApiException("Missing the required parameter 'integrationId' when calling getIntegration(Async)");
        }
        Call call = this.getIntegrationCall(appId, integrationId, progressListener, progressRequestListener);
        return call;
    }

    public IntegrationResponse getIntegration(String appId, String integrationId) throws ApiException {
        ApiResponse<IntegrationResponse> resp = this.getIntegrationWithHttpInfo(appId, integrationId);
        return resp.getData();
    }

    public ApiResponse<IntegrationResponse> getIntegrationWithHttpInfo(String appId, String integrationId) throws ApiException {
        Call call = this.getIntegrationValidateBeforeCall(appId, integrationId, null, null);
        Type localVarReturnType = new TypeToken<IntegrationResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getIntegrationAsync(String appId, String integrationId, final ApiCallback<IntegrationResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getIntegrationValidateBeforeCall(appId, integrationId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<IntegrationResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getIntegrationMenuCall(String appId, String integrationId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v1/apps/{appId}/integrations/{integrationId}/menu".replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString())).replaceAll("\\{integrationId\\}", this.apiClient.escapeString(integrationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"jwt"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getIntegrationMenuValidateBeforeCall(String appId, String integrationId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (appId == null) {
            throw new ApiException("Missing the required parameter 'appId' when calling getIntegrationMenu(Async)");
        }
        if (integrationId == null) {
            throw new ApiException("Missing the required parameter 'integrationId' when calling getIntegrationMenu(Async)");
        }
        Call call = this.getIntegrationMenuCall(appId, integrationId, progressListener, progressRequestListener);
        return call;
    }

    public MenuResponse getIntegrationMenu(String appId, String integrationId) throws ApiException {
        ApiResponse<MenuResponse> resp = this.getIntegrationMenuWithHttpInfo(appId, integrationId);
        return resp.getData();
    }

    public ApiResponse<MenuResponse> getIntegrationMenuWithHttpInfo(String appId, String integrationId) throws ApiException {
        Call call = this.getIntegrationMenuValidateBeforeCall(appId, integrationId, null, null);
        Type localVarReturnType = new TypeToken<MenuResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getIntegrationMenuAsync(String appId, String integrationId, final ApiCallback<MenuResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getIntegrationMenuValidateBeforeCall(appId, integrationId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<MenuResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call listIntegrationsCall(String appId, String types, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v1/apps/{appId}/integrations".replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (types != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "types", types));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"jwt"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call listIntegrationsValidateBeforeCall(String appId, String types, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (appId == null) {
            throw new ApiException("Missing the required parameter 'appId' when calling listIntegrations(Async)");
        }
        Call call = this.listIntegrationsCall(appId, types, progressListener, progressRequestListener);
        return call;
    }

    public ListIntegrationsResponse listIntegrations(String appId, String types) throws ApiException {
        ApiResponse<ListIntegrationsResponse> resp = this.listIntegrationsWithHttpInfo(appId, types);
        return resp.getData();
    }

    public ApiResponse<ListIntegrationsResponse> listIntegrationsWithHttpInfo(String appId, String types) throws ApiException {
        Call call = this.listIntegrationsValidateBeforeCall(appId, types, null, null);
        Type localVarReturnType = new TypeToken<ListIntegrationsResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call listIntegrationsAsync(String appId, String types, final ApiCallback<ListIntegrationsResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.listIntegrationsValidateBeforeCall(appId, types, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ListIntegrationsResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call updateIntegrationCall(String appId, String integrationId, IntegrationUpdate integrationUpdateBody, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        IntegrationUpdate localVarPostBody = integrationUpdateBody;
        String localVarPath = "/v1/apps/{appId}/integrations/{integrationId}".replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString())).replaceAll("\\{integrationId\\}", this.apiClient.escapeString(integrationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"jwt"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call updateIntegrationValidateBeforeCall(String appId, String integrationId, IntegrationUpdate integrationUpdateBody, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (appId == null) {
            throw new ApiException("Missing the required parameter 'appId' when calling updateIntegration(Async)");
        }
        if (integrationId == null) {
            throw new ApiException("Missing the required parameter 'integrationId' when calling updateIntegration(Async)");
        }
        if (integrationUpdateBody == null) {
            throw new ApiException("Missing the required parameter 'integrationUpdateBody' when calling updateIntegration(Async)");
        }
        Call call = this.updateIntegrationCall(appId, integrationId, integrationUpdateBody, progressListener, progressRequestListener);
        return call;
    }

    public IntegrationResponse updateIntegration(String appId, String integrationId, IntegrationUpdate integrationUpdateBody) throws ApiException {
        ApiResponse<IntegrationResponse> resp = this.updateIntegrationWithHttpInfo(appId, integrationId, integrationUpdateBody);
        return resp.getData();
    }

    public ApiResponse<IntegrationResponse> updateIntegrationWithHttpInfo(String appId, String integrationId, IntegrationUpdate integrationUpdateBody) throws ApiException {
        Call call = this.updateIntegrationValidateBeforeCall(appId, integrationId, integrationUpdateBody, null, null);
        Type localVarReturnType = new TypeToken<IntegrationResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call updateIntegrationAsync(String appId, String integrationId, IntegrationUpdate integrationUpdateBody, final ApiCallback<IntegrationResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.updateIntegrationValidateBeforeCall(appId, integrationId, integrationUpdateBody, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<IntegrationResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call updateIntegrationMenuCall(String appId, String integrationId, Menu menuUpdateBody, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Menu localVarPostBody = menuUpdateBody;
        String localVarPath = "/v1/apps/{appId}/integrations/{integrationId}/menu".replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString())).replaceAll("\\{integrationId\\}", this.apiClient.escapeString(integrationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"jwt"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call updateIntegrationMenuValidateBeforeCall(String appId, String integrationId, Menu menuUpdateBody, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (appId == null) {
            throw new ApiException("Missing the required parameter 'appId' when calling updateIntegrationMenu(Async)");
        }
        if (integrationId == null) {
            throw new ApiException("Missing the required parameter 'integrationId' when calling updateIntegrationMenu(Async)");
        }
        if (menuUpdateBody == null) {
            throw new ApiException("Missing the required parameter 'menuUpdateBody' when calling updateIntegrationMenu(Async)");
        }
        Call call = this.updateIntegrationMenuCall(appId, integrationId, menuUpdateBody, progressListener, progressRequestListener);
        return call;
    }

    public MenuResponse updateIntegrationMenu(String appId, String integrationId, Menu menuUpdateBody) throws ApiException {
        ApiResponse<MenuResponse> resp = this.updateIntegrationMenuWithHttpInfo(appId, integrationId, menuUpdateBody);
        return resp.getData();
    }

    public ApiResponse<MenuResponse> updateIntegrationMenuWithHttpInfo(String appId, String integrationId, Menu menuUpdateBody) throws ApiException {
        Call call = this.updateIntegrationMenuValidateBeforeCall(appId, integrationId, menuUpdateBody, null, null);
        Type localVarReturnType = new TypeToken<MenuResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call updateIntegrationMenuAsync(String appId, String integrationId, Menu menuUpdateBody, final ApiCallback<MenuResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.updateIntegrationMenuValidateBeforeCall(appId, integrationId, menuUpdateBody, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<MenuResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

