/*
 * Decompiled with CFR 0.152.
 */
package io.smooch.client.api;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import io.smooch.client.ApiCallback;
import io.smooch.client.ApiClient;
import io.smooch.client.ApiException;
import io.smooch.client.ApiResponse;
import io.smooch.client.Configuration;
import io.smooch.client.Pair;
import io.smooch.client.ProgressRequestBody;
import io.smooch.client.ProgressResponseBody;
import io.smooch.client.model.JwtResponse;
import io.smooch.client.model.ListSecretKeysResponse;
import io.smooch.client.model.ListServiceAccountsResponse;
import io.smooch.client.model.SecretKeyCreate;
import io.smooch.client.model.SecretKeyResponse;
import io.smooch.client.model.ServiceAccountCreate;
import io.smooch.client.model.ServiceAccountResponse;
import io.smooch.client.model.ServiceAccountUpdate;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;

public class ServiceAccountApi {
    private ApiClient apiClient;

    public ServiceAccountApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ServiceAccountApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call createSecretKeyCall(String serviceAccountId, SecretKeyCreate secretKeyCreateBody, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        SecretKeyCreate localVarPostBody = secretKeyCreateBody;
        String localVarPath = "/v1/serviceaccounts/{serviceAccountId}/keys".replaceAll("\\{serviceAccountId\\}", this.apiClient.escapeString(serviceAccountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"jwt"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call createSecretKeyValidateBeforeCall(String serviceAccountId, SecretKeyCreate secretKeyCreateBody, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (serviceAccountId == null) {
            throw new ApiException("Missing the required parameter 'serviceAccountId' when calling createSecretKey(Async)");
        }
        if (secretKeyCreateBody == null) {
            throw new ApiException("Missing the required parameter 'secretKeyCreateBody' when calling createSecretKey(Async)");
        }
        Call call = this.createSecretKeyCall(serviceAccountId, secretKeyCreateBody, progressListener, progressRequestListener);
        return call;
    }

    public SecretKeyResponse createSecretKey(String serviceAccountId, SecretKeyCreate secretKeyCreateBody) throws ApiException {
        ApiResponse<SecretKeyResponse> resp = this.createSecretKeyWithHttpInfo(serviceAccountId, secretKeyCreateBody);
        return resp.getData();
    }

    public ApiResponse<SecretKeyResponse> createSecretKeyWithHttpInfo(String serviceAccountId, SecretKeyCreate secretKeyCreateBody) throws ApiException {
        Call call = this.createSecretKeyValidateBeforeCall(serviceAccountId, secretKeyCreateBody, null, null);
        Type localVarReturnType = new TypeToken<SecretKeyResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call createSecretKeyAsync(String serviceAccountId, SecretKeyCreate secretKeyCreateBody, final ApiCallback<SecretKeyResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.createSecretKeyValidateBeforeCall(serviceAccountId, secretKeyCreateBody, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<SecretKeyResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call createServiceAccountCall(ServiceAccountCreate serviceAccountCreateBody, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        ServiceAccountCreate localVarPostBody = serviceAccountCreateBody;
        String localVarPath = "/v1/serviceaccounts";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"jwt"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call createServiceAccountValidateBeforeCall(ServiceAccountCreate serviceAccountCreateBody, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (serviceAccountCreateBody == null) {
            throw new ApiException("Missing the required parameter 'serviceAccountCreateBody' when calling createServiceAccount(Async)");
        }
        Call call = this.createServiceAccountCall(serviceAccountCreateBody, progressListener, progressRequestListener);
        return call;
    }

    public ServiceAccountResponse createServiceAccount(ServiceAccountCreate serviceAccountCreateBody) throws ApiException {
        ApiResponse<ServiceAccountResponse> resp = this.createServiceAccountWithHttpInfo(serviceAccountCreateBody);
        return resp.getData();
    }

    public ApiResponse<ServiceAccountResponse> createServiceAccountWithHttpInfo(ServiceAccountCreate serviceAccountCreateBody) throws ApiException {
        Call call = this.createServiceAccountValidateBeforeCall(serviceAccountCreateBody, null, null);
        Type localVarReturnType = new TypeToken<ServiceAccountResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call createServiceAccountAsync(ServiceAccountCreate serviceAccountCreateBody, final ApiCallback<ServiceAccountResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.createServiceAccountValidateBeforeCall(serviceAccountCreateBody, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ServiceAccountResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call deleteSecretKeyCall(String serviceAccountId, String keyId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v1/serviceaccounts/{serviceAccountId}/keys/{keyId}".replaceAll("\\{serviceAccountId\\}", this.apiClient.escapeString(serviceAccountId.toString())).replaceAll("\\{keyId\\}", this.apiClient.escapeString(keyId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"jwt"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deleteSecretKeyValidateBeforeCall(String serviceAccountId, String keyId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (serviceAccountId == null) {
            throw new ApiException("Missing the required parameter 'serviceAccountId' when calling deleteSecretKey(Async)");
        }
        if (keyId == null) {
            throw new ApiException("Missing the required parameter 'keyId' when calling deleteSecretKey(Async)");
        }
        Call call = this.deleteSecretKeyCall(serviceAccountId, keyId, progressListener, progressRequestListener);
        return call;
    }

    public void deleteSecretKey(String serviceAccountId, String keyId) throws ApiException {
        this.deleteSecretKeyWithHttpInfo(serviceAccountId, keyId);
    }

    public ApiResponse<Void> deleteSecretKeyWithHttpInfo(String serviceAccountId, String keyId) throws ApiException {
        Call call = this.deleteSecretKeyValidateBeforeCall(serviceAccountId, keyId, null, null);
        return this.apiClient.execute(call);
    }

    public Call deleteSecretKeyAsync(String serviceAccountId, String keyId, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteSecretKeyValidateBeforeCall(serviceAccountId, keyId, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call deleteServiceAccountCall(String serviceAccountId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v1/serviceaccounts/{serviceAccountId}".replaceAll("\\{serviceAccountId\\}", this.apiClient.escapeString(serviceAccountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"jwt"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deleteServiceAccountValidateBeforeCall(String serviceAccountId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (serviceAccountId == null) {
            throw new ApiException("Missing the required parameter 'serviceAccountId' when calling deleteServiceAccount(Async)");
        }
        Call call = this.deleteServiceAccountCall(serviceAccountId, progressListener, progressRequestListener);
        return call;
    }

    public void deleteServiceAccount(String serviceAccountId) throws ApiException {
        this.deleteServiceAccountWithHttpInfo(serviceAccountId);
    }

    public ApiResponse<Void> deleteServiceAccountWithHttpInfo(String serviceAccountId) throws ApiException {
        Call call = this.deleteServiceAccountValidateBeforeCall(serviceAccountId, null, null);
        return this.apiClient.execute(call);
    }

    public Call deleteServiceAccountAsync(String serviceAccountId, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteServiceAccountValidateBeforeCall(serviceAccountId, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call getJwtCall(String serviceAccountId, String keyId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v1/serviceaccounts/{serviceAccountId}/keys/{keyId}/jwt".replaceAll("\\{serviceAccountId\\}", this.apiClient.escapeString(serviceAccountId.toString())).replaceAll("\\{keyId\\}", this.apiClient.escapeString(keyId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"jwt"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getJwtValidateBeforeCall(String serviceAccountId, String keyId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (serviceAccountId == null) {
            throw new ApiException("Missing the required parameter 'serviceAccountId' when calling getJwt(Async)");
        }
        if (keyId == null) {
            throw new ApiException("Missing the required parameter 'keyId' when calling getJwt(Async)");
        }
        Call call = this.getJwtCall(serviceAccountId, keyId, progressListener, progressRequestListener);
        return call;
    }

    public JwtResponse getJwt(String serviceAccountId, String keyId) throws ApiException {
        ApiResponse<JwtResponse> resp = this.getJwtWithHttpInfo(serviceAccountId, keyId);
        return resp.getData();
    }

    public ApiResponse<JwtResponse> getJwtWithHttpInfo(String serviceAccountId, String keyId) throws ApiException {
        Call call = this.getJwtValidateBeforeCall(serviceAccountId, keyId, null, null);
        Type localVarReturnType = new TypeToken<JwtResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getJwtAsync(String serviceAccountId, String keyId, final ApiCallback<JwtResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getJwtValidateBeforeCall(serviceAccountId, keyId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<JwtResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getSecretKeyCall(String serviceAccountId, String keyId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v1/serviceaccounts/{serviceAccountId}/keys/{keyId}".replaceAll("\\{serviceAccountId\\}", this.apiClient.escapeString(serviceAccountId.toString())).replaceAll("\\{keyId\\}", this.apiClient.escapeString(keyId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"jwt"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getSecretKeyValidateBeforeCall(String serviceAccountId, String keyId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (serviceAccountId == null) {
            throw new ApiException("Missing the required parameter 'serviceAccountId' when calling getSecretKey(Async)");
        }
        if (keyId == null) {
            throw new ApiException("Missing the required parameter 'keyId' when calling getSecretKey(Async)");
        }
        Call call = this.getSecretKeyCall(serviceAccountId, keyId, progressListener, progressRequestListener);
        return call;
    }

    public SecretKeyResponse getSecretKey(String serviceAccountId, String keyId) throws ApiException {
        ApiResponse<SecretKeyResponse> resp = this.getSecretKeyWithHttpInfo(serviceAccountId, keyId);
        return resp.getData();
    }

    public ApiResponse<SecretKeyResponse> getSecretKeyWithHttpInfo(String serviceAccountId, String keyId) throws ApiException {
        Call call = this.getSecretKeyValidateBeforeCall(serviceAccountId, keyId, null, null);
        Type localVarReturnType = new TypeToken<SecretKeyResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getSecretKeyAsync(String serviceAccountId, String keyId, final ApiCallback<SecretKeyResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getSecretKeyValidateBeforeCall(serviceAccountId, keyId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<SecretKeyResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getServiceAccountCall(String serviceAccountId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v1/serviceaccounts/{serviceAccountId}".replaceAll("\\{serviceAccountId\\}", this.apiClient.escapeString(serviceAccountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"jwt"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getServiceAccountValidateBeforeCall(String serviceAccountId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (serviceAccountId == null) {
            throw new ApiException("Missing the required parameter 'serviceAccountId' when calling getServiceAccount(Async)");
        }
        Call call = this.getServiceAccountCall(serviceAccountId, progressListener, progressRequestListener);
        return call;
    }

    public ServiceAccountResponse getServiceAccount(String serviceAccountId) throws ApiException {
        ApiResponse<ServiceAccountResponse> resp = this.getServiceAccountWithHttpInfo(serviceAccountId);
        return resp.getData();
    }

    public ApiResponse<ServiceAccountResponse> getServiceAccountWithHttpInfo(String serviceAccountId) throws ApiException {
        Call call = this.getServiceAccountValidateBeforeCall(serviceAccountId, null, null);
        Type localVarReturnType = new TypeToken<ServiceAccountResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getServiceAccountAsync(String serviceAccountId, final ApiCallback<ServiceAccountResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getServiceAccountValidateBeforeCall(serviceAccountId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ServiceAccountResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call listSecretKeysCall(String serviceAccountId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v1/serviceaccounts/{serviceAccountId}/keys".replaceAll("\\{serviceAccountId\\}", this.apiClient.escapeString(serviceAccountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"jwt"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call listSecretKeysValidateBeforeCall(String serviceAccountId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (serviceAccountId == null) {
            throw new ApiException("Missing the required parameter 'serviceAccountId' when calling listSecretKeys(Async)");
        }
        Call call = this.listSecretKeysCall(serviceAccountId, progressListener, progressRequestListener);
        return call;
    }

    public ListSecretKeysResponse listSecretKeys(String serviceAccountId) throws ApiException {
        ApiResponse<ListSecretKeysResponse> resp = this.listSecretKeysWithHttpInfo(serviceAccountId);
        return resp.getData();
    }

    public ApiResponse<ListSecretKeysResponse> listSecretKeysWithHttpInfo(String serviceAccountId) throws ApiException {
        Call call = this.listSecretKeysValidateBeforeCall(serviceAccountId, null, null);
        Type localVarReturnType = new TypeToken<ListSecretKeysResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call listSecretKeysAsync(String serviceAccountId, final ApiCallback<ListSecretKeysResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.listSecretKeysValidateBeforeCall(serviceAccountId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ListSecretKeysResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call listServiceAccountsCall(Integer limit, Integer offset, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v1/serviceaccounts";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (limit != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "offset", offset));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"jwt"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call listServiceAccountsValidateBeforeCall(Integer limit, Integer offset, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.listServiceAccountsCall(limit, offset, progressListener, progressRequestListener);
        return call;
    }

    public ListServiceAccountsResponse listServiceAccounts(Integer limit, Integer offset) throws ApiException {
        ApiResponse<ListServiceAccountsResponse> resp = this.listServiceAccountsWithHttpInfo(limit, offset);
        return resp.getData();
    }

    public ApiResponse<ListServiceAccountsResponse> listServiceAccountsWithHttpInfo(Integer limit, Integer offset) throws ApiException {
        Call call = this.listServiceAccountsValidateBeforeCall(limit, offset, null, null);
        Type localVarReturnType = new TypeToken<ListServiceAccountsResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call listServiceAccountsAsync(Integer limit, Integer offset, final ApiCallback<ListServiceAccountsResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.listServiceAccountsValidateBeforeCall(limit, offset, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ListServiceAccountsResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call updateServiceAccountCall(String serviceAccountId, ServiceAccountUpdate serviceAccountUpdateBody, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        ServiceAccountUpdate localVarPostBody = serviceAccountUpdateBody;
        String localVarPath = "/v1/serviceaccounts/{serviceAccountId}".replaceAll("\\{serviceAccountId\\}", this.apiClient.escapeString(serviceAccountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"jwt"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call updateServiceAccountValidateBeforeCall(String serviceAccountId, ServiceAccountUpdate serviceAccountUpdateBody, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (serviceAccountId == null) {
            throw new ApiException("Missing the required parameter 'serviceAccountId' when calling updateServiceAccount(Async)");
        }
        if (serviceAccountUpdateBody == null) {
            throw new ApiException("Missing the required parameter 'serviceAccountUpdateBody' when calling updateServiceAccount(Async)");
        }
        Call call = this.updateServiceAccountCall(serviceAccountId, serviceAccountUpdateBody, progressListener, progressRequestListener);
        return call;
    }

    public ServiceAccountResponse updateServiceAccount(String serviceAccountId, ServiceAccountUpdate serviceAccountUpdateBody) throws ApiException {
        ApiResponse<ServiceAccountResponse> resp = this.updateServiceAccountWithHttpInfo(serviceAccountId, serviceAccountUpdateBody);
        return resp.getData();
    }

    public ApiResponse<ServiceAccountResponse> updateServiceAccountWithHttpInfo(String serviceAccountId, ServiceAccountUpdate serviceAccountUpdateBody) throws ApiException {
        Call call = this.updateServiceAccountValidateBeforeCall(serviceAccountId, serviceAccountUpdateBody, null, null);
        Type localVarReturnType = new TypeToken<ServiceAccountResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call updateServiceAccountAsync(String serviceAccountId, ServiceAccountUpdate serviceAccountUpdateBody, final ApiCallback<ServiceAccountResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.updateServiceAccountValidateBeforeCall(serviceAccountId, serviceAccountUpdateBody, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ServiceAccountResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

