/*
 * Decompiled with CFR 0.152.
 */
package io.smooch.client.api;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import io.smooch.client.ApiCallback;
import io.smooch.client.ApiClient;
import io.smooch.client.ApiException;
import io.smooch.client.ApiResponse;
import io.smooch.client.Configuration;
import io.smooch.client.Pair;
import io.smooch.client.ProgressRequestBody;
import io.smooch.client.ProgressResponseBody;
import io.smooch.client.model.ListTemplatesResponse;
import io.smooch.client.model.TemplateCreate;
import io.smooch.client.model.TemplateResponse;
import io.smooch.client.model.TemplateUpdate;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;

public class TemplateApi {
    private ApiClient apiClient;

    public TemplateApi() {
        this(Configuration.getDefaultApiClient());
    }

    public TemplateApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call createTemplateCall(String appId, TemplateCreate templateCreateBody, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        TemplateCreate localVarPostBody = templateCreateBody;
        String localVarPath = "/v1/apps/{appId}/templates".replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"jwt"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call createTemplateValidateBeforeCall(String appId, TemplateCreate templateCreateBody, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (appId == null) {
            throw new ApiException("Missing the required parameter 'appId' when calling createTemplate(Async)");
        }
        if (templateCreateBody == null) {
            throw new ApiException("Missing the required parameter 'templateCreateBody' when calling createTemplate(Async)");
        }
        Call call = this.createTemplateCall(appId, templateCreateBody, progressListener, progressRequestListener);
        return call;
    }

    public TemplateResponse createTemplate(String appId, TemplateCreate templateCreateBody) throws ApiException {
        ApiResponse<TemplateResponse> resp = this.createTemplateWithHttpInfo(appId, templateCreateBody);
        return resp.getData();
    }

    public ApiResponse<TemplateResponse> createTemplateWithHttpInfo(String appId, TemplateCreate templateCreateBody) throws ApiException {
        Call call = this.createTemplateValidateBeforeCall(appId, templateCreateBody, null, null);
        Type localVarReturnType = new TypeToken<TemplateResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call createTemplateAsync(String appId, TemplateCreate templateCreateBody, final ApiCallback<TemplateResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.createTemplateValidateBeforeCall(appId, templateCreateBody, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<TemplateResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call deleteTemplateCall(String appId, String templateId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v1/apps/{appId}/templates/{templateId}".replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString())).replaceAll("\\{templateId\\}", this.apiClient.escapeString(templateId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"jwt"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deleteTemplateValidateBeforeCall(String appId, String templateId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (appId == null) {
            throw new ApiException("Missing the required parameter 'appId' when calling deleteTemplate(Async)");
        }
        if (templateId == null) {
            throw new ApiException("Missing the required parameter 'templateId' when calling deleteTemplate(Async)");
        }
        Call call = this.deleteTemplateCall(appId, templateId, progressListener, progressRequestListener);
        return call;
    }

    public void deleteTemplate(String appId, String templateId) throws ApiException {
        this.deleteTemplateWithHttpInfo(appId, templateId);
    }

    public ApiResponse<Void> deleteTemplateWithHttpInfo(String appId, String templateId) throws ApiException {
        Call call = this.deleteTemplateValidateBeforeCall(appId, templateId, null, null);
        return this.apiClient.execute(call);
    }

    public Call deleteTemplateAsync(String appId, String templateId, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteTemplateValidateBeforeCall(appId, templateId, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call getTemplateCall(String appId, String templateId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v1/apps/{appId}/templates/{templateId}".replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString())).replaceAll("\\{templateId\\}", this.apiClient.escapeString(templateId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"jwt"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getTemplateValidateBeforeCall(String appId, String templateId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (appId == null) {
            throw new ApiException("Missing the required parameter 'appId' when calling getTemplate(Async)");
        }
        if (templateId == null) {
            throw new ApiException("Missing the required parameter 'templateId' when calling getTemplate(Async)");
        }
        Call call = this.getTemplateCall(appId, templateId, progressListener, progressRequestListener);
        return call;
    }

    public TemplateResponse getTemplate(String appId, String templateId) throws ApiException {
        ApiResponse<TemplateResponse> resp = this.getTemplateWithHttpInfo(appId, templateId);
        return resp.getData();
    }

    public ApiResponse<TemplateResponse> getTemplateWithHttpInfo(String appId, String templateId) throws ApiException {
        Call call = this.getTemplateValidateBeforeCall(appId, templateId, null, null);
        Type localVarReturnType = new TypeToken<TemplateResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getTemplateAsync(String appId, String templateId, final ApiCallback<TemplateResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getTemplateValidateBeforeCall(appId, templateId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<TemplateResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call listTemplatesCall(String appId, Integer limit, Integer offset, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v1/apps/{appId}/templates".replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (limit != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "offset", offset));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"jwt"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call listTemplatesValidateBeforeCall(String appId, Integer limit, Integer offset, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (appId == null) {
            throw new ApiException("Missing the required parameter 'appId' when calling listTemplates(Async)");
        }
        Call call = this.listTemplatesCall(appId, limit, offset, progressListener, progressRequestListener);
        return call;
    }

    public ListTemplatesResponse listTemplates(String appId, Integer limit, Integer offset) throws ApiException {
        ApiResponse<ListTemplatesResponse> resp = this.listTemplatesWithHttpInfo(appId, limit, offset);
        return resp.getData();
    }

    public ApiResponse<ListTemplatesResponse> listTemplatesWithHttpInfo(String appId, Integer limit, Integer offset) throws ApiException {
        Call call = this.listTemplatesValidateBeforeCall(appId, limit, offset, null, null);
        Type localVarReturnType = new TypeToken<ListTemplatesResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call listTemplatesAsync(String appId, Integer limit, Integer offset, final ApiCallback<ListTemplatesResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.listTemplatesValidateBeforeCall(appId, limit, offset, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ListTemplatesResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call updateTemplateCall(String appId, String templateId, TemplateUpdate templateUpdateBody, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        TemplateUpdate localVarPostBody = templateUpdateBody;
        String localVarPath = "/v1/apps/{appId}/templates/{templateId}".replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString())).replaceAll("\\{templateId\\}", this.apiClient.escapeString(templateId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"jwt"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call updateTemplateValidateBeforeCall(String appId, String templateId, TemplateUpdate templateUpdateBody, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (appId == null) {
            throw new ApiException("Missing the required parameter 'appId' when calling updateTemplate(Async)");
        }
        if (templateId == null) {
            throw new ApiException("Missing the required parameter 'templateId' when calling updateTemplate(Async)");
        }
        if (templateUpdateBody == null) {
            throw new ApiException("Missing the required parameter 'templateUpdateBody' when calling updateTemplate(Async)");
        }
        Call call = this.updateTemplateCall(appId, templateId, templateUpdateBody, progressListener, progressRequestListener);
        return call;
    }

    public TemplateResponse updateTemplate(String appId, String templateId, TemplateUpdate templateUpdateBody) throws ApiException {
        ApiResponse<TemplateResponse> resp = this.updateTemplateWithHttpInfo(appId, templateId, templateUpdateBody);
        return resp.getData();
    }

    public ApiResponse<TemplateResponse> updateTemplateWithHttpInfo(String appId, String templateId, TemplateUpdate templateUpdateBody) throws ApiException {
        Call call = this.updateTemplateValidateBeforeCall(appId, templateId, templateUpdateBody, null, null);
        Type localVarReturnType = new TypeToken<TemplateResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call updateTemplateAsync(String appId, String templateId, TemplateUpdate templateUpdateBody, final ApiCallback<TemplateResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.updateTemplateValidateBeforeCall(appId, templateId, templateUpdateBody, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<TemplateResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

