/*
 * Decompiled with CFR 0.152.
 */
package io.smooch.client.api;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import io.smooch.client.ApiCallback;
import io.smooch.client.ApiClient;
import io.smooch.client.ApiException;
import io.smooch.client.ApiResponse;
import io.smooch.client.Configuration;
import io.smooch.client.Pair;
import io.smooch.client.ProgressRequestBody;
import io.smooch.client.ProgressResponseBody;
import io.smooch.client.model.ListWebhooksResponse;
import io.smooch.client.model.WebhookCreate;
import io.smooch.client.model.WebhookResponse;
import io.smooch.client.model.WebhookUpdate;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;

public class WebhookApi {
    private ApiClient apiClient;

    public WebhookApi() {
        this(Configuration.getDefaultApiClient());
    }

    public WebhookApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call createWebhookCall(String appId, WebhookCreate webhookCreateBody, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        WebhookCreate localVarPostBody = webhookCreateBody;
        String localVarPath = "/v1/apps/{appId}/webhooks".replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"jwt"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call createWebhookValidateBeforeCall(String appId, WebhookCreate webhookCreateBody, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (appId == null) {
            throw new ApiException("Missing the required parameter 'appId' when calling createWebhook(Async)");
        }
        if (webhookCreateBody == null) {
            throw new ApiException("Missing the required parameter 'webhookCreateBody' when calling createWebhook(Async)");
        }
        Call call = this.createWebhookCall(appId, webhookCreateBody, progressListener, progressRequestListener);
        return call;
    }

    public WebhookResponse createWebhook(String appId, WebhookCreate webhookCreateBody) throws ApiException {
        ApiResponse<WebhookResponse> resp = this.createWebhookWithHttpInfo(appId, webhookCreateBody);
        return resp.getData();
    }

    public ApiResponse<WebhookResponse> createWebhookWithHttpInfo(String appId, WebhookCreate webhookCreateBody) throws ApiException {
        Call call = this.createWebhookValidateBeforeCall(appId, webhookCreateBody, null, null);
        Type localVarReturnType = new TypeToken<WebhookResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call createWebhookAsync(String appId, WebhookCreate webhookCreateBody, final ApiCallback<WebhookResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.createWebhookValidateBeforeCall(appId, webhookCreateBody, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<WebhookResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call deleteWebhookCall(String appId, String webhookId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v1/apps/{appId}/webhooks/{webhookId}".replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString())).replaceAll("\\{webhookId\\}", this.apiClient.escapeString(webhookId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"jwt"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deleteWebhookValidateBeforeCall(String appId, String webhookId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (appId == null) {
            throw new ApiException("Missing the required parameter 'appId' when calling deleteWebhook(Async)");
        }
        if (webhookId == null) {
            throw new ApiException("Missing the required parameter 'webhookId' when calling deleteWebhook(Async)");
        }
        Call call = this.deleteWebhookCall(appId, webhookId, progressListener, progressRequestListener);
        return call;
    }

    public void deleteWebhook(String appId, String webhookId) throws ApiException {
        this.deleteWebhookWithHttpInfo(appId, webhookId);
    }

    public ApiResponse<Void> deleteWebhookWithHttpInfo(String appId, String webhookId) throws ApiException {
        Call call = this.deleteWebhookValidateBeforeCall(appId, webhookId, null, null);
        return this.apiClient.execute(call);
    }

    public Call deleteWebhookAsync(String appId, String webhookId, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteWebhookValidateBeforeCall(appId, webhookId, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call getWebhookCall(String appId, String webhookId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v1/apps/{appId}/webhooks/{webhookId}".replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString())).replaceAll("\\{webhookId\\}", this.apiClient.escapeString(webhookId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"jwt"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getWebhookValidateBeforeCall(String appId, String webhookId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (appId == null) {
            throw new ApiException("Missing the required parameter 'appId' when calling getWebhook(Async)");
        }
        if (webhookId == null) {
            throw new ApiException("Missing the required parameter 'webhookId' when calling getWebhook(Async)");
        }
        Call call = this.getWebhookCall(appId, webhookId, progressListener, progressRequestListener);
        return call;
    }

    public WebhookResponse getWebhook(String appId, String webhookId) throws ApiException {
        ApiResponse<WebhookResponse> resp = this.getWebhookWithHttpInfo(appId, webhookId);
        return resp.getData();
    }

    public ApiResponse<WebhookResponse> getWebhookWithHttpInfo(String appId, String webhookId) throws ApiException {
        Call call = this.getWebhookValidateBeforeCall(appId, webhookId, null, null);
        Type localVarReturnType = new TypeToken<WebhookResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getWebhookAsync(String appId, String webhookId, final ApiCallback<WebhookResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getWebhookValidateBeforeCall(appId, webhookId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<WebhookResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call listWebhooksCall(String appId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v1/apps/{appId}/webhooks".replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"jwt"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call listWebhooksValidateBeforeCall(String appId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (appId == null) {
            throw new ApiException("Missing the required parameter 'appId' when calling listWebhooks(Async)");
        }
        Call call = this.listWebhooksCall(appId, progressListener, progressRequestListener);
        return call;
    }

    public ListWebhooksResponse listWebhooks(String appId) throws ApiException {
        ApiResponse<ListWebhooksResponse> resp = this.listWebhooksWithHttpInfo(appId);
        return resp.getData();
    }

    public ApiResponse<ListWebhooksResponse> listWebhooksWithHttpInfo(String appId) throws ApiException {
        Call call = this.listWebhooksValidateBeforeCall(appId, null, null);
        Type localVarReturnType = new TypeToken<ListWebhooksResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call listWebhooksAsync(String appId, final ApiCallback<ListWebhooksResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.listWebhooksValidateBeforeCall(appId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ListWebhooksResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call updateWebhookCall(String appId, String webhookId, WebhookUpdate webhookUpdateBody, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        WebhookUpdate localVarPostBody = webhookUpdateBody;
        String localVarPath = "/v1/apps/{appId}/webhooks/{webhookId}".replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString())).replaceAll("\\{webhookId\\}", this.apiClient.escapeString(webhookId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"jwt"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call updateWebhookValidateBeforeCall(String appId, String webhookId, WebhookUpdate webhookUpdateBody, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (appId == null) {
            throw new ApiException("Missing the required parameter 'appId' when calling updateWebhook(Async)");
        }
        if (webhookId == null) {
            throw new ApiException("Missing the required parameter 'webhookId' when calling updateWebhook(Async)");
        }
        if (webhookUpdateBody == null) {
            throw new ApiException("Missing the required parameter 'webhookUpdateBody' when calling updateWebhook(Async)");
        }
        Call call = this.updateWebhookCall(appId, webhookId, webhookUpdateBody, progressListener, progressRequestListener);
        return call;
    }

    public WebhookResponse updateWebhook(String appId, String webhookId, WebhookUpdate webhookUpdateBody) throws ApiException {
        ApiResponse<WebhookResponse> resp = this.updateWebhookWithHttpInfo(appId, webhookId, webhookUpdateBody);
        return resp.getData();
    }

    public ApiResponse<WebhookResponse> updateWebhookWithHttpInfo(String appId, String webhookId, WebhookUpdate webhookUpdateBody) throws ApiException {
        Call call = this.updateWebhookValidateBeforeCall(appId, webhookId, webhookUpdateBody, null, null);
        Type localVarReturnType = new TypeToken<WebhookResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call updateWebhookAsync(String appId, String webhookId, WebhookUpdate webhookUpdateBody, final ApiCallback<WebhookResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.updateWebhookValidateBeforeCall(appId, webhookId, webhookUpdateBody, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<WebhookResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

