/*
 * Decompiled with CFR 0.152.
 */
package io.smooch.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

public class Action {
    @SerializedName(value="type")
    private String type = null;
    @SerializedName(value="text")
    private String text = null;
    @SerializedName(value="payload")
    private String payload = null;
    @SerializedName(value="metadata")
    private Object metadata = null;
    @SerializedName(value="amount")
    private Integer amount = null;
    @SerializedName(value="currency")
    private String currency = null;
    @SerializedName(value="default")
    private Boolean _default = null;
    @SerializedName(value="iconUrl")
    private String iconUrl = null;
    @SerializedName(value="uri")
    private String uri = null;
    @SerializedName(value="fallback")
    private String fallback = null;
    @SerializedName(value="size")
    private String size = null;
    @SerializedName(value="extraChannelOptions")
    private Object extraChannelOptions = null;

    public Action type(String type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="The action type.")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Action text(String text) {
        this.text = text;
        return this;
    }

    @ApiModelProperty(required=true, value="The button text.")
    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public Action payload(String payload) {
        this.payload = payload;
        return this;
    }

    @ApiModelProperty(value="The payload to be sent with the resulting webhook. Required for *postback* and *reply* actions. ")
    public String getPayload() {
        return this.payload;
    }

    public void setPayload(String payload) {
        this.payload = payload;
    }

    public Action metadata(Object metadata) {
        this.metadata = metadata;
        return this;
    }

    @ApiModelProperty(value="Flat JSON object containing any custom properties associated with the action.")
    public Object getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Object metadata) {
        this.metadata = metadata;
    }

    public Action amount(Integer amount) {
        this.amount = amount;
        return this;
    }

    @ApiModelProperty(value="The amount being charged. It needs to be specified in cents and is an integer. Required for *buy* actions. ")
    public Integer getAmount() {
        return this.amount;
    }

    public void setAmount(Integer amount) {
        this.amount = amount;
    }

    public Action currency(String currency) {
        this.currency = currency;
        return this;
    }

    @ApiModelProperty(value="The currency of the amount being charged (USD, CAD, etc.).")
    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public Action _default(Boolean _default) {
        this._default = _default;
        return this;
    }

    @ApiModelProperty(value="Flag indicating if the message action is the default for a message item in Facebook Messenger.")
    public Boolean getDefault() {
        return this._default;
    }

    public void setDefault(Boolean _default) {
        this._default = _default;
    }

    public Action iconUrl(String iconUrl) {
        this.iconUrl = iconUrl;
        return this;
    }

    @ApiModelProperty(value="An icon to render next to the reply option (Facebook Messenger and Web Messenger only).")
    public String getIconUrl() {
        return this.iconUrl;
    }

    public void setIconUrl(String iconUrl) {
        this.iconUrl = iconUrl;
    }

    public Action uri(String uri) {
        this.uri = uri;
        return this;
    }

    @ApiModelProperty(value="The action URI. This is the link that will be used in the clients when clicking the button. Required for *link* and *webview* actions. ")
    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public Action fallback(String fallback) {
        this.fallback = fallback;
        return this;
    }

    @ApiModelProperty(value="The webview action fallback uri. This is the link that will be used in clients that do not support webviews. Required for *webview* actions. ")
    public String getFallback() {
        return this.fallback;
    }

    public void setFallback(String fallback) {
        this.fallback = fallback;
    }

    public Action size(String size) {
        this.size = size;
        return this;
    }

    @ApiModelProperty(value="The size used to display the webview. Allowed values are [\"compact\", \"tall\", \"full\"]. (Optional) Used for *webview* actions. ")
    public String getSize() {
        return this.size;
    }

    public void setSize(String size) {
        this.size = size;
    }

    public Action extraChannelOptions(Object extraChannelOptions) {
        this.extraChannelOptions = extraChannelOptions;
        return this;
    }

    @ApiModelProperty(value="Extra options to pass directly to the channel API. See [Extra Channel Options](https://docs.smooch.io/rest#extra-channel-options-schema)")
    public Object getExtraChannelOptions() {
        return this.extraChannelOptions;
    }

    public void setExtraChannelOptions(Object extraChannelOptions) {
        this.extraChannelOptions = extraChannelOptions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Action action = (Action)o;
        return Objects.equals(this.type, action.type) && Objects.equals(this.text, action.text) && Objects.equals(this.payload, action.payload) && Objects.equals(this.metadata, action.metadata) && Objects.equals(this.amount, action.amount) && Objects.equals(this.currency, action.currency) && Objects.equals(this._default, action._default) && Objects.equals(this.iconUrl, action.iconUrl) && Objects.equals(this.uri, action.uri) && Objects.equals(this.fallback, action.fallback) && Objects.equals(this.size, action.size) && Objects.equals(this.extraChannelOptions, action.extraChannelOptions);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.text, this.payload, this.metadata, this.amount, this.currency, this._default, this.iconUrl, this.uri, this.fallback, this.size, this.extraChannelOptions);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Action {\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    text: ").append(this.toIndentedString(this.text)).append("\n");
        sb.append("    payload: ").append(this.toIndentedString(this.payload)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    currency: ").append(this.toIndentedString(this.currency)).append("\n");
        sb.append("    _default: ").append(this.toIndentedString(this._default)).append("\n");
        sb.append("    iconUrl: ").append(this.toIndentedString(this.iconUrl)).append("\n");
        sb.append("    uri: ").append(this.toIndentedString(this.uri)).append("\n");
        sb.append("    fallback: ").append(this.toIndentedString(this.fallback)).append("\n");
        sb.append("    size: ").append(this.toIndentedString(this.size)).append("\n");
        sb.append("    extraChannelOptions: ").append(this.toIndentedString(this.extraChannelOptions)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

