/*
 * Decompiled with CFR 0.152.
 */
package io.smooch.client.model;

import com.google.gson.annotations.SerializedName;
import io.smooch.client.model.Client;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class AppUser {
    @SerializedName(value="_id")
    private String id = null;
    @SerializedName(value="userId")
    private String userId = null;
    @SerializedName(value="givenName")
    private String givenName = null;
    @SerializedName(value="surname")
    private String surname = null;
    @SerializedName(value="email")
    private String email = null;
    @SerializedName(value="signedUpAt")
    private String signedUpAt = null;
    @SerializedName(value="properties")
    private Object properties = null;
    @SerializedName(value="conversationStarted")
    private Boolean conversationStarted = null;
    @SerializedName(value="credentialRequired")
    private Boolean credentialRequired = null;
    @SerializedName(value="clients")
    private List<Client> clients = null;
    @SerializedName(value="pendingClients")
    private List<Client> pendingClients = null;

    public AppUser id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(required=true, value="The app user's ID, generated automatically.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public AppUser userId(String userId) {
        this.userId = userId;
        return this;
    }

    @ApiModelProperty(value="The app user's userId. This ID is specified by the appMaker. ")
    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public AppUser givenName(String givenName) {
        this.givenName = givenName;
        return this;
    }

    @ApiModelProperty(value="The app user's given name.")
    public String getGivenName() {
        return this.givenName;
    }

    public void setGivenName(String givenName) {
        this.givenName = givenName;
    }

    public AppUser surname(String surname) {
        this.surname = surname;
        return this;
    }

    @ApiModelProperty(value="The app user's surname.")
    public String getSurname() {
        return this.surname;
    }

    public void setSurname(String surname) {
        this.surname = surname;
    }

    public AppUser email(String email) {
        this.email = email;
        return this;
    }

    @ApiModelProperty(value="The app user's email.")
    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public AppUser signedUpAt(String signedUpAt) {
        this.signedUpAt = signedUpAt;
        return this;
    }

    @ApiModelProperty(value="A datetime string with the format *yyyy-mm-ddThh:mm:ssZ* representing the moment an appUser was created.")
    public String getSignedUpAt() {
        return this.signedUpAt;
    }

    public void setSignedUpAt(String signedUpAt) {
        this.signedUpAt = signedUpAt;
    }

    public AppUser properties(Object properties) {
        this.properties = properties;
        return this;
    }

    @ApiModelProperty(required=true, value="Custom properties for the app user.")
    public Object getProperties() {
        return this.properties;
    }

    public void setProperties(Object properties) {
        this.properties = properties;
    }

    public AppUser conversationStarted(Boolean conversationStarted) {
        this.conversationStarted = conversationStarted;
        return this;
    }

    @ApiModelProperty(required=true, value="Flag indicating if the conversation has started for the app user.")
    public Boolean getConversationStarted() {
        return this.conversationStarted;
    }

    public void setConversationStarted(Boolean conversationStarted) {
        this.conversationStarted = conversationStarted;
    }

    public AppUser credentialRequired(Boolean credentialRequired) {
        this.credentialRequired = credentialRequired;
        return this;
    }

    @ApiModelProperty(value="Flag indicating if the appUser is secured by a JSON Web Token or not.")
    public Boolean getCredentialRequired() {
        return this.credentialRequired;
    }

    public void setCredentialRequired(Boolean credentialRequired) {
        this.credentialRequired = credentialRequired;
    }

    public AppUser clients(List<Client> clients) {
        this.clients = clients;
        return this;
    }

    public AppUser addClientsItem(Client clientsItem) {
        if (this.clients == null) {
            this.clients = new ArrayList<Client>();
        }
        this.clients.add(clientsItem);
        return this;
    }

    @ApiModelProperty(value="List of clients associated with the app user.")
    public List<Client> getClients() {
        return this.clients;
    }

    public void setClients(List<Client> clients) {
        this.clients = clients;
    }

    public AppUser pendingClients(List<Client> pendingClients) {
        this.pendingClients = pendingClients;
        return this;
    }

    public AppUser addPendingClientsItem(Client pendingClientsItem) {
        if (this.pendingClients == null) {
            this.pendingClients = new ArrayList<Client>();
        }
        this.pendingClients.add(pendingClientsItem);
        return this;
    }

    @ApiModelProperty(value="As clients, but containing linked clients which have not been confirmed yet (i.e. Twilio SMS).")
    public List<Client> getPendingClients() {
        return this.pendingClients;
    }

    public void setPendingClients(List<Client> pendingClients) {
        this.pendingClients = pendingClients;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AppUser appUser = (AppUser)o;
        return Objects.equals(this.id, appUser.id) && Objects.equals(this.userId, appUser.userId) && Objects.equals(this.givenName, appUser.givenName) && Objects.equals(this.surname, appUser.surname) && Objects.equals(this.email, appUser.email) && Objects.equals(this.signedUpAt, appUser.signedUpAt) && Objects.equals(this.properties, appUser.properties) && Objects.equals(this.conversationStarted, appUser.conversationStarted) && Objects.equals(this.credentialRequired, appUser.credentialRequired) && Objects.equals(this.clients, appUser.clients) && Objects.equals(this.pendingClients, appUser.pendingClients);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.userId, this.givenName, this.surname, this.email, this.signedUpAt, this.properties, this.conversationStarted, this.credentialRequired, this.clients, this.pendingClients);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AppUser {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    userId: ").append(this.toIndentedString(this.userId)).append("\n");
        sb.append("    givenName: ").append(this.toIndentedString(this.givenName)).append("\n");
        sb.append("    surname: ").append(this.toIndentedString(this.surname)).append("\n");
        sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
        sb.append("    signedUpAt: ").append(this.toIndentedString(this.signedUpAt)).append("\n");
        sb.append("    properties: ").append(this.toIndentedString(this.properties)).append("\n");
        sb.append("    conversationStarted: ").append(this.toIndentedString(this.conversationStarted)).append("\n");
        sb.append("    credentialRequired: ").append(this.toIndentedString(this.credentialRequired)).append("\n");
        sb.append("    clients: ").append(this.toIndentedString(this.clients)).append("\n");
        sb.append("    pendingClients: ").append(this.toIndentedString(this.pendingClients)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

