/*
 * Decompiled with CFR 0.152.
 */
package io.smooch.client.model;

import com.google.gson.annotations.SerializedName;
import io.smooch.client.model.Confirmation;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

public class AppUserLink {
    @SerializedName(value="type")
    private String type = null;
    @SerializedName(value="phoneNumber")
    private String phoneNumber = null;
    @SerializedName(value="address")
    private String address = null;
    @SerializedName(value="givenName")
    private String givenName = null;
    @SerializedName(value="surname")
    private String surname = null;
    @SerializedName(value="subject")
    private String subject = null;
    @SerializedName(value="skipConfirmation")
    private String skipConfirmation = null;
    @SerializedName(value="confirmation")
    private Confirmation confirmation = null;

    public AppUserLink type(String type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="The type of the channel to link.")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public AppUserLink phoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
        return this;
    }

    @ApiModelProperty(value="A String of the appUser\u2019s phone number. It must contain the + prefix and the country code. Required for *messenger*, *twilio* and *messagebird* linking. ")
    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public AppUserLink address(String address) {
        this.address = address;
        return this;
    }

    @ApiModelProperty(value="A String of the appUser\u2019s email address. Required for *mailgun* linking. ")
    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public AppUserLink givenName(String givenName) {
        this.givenName = givenName;
        return this;
    }

    @ApiModelProperty(value="A String of the appUser\u2019s given name. Used as additional criteria to increase the likelihood of a match. (Optional) Used for *messenger* linking. ")
    public String getGivenName() {
        return this.givenName;
    }

    public void setGivenName(String givenName) {
        this.givenName = givenName;
    }

    public AppUserLink surname(String surname) {
        this.surname = surname;
        return this;
    }

    @ApiModelProperty(value="A String of the appUser\u2019s surname. Used as additional criteria to increase the likelihood of a match. (Optional) Used for *messenger* linking. ")
    public String getSurname() {
        return this.surname;
    }

    public void setSurname(String surname) {
        this.surname = surname;
    }

    public AppUserLink subject(String subject) {
        this.subject = subject;
        return this;
    }

    @ApiModelProperty(value="Subject for the outgoing email. (Optional) Used for *mailgun* linking. ")
    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public AppUserLink skipConfirmation(String skipConfirmation) {
        this.skipConfirmation = skipConfirmation;
        return this;
    }

    @ApiModelProperty(value="(Deprecated, use confirmation instead) Flag indicating if the linking confirmation should be skipped.")
    public String getSkipConfirmation() {
        return this.skipConfirmation;
    }

    public void setSkipConfirmation(String skipConfirmation) {
        this.skipConfirmation = skipConfirmation;
    }

    public AppUserLink confirmation(Confirmation confirmation) {
        this.confirmation = confirmation;
        return this;
    }

    @ApiModelProperty(required=true, value="Allows you to specify the strategy used to initiate a link with the target user.")
    public Confirmation getConfirmation() {
        return this.confirmation;
    }

    public void setConfirmation(Confirmation confirmation) {
        this.confirmation = confirmation;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AppUserLink appUserLink = (AppUserLink)o;
        return Objects.equals(this.type, appUserLink.type) && Objects.equals(this.phoneNumber, appUserLink.phoneNumber) && Objects.equals(this.address, appUserLink.address) && Objects.equals(this.givenName, appUserLink.givenName) && Objects.equals(this.surname, appUserLink.surname) && Objects.equals(this.subject, appUserLink.subject) && Objects.equals(this.skipConfirmation, appUserLink.skipConfirmation) && Objects.equals(this.confirmation, appUserLink.confirmation);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.phoneNumber, this.address, this.givenName, this.surname, this.subject, this.skipConfirmation, this.confirmation);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AppUserLink {\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    phoneNumber: ").append(this.toIndentedString(this.phoneNumber)).append("\n");
        sb.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        sb.append("    givenName: ").append(this.toIndentedString(this.givenName)).append("\n");
        sb.append("    surname: ").append(this.toIndentedString(this.surname)).append("\n");
        sb.append("    subject: ").append(this.toIndentedString(this.subject)).append("\n");
        sb.append("    skipConfirmation: ").append(this.toIndentedString(this.skipConfirmation)).append("\n");
        sb.append("    confirmation: ").append(this.toIndentedString(this.confirmation)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

