/*
 * Decompiled with CFR 0.152.
 */
package io.smooch.client.model;

import com.google.gson.annotations.SerializedName;
import io.smooch.client.model.ClientInfo;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

public class Client {
    @SerializedName(value="id")
    private String id = null;
    @SerializedName(value="active")
    private Boolean active = null;
    @SerializedName(value="lastSeen")
    private String lastSeen = null;
    @SerializedName(value="platform")
    private String platform = null;
    @SerializedName(value="pushNotificationToken")
    private String pushNotificationToken = null;
    @SerializedName(value="appVersion")
    private String appVersion = null;
    @SerializedName(value="displayName")
    private String displayName = null;
    @SerializedName(value="info")
    private ClientInfo info = null;
    @SerializedName(value="raw")
    private Object raw = null;

    public Client id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(required=true, value="An identifier for the client. Must be globally unique.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Client active(Boolean active) {
        this.active = active;
        return this;
    }

    @ApiModelProperty(value="Flag indicating if the client is active.")
    public Boolean getActive() {
        return this.active;
    }

    public void setActive(Boolean active) {
        this.active = active;
    }

    public Client lastSeen(String lastSeen) {
        this.lastSeen = lastSeen;
        return this;
    }

    @ApiModelProperty(value="The date time the client was last seen.")
    public String getLastSeen() {
        return this.lastSeen;
    }

    public void setLastSeen(String lastSeen) {
        this.lastSeen = lastSeen;
    }

    public Client platform(String platform) {
        this.platform = platform;
        return this;
    }

    @ApiModelProperty(required=true, value="The client's platform.")
    public String getPlatform() {
        return this.platform;
    }

    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public Client pushNotificationToken(String pushNotificationToken) {
        this.pushNotificationToken = pushNotificationToken;
        return this;
    }

    @ApiModelProperty(value="The GCM or APN token to be used for sending push notifications to the device. Applies to only *android* and *ios* clients. ")
    public String getPushNotificationToken() {
        return this.pushNotificationToken;
    }

    public void setPushNotificationToken(String pushNotificationToken) {
        this.pushNotificationToken = pushNotificationToken;
    }

    public Client appVersion(String appVersion) {
        this.appVersion = appVersion;
        return this;
    }

    @ApiModelProperty(value="A reserved string field for reporting the app version running on the device.")
    public String getAppVersion() {
        return this.appVersion;
    }

    public void setAppVersion(String appVersion) {
        this.appVersion = appVersion;
    }

    public Client displayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @ApiModelProperty(value="The client's display name.")
    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public Client info(ClientInfo info) {
        this.info = info;
        return this;
    }

    @ApiModelProperty(value="")
    public ClientInfo getInfo() {
        return this.info;
    }

    public void setInfo(ClientInfo info) {
        this.info = info;
    }

    public Client raw(Object raw) {
        this.raw = raw;
        return this;
    }

    @ApiModelProperty(value="An Object with raw properties that vary for each client platform. All keys are optional and not guaranteed to be available.")
    public Object getRaw() {
        return this.raw;
    }

    public void setRaw(Object raw) {
        this.raw = raw;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Client client = (Client)o;
        return Objects.equals(this.id, client.id) && Objects.equals(this.active, client.active) && Objects.equals(this.lastSeen, client.lastSeen) && Objects.equals(this.platform, client.platform) && Objects.equals(this.pushNotificationToken, client.pushNotificationToken) && Objects.equals(this.appVersion, client.appVersion) && Objects.equals(this.displayName, client.displayName) && Objects.equals(this.info, client.info) && Objects.equals(this.raw, client.raw);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.active, this.lastSeen, this.platform, this.pushNotificationToken, this.appVersion, this.displayName, this.info, this.raw);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Client {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    active: ").append(this.toIndentedString(this.active)).append("\n");
        sb.append("    lastSeen: ").append(this.toIndentedString(this.lastSeen)).append("\n");
        sb.append("    platform: ").append(this.toIndentedString(this.platform)).append("\n");
        sb.append("    pushNotificationToken: ").append(this.toIndentedString(this.pushNotificationToken)).append("\n");
        sb.append("    appVersion: ").append(this.toIndentedString(this.appVersion)).append("\n");
        sb.append("    displayName: ").append(this.toIndentedString(this.displayName)).append("\n");
        sb.append("    info: ").append(this.toIndentedString(this.info)).append("\n");
        sb.append("    raw: ").append(this.toIndentedString(this.raw)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

