/*
 * Decompiled with CFR 0.152.
 */
package io.smooch.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class IntegrationUpdate {
    @SerializedName(value="brandColor")
    private String brandColor = null;
    @SerializedName(value="fixedIntroPane")
    private Boolean fixedIntroPane = null;
    @SerializedName(value="conversationColor")
    private String conversationColor = null;
    @SerializedName(value="actionColor")
    private String actionColor = null;
    @SerializedName(value="displayStyle")
    private String displayStyle = null;
    @SerializedName(value="buttonIconUrl")
    private String buttonIconUrl = null;
    @SerializedName(value="buttonWidth")
    private String buttonWidth = null;
    @SerializedName(value="buttonHeight")
    private String buttonHeight = null;
    @SerializedName(value="integrationOrder")
    private List<String> integrationOrder = null;
    @SerializedName(value="businessName")
    private String businessName = null;
    @SerializedName(value="businessIconUrl")
    private String businessIconUrl = null;
    @SerializedName(value="backgroundImageUrl")
    private String backgroundImageUrl = null;
    @SerializedName(value="originWhitelist")
    private List<String> originWhitelist = null;
    @SerializedName(value="channelId")
    private String channelId = null;
    @SerializedName(value="channelSecret")
    private String channelSecret = null;

    public IntegrationUpdate brandColor(String brandColor) {
        this.brandColor = brandColor;
        return this;
    }

    @ApiModelProperty(value="This color will be used in the messenger header and the button or tab in idle state. (Optional) Used for *Web Messenger* integrations. ")
    public String getBrandColor() {
        return this.brandColor;
    }

    public void setBrandColor(String brandColor) {
        this.brandColor = brandColor;
    }

    public IntegrationUpdate fixedIntroPane(Boolean fixedIntroPane) {
        this.fixedIntroPane = fixedIntroPane;
        return this;
    }

    @ApiModelProperty(value="When `true`, the introduction pane will be pinned at the top of the conversation instead of scrolling with it. The default value is `false`. (Optional) Used for *Web Messenger* integrations. ")
    public Boolean getFixedIntroPane() {
        return this.fixedIntroPane;
    }

    public void setFixedIntroPane(Boolean fixedIntroPane) {
        this.fixedIntroPane = fixedIntroPane;
    }

    public IntegrationUpdate conversationColor(String conversationColor) {
        this.conversationColor = conversationColor;
        return this;
    }

    @ApiModelProperty(value="This color will be used for customer messages, quick replies and actions in the footer. (Optional) Used for *Web Messenger* integrations. ")
    public String getConversationColor() {
        return this.conversationColor;
    }

    public void setConversationColor(String conversationColor) {
        this.conversationColor = conversationColor;
    }

    public IntegrationUpdate actionColor(String actionColor) {
        this.actionColor = actionColor;
        return this;
    }

    @ApiModelProperty(value="This color will be used for call-to-actions inside your messages. (Optional) Used for *Web Messenger* integrations. ")
    public String getActionColor() {
        return this.actionColor;
    }

    public void setActionColor(String actionColor) {
        this.actionColor = actionColor;
    }

    public IntegrationUpdate displayStyle(String displayStyle) {
        this.displayStyle = displayStyle;
        return this;
    }

    @ApiModelProperty(value="Choose how the messenger will appear on your website. Must be either button or tab. (Optional) Used for *Web Messenger* integrations. ")
    public String getDisplayStyle() {
        return this.displayStyle;
    }

    public void setDisplayStyle(String displayStyle) {
        this.displayStyle = displayStyle;
    }

    public IntegrationUpdate buttonIconUrl(String buttonIconUrl) {
        this.buttonIconUrl = buttonIconUrl;
        return this;
    }

    @ApiModelProperty(value="With the button style Web Messenger, you have the option of selecting your own button icon. (Optional) Used for *Web Messenger* integrations. ")
    public String getButtonIconUrl() {
        return this.buttonIconUrl;
    }

    public void setButtonIconUrl(String buttonIconUrl) {
        this.buttonIconUrl = buttonIconUrl;
    }

    public IntegrationUpdate buttonWidth(String buttonWidth) {
        this.buttonWidth = buttonWidth;
        return this;
    }

    @ApiModelProperty(value="With the button style Web Messenger, you have the option of specifying its width. (Optional) Used for *Web Messenger* integrations. ")
    public String getButtonWidth() {
        return this.buttonWidth;
    }

    public void setButtonWidth(String buttonWidth) {
        this.buttonWidth = buttonWidth;
    }

    public IntegrationUpdate buttonHeight(String buttonHeight) {
        this.buttonHeight = buttonHeight;
        return this;
    }

    @ApiModelProperty(value="With the button style Web Messenger, you have the option of specifying its height. (Optional) Used for *Web Messenger* integrations. ")
    public String getButtonHeight() {
        return this.buttonHeight;
    }

    public void setButtonHeight(String buttonHeight) {
        this.buttonHeight = buttonHeight;
    }

    public IntegrationUpdate integrationOrder(List<String> integrationOrder) {
        this.integrationOrder = integrationOrder;
        return this;
    }

    public IntegrationUpdate addIntegrationOrderItem(String integrationOrderItem) {
        if (this.integrationOrder == null) {
            this.integrationOrder = new ArrayList<String>();
        }
        this.integrationOrder.add(integrationOrderItem);
        return this;
    }

    @ApiModelProperty(value="Array of integration IDs, order will be reflected in the Web Messenger. When set, only integrations from this list will be displayed in the Web Messenger. If unset, all integrations will be displayed (Optional) Used for *Web Messenger* integrations. ")
    public List<String> getIntegrationOrder() {
        return this.integrationOrder;
    }

    public void setIntegrationOrder(List<String> integrationOrder) {
        this.integrationOrder = integrationOrder;
    }

    public IntegrationUpdate businessName(String businessName) {
        this.businessName = businessName;
        return this;
    }

    @ApiModelProperty(value="A custom business name for the Web Messenger. (Optional) Used for *Web Messenger* integrations. ")
    public String getBusinessName() {
        return this.businessName;
    }

    public void setBusinessName(String businessName) {
        this.businessName = businessName;
    }

    public IntegrationUpdate businessIconUrl(String businessIconUrl) {
        this.businessIconUrl = businessIconUrl;
        return this;
    }

    @ApiModelProperty(value="A custom business icon url for the Web Messenger. (Optional) Used for *Web Messenger* integrations. ")
    public String getBusinessIconUrl() {
        return this.businessIconUrl;
    }

    public void setBusinessIconUrl(String businessIconUrl) {
        this.businessIconUrl = businessIconUrl;
    }

    public IntegrationUpdate backgroundImageUrl(String backgroundImageUrl) {
        this.backgroundImageUrl = backgroundImageUrl;
        return this;
    }

    @ApiModelProperty(value="A custom background url for the Web Messenger. (Optional) Used for *Web Messenger* integrations. ")
    public String getBackgroundImageUrl() {
        return this.backgroundImageUrl;
    }

    public void setBackgroundImageUrl(String backgroundImageUrl) {
        this.backgroundImageUrl = backgroundImageUrl;
    }

    public IntegrationUpdate originWhitelist(List<String> originWhitelist) {
        this.originWhitelist = originWhitelist;
        return this;
    }

    public IntegrationUpdate addOriginWhitelistItem(String originWhitelistItem) {
        if (this.originWhitelist == null) {
            this.originWhitelist = new ArrayList<String>();
        }
        this.originWhitelist.add(originWhitelistItem);
        return this;
    }

    @ApiModelProperty(value="A list of origins to whitelist. When set, only the origins from this list will be able to initialize the Web Messenger. If unset, all origins are whitelisted. The elements in the list should follow the serialized-origin format from RFC 6454 `scheme \"://\" host [ \":\" port ]`, where scheme is `http` or `https`. (Optional) Used for *Web Messenger* integrations. ")
    public List<String> getOriginWhitelist() {
        return this.originWhitelist;
    }

    public void setOriginWhitelist(List<String> originWhitelist) {
        this.originWhitelist = originWhitelist;
    }

    public IntegrationUpdate channelId(String channelId) {
        this.channelId = channelId;
        return this;
    }

    @ApiModelProperty(value="LINE Channel ID. Required for *line* integrations. ")
    public String getChannelId() {
        return this.channelId;
    }

    public void setChannelId(String channelId) {
        this.channelId = channelId;
    }

    public IntegrationUpdate channelSecret(String channelSecret) {
        this.channelSecret = channelSecret;
        return this;
    }

    @ApiModelProperty(value="LINE Channel Secret. Required for *line* integrations. ")
    public String getChannelSecret() {
        return this.channelSecret;
    }

    public void setChannelSecret(String channelSecret) {
        this.channelSecret = channelSecret;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IntegrationUpdate integrationUpdate = (IntegrationUpdate)o;
        return Objects.equals(this.brandColor, integrationUpdate.brandColor) && Objects.equals(this.fixedIntroPane, integrationUpdate.fixedIntroPane) && Objects.equals(this.conversationColor, integrationUpdate.conversationColor) && Objects.equals(this.actionColor, integrationUpdate.actionColor) && Objects.equals(this.displayStyle, integrationUpdate.displayStyle) && Objects.equals(this.buttonIconUrl, integrationUpdate.buttonIconUrl) && Objects.equals(this.buttonWidth, integrationUpdate.buttonWidth) && Objects.equals(this.buttonHeight, integrationUpdate.buttonHeight) && Objects.equals(this.integrationOrder, integrationUpdate.integrationOrder) && Objects.equals(this.businessName, integrationUpdate.businessName) && Objects.equals(this.businessIconUrl, integrationUpdate.businessIconUrl) && Objects.equals(this.backgroundImageUrl, integrationUpdate.backgroundImageUrl) && Objects.equals(this.originWhitelist, integrationUpdate.originWhitelist) && Objects.equals(this.channelId, integrationUpdate.channelId) && Objects.equals(this.channelSecret, integrationUpdate.channelSecret);
    }

    public int hashCode() {
        return Objects.hash(this.brandColor, this.fixedIntroPane, this.conversationColor, this.actionColor, this.displayStyle, this.buttonIconUrl, this.buttonWidth, this.buttonHeight, this.integrationOrder, this.businessName, this.businessIconUrl, this.backgroundImageUrl, this.originWhitelist, this.channelId, this.channelSecret);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IntegrationUpdate {\n");
        sb.append("    brandColor: ").append(this.toIndentedString(this.brandColor)).append("\n");
        sb.append("    fixedIntroPane: ").append(this.toIndentedString(this.fixedIntroPane)).append("\n");
        sb.append("    conversationColor: ").append(this.toIndentedString(this.conversationColor)).append("\n");
        sb.append("    actionColor: ").append(this.toIndentedString(this.actionColor)).append("\n");
        sb.append("    displayStyle: ").append(this.toIndentedString(this.displayStyle)).append("\n");
        sb.append("    buttonIconUrl: ").append(this.toIndentedString(this.buttonIconUrl)).append("\n");
        sb.append("    buttonWidth: ").append(this.toIndentedString(this.buttonWidth)).append("\n");
        sb.append("    buttonHeight: ").append(this.toIndentedString(this.buttonHeight)).append("\n");
        sb.append("    integrationOrder: ").append(this.toIndentedString(this.integrationOrder)).append("\n");
        sb.append("    businessName: ").append(this.toIndentedString(this.businessName)).append("\n");
        sb.append("    businessIconUrl: ").append(this.toIndentedString(this.businessIconUrl)).append("\n");
        sb.append("    backgroundImageUrl: ").append(this.toIndentedString(this.backgroundImageUrl)).append("\n");
        sb.append("    originWhitelist: ").append(this.toIndentedString(this.originWhitelist)).append("\n");
        sb.append("    channelId: ").append(this.toIndentedString(this.channelId)).append("\n");
        sb.append("    channelSecret: ").append(this.toIndentedString(this.channelSecret)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

