/*
 * Decompiled with CFR 0.152.
 */
package io.smooch.client.model;

import com.google.gson.annotations.SerializedName;
import io.smooch.client.model.SubMenuItem;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class MenuItem {
    @SerializedName(value="text")
    private String text = null;
    @SerializedName(value="uri")
    private String uri = null;
    @SerializedName(value="type")
    private String type = null;
    @SerializedName(value="payload")
    private String payload = null;
    @SerializedName(value="items")
    private List<SubMenuItem> items = null;

    public MenuItem text(String text) {
        this.text = text;
        return this;
    }

    @ApiModelProperty(required=true, value="The button text of the menu item.")
    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public MenuItem uri(String uri) {
        this.uri = uri;
        return this;
    }

    @ApiModelProperty(value="A valid address, like http://smooch.io. Required for a link type item.")
    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public MenuItem type(String type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="Can either be link, postback, which correspond to Smooch\u2019s link and postback actions, or submenu for nested menus.")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public MenuItem payload(String payload) {
        this.payload = payload;
        return this;
    }

    @ApiModelProperty(value="A payload for a postback. Required for a postback type item.")
    public String getPayload() {
        return this.payload;
    }

    public void setPayload(String payload) {
        this.payload = payload;
    }

    public MenuItem items(List<SubMenuItem> items) {
        this.items = items;
        return this;
    }

    public MenuItem addItemsItem(SubMenuItem itemsItem) {
        if (this.items == null) {
            this.items = new ArrayList<SubMenuItem>();
        }
        this.items.add(itemsItem);
        return this;
    }

    @ApiModelProperty(value="A list of menu items for a submenu.")
    public List<SubMenuItem> getItems() {
        return this.items;
    }

    public void setItems(List<SubMenuItem> items) {
        this.items = items;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MenuItem menuItem = (MenuItem)o;
        return Objects.equals(this.text, menuItem.text) && Objects.equals(this.uri, menuItem.uri) && Objects.equals(this.type, menuItem.type) && Objects.equals(this.payload, menuItem.payload) && Objects.equals(this.items, menuItem.items);
    }

    public int hashCode() {
        return Objects.hash(this.text, this.uri, this.type, this.payload, this.items);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MenuItem {\n");
        sb.append("    text: ").append(this.toIndentedString(this.text)).append("\n");
        sb.append("    uri: ").append(this.toIndentedString(this.uri)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    payload: ").append(this.toIndentedString(this.payload)).append("\n");
        sb.append("    items: ").append(this.toIndentedString(this.items)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

