/*
 * Decompiled with CFR 0.152.
 */
package io.smooch.client.model;

import com.google.gson.annotations.SerializedName;
import io.smooch.client.model.Action;
import io.smooch.client.model.DisplaySettings;
import io.smooch.client.model.MessageItem;
import io.smooch.client.model.Source;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class Message {
    @SerializedName(value="_id")
    private String id = null;
    @SerializedName(value="authorId")
    private String authorId = null;
    @SerializedName(value="role")
    private String role = null;
    @SerializedName(value="type")
    private String type = null;
    @SerializedName(value="source")
    private Source source = null;
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="text")
    private String text = null;
    @SerializedName(value="email")
    private String email = null;
    @SerializedName(value="avatarUrl")
    private String avatarUrl = null;
    @SerializedName(value="received")
    private Double received = null;
    @SerializedName(value="mediaUrl")
    private String mediaUrl = null;
    @SerializedName(value="mediaType")
    private String mediaType = null;
    @SerializedName(value="metadata")
    private Object metadata = null;
    @SerializedName(value="items")
    private List<MessageItem> items = null;
    @SerializedName(value="actions")
    private List<Action> actions = null;
    @SerializedName(value="payload")
    private String payload = null;
    @SerializedName(value="displaySettings")
    private DisplaySettings displaySettings = null;

    public Message id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(required=true, value="The message ID, generated automatically.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Message authorId(String authorId) {
        this.authorId = authorId;
        return this;
    }

    @ApiModelProperty(required=true, value="The ID of the message's author.")
    public String getAuthorId() {
        return this.authorId;
    }

    public void setAuthorId(String authorId) {
        this.authorId = authorId;
    }

    public Message role(String role) {
        this.role = role;
        return this;
    }

    @ApiModelProperty(required=true, value="The role of the individual posting the message. Can be either *appUser* or *appMaker*.")
    public String getRole() {
        return this.role;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public Message type(String type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="The message type.")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Message source(Source source) {
        this.source = source;
        return this;
    }

    @ApiModelProperty(value="The source of the message.")
    public Source getSource() {
        return this.source;
    }

    public void setSource(Source source) {
        this.source = source;
    }

    public Message name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="The display name of the message author.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Message text(String text) {
        this.text = text;
        return this;
    }

    @ApiModelProperty(required=true, value="The message text. Required for text messages. ")
    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public Message email(String email) {
        this.email = email;
        return this;
    }

    @ApiModelProperty(value="The email address of the message author.")
    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public Message avatarUrl(String avatarUrl) {
        this.avatarUrl = avatarUrl;
        return this;
    }

    @ApiModelProperty(required=true, value="The URL of the desired message avatar image.")
    public String getAvatarUrl() {
        return this.avatarUrl;
    }

    public void setAvatarUrl(String avatarUrl) {
        this.avatarUrl = avatarUrl;
    }

    public Message received(Double received) {
        this.received = received;
        return this;
    }

    @ApiModelProperty(required=true, value="The unix timestamp of the moment the message was received.")
    public Double getReceived() {
        return this.received;
    }

    public void setReceived(Double received) {
        this.received = received;
    }

    public Message mediaUrl(String mediaUrl) {
        this.mediaUrl = mediaUrl;
        return this;
    }

    @ApiModelProperty(value="The mediaUrl for the message. Required for image/file messages. ")
    public String getMediaUrl() {
        return this.mediaUrl;
    }

    public void setMediaUrl(String mediaUrl) {
        this.mediaUrl = mediaUrl;
    }

    public Message mediaType(String mediaType) {
        this.mediaType = mediaType;
        return this;
    }

    @ApiModelProperty(value="The mediaType for the message. Required for image/file messages. ")
    public String getMediaType() {
        return this.mediaType;
    }

    public void setMediaType(String mediaType) {
        this.mediaType = mediaType;
    }

    public Message metadata(Object metadata) {
        this.metadata = metadata;
        return this;
    }

    @ApiModelProperty(value="Flat JSON object containing any custom properties associated with the message.")
    public Object getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Object metadata) {
        this.metadata = metadata;
    }

    public Message items(List<MessageItem> items) {
        this.items = items;
        return this;
    }

    public Message addItemsItem(MessageItem itemsItem) {
        if (this.items == null) {
            this.items = new ArrayList<MessageItem>();
        }
        this.items.add(itemsItem);
        return this;
    }

    @ApiModelProperty(value="The items in the message list. Required for carousel and list messages. ")
    public List<MessageItem> getItems() {
        return this.items;
    }

    public void setItems(List<MessageItem> items) {
        this.items = items;
    }

    public Message actions(List<Action> actions) {
        this.actions = actions;
        return this;
    }

    public Message addActionsItem(Action actionsItem) {
        if (this.actions == null) {
            this.actions = new ArrayList<Action>();
        }
        this.actions.add(actionsItem);
        return this;
    }

    @ApiModelProperty(value="The actions in the message.")
    public List<Action> getActions() {
        return this.actions;
    }

    public void setActions(List<Action> actions) {
        this.actions = actions;
    }

    public Message payload(String payload) {
        this.payload = payload;
        return this;
    }

    @ApiModelProperty(value="The payload of a reply action, if applicable.")
    public String getPayload() {
        return this.payload;
    }

    public void setPayload(String payload) {
        this.payload = payload;
    }

    public Message displaySettings(DisplaySettings displaySettings) {
        this.displaySettings = displaySettings;
        return this;
    }

    @ApiModelProperty(value="Settings to adjust the carousel layout. See [Display Settings](https://docs.smooch.io/rest/#display-settings).")
    public DisplaySettings getDisplaySettings() {
        return this.displaySettings;
    }

    public void setDisplaySettings(DisplaySettings displaySettings) {
        this.displaySettings = displaySettings;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Message message = (Message)o;
        return Objects.equals(this.id, message.id) && Objects.equals(this.authorId, message.authorId) && Objects.equals(this.role, message.role) && Objects.equals(this.type, message.type) && Objects.equals(this.source, message.source) && Objects.equals(this.name, message.name) && Objects.equals(this.text, message.text) && Objects.equals(this.email, message.email) && Objects.equals(this.avatarUrl, message.avatarUrl) && Objects.equals(this.received, message.received) && Objects.equals(this.mediaUrl, message.mediaUrl) && Objects.equals(this.mediaType, message.mediaType) && Objects.equals(this.metadata, message.metadata) && Objects.equals(this.items, message.items) && Objects.equals(this.actions, message.actions) && Objects.equals(this.payload, message.payload) && Objects.equals(this.displaySettings, message.displaySettings);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.authorId, this.role, this.type, this.source, this.name, this.text, this.email, this.avatarUrl, this.received, this.mediaUrl, this.mediaType, this.metadata, this.items, this.actions, this.payload, this.displaySettings);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Message {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    authorId: ").append(this.toIndentedString(this.authorId)).append("\n");
        sb.append("    role: ").append(this.toIndentedString(this.role)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    source: ").append(this.toIndentedString(this.source)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    text: ").append(this.toIndentedString(this.text)).append("\n");
        sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
        sb.append("    avatarUrl: ").append(this.toIndentedString(this.avatarUrl)).append("\n");
        sb.append("    received: ").append(this.toIndentedString(this.received)).append("\n");
        sb.append("    mediaUrl: ").append(this.toIndentedString(this.mediaUrl)).append("\n");
        sb.append("    mediaType: ").append(this.toIndentedString(this.mediaType)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    items: ").append(this.toIndentedString(this.items)).append("\n");
        sb.append("    actions: ").append(this.toIndentedString(this.actions)).append("\n");
        sb.append("    payload: ").append(this.toIndentedString(this.payload)).append("\n");
        sb.append("    displaySettings: ").append(this.toIndentedString(this.displaySettings)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

