/*
 * Decompiled with CFR 0.152.
 */
package io.smooch.client.model;

import com.google.gson.annotations.SerializedName;
import io.smooch.client.model.Action;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class MessageItem {
    @SerializedName(value="title")
    private String title = null;
    @SerializedName(value="description")
    private String description = null;
    @SerializedName(value="mediaUrl")
    private String mediaUrl = null;
    @SerializedName(value="size")
    private String size = null;
    @SerializedName(value="mediaType")
    private String mediaType = null;
    @SerializedName(value="actions")
    private List<Action> actions = new ArrayList<Action>();

    public MessageItem title(String title) {
        this.title = title;
        return this;
    }

    @ApiModelProperty(required=true, value="The title of the message item.")
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public MessageItem description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="The text description, or subtitle.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public MessageItem mediaUrl(String mediaUrl) {
        this.mediaUrl = mediaUrl;
        return this;
    }

    @ApiModelProperty(value="The image URL to be shown in the carousel/list item.")
    public String getMediaUrl() {
        return this.mediaUrl;
    }

    public void setMediaUrl(String mediaUrl) {
        this.mediaUrl = mediaUrl;
    }

    public MessageItem size(String size) {
        this.size = size;
        return this;
    }

    @ApiModelProperty(value="The size of the image to be shown in the carousel/list item. Only top item of Facebook Messenger carousel supported. Choose from *compact* and *large*. ")
    public String getSize() {
        return this.size;
    }

    public void setSize(String size) {
        this.size = size;
    }

    public MessageItem mediaType(String mediaType) {
        this.mediaType = mediaType;
        return this;
    }

    @ApiModelProperty(value="If a *mediaUrl* was specified, the media type is defined here, for example *image/jpeg*.")
    public String getMediaType() {
        return this.mediaType;
    }

    public void setMediaType(String mediaType) {
        this.mediaType = mediaType;
    }

    public MessageItem actions(List<Action> actions) {
        this.actions = actions;
        return this;
    }

    public MessageItem addActionsItem(Action actionsItem) {
        this.actions.add(actionsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="Array of [action buttons](https://docs.smooch.io/rest/#action-buttons). At least 1 is required, a maximum of 3 are allowed.")
    public List<Action> getActions() {
        return this.actions;
    }

    public void setActions(List<Action> actions) {
        this.actions = actions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MessageItem messageItem = (MessageItem)o;
        return Objects.equals(this.title, messageItem.title) && Objects.equals(this.description, messageItem.description) && Objects.equals(this.mediaUrl, messageItem.mediaUrl) && Objects.equals(this.size, messageItem.size) && Objects.equals(this.mediaType, messageItem.mediaType) && Objects.equals(this.actions, messageItem.actions);
    }

    public int hashCode() {
        return Objects.hash(this.title, this.description, this.mediaUrl, this.size, this.mediaType, this.actions);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MessageItem {\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    mediaUrl: ").append(this.toIndentedString(this.mediaUrl)).append("\n");
        sb.append("    size: ").append(this.toIndentedString(this.size)).append("\n");
        sb.append("    mediaType: ").append(this.toIndentedString(this.mediaType)).append("\n");
        sb.append("    actions: ").append(this.toIndentedString(this.actions)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

