/*
 * Decompiled with CFR 0.152.
 */
package io.smooch.client.model;

import com.google.gson.annotations.SerializedName;
import io.smooch.client.model.Action;
import io.smooch.client.model.Destination;
import io.smooch.client.model.MessageItem;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class MessagePost {
    @SerializedName(value="role")
    private String role = null;
    @SerializedName(value="type")
    private String type = null;
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="email")
    private String email = null;
    @SerializedName(value="avatarUrl")
    private String avatarUrl = null;
    @SerializedName(value="metadata")
    private Object metadata = null;
    @SerializedName(value="payload")
    private String payload = null;
    @SerializedName(value="text")
    private String text = null;
    @SerializedName(value="mediaUrl")
    private String mediaUrl = null;
    @SerializedName(value="mediaType")
    private String mediaType = null;
    @SerializedName(value="items")
    private List<MessageItem> items = null;
    @SerializedName(value="actions")
    private List<Action> actions = null;
    @SerializedName(value="destination")
    private Destination destination = null;

    public MessagePost role(String role) {
        this.role = role;
        return this;
    }

    @ApiModelProperty(required=true, value="The role of the individual posting the message. Can be either *appUser* or *appMaker*.")
    public String getRole() {
        return this.role;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public MessagePost type(String type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="The message type.")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public MessagePost name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="The display name of the message author.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public MessagePost email(String email) {
        this.email = email;
        return this;
    }

    @ApiModelProperty(value="The email address of the message author.")
    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public MessagePost avatarUrl(String avatarUrl) {
        this.avatarUrl = avatarUrl;
        return this;
    }

    @ApiModelProperty(value="The URL of the desired message avatar image.")
    public String getAvatarUrl() {
        return this.avatarUrl;
    }

    public void setAvatarUrl(String avatarUrl) {
        this.avatarUrl = avatarUrl;
    }

    public MessagePost metadata(Object metadata) {
        this.metadata = metadata;
        return this;
    }

    @ApiModelProperty(value="Flat JSON object containing any custom properties associated with the message.")
    public Object getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Object metadata) {
        this.metadata = metadata;
    }

    public MessagePost payload(String payload) {
        this.payload = payload;
        return this;
    }

    @ApiModelProperty(value="The payload of a reply action, if applicable.")
    public String getPayload() {
        return this.payload;
    }

    public void setPayload(String payload) {
        this.payload = payload;
    }

    public MessagePost text(String text) {
        this.text = text;
        return this;
    }

    @ApiModelProperty(value="The message text. Required for text messages. ")
    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public MessagePost mediaUrl(String mediaUrl) {
        this.mediaUrl = mediaUrl;
        return this;
    }

    @ApiModelProperty(value="The mediaUrl for the message. Required for image/file messages. ")
    public String getMediaUrl() {
        return this.mediaUrl;
    }

    public void setMediaUrl(String mediaUrl) {
        this.mediaUrl = mediaUrl;
    }

    public MessagePost mediaType(String mediaType) {
        this.mediaType = mediaType;
        return this;
    }

    @ApiModelProperty(value="The mediaType for the message. Required for image/file messages. ")
    public String getMediaType() {
        return this.mediaType;
    }

    public void setMediaType(String mediaType) {
        this.mediaType = mediaType;
    }

    public MessagePost items(List<MessageItem> items) {
        this.items = items;
        return this;
    }

    public MessagePost addItemsItem(MessageItem itemsItem) {
        if (this.items == null) {
            this.items = new ArrayList<MessageItem>();
        }
        this.items.add(itemsItem);
        return this;
    }

    @ApiModelProperty(value="The items in the message list. Required for carousel and list messages. ")
    public List<MessageItem> getItems() {
        return this.items;
    }

    public void setItems(List<MessageItem> items) {
        this.items = items;
    }

    public MessagePost actions(List<Action> actions) {
        this.actions = actions;
        return this;
    }

    public MessagePost addActionsItem(Action actionsItem) {
        if (this.actions == null) {
            this.actions = new ArrayList<Action>();
        }
        this.actions.add(actionsItem);
        return this;
    }

    @ApiModelProperty(value="The actions in the message.")
    public List<Action> getActions() {
        return this.actions;
    }

    public void setActions(List<Action> actions) {
        this.actions = actions;
    }

    public MessagePost destination(Destination destination) {
        this.destination = destination;
        return this;
    }

    @ApiModelProperty(value="Specifies which channel to deliver a message to. See [list integrations](https://docs.smooch.io/rest/#list-integrations) to get integration ID and type.")
    public Destination getDestination() {
        return this.destination;
    }

    public void setDestination(Destination destination) {
        this.destination = destination;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MessagePost messagePost = (MessagePost)o;
        return Objects.equals(this.role, messagePost.role) && Objects.equals(this.type, messagePost.type) && Objects.equals(this.name, messagePost.name) && Objects.equals(this.email, messagePost.email) && Objects.equals(this.avatarUrl, messagePost.avatarUrl) && Objects.equals(this.metadata, messagePost.metadata) && Objects.equals(this.payload, messagePost.payload) && Objects.equals(this.text, messagePost.text) && Objects.equals(this.mediaUrl, messagePost.mediaUrl) && Objects.equals(this.mediaType, messagePost.mediaType) && Objects.equals(this.items, messagePost.items) && Objects.equals(this.actions, messagePost.actions) && Objects.equals(this.destination, messagePost.destination);
    }

    public int hashCode() {
        return Objects.hash(this.role, this.type, this.name, this.email, this.avatarUrl, this.metadata, this.payload, this.text, this.mediaUrl, this.mediaType, this.items, this.actions, this.destination);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MessagePost {\n");
        sb.append("    role: ").append(this.toIndentedString(this.role)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
        sb.append("    avatarUrl: ").append(this.toIndentedString(this.avatarUrl)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    payload: ").append(this.toIndentedString(this.payload)).append("\n");
        sb.append("    text: ").append(this.toIndentedString(this.text)).append("\n");
        sb.append("    mediaUrl: ").append(this.toIndentedString(this.mediaUrl)).append("\n");
        sb.append("    mediaType: ").append(this.toIndentedString(this.mediaType)).append("\n");
        sb.append("    items: ").append(this.toIndentedString(this.items)).append("\n");
        sb.append("    actions: ").append(this.toIndentedString(this.actions)).append("\n");
        sb.append("    destination: ").append(this.toIndentedString(this.destination)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

