/*
 * Decompiled with CFR 0.152.
 */
package io.smooch.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class Webhook {
    @SerializedName(value="_id")
    private String id = null;
    @SerializedName(value="target")
    private String target = null;
    @SerializedName(value="triggers")
    private List<String> triggers = new ArrayList<String>();
    @SerializedName(value="secret")
    private String secret = null;

    public Webhook id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(required=true, value="The webhook ID, generated automatically.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Webhook target(String target) {
        this.target = target;
        return this;
    }

    @ApiModelProperty(required=true, value="URL to be called when the webhook is triggered.")
    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public Webhook triggers(List<String> triggers) {
        this.triggers = triggers;
        return this;
    }

    public Webhook addTriggersItem(String triggersItem) {
        this.triggers.add(triggersItem);
        return this;
    }

    @ApiModelProperty(required=true, value="An array of triggers you wish to have the webhook listen to. If unspecified the default trigger is *message*.")
    public List<String> getTriggers() {
        return this.triggers;
    }

    public void setTriggers(List<String> triggers) {
        this.triggers = triggers;
    }

    public Webhook secret(String secret) {
        this.secret = secret;
        return this;
    }

    @ApiModelProperty(required=true, value="Secret which will be transmitted with each webhook invocation and can be used to verify the authenticity of the caller.")
    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Webhook webhook = (Webhook)o;
        return Objects.equals(this.id, webhook.id) && Objects.equals(this.target, webhook.target) && Objects.equals(this.triggers, webhook.triggers) && Objects.equals(this.secret, webhook.secret);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.target, this.triggers, this.secret);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Webhook {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    target: ").append(this.toIndentedString(this.target)).append("\n");
        sb.append("    triggers: ").append(this.toIndentedString(this.triggers)).append("\n");
        sb.append("    secret: ").append(this.toIndentedString(this.secret)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

