/*
 * Decompiled with CFR 0.152.
 */
package io.smooch.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class WebhookUpdate {
    @SerializedName(value="target")
    private String target = null;
    @SerializedName(value="triggers")
    private List<String> triggers = null;

    public WebhookUpdate target(String target) {
        this.target = target;
        return this;
    }

    @ApiModelProperty(value="URL to be called when the webhook is triggered.")
    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public WebhookUpdate triggers(List<String> triggers) {
        this.triggers = triggers;
        return this;
    }

    public WebhookUpdate addTriggersItem(String triggersItem) {
        if (this.triggers == null) {
            this.triggers = new ArrayList<String>();
        }
        this.triggers.add(triggersItem);
        return this;
    }

    @ApiModelProperty(value="An array of triggers you wish to have the webhook listen to. If unspecified the default trigger is *message*.")
    public List<String> getTriggers() {
        return this.triggers;
    }

    public void setTriggers(List<String> triggers) {
        this.triggers = triggers;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WebhookUpdate webhookUpdate = (WebhookUpdate)o;
        return Objects.equals(this.target, webhookUpdate.target) && Objects.equals(this.triggers, webhookUpdate.triggers);
    }

    public int hashCode() {
        return Objects.hash(this.target, this.triggers);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WebhookUpdate {\n");
        sb.append("    target: ").append(this.toIndentedString(this.target)).append("\n");
        sb.append("    triggers: ").append(this.toIndentedString(this.triggers)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

