/*
 * Copyright (c) 2010-2015 Pivotal Software, Inc. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you
 * may not use this file except in compliance with the License. You
 * may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * permissions and limitations under the License. See accompanying
 * LICENSE file.
 */
package quickstart;

import java.io.IOException;

import junit.framework.AssertionFailedError;

/**
 * Verifies that quickstart test output containing an unexpected extra line
 * will fail with that line as the failure message.
 * 
 * @author Kirk Lund
 */
public class FailWithExtraLineInOutputJUnitTest extends FailOutputTestCase {
  
  public FailWithExtraLineInOutputJUnitTest() {
    super("FailWithExtraLineInOutputJUnitTest");
  }
  
  @Override
  String problem() {
    return "This is an extra line";
  }
  
  @Override
  void outputProblem(String message) {
    System.out.println(message);
  }
  
  public void testFailWithExtraLineInOutput() throws InterruptedException, IOException {
    // output has an extra line and should fail
    this.process = new ProcessWrapper(getClass());
    this.process.execute(createProperties());
    this.process.waitForOutputToMatch("Begin " + name() + "\\.main");
    this.process.waitForOutputToMatch("Press Enter to continue\\.");
    this.process.sendInput();
    this.process.waitForOutputToMatch("End " + name() + "\\.main");
    this.process.waitFor();
    printProcessOutput(process);
    String goldenString = "Begin " + name() + ".main" + "\n" 
        + "Press Enter to continue." + "\n" 
        + "End " + name() + ".main" + "\n";
    innerPrintOutput(goldenString, "GOLDEN");
    try {
      assertOutputMatchesGoldenFile(this.process.getOutput(), goldenString);
      fail("assertOutputMatchesGoldenFile should have failed due to " + problem());
    } catch (AssertionFailedError expected) {
      assertTrue(expected.getMessage().contains(problem()));
    }
  }
  
  public static void main(String[] args) throws Exception {
    new FailWithExtraLineInOutputJUnitTest().execute();
  }
}
