INCLUDE $JTESTS/hydraconfig/hydraparams1.inc;
INCLUDE $JTESTS/hydraconfig/topology_4.inc;
hydra.GemFirePrms-distributedSystem = ds;

THREADGROUP adminThreads
    totalThreads = fcn
                   ${${A}Hosts} * ${${A}VMsPerHost} * ${${A}ThreadsPerVM}
                   ncf
    clientNames  = fcn "hydra.TestConfigFcns.generateNames
                        (\"${A}\", ${${A}Hosts}, true)"
                   ncf;
THREADGROUP accessorThreads
    totalThreads = fcn
                   ${${B}Hosts} * ${${B}VMsPerHost} * ${${B}ThreadsPerVM}
                   ncf
    clientNames  = fcn "hydra.TestConfigFcns.generateNames
                        (\"${B}\", ${${B}Hosts}, true)"
                   ncf;
THREADGROUP dataStoreThreads
    totalThreads = fcn
                   ${${C}Hosts} * ${${C}VMsPerHost} * ${${C}ThreadsPerVM}
                   ncf
    clientNames  = fcn "hydra.TestConfigFcns.generateNames
                        (\"${C}\", ${${C}Hosts}, true)"
                   ncf;
THREADGROUP extraVMThreads
    totalThreads = fcn
                   ${${D}Hosts} * ${${D}VMsPerHost} * ${${D}ThreadsPerVM}
                   ncf
    clientNames  = fcn "hydra.TestConfigFcns.generateNames
                        (\"${D}\", ${${D}Hosts}, true)"
                   ncf;

INITTASK     taskClass   = rebalance.CapacityTest  taskMethod = HydraTask_initAccessor
             threadGroups = accessorThreads;

INITTASK     taskClass   = rebalance.CapacityTest  taskMethod = HydraTask_initDataStore
             threadGroups = dataStoreThreads;

INITTASK     taskClass     = util.AdminHelper  taskMethod = HydraTask_initializeAdminDS
             threadGroups = adminThreads;

// Bring a new vm into the ds one at a time; this is a serial execution test
// with round robin
TASK         taskClass   = rebalance.CapacityTest  taskMethod = HydraTask_addCapacity
             threadGroups = extraVMThreads
             maxTimesToRun = fcn ${extraDataStoreHosts} * ${extraDataStoreVMsPerHost} ncf;


hydra.Prms-totalTaskTimeSec = 1200;
hydra.Prms-maxResultWaitSec = 600;
hydra.Prms-serialExecution = true;
hydra.Prms-roundRobin = true;

INCLUDE $JTESTS/util/randomValues.inc;
util.RandomValuesPrms-objectType = byte[];
util.RandomValuesPrms-elementSize = 1000;
util.ValueHolderPrms-useExtraObject = true;
hydra.GemFirePrms-conserveSockets = ONEOF true false FOENO;

hydra.CachePrms-names           = cache1;
hydra.CachePrms-searchTimeout   = 600;

util.TestHelperPrms-minTaskGranularitySec = 30;

hydra.RegionPrms-names          = accessorRegion     dataStoreRegion;
hydra.RegionPrms-regionName     = partitionedRegion  partitionedRegion;
hydra.RegionPrms-dataPolicy     = partition;
hydra.RegionPrms-partitionName  = pr;

hydra.PartitionPrms-names           = pr;
hydra.PartitionPrms-redundantCopies = 3;

rebalance.RebalancePrms-localMaxMemory = ${localMaxMemory};

util.CachePrms-useDeclarativeXmlFile = ONEOF true false FOENO;
util.AdminHelperPrms-alertListener = rebalance.CapacityAdminListener;
