hydra.Prms-testDescription = "
This is a peer to peer test with co-located partitioned regions.
The test does function executions on replicated regions, partitioned regions and also on members.
This test does a set of random function executions with/without filter,
args and result collector. The test also does multiple function executions with
single/multiple data sets. Test then validates the results of each function execution
results.
";

INCLUDE $JTESTS/hydraconfig/hydraparams1.inc;
INCLUDE $JTESTS/hydraconfig/topology_p2p_2.inc;

THREADGROUP verifyThreads totalThreads = fcn "${peerVMsPerHost} * ${peerHosts}" ncf
                          totalVMs = fcn "${peerVMsPerHost} * ${peerHosts}" ncf;

// VM to control the rebalance 
THREADGROUP rebalance
    totalThreads = fcn
                   ${rebalanceHosts} * ${rebalanceVMsPerHost} * ${rebalanceThreadsPerVM}
                   ncf
    clientNames  = fcn "hydra.TestConfigFcns.generateNames
                        (\"rebalance\", ${rebalanceHosts}, true)"
                   ncf;

STARTTASK    taskClass     = parReg.execute.FunctionServiceTest  taskMethod = StartTask_initialize;

INITTASK     taskClass     = parReg.execute.FunctionServiceTest  taskMethod = HydraTask_initialize
                         threadGroups = verifyThreads
			 runMode = always;
			 
INITTASK     taskClass     = parReg.execute.FunctionServiceTest  taskMethod = HydraTask_initRegisterFunction
             threadGroups = verifyThreads, default
             ;
             
INITTASK     taskClass     = parReg.execute.FunctionServiceTest  taskMethod = HydraTask_loadRegions
             threadGroups = verifyThreads, default
             batch;			 
             
INITTASK     taskClass     = parReg.execute.FunctionServiceTest  taskMethod  = HydraTask_verifyPRMetaData
             threadGroups = verifyThreads;

INITTASK     taskClass     = parReg.execute.FunctionServiceTest  taskMethod = HydraTask_verifyRegionSize
             threadGroups = verifyThreads
             ;      

INITTASK     taskClass     = parReg.execute.FunctionServiceTest  taskMethod  = HydraTask_putKeySetInBB
             threadGroups = verifyThreads;

TASK         taskClass     = parReg.execute.FunctionServiceTest  taskMethod = HydraTask_doFireAndForgetExecutions
             threadGroups = verifyThreads, default
             weight = 20;
             
TASK         taskClass     = parReg.execute.FunctionServiceTest  taskMethod = HydraTask_doRandomFunctionExecutions
             threadGroups = verifyThreads, default
             weight = 2000;

TASK         taskClass     = parReg.execute.FunctionServiceTest  taskMethod = HydraTask_doRandomMemberFunctionExecutions
             threadGroups = verifyThreads, default
             weight = 2000;  
             
CLOSETASK    taskClass     = parReg.execute.FunctionServiceTest  taskMethod  = HydraTask_verifyPrimaries
             threadGroups = verifyThreads;

CLOSETASK    taskClass     = parReg.execute.FunctionServiceTest  taskMethod  = HydraTask_verifyPRMetaData
             threadGroups = verifyThreads; 
             
CLOSETASK    taskClass     = parReg.execute.FunctionServiceTest  taskMethod  = HydraTask_verifyColocatedRegions
             threadGroups = verifyThreads;
                                                               
hydra.RegionPrms-names          = 
      region1 region2 region3 region4 ;

hydra.RegionPrms-regionName     = 
      clientRegion1 clientRegion2 clientRegion3 clientRegion4 ;

hydra.RegionPrms-dataPolicy     = partition	partition	partition	partition;
hydra.RegionPrms-partitionName  = pr1 pr2 pr3 pr4 ;

hydra.PartitionPrms-names       = pr1 pr2 pr3 pr4;
hydra.PartitionPrms-startupRecoveryDelay = -1;  // rely on rebalance
hydra.PartitionPrms-partitionResolver = parReg.colocation.MonthPartitionResolver;

hydra.PartitionPrms-colocatedWith = none clientRegion1 clientRegion2 clientRegion3 ;

hydra.PartitionPrms-redundantCopies = 	 ${redundantCopies} ;

hydra.Prms-maxResultWaitSec = 600;

hydra.VmPrms-extraVMArgs = "-Xmx1000m";

hydra.Prms-totalTaskTimeSec = 200; 
hydra.Prms-maxResultWaitSec = 800;

util.TestHelperPrms-minTaskGranularitySec = 60;

getInitialImage.InitImagePrms-numKeys = ${numKeys};
// numNewKeys is 10% of the total number of keys
getInitialImage.InitImagePrms-numNewKeys = fcn "${numKeys} * 0.1" ncf;
getInitialImage.InitImagePrms-useCacheLoader=false;

INCLUDE $JTESTS/util/randomValues.inc;
util.RandomValuesPrms-objectType = byte[];
util.RandomValuesPrms-elementSize = ONEOF 50 100 500 1000 2500 5000 FOENO;
util.ValueHolderPrms-useExtraObject = true;

hydra.GemFirePrms-conserveSockets = ONEOF true false FOENO;

hydra.CachePrms-names           = cache1;
hydra.CachePrms-searchTimeout   = 600;


parReg.ParRegPrms-partitionResolverData = BB;
parReg.ParRegPrms-isWithRoutingResolver = true;
parReg.ParRegPrms-numberOfDataStore = fcn 
                                         "(${peerVMsPerHost} * ${peerHosts}) + 
                                          (${rebalanceHosts} * ${rebalanceVMsPerHost})" 
                                      ncf;
