/*
 * Copyright (c) 2010-2015 Pivotal Software, Inc. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you
 * may not use this file except in compliance with the License. You
 * may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * permissions and limitations under the License. See accompanying
 * LICENSE file.
 */
package security;

import java.security.Principal;
import java.util.Properties;

import templates.security.DummyAuthenticator;
import templates.security.UserPasswordAuthInit;

public class DummyCredentialGenerator extends CredentialGenerator {

  public DummyCredentialGenerator() {
  }

  protected Properties initialize() throws IllegalArgumentException {
    return null;
  }

  public ClassCode classCode() {
    return ClassCode.DUMMY;
  }

  public String getAuthInit() {
    return "templates.security.UserPasswordAuthInit.create";
  }

  public String getAuthenticator() {
    return "templates.security.DummyAuthenticator.create";
  }

  public Properties getValidCredentials(int index) {

    String[] validGroups = new String[] { "admin", "user", "reader", "writer" };
    String[] admins = new String[] { "root", "admin", "administrator" };

    Properties props = new Properties();
    int groupNum = (index % validGroups.length);
    String userName;
    if (groupNum == 0) {
      userName = admins[index % admins.length];
    }
    else {
      userName = validGroups[groupNum] + (index / validGroups.length);
    }
    props.setProperty(UserPasswordAuthInit.USER_NAME, userName);
    props.setProperty(UserPasswordAuthInit.PASSWORD, userName);
    return props;
  }

  public Properties getValidCredentials(Principal principal) {

    String userName = principal.getName();
    if (DummyAuthenticator.testValidName(userName)) {
      Properties props = new Properties();
      props.setProperty(UserPasswordAuthInit.USER_NAME, userName);
      props.setProperty(UserPasswordAuthInit.PASSWORD, userName);
      return props;
    }
    else {
      throw new IllegalArgumentException("Dummy: [" + userName
          + "] is not a valid user");
    }
  }

  public Properties getInvalidCredentials(int index) {

    Properties props = new Properties();
    props.setProperty(UserPasswordAuthInit.USER_NAME, "invalid" + index);
    props.setProperty(UserPasswordAuthInit.PASSWORD, "none");
    return props;
  }

}
