/*
 * Decompiled with CFR 0.152.
 */
package admin;

import admin.AdminBB;
import com.gemstone.gemfire.admin.SystemMemberCacheEvent;
import com.gemstone.gemfire.admin.SystemMemberRegionEvent;
import com.gemstone.gemfire.admin.SystemMembershipEvent;
import com.gemstone.gemfire.cache.Operation;
import com.gemstone.gemfire.distributed.DistributedMember;
import hydra.Log;
import hydra.RemoteTestModule;
import hydra.blackboard.SharedMap;
import java.util.List;
import util.TestException;
import util.TestHelper;

public class AbstractListener {
    public String logCall(String methodName, SystemMembershipEvent event) {
        String aStr = this.toString(methodName, event);
        Log.getLogWriter().info(aStr);
        return aStr;
    }

    public String toString(String methodName, SystemMembershipEvent event) {
        StringBuffer aStr = new StringBuffer();
        aStr.append("Invoked " + this.getClass().getName() + ": " + methodName + " in " + RemoteTestModule.getMyClientName() + "\n");
        if (event == null) {
            return aStr.toString();
        }
        aStr.append("   event.getDistributedMember(): " + event.getDistributedMember().toString() + "\n");
        aStr.append("   event.getMemberId(): " + event.getMemberId() + "\n");
        if (event instanceof SystemMemberCacheEvent) {
            Operation op = ((SystemMemberCacheEvent)event).getOperation();
            aStr.append("   Operation: " + op.toString() + "\n");
        }
        if (event instanceof SystemMemberRegionEvent) {
            aStr.append("   RegionPath: " + ((SystemMemberRegionEvent)event).getRegionPath() + "\n");
        }
        return aStr.toString();
    }

    public static void verifyMemberJoined(DistributedMember dm) {
        List activeMembers = (List)AdminBB.getInstance().getSharedMap().get(AdminBB.activeMembers);
        if (!activeMembers.contains(dm)) {
            AbstractListener.throwException("Event received from member " + dm.toString() + " but member not found in activeMembers list: " + activeMembers);
        }
    }

    public static void throwException(String errStr) {
        SharedMap aMap = AdminBB.getInstance().getSharedMap();
        aMap.put(TestHelper.EVENT_ERROR_KEY, errStr + " " + TestHelper.getStackTrace());
        Log.getLogWriter().info(errStr);
        throw new TestException(errStr);
    }
}

