/*
 * Decompiled with CFR 0.152.
 */
package admin;

import admin.AdminBB;
import admin.AdminPrms;
import admin.AdminTestDistributedSystemFactory;
import admin.AdminTestException;
import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.admin.AdminDistributedSystem;
import com.gemstone.gemfire.admin.AdminDistributedSystemFactory;
import com.gemstone.gemfire.admin.AdminException;
import com.gemstone.gemfire.admin.CacheVm;
import com.gemstone.gemfire.admin.CacheVmConfig;
import com.gemstone.gemfire.admin.DistributedSystemConfig;
import com.gemstone.gemfire.admin.SystemMember;
import com.gemstone.gemfire.admin.SystemMemberCache;
import com.gemstone.gemfire.admin.internal.AdminDistributedSystemImpl;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.distributed.DistributedSystem;
import hydra.ConfigHashtable;
import hydra.FileUtil;
import hydra.GsRandom;
import hydra.HostHelper;
import hydra.HydraRuntimeException;
import hydra.Log;
import hydra.ProcessMgr;
import hydra.TestConfig;
import hydra.blackboard.SharedCounters;
import util.CacheUtil;
import util.TestException;

public class CacheServerAdminTest {
    protected static CacheServerAdminTest cacheServerAdminTest = null;
    protected AdminDistributedSystem admin = null;

    public static synchronized void initializeForAdminTask() {
        if (cacheServerAdminTest == null) {
            cacheServerAdminTest = new CacheServerAdminTest();
            CacheUtil.createCache();
            cacheServerAdminTest.initializeForAdmin();
        }
    }

    public static void startCacheServerTask() {
        cacheServerAdminTest.startCacheServer();
    }

    protected void startCacheServer() {
        SharedCounters sc = AdminBB.getInstance().getSharedCounters();
        int maxCacheServers = TestConfig.tab().intAt(AdminPrms.maxCacheServers);
        if (sc.read(AdminBB.runningCacheServers) < (long)maxCacheServers) {
            String cacheServerId;
            CacheVm cacheServer;
            sc.increment(AdminBB.runningCacheServers);
            sc.increment(AdminBB.startCacheServerRequests);
            String hostName = TestConfig.tab().stringAt(AdminPrms.cacheServerHost);
            String remoteCommand = TestConfig.tab().stringAt(AdminPrms.cacheServerRemoteCommand);
            try {
                cacheServer = this.admin.addCacheVm();
                cacheServerId = cacheServer.getId();
                CacheServerAdminTest.log().info("cache server added, ID is: " + cacheServerId);
            }
            catch (AdminException ae) {
                throw new TestException("Unable to add Cache Server");
            }
            CacheVmConfig cacheServerConfig = cacheServer.getVmConfig();
            CacheServerAdminTest.log().info("got cache server config");
            if (hostName.equals("localhost")) {
                CacheServerAdminTest.log().info("host is localhost");
                hostName = HostHelper.getCanonicalHostName();
            }
            CacheServerAdminTest.log().info("host has been set");
            if (!remoteCommand.equals("none")) {
                CacheServerAdminTest.log().info("setting remote command to: " + remoteCommand);
                cacheServerConfig.setRemoteCommand(remoteCommand);
                CacheServerAdminTest.log().info("set remote command to: " + remoteCommand);
            }
            cacheServerConfig.setHost(hostName);
            CacheServerAdminTest.log().info("set host in config for cache server");
            String workingDir = cacheServerConfig.getWorkingDirectory();
            workingDir = workingDir + "/" + cacheServerId + "_" + ProcessMgr.getProcessId();
            FileUtil.mkdir(workingDir);
            if (!HostHelper.isWindows()) {
                String productDir;
                if (!workingDir.startsWith("/export")) {
                    workingDir = "/export" + workingDir;
                }
                if (!(productDir = cacheServerConfig.getProductDirectory()).startsWith("/export")) {
                    cacheServerConfig.setProductDirectory("/export" + productDir);
                }
            }
            cacheServerConfig.setWorkingDirectory(workingDir);
            CacheServerAdminTest.log().info("set working dir to: " + workingDir);
            CacheServerAdminTest.log().info("ready to start cache server: " + cacheServerId);
            long timeout = 60000L;
            try {
                cacheServer.start();
                if (!cacheServer.waitToStart(timeout)) {
                    throw new TestException("CacheServer in " + workingDir + "not started after " + timeout + " ms");
                }
                CacheServerAdminTest.log().info("CacheServer " + cacheServer.getId() + " is running is: " + cacheServer.isRunning());
            }
            catch (Exception e) {
                throw new TestException("Unable to start Cache Server", e);
            }
        }
        CacheServerAdminTest.log().info("already started max cache servers (as specified in test config)");
    }

    public static void stopRandomCacheServerTask() {
        cacheServerAdminTest.stopRandomCacheServer();
    }

    private void stopRandomCacheServer() {
        GsRandom rng = new GsRandom();
        CacheVm[] cacheServers = this.getCacheServers();
        int numCacheServers = cacheServers.length;
        if (numCacheServers > 0) {
            int i = rng.nextInt(0, numCacheServers - 1);
            try {
                CacheServerAdminTest.log().info("cache server to stop is: " + i);
                if (cacheServers[i].isRunning()) {
                    CacheServerAdminTest.log().info("Stopping cache server: " + cacheServers[i].getId());
                    cacheServers[i].stop();
                    SharedCounters sc = AdminBB.getInstance().getSharedCounters();
                    sc.increment(AdminBB.stopCacheServerRequests);
                    sc.decrement(AdminBB.runningCacheServers);
                } else {
                    CacheServerAdminTest.log().info("No cache server stopped, selected cache server was not running");
                }
            }
            catch (AdminException ae) {
                throw new TestException("Unable to stop Cache Server: " + cacheServers[i].getId(), ae);
            }
            catch (IllegalStateException ise) {
                throw new TestException("Problem with CacheServer remote command for: " + cacheServers[i].getId(), ise);
            }
        }
    }

    public static void stopAllCacheServersTask() {
        CacheServerAdminTest.initializeForAdminTask();
        cacheServerAdminTest.stopAllCacheServers();
    }

    protected void stopAllCacheServers() {
        CacheVm[] cacheServers = this.getCacheServers();
        for (int i = 0; i < cacheServers.length; ++i) {
            CacheVm cacheServer = cacheServers[i];
            if (cacheServer.isRunning()) {
                try {
                    CacheServerAdminTest.log().info("Stopping cache server: " + cacheServer.getId());
                    cacheServer.stop();
                    continue;
                }
                catch (AdminException ae) {
                    throw new TestException("Unable to stop Cache Server: " + cacheServer.getId(), ae);
                }
                catch (Exception e) {
                    CacheServerAdminTest.log().info("Exception - trying to stop cache server: " + cacheServer.getId());
                    continue;
                }
            }
            CacheServerAdminTest.log().info("No running cache servers found in stopAllCacheServers.");
        }
    }

    public static void validateCacheServersTask() {
        CacheServerAdminTest.initializeForAdminTask();
        cacheServerAdminTest.validateCacheServers();
    }

    protected void validateCacheServers() {
        SharedCounters sc = AdminBB.getInstance().getSharedCounters();
        long numStops = sc.read(AdminBB.stopCacheServerRequests);
        long numStarts = sc.read(AdminBB.startCacheServerRequests);
        int currRunningCacheServers = 0;
        CacheVm[] cacheServers = this.getCacheServers();
        for (int i = 0; i < cacheServers.length; ++i) {
            if (!cacheServers[i].isRunning()) continue;
            CacheServerAdminTest.log().info("In validate cache server: " + cacheServers[i].getId() + " isRunning status is: " + cacheServers[i].isRunning());
            ++currRunningCacheServers;
        }
        CacheServerAdminTest.log().info("requested start " + numStarts + " cache servers");
        CacheServerAdminTest.log().info("requested stop " + numStops + " cache servers");
        CacheServerAdminTest.log().info("admin found " + currRunningCacheServers + " running cache servers");
    }

    public static void accessCacheServersTask() {
        cacheServerAdminTest.accessCacheServers();
    }

    protected void accessCacheServers() {
        CacheVm[] cacheServers = this.getCacheServers();
        for (int i = 0; i < cacheServers.length; ++i) {
            CacheVm cacheServer = cacheServers[i];
            CacheServerAdminTest.log().info("Cache Server: " + cacheServer.toString());
            CacheServerAdminTest.log().info("CacheServer is running: " + cacheServer.isRunning());
            CacheServerAdminTest.log().info("type: " + cacheServer.getType());
            CacheServerAdminTest.log().info("CacheServer classpath is: " + cacheServer.getVmConfig().getClassPath());
            CacheServerAdminTest.log().info("product dir is: " + cacheServer.getVmConfig().getProductDirectory());
            CacheServerAdminTest.log().info("working dir is: " + cacheServer.getVmConfig().getWorkingDirectory());
            CacheServerAdminTest.log().info("host is: " + cacheServer.getVmConfig().getHost());
            CacheServerAdminTest.log().info("remoteCommand is: " + cacheServer.getVmConfig().getRemoteCommand());
            CacheServerAdminTest.log().info("CacheServer is running: " + cacheServer.isRunning());
            try {
                SystemMemberCache cache = cacheServer.getCache();
                CacheServerAdminTest.log().info("getCache() succeeded for cache server: " + cacheServer.getId());
                continue;
            }
            catch (AdminException ae) {
                throw new TestException("Unable to get cache for cache server: " + cacheServer.getId());
            }
        }
    }

    protected SystemMember[] getApplicationSystemMembers() {
        SystemMember[] systemMembers = null;
        try {
            systemMembers = this.admin.getSystemMemberApplications();
        }
        catch (AdminException ae) {
            throw new HydraRuntimeException("Could not get SystemMemberApplications");
        }
        if (systemMembers.length == 0) {
            throw new HydraRuntimeException("Found no system members");
        }
        CacheServerAdminTest.log().info("DEBUG Found: " + systemMembers.length + " system members");
        return systemMembers;
    }

    protected CacheVm[] getCacheServers() {
        CacheVm[] cacheServers = null;
        try {
            cacheServers = this.admin.getCacheVms();
        }
        catch (AdminException ae) {
            throw new HydraRuntimeException("Could not get Cache Servers");
        }
        if (cacheServers.length == 0) {
            CacheServerAdminTest.log().info("Admin found 0 configured cache servers");
        } else {
            CacheServerAdminTest.log().info("Admin found: " + cacheServers.length + " cacheServers");
        }
        return cacheServers;
    }

    protected void initializeForAdmin() {
        DistributedSystemConfig dsConfig;
        CacheServerAdminTest.log().info("Creating an admin DistributedSystem...");
        Cache cache = CacheUtil.getCache();
        DistributedSystem thisVmDs = cache.getDistributedSystem();
        try {
            dsConfig = AdminDistributedSystemFactory.defineDistributedSystem((DistributedSystem)thisVmDs, null);
        }
        catch (AdminException ae) {
            String s = "Problem getting config for ds to which VM is currently connected";
            throw new AdminTestException(s, (Exception)((Object)ae));
        }
        try {
            this.admin = AdminTestDistributedSystemFactory.getDistributedSystem(dsConfig);
        }
        catch (AdminTestException ae) {
            throw new HydraRuntimeException("Could not getDistributedSystem", (Exception)((Object)ae));
        }
        if (this.admin instanceof AdminDistributedSystemImpl) {
            ((AdminDistributedSystemImpl)this.admin).connect(Log.getLogWriter().convertToLogWriterI18n());
        } else {
            this.admin.connect();
        }
        long timeout = 30000L;
        try {
            if (!this.admin.waitToBeConnected(timeout)) {
                String s = "Could not connect after " + timeout + "ms";
                throw new TestException(s);
            }
        }
        catch (InterruptedException ex) {
            String s = "Interrupted while waiting to be connected";
            throw new HydraRuntimeException(s, ex);
        }
        CacheServerAdminTest.log().info("initialize completed");
    }

    protected static ConfigHashtable tab() {
        return TestConfig.tab();
    }

    protected static LogWriter log() {
        return Log.getLogWriter();
    }
}

