/*
 * Decompiled with CFR 0.152.
 */
package admin;

import admin.AdminBB;
import admin.AdminTestException;
import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.Locator;
import event.EventTest;
import hydra.DistributedConnectionMgr;
import hydra.GemFireDescription;
import hydra.HostHelper;
import hydra.HydraRuntimeException;
import hydra.Log;
import hydra.PortHelper;
import hydra.ProcessMgr;
import hydra.TestConfig;
import hydra.blackboard.SharedMap;
import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import util.TestException;

public class LocatorTest {
    protected static LocatorTest locatorTest;

    public static void HydraTask_startLocator() {
        if (locatorTest == null) {
            locatorTest = new LocatorTest();
            locatorTest.startLocator();
        }
    }

    protected void startLocator() {
        int numLocatorsRunningInVM = Locator.getLocators().size();
        int port = PortHelper.getRandomPort();
        String gemfireName = System.getProperty("gemfireName");
        GemFireDescription gfd = TestConfig.getInstance().getGemFireDescription(gemfireName);
        Properties props = gfd.getDistributedSystemProperties();
        File logFile = new File("locator-" + port + ".log");
        try {
            Locator locator = Locator.startLocator((int)port, (File)logFile);
        }
        catch (Exception e) {
            String s = "Problem starting nonHydra Locator in application VM";
            throw new AdminTestException(s, e);
        }
        int expectedNumLocators = numLocatorsRunningInVM + 1;
        if (Locator.getLocators().size() != expectedNumLocators) {
            throw new AdminTestException("Expected " + expectedNumLocators + " locators but found " + Locator.getLocators().size());
        }
        String host = HostHelper.getLocalHost();
        String locatorStr = host + "[" + port + "]";
        AdminBB bb = AdminBB.getInstance();
        Integer pid = new Integer(ProcessMgr.getProcessId());
        bb.getSharedMap().put(locatorStr, pid);
        Log.getLogWriter().info("Locator started: " + locatorStr);
    }

    public static void HydraTask_setConnection() {
        if (locatorTest == null) {
            locatorTest = new LocatorTest();
        }
        locatorTest.setConnection();
    }

    protected void setConnection() {
        String currLocators = "";
        AdminBB bb = AdminBB.getInstance();
        Map locatorsMap = bb.getSharedMap().getMap();
        Set locators = locatorsMap.keySet();
        if (locators.size() == 0) {
            String s = "found no locators in shared map";
            throw new AdminTestException(s);
        }
        Iterator it = locators.iterator();
        currLocators = (String)it.next();
        while (it.hasNext()) {
            currLocators = currLocators + "," + (String)it.next();
        }
        String gemfireName = System.getProperty("gemfireName");
        if (gemfireName == null) {
            throw new AdminTestException("Could not get GEMFIRE_NAME_PROPERTY");
        }
        GemFireDescription gfd = TestConfig.getInstance().getGemFireDescription(gemfireName);
        Properties gfdProps = gfd.getDistributedSystemProperties();
        gfdProps.setProperty("locators", currLocators);
        Log.getLogWriter().info("Added locator, locators: " + currLocators);
        DistributedConnectionMgr.disconnect();
        DistributedSystem system = DistributedConnectionMgr.connect(gemfireName, gfdProps);
    }

    public static void HydraTask_stopLocator() {
        if (locatorTest == null) {
            locatorTest = new LocatorTest();
        }
        locatorTest.stopLocator();
    }

    protected void stopLocator() {
        Locator locator = null;
        List locators = Locator.getLocators();
        Object[] locatorArray = locators.toArray();
        for (int i = 0; i < locators.size(); ++i) {
            locator = (Locator)locatorArray[i];
            locator.stop();
            Log.getLogWriter().info("Stopped locator: " + locator.toString());
        }
        locators = Locator.getLocators();
        if (locators.size() != 0) {
            String s = "Expected 0 locators in VM but found: " + locators.size();
            throw new AdminTestException(s);
        }
    }

    public static void HydraTask_clearSharedMap() {
        AdminBB bb = AdminBB.getInstance();
        bb.getSharedMap().clear();
    }

    public static void HydraTask_validateLocator() {
        locatorTest.validateLocator();
    }

    protected void validateLocator() {
        AdminBB bb = AdminBB.getInstance();
        SharedMap map = bb.getSharedMap();
        List locators = Locator.getLocators();
        int numLocatorsRunningInVm = locators.size();
        int numLocatorsStartedInVm = 0;
        int currPid = ProcessMgr.getProcessId();
        Collection locatorVmPids = map.getMap().values();
        for (Integer pid : locatorVmPids) {
            if (currPid != pid) continue;
            ++numLocatorsStartedInVm;
        }
        if (numLocatorsStartedInVm != numLocatorsRunningInVm) {
            String s = "Shared Map of locators doesn't match VM locators for PID: " + currPid;
            throw new AdminTestException(s);
        }
    }

    public static void eventTest_validateRegion() {
        if (locatorTest == null) {
            locatorTest = new LocatorTest();
            locatorTest.validateRegion();
        }
    }

    protected void validateRegion() {
        try {
            this.startLocator();
            this.setConnection();
        }
        catch (Exception e) {
            throw new TestException("Unable to start locator", e);
        }
        try {
            EventTest.HydraTask_iterate();
        }
        catch (VirtualMachineError e) {
            SystemFailure.initiateFailure((Error)e);
            throw e;
        }
        catch (Throwable e) {
            String s = "validate_region failed to perform EventTest.HydraTask_iterate()";
            throw new HydraRuntimeException(s, e);
        }
    }
}

