/*
 * Decompiled with CFR 0.152.
 */
package admin;

import admin.ShutDownAllMembersPrms;
import com.gemstone.gemfire.admin.AdminDistributedSystem;
import com.gemstone.gemfire.admin.AdminException;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheClosedException;
import com.gemstone.gemfire.cache.InterestResultPolicy;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.DistributedSystemDisconnectedException;
import hydra.BridgeHelper;
import hydra.BridgePrms;
import hydra.CacheHelper;
import hydra.DistributedSystemHelper;
import hydra.Log;
import hydra.RegionHelper;
import hydra.TestConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import util.AdminHelper;
import util.TestException;
import util.TestHelper;

public class ShutDownAllMembersTest {
    public static ShutDownAllMembersTest testInstance = null;
    private boolean isBridgeConfiguration;
    private boolean isBridgeClient;
    private Cache theCache;
    private DistributedSystem ds;
    private List<Region> regionList = new ArrayList<Region>();

    public static synchronized void HydraTask_initializeClient() throws Throwable {
        if (testInstance == null) {
            testInstance = new ShutDownAllMembersTest();
            testInstance.initializeInstance();
            ShutDownAllMembersTest.testInstance.theCache = CacheHelper.createCache("cache1");
            ShutDownAllMembersTest.testInstance.ds = DistributedSystemHelper.getDistributedSystem();
            String regionConfigName = ShutDownAllMembersPrms.getRegionConfigName();
            ShutDownAllMembersTest.testInstance.regionList.add(RegionHelper.createRegion(regionConfigName));
            if (ShutDownAllMembersTest.testInstance.isBridgeConfiguration) {
                ShutDownAllMembersTest.testInstance.isBridgeClient = true;
                ShutDownAllMembersTest.registerInterest();
            }
        }
    }

    public static synchronized void HydraTask_initialize() throws Throwable {
        if (testInstance == null) {
            testInstance = new ShutDownAllMembersTest();
            testInstance.initializeInstance();
            ShutDownAllMembersTest.testInstance.theCache = CacheHelper.createCache("cache1");
            ShutDownAllMembersTest.testInstance.ds = DistributedSystemHelper.getDistributedSystem();
            String regionConfigName = ShutDownAllMembersPrms.getRegionConfigName();
            ShutDownAllMembersTest.testInstance.regionList.add(RegionHelper.createRegion(regionConfigName));
            if (ShutDownAllMembersTest.testInstance.isBridgeConfiguration) {
                ShutDownAllMembersTest.testInstance.isBridgeClient = false;
                BridgeHelper.startBridgeServer("bridge");
            }
        }
    }

    public static synchronized void HydraTask_initLocator() {
        DistributedSystemHelper.createLocator();
        DistributedSystemHelper.startLocatorAndAdminDS();
    }

    private void initializeInstance() {
        this.isBridgeConfiguration = TestConfig.tab().vecAt(BridgePrms.names, null) != null;
    }

    public static void HydraTask_shutDownAllMembers() {
        Set memberSet;
        AdminDistributedSystem adminDS = AdminHelper.getAdminDistributedSystem();
        Log.getLogWriter().info("AdminDS " + adminDS + " is shutting down all members...");
        try {
            memberSet = adminDS.shutDownAllMembers();
        }
        catch (AdminException e1) {
            throw new TestException(TestHelper.getStackTrace(e1));
        }
        Log.getLogWriter().info("AdminDS " + adminDS + " shut down (disconnected) the following members " + "(vms remain up): " + memberSet);
    }

    public static void HydraTask_verifyVmStatus() {
        boolean expectVmShutDown = ShutDownAllMembersPrms.getExpectVmShutDown();
        boolean cacheClosed = ShutDownAllMembersTest.testInstance.theCache.isClosed();
        boolean dsConnected = ShutDownAllMembersTest.testInstance.ds.isConnected();
        if (expectVmShutDown) {
            if (!cacheClosed) {
                throw new TestException("Expected cache to be closed but " + ShutDownAllMembersTest.testInstance.theCache + " isClosed() returned " + cacheClosed);
            }
            Log.getLogWriter().info("Cache is closed as expected");
            if (dsConnected) {
                throw new TestException("Expected to be disconnected from the DS, but " + ShutDownAllMembersTest.testInstance.ds + " isConnected() returned " + dsConnected);
            }
            Log.getLogWriter().info("This vm is disconnected from the ds as expected");
            for (Region aRegion : ShutDownAllMembersTest.testInstance.regionList) {
                try {
                    aRegion.size();
                    throw new TestException("Was able to call size() on region, but we expected this vm to be disconnected from the ds");
                }
                catch (DistributedSystemDisconnectedException e) {
                    Log.getLogWriter().info(aRegion.getFullPath() + " is not accessible as expected");
                }
                catch (CacheClosedException cce) {
                    Log.getLogWriter().info(aRegion.getFullPath() + " is not accessible as expected");
                }
            }
        } else {
            if (cacheClosed) {
                throw new TestException("Expect cache to not be closed but " + ShutDownAllMembersTest.testInstance.theCache + " is " + cacheClosed);
            }
            Log.getLogWriter().info("Cache is not closed as expected");
            if (!dsConnected) {
                throw new TestException("Expected to be connected to the DS, but " + ShutDownAllMembersTest.testInstance.ds + " isConnected() returned " + dsConnected);
            }
            Log.getLogWriter().info("This vm is connected to the ds as expected");
            for (Region aRegion : ShutDownAllMembersTest.testInstance.regionList) {
                try {
                    aRegion.size();
                    Log.getLogWriter().info(aRegion + " is accessible as expected");
                }
                catch (DistributedSystemDisconnectedException e) {
                    throw new TestException("Was unable to call size() on region, but we expected this vm to be connected from the ds " + TestHelper.getStackTrace(e));
                }
            }
        }
    }

    public static void HydraTask_verifyAdminVmStatus() {
        boolean expectVmShutDown = ShutDownAllMembersPrms.getExpectVmShutDown();
        AdminDistributedSystem adminDS = AdminHelper.getAdminDistributedSystem();
        boolean isConnected = adminDS.isConnected();
        if (expectVmShutDown) {
            if (!isConnected) {
                throw new TestException("Expected this admin vm to not be connected but " + adminDS + " isConnected() returned " + isConnected);
            }
            Log.getLogWriter().info("admin vm is connected as expected");
        }
    }

    protected static void registerInterest() {
        Set rootRegions = CacheHelper.getCache().rootRegions();
        for (Region aRegion : rootRegions) {
            Log.getLogWriter().info("Calling registerInterest for all keys, result interest policy KEYS_VALUES for region " + aRegion.getFullPath());
            aRegion.registerInterest((Object)"ALL_KEYS", InterestResultPolicy.KEYS_VALUES);
            Log.getLogWriter().info("Done calling registerInterest for all keys, result interest policy KEYS_VALUES, " + aRegion.getFullPath() + " size is " + aRegion.size());
        }
    }
}

