/*
 * Decompiled with CFR 0.152.
 */
package admin.jmx;

import admin.jmx.RecyclePrms;
import admin.jmx.RecycleSysBlackboard;
import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.admin.GemFireMemberStatus;
import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.CacheWriter;
import com.gemstone.gemfire.cache.CacheWriterException;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.InterestResultPolicy;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.RegionEvent;
import com.gemstone.gemfire.cache.RegionExistsException;
import com.gemstone.gemfire.cache.server.CacheServer;
import com.gemstone.gemfire.cache.util.CacheListenerAdapter;
import com.gemstone.gemfire.cache.util.GatewayHub;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.DistributionConfig;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.cache.GatewayHubStatus;
import com.gemstone.gemfire.internal.cache.HARegion;
import com.gemstone.gemfire.internal.cache.tier.InternalBridgeMembership;
import hydra.BridgeHelper;
import hydra.CacheHelper;
import hydra.ClientVmMgr;
import hydra.ClientVmNotFoundException;
import hydra.ConfigHashtable;
import hydra.ConfigPrms;
import hydra.DistributedSystemHelper;
import hydra.GatewayHubHelper;
import hydra.GsRandom;
import hydra.HydraRuntimeException;
import hydra.HydraVector;
import hydra.Log;
import hydra.RegionHelper;
import hydra.RegionPrms;
import hydra.TestConfig;
import hydra.blackboard.SharedMap;
import java.io.IOException;
import java.util.Random;
import java.util.Set;
import util.NameFactory;
import util.TestException;

public class RecycleSystem {
    protected static final String REGION_NAME = "GlobalVillage";
    protected static int absoluteRegionCount;
    static ConfigHashtable conftab;
    static LogWriter logger;
    static GsRandom rand;
    static int executionCount;

    public static void doTask() {
        if (CacheHelper.getCache() != null) {
            DistributedSystem disSys = CacheHelper.getCache().getDistributedSystem();
            Cache cache = CacheHelper.getCache();
            GemFireMemberStatus status = new GemFireMemberStatus(cache);
            logger.info("RecycleSystem:doTask:: Status from the existing system " + status.toString());
        } else {
            logger.info("RecycleSystem:doTask:: No Cache Available");
        }
        int sleepSecs = conftab.intAt(RecyclePrms.sleepBetweenCycles, 120);
        try {
            Thread.sleep(sleepSecs * 1000);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void updateKeys() {
        if (DistributedSystemHelper.getDistributedSystem() == null || CacheHelper.getCache() == null) {
            return;
        }
        Cache cache = CacheFactory.getInstance((DistributedSystem)DistributedSystemHelper.getDistributedSystem());
        Object[] regionList = cache.rootRegions().toArray();
        logger.info("RecycleSystem:updateKeys:: cache" + cache);
        int numRegs = regionList.length;
        for (int i = 0; i < numRegs; ++i) {
            Region reg = (Region)regionList[i];
            if (reg instanceof HARegion) continue;
            Set keys = reg.keySet();
            logger.info("RecycleSystem:updateKeys:: number of keys in  " + reg.getFullPath() + " is  " + keys.size());
            for (Object key : keys) {
                reg.put(key, key);
                logger.info("RecycleSystem:updateKeys:: updated value for" + key);
            }
        }
        GemFireMemberStatus status = new GemFireMemberStatus(cache);
        logger.info("RecycleSystem:updateKeys:: Status from the existing system " + status.toString());
        logger.info("RecycleSystem:updateKeys::" + InternalBridgeMembership.getClientQueueSizes());
        int sleepSecs = RecycleSystem.restart();
        try {
            Thread.sleep(sleepSecs * 1000);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void getKeys() {
        Cache cache = CacheFactory.getInstance((DistributedSystem)DistributedSystemHelper.getDistributedSystem());
        Object[] regionList = cache.rootRegions().toArray();
        logger.info("RecycleSystem:getKeys:: cache" + cache);
        int numRegs = regionList.length;
        for (int i = 0; i < numRegs; ++i) {
            Region reg = (Region)regionList[i];
            if (reg instanceof HARegion) continue;
            Set keys = reg.keySet();
            logger.info("RecycleSystem:getKeys:: number of keys in  " + reg.getFullPath() + " is  " + keys.size());
            for (Object key : keys) {
                Object value = reg.get(key);
                logger.info("RecycleSystem:getKeys:: value for" + key + " is " + value);
            }
        }
        int sleepSecs = RecycleSystem.restart();
        try {
            Thread.sleep(sleepSecs * 1000);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void invokeCacheMiss() {
        Cache cache = CacheFactory.getInstance((DistributedSystem)DistributedSystemHelper.getDistributedSystem());
        Object[] regionList = cache.rootRegions().toArray();
        int numRegs = regionList.length;
        for (int i = 0; i < numRegs; ++i) {
            Region reg = (Region)regionList[i];
            if (reg instanceof HARegion) continue;
            int keysize = reg.keySet().size();
            for (int j = 0; j < keysize; ++j) {
                reg.get((Object)("notexist" + j));
            }
        }
    }

    protected static void hardStop() {
        boolean hardStop = RecyclePrms.isRecycleModeHardKill();
        if (hardStop) {
            try {
                ClientVmMgr.stop("killing myself", -21, -30);
                return;
            }
            catch (ClientVmNotFoundException ex) {
                throw new HydraRuntimeException("I should always be able to kill myself", ex);
            }
        }
    }

    public static void stopEdgeClient() {
        RecycleSystem.stopCacheEntities();
        RecycleSystem.hardStop();
    }

    public static void stopCacheEntities() {
        if (CacheHelper.getCache() != null) {
            DistributedSystem disSys = CacheHelper.getCache().getDistributedSystem();
            RecycleSysBlackboard.getInstance().getSharedMap().remove(disSys.getMemberId());
            GatewayHubHelper.stopGatewayHub();
            BridgeHelper.stopBridgeServer();
            CacheHelper.closeCache();
            disSys.disconnect();
            absoluteRegionCount = 0;
            logger.info("RecycleSystem:stopCacheEntities:: Disconnected from the existing system");
        } else {
            logger.info("RecycleSystem:stopCacheEntities:: Wasn't even connected to any system");
        }
    }

    public static void stopGateways() {
        if (CacheHelper.getCache() != null && GatewayHubHelper.getGatewayHub() != null) {
            GatewayHubHelper.getGatewayHub().stopGateways();
            logger.info("RecycleSystem:stopGateways:: Stopped all Gateways in the Hub");
        } else {
            logger.info("RecycleSystem:stopGateways:: There was no Cache or Hub");
        }
    }

    public static void stopGatewayHub() {
        if (CacheHelper.getCache() != null && GatewayHubHelper.getGatewayHub() != null) {
            DistributedSystem disSys = CacheHelper.getCache().getDistributedSystem();
            Cache cache = CacheHelper.getCache();
            GemFireMemberStatus status = new GemFireMemberStatus(cache);
            GatewayHubHelper.getGatewayHub().stopGateways();
            GatewayHubHelper.stopGatewayHub();
            if (status.getIsPrimaryGatewayHub()) {
                long num = RecycleSysBlackboard.getInstance().getSharedCounters().decrementAndRead(RecycleSysBlackboard.numOfPrimaryGateways);
                logger.info("RecycleSystem:stopGateways:: Stopped all Gateways & the Prim Hub.Current total=" + num);
            } else if (status.getIsSecondaryGatewayHub()) {
                long num = RecycleSysBlackboard.getInstance().getSharedCounters().decrementAndRead(RecycleSysBlackboard.numOfSecondaryGateways);
                logger.info("RecycleSystem:stopGateways:: Stopped all Gateways & the Seco Hub.Current total=" + num);
            } else {
                long num = RecycleSysBlackboard.getInstance().getSharedCounters().decrementAndRead(RecycleSysBlackboard.numOfGateways);
                logger.info("RecycleSystem:stopGateways:: Stopped all Gateways & the Hub.Current total=" + num);
            }
        } else {
            logger.info("RecycleSystem:stopGateways:: There was no Cache or Hub");
        }
    }

    public static void startPeerCache() {
        RecycleSystem.startCache();
    }

    public static void startServerCache() {
        String bridgeConfig = ConfigPrms.getBridgeConfig();
        RecycleSystem.startCache();
        CacheServer bridgeServer = BridgeHelper.startBridgeServer(bridgeConfig);
        InternalDistributedSystem ds = (InternalDistributedSystem)CacheHelper.getCache().getDistributedSystem();
        DistributionConfig config = ds.getConfig();
        logger.info("RecycleSystem::startServerCache bindAddress = " + config.getBindAddress());
        Cache cache = CacheHelper.getCache();
        GemFireMemberStatus status = new GemFireMemberStatus(cache);
        RecycleSysBlackboard.getInstance().getSharedMap().put(status.getMemberId(), status);
    }

    public static void createGatewayCache() {
        String bridgeConfig = ConfigPrms.getBridgeConfig();
        String gatewayHubConfig = ConfigPrms.getGatewayHubConfig();
        String gatewayConfig = ConfigPrms.getGatewayConfig();
        RecycleSystem.startCache();
        BridgeHelper.startBridgeServer(bridgeConfig);
        GatewayHub hub = GatewayHubHelper.createGatewayHub(ConfigPrms.getGatewayHubConfig());
        logger.info("RecycleSystem::createGatewayCache::setpForDS = " + CacheHelper.getCache().getDistributedSystem().getName());
    }

    public static void createGateways() {
        if (GatewayHubHelper.getGatewayHub() != null) {
            GatewayHubHelper.addGateways(ConfigPrms.getGatewayConfig());
            RecycleSystem.startGatewayHub();
        } else {
            logger.info("RecycleSystem::createGateways::No Gateway Added No Gateway Hub identified");
        }
    }

    public static void startGateways() {
        try {
            GatewayHubHelper.getGatewayHub().startGateways();
        }
        catch (IOException ioEx) {
            String err = "Problem starting gateways";
            throw new HydraRuntimeException(err, ioEx);
        }
    }

    public static void startGatewayHub() {
        GatewayHubHelper.startGatewayHub();
        try {
            GatewayHubHelper.getGatewayHub().startGateways();
        }
        catch (IOException ioEx) {
            String err = "Problem starting gateways";
            throw new HydraRuntimeException(err, ioEx);
        }
        GemFireMemberStatus status = new GemFireMemberStatus(CacheHelper.getCache());
        RecycleSysBlackboard.getInstance().getSharedMap().put(status.getMemberId(), status);
    }

    public static void startEdgeClient() {
        String cacheConfig = RecyclePrms.getEdgeCacheConfig();
        String regionConfig = RecyclePrms.getEdgeRegionConfig();
        Cache cache = CacheHelper.createCache(cacheConfig);
        int numRegs = conftab.intAt(RecyclePrms.numberOfRootRegions, 0);
        if (RecyclePrms.isRegionNamesDefined()) {
            RecycleSystem.createUserDefinedRegion(cache);
        } else {
            RecycleSystem.createRegion(regionConfig, cache, numRegs, false);
        }
        GemFireMemberStatus status = new GemFireMemberStatus(cache);
        int loaders = cache.getCacheServers().size();
        RecycleSysBlackboard.getInstance().getSharedMap().put(status.getMemberId(), status);
        logger.info("RecycleSystem::startEdgeClient:: statusIsClient:serversSize " + status.getIsClient() + ":" + loaders);
    }

    public static void restartPeerCache() {
        int sleepSecs = RecycleSystem.restart();
        try {
            Thread.sleep(sleepSecs * 1000);
        }
        catch (Exception exception) {
            // empty catch block
        }
        RecycleSystem.stopCacheEntities();
        RecycleSystem.hardStop();
        RecycleSystem.startPeerCache();
    }

    public static void restartServerCache() {
        int sleepSecs = RecycleSystem.restart();
        try {
            Thread.sleep(sleepSecs * 1000);
        }
        catch (Exception e) {
            logger.warning(e.getMessage());
        }
        RecycleSystem.stopCacheEntities();
        RecycleSystem.hardStop();
        RecycleSystem.startServerCache();
    }

    public static void restartGatewayCache() {
        if (executionCount == 0) {
            GatewayHubHelper.addGateways(ConfigPrms.getGatewayConfig());
            GatewayHubHelper.startGatewayHub();
        }
        int sleepSecs = RecycleSystem.restart();
        try {
            Thread.sleep(sleepSecs * 1000);
        }
        catch (Exception e) {
            logger.warning(e.getMessage());
        }
        RecycleSystem.stopGateways();
        RecycleSystem.startGateways();
        DistributedSystem disSys = CacheHelper.getCache().getDistributedSystem();
        Cache cache = CacheHelper.getCache();
        GemFireMemberStatus status = new GemFireMemberStatus(cache);
        logger.info("RecycleSystem::restartgatewayCache:Status = " + ((GatewayHubStatus)status.getGatewayHubStatus()).getGatewayStatuses()[0].getEndpointStatuses().length);
        logger.info("RecycleSystem::restartgatewayCache:Status = " + status.toString());
    }

    public static void printGatewayStatus() {
        DistributedSystem disSys = CacheHelper.getCache().getDistributedSystem();
        Cache cache = CacheHelper.getCache();
        GemFireMemberStatus status = new GemFireMemberStatus(cache);
        logger.info("RecycleSystem::restartgatewayCache:Status = " + status.toString());
        int sleepSecs = RecycleSystem.restart();
        try {
            Thread.sleep(sleepSecs * 1000);
        }
        catch (Exception e) {
            logger.warning(e.getMessage());
        }
    }

    public static void restartGatewayHubs() {
        int sleepSecs = RecycleSystem.restart();
        try {
            Thread.sleep(sleepSecs * 1000);
        }
        catch (Exception e) {
            logger.warning(e.getMessage());
        }
        RecycleSystem.startGatewayHub();
        sleepSecs = RecycleSystem.restart();
        try {
            Thread.sleep(sleepSecs * 1000);
        }
        catch (Exception e) {
            logger.warning(e.getMessage());
        }
        DistributedSystem disSys = CacheHelper.getCache().getDistributedSystem();
        Cache cache = CacheHelper.getCache();
        GemFireMemberStatus status = new GemFireMemberStatus(cache);
        if (status.getIsPrimaryGatewayHub()) {
            long num = RecycleSysBlackboard.getInstance().getSharedCounters().incrementAndRead(RecycleSysBlackboard.numOfPrimaryGateways);
            logger.info("RecycleSystem:startGatewayHub:: Started all Gateways & the Prim Hub.Current total=" + num);
        } else if (status.getIsSecondaryGatewayHub()) {
            long num = RecycleSysBlackboard.getInstance().getSharedCounters().incrementAndRead(RecycleSysBlackboard.numOfSecondaryGateways);
            logger.info("RecycleSystem:startGatewayHub:: Started all Gateways & the Seco Hub.Current total=" + num);
        } else {
            long num = RecycleSysBlackboard.getInstance().getSharedCounters().incrementAndRead(RecycleSysBlackboard.numOfGateways);
            logger.info("RecycleSystem:startGatewayHub:: Started all Gateways & the Hub.Current total=" + num);
        }
        RecycleSystem.stopGatewayHub();
        RecycleSystem.hardStop();
        logger.info("RecycleSystem::restartGatewayHubs:Status = " + status.toString());
    }

    public static void restartEdgeClient() {
        int sleepSecs = RecycleSystem.restart();
        try {
            Thread.sleep(sleepSecs * 1000);
        }
        catch (Exception exception) {
            // empty catch block
        }
        RecycleSystem.stopCacheEntities();
        RecycleSystem.hardStop();
        RecycleSystem.startEdgeClient();
    }

    public static void printResults() {
        logger.info("RecycleSystem:printResults");
        RecycleSysBlackboard.getInstance().printSharedCounters();
    }

    private static int restart() {
        int sleepSecs = conftab.intAt(RecyclePrms.sleepBetweenCycles, 120);
        if (executionCount == 0) {
            sleepSecs = 1;
            ++executionCount;
        }
        return sleepSecs;
    }

    protected static void startCache() {
        String cacheConfig = ConfigPrms.getCacheConfig();
        String regionConfig = ConfigPrms.getRegionConfig();
        Cache cache = CacheHelper.createCache(cacheConfig);
        int numRegs = conftab.intAt(RecyclePrms.numberOfRootRegions, 0);
        if (RecyclePrms.isRegionNamesDefined()) {
            RecycleSystem.createUserDefinedRegion(cache);
        } else {
            RecycleSystem.createRegion(regionConfig, cache, numRegs, false);
        }
        GemFireMemberStatus status = new GemFireMemberStatus(CacheHelper.getCache());
        RecycleSysBlackboard.getInstance().getSharedMap().put(status.getMemberId(), status);
    }

    public static void destroyAndCreateRegions() {
        int sleepSecs = RecycleSystem.restart();
        try {
            Thread.sleep(sleepSecs * 1000);
        }
        catch (Exception exception) {
            // empty catch block
        }
        String regionConfig = ConfigPrms.getRegionConfig();
        Cache cache = CacheFactory.getInstance((DistributedSystem)DistributedSystemHelper.getDistributedSystem());
        int numRegs = conftab.intAt(RecyclePrms.numberOfRootRegions, 0);
        logger.info("\n\tRecycleSystem:destroyAndCreateRegions:: No of root region of " + cache + " before destroying  " + cache.rootRegions().size() + ", no of root region desired : " + numRegs);
        int rootRegNo = cache.rootRegions().size();
        if (numRegs < rootRegNo) {
            RecycleSystem.destroyRegion(cache.rootRegions(), rootRegNo - numRegs);
            logger.info("\n\tRecycleSystem:destroyAndCreateRegions:: No of root region of " + cache + " after destroying  " + cache.rootRegions().size());
        } else if (numRegs > rootRegNo) {
            RecycleSystem.createRegion(regionConfig, cache, numRegs - rootRegNo, false);
            logger.info("\n\t RecycleSystem:destroyAndCreateRegions:: No of root region of " + cache + " after creating new region  " + cache.rootRegions().size());
        }
    }

    protected static void destroyRegion(Set regions, int noOfRegToBeDestroyed) {
        Object[] regionList = regions.toArray();
        int numRegs = regionList.length;
        Random generator = new Random();
        if (numRegs < 1) {
            return;
        }
        int temp = 0;
        for (int i = 0; i < noOfRegToBeDestroyed; ++i) {
            temp = generator.nextInt(numRegs);
            Region region = (Region)regionList[temp];
            if (region == null) {
                --i;
                continue;
            }
            Set keySet = region.keySet();
            Log.getLogWriter().info("Data in  " + region.toString() + ": -----");
            for (Object key : keySet) {
                Log.getLogWriter().info("Key :  " + key + "/ value:" + region.get(key));
            }
            region.destroyRegion();
            regionList[temp] = null;
        }
        logger.info("RecycleSystem:destroyRegion:: destroyed region :" + regionList[temp]);
    }

    protected static void createUserDefinedRegion(Cache cache) {
        HydraVector regionNames = TestConfig.tab().vecAt(RegionPrms.names, null);
        logger.info("RecycleSystem:createRegion:: Number of more Region to be created " + regionNames.size());
        for (int i = 0; i < regionNames.size(); ++i) {
            String regionDescriptName = (String)regionNames.get(i);
            Region aRegion = null;
            String regionName = RegionHelper.getRegionDescription(regionDescriptName).getRegionName();
            try {
                aRegion = cache.createRegion(regionName, RegionHelper.getRegionAttributes(regionDescriptName));
                Log.getLogWriter().info("Created  region " + regionName + " with region descript name " + regionDescriptName);
                RecycleSystem.populateRegion(aRegion);
                continue;
            }
            catch (RegionExistsException e) {
                Log.getLogWriter().info("Using existing  region " + regionName);
                aRegion = e.getRegion();
                if (aRegion != null) continue;
                throw new TestException("RegionExistsException.getRegion returned null");
            }
        }
    }

    protected static void createRegion(String regionConfig, Cache cache, int noOfRegToBeCreated, boolean registerInterest) {
        logger.info("RecycleSystem:createRegion:: Number of more Region to be created " + noOfRegToBeCreated);
        String regInfo = "\n\t";
        for (int i = 0; i < noOfRegToBeCreated; ++i) {
            AttributesFactory factory = RegionHelper.getAttributesFactory(regionConfig);
            RegionAttributes attributes = RegionHelper.getRegionAttributes(factory);
            regInfo = "\n\t";
            String name = "GlobalVillage_" + absoluteRegionCount;
            ++absoluteRegionCount;
            Region reg = RegionHelper.createRegion(name, attributes);
            if (registerInterest) {
                RecycleSystem.registerInterest(reg);
            }
            RecycleSystem.populateRegion(reg);
            regInfo = regInfo + reg.getFullPath() + "\n\t";
            int subRegs = conftab.intAt(RecyclePrms.regionDepth, 0);
            for (int j = 0; j < subRegs; ++j) {
                reg = reg.createSubregion(reg.getName() + "_" + j, attributes);
                if (registerInterest) {
                    RecycleSystem.registerInterest(reg);
                }
                RecycleSystem.populateRegion(reg);
                regInfo = regInfo + reg.getFullPath() + "\n\t";
            }
        }
        logger.info("RecycleSystem:createRegion:: Region Created " + regInfo);
    }

    private static void registerInterest(Region region) {
        InterestResultPolicy interestResultPolicy = RecyclePrms.getInterestResultPolicy();
        region.registerInterest((Object)"ALL_KEYS", interestResultPolicy);
        Log.getLogWriter().info("Initialized region " + region + "\nRegistered interest in ALL_KEYS with InterestResultPolicy = " + interestResultPolicy);
    }

    private static void populateRegion(Region region) {
        boolean isPartitionRegion = false;
        if (region.getAttributes().getDataPolicy().equals(DataPolicy.PARTITION)) {
            isPartitionRegion = true;
        }
        int noOfEntity = conftab.intAt(RecyclePrms.numberOfEntitiesInRegion, 0);
        Random generator = new Random();
        for (int i = 0; i < noOfEntity; ++i) {
            String key = String.valueOf(i);
            Integer value = new Integer(generator.nextInt(200));
            if (isPartitionRegion) {
                key = NameFactory.getNextPositiveObjectName();
            }
            region.put((Object)key, (Object)value);
            Log.getLogWriter().info("Putting key :" + key + " in region :" + region.getFullPath());
        }
        Log.getLogWriter().info("region info : " + region.toString() + " data size:" + region.entrySet().size());
    }

    public static void setSystemReady() {
        SharedMap map = RecycleSysBlackboard.getInstance().getSharedMap();
        map.put("system ready", "true");
    }

    static {
        conftab = TestConfig.tab();
        logger = Log.getLogWriter();
        rand = new GsRandom();
        executionCount = 0;
    }

    public class EdgeWriter
    implements CacheWriter {
        public void beforeCreate(EntryEvent arg0) throws CacheWriterException {
            logger.info("EdgeWriter::beforeCreate");
        }

        public void beforeDestroy(EntryEvent arg0) throws CacheWriterException {
            logger.info("EdgeWriter::beforeDestroy");
        }

        public void beforeRegionClear(RegionEvent arg0) throws CacheWriterException {
            logger.info("EdgeWriter::beforeRegionClear");
        }

        public void beforeRegionDestroy(RegionEvent arg0) throws CacheWriterException {
            logger.info("EdgeWriter::beforeRegionDestroy");
        }

        public void beforeUpdate(EntryEvent arg0) throws CacheWriterException {
            logger.info("EdgeWriter::beforeUpdate");
        }

        public void close() {
            logger.info("EdgeWriter::close");
        }
    }

    public class EdgeCacheListener
    extends CacheListenerAdapter {
        public void afterRegionCreate(RegionEvent event) {
            logger.info("Executing EdgeCacheListener:afterRegionCreate::Notification Received");
        }
    }
}

