/*
 * Decompiled with CFR 0.152.
 */
package asyncMsg;

import asyncMsg.AsyncMsgBB;
import com.gemstone.gemfire.admin.Alert;
import com.gemstone.gemfire.admin.AlertListener;
import com.gemstone.gemfire.admin.OperationCancelledException;
import hydra.Log;
import hydra.MasterController;
import hydra.ProcessMgr;
import hydra.RemoteTestModule;
import util.TestException;
import util.TestHelper;

public class AdminListener
implements AlertListener {
    private static Alert slowReceiverAlert = null;

    public void alert(Alert alert) {
        try {
            String alertStr = this.getAlertString(alert);
            Log.getLogWriter().info(alertStr);
            AdminListener.lookForSlowReceiverAlert(alert, alertStr);
        }
        catch (Exception e) {
            String errStr = "Error occurred in vm_" + RemoteTestModule.getMyVmid() + " " + TestHelper.getStackTrace(e);
            Log.getLogWriter().info(errStr);
            AsyncMsgBB.getBB().getSharedMap().put("Error", errStr);
        }
    }

    protected String getAlertString(Alert alert) {
        int myPID = ProcessMgr.getProcessId();
        StringBuffer aStr = new StringBuffer();
        aStr.append("Invoked " + this.getClass().getName() + " in client with vmID " + RemoteTestModule.getMyVmid() + ", pid " + myPID + "\n");
        aStr.append("   alert.getConnectionName(): " + alert.getConnectionName() + "\n");
        aStr.append("   alert.getDate(): " + alert.getDate() + "\n");
        aStr.append("   alert.getLevel(): " + alert.getLevel() + "\n");
        aStr.append("   alert.getMessage(): " + alert.getMessage() + "\n");
        aStr.append("   alert.getSourceId(): " + alert.getSourceId() + "\n");
        try {
            aStr.append("   alert.getSystemMember(): " + alert.getSystemMember());
        }
        catch (OperationCancelledException e) {
            String errStr = "Bug 39657; Error occurred in vm_" + RemoteTestModule.getMyVmid() + " " + TestHelper.getStackTrace(e);
            Log.getLogWriter().info(errStr);
            AsyncMsgBB.getBB().getSharedMap().put("Error", errStr);
            aStr.append(errStr);
        }
        return aStr.toString();
    }

    private static synchronized void lookForSlowReceiverAlert(Alert alert, String alertStr) {
        String msg;
        if (slowReceiverAlert == null && (msg = alert.getMessage()).indexOf("asking slow receiver") >= 0) {
            slowReceiverAlert = alert;
            AsyncMsgBB.getBB().getSharedMap().put("SlowReceiverKey", alertStr);
            Log.getLogWriter().info("Admin VM has recognized slow receiver alert " + alertStr + " and written this alert to the AsyncMsgBB blackboard");
        }
    }

    public static void waitForSlowReceiverAlert(int secondsToWait) {
        Log.getLogWriter().info("Waiting to recognize a slow receiver alert...");
        long start = System.currentTimeMillis();
        long millisToWait = secondsToWait * 1000;
        while (System.currentTimeMillis() - start < millisToWait) {
            String alertStr = (String)AsyncMsgBB.getBB().getSharedMap().get("SlowReceiverKey");
            if (alertStr != null) {
                return;
            }
            MasterController.sleepForMs(1000);
        }
        throw new TestException("Did not find a slow receiver alert in " + secondsToWait + " seconds");
    }

    public static boolean slowReceiverAlertOccurred() {
        Object anObj = AsyncMsgBB.getBB().getSharedMap().get("SlowReceiverKey");
        return anObj != null;
    }
}

