/*
 * Decompiled with CFR 0.152.
 */
package asyncMsg;

import asyncMsg.AdminListener;
import asyncMsg.AsyncMsgBB;
import asyncMsg.AsyncMsgPrms;
import asyncMsg.BurstListener;
import asyncMsg.Loader;
import com.gemstone.gemfire.CancelException;
import com.gemstone.gemfire.CopyHelper;
import com.gemstone.gemfire.ForcedDisconnectException;
import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.CacheLoader;
import com.gemstone.gemfire.cache.CacheLoaderException;
import com.gemstone.gemfire.cache.CacheRuntimeException;
import com.gemstone.gemfire.cache.CacheWriter;
import com.gemstone.gemfire.cache.CacheWriterException;
import com.gemstone.gemfire.cache.EntryExistsException;
import com.gemstone.gemfire.cache.EntryNotFoundException;
import com.gemstone.gemfire.cache.MirrorType;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.RegionDestroyedException;
import com.gemstone.gemfire.cache.RegionExistsException;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.TimeoutException;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.DistributedSystemDisconnectedException;
import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.distributed.internal.DMStats;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import diskReg.DiskRegUtil;
import getInitialImage.InitImageTest;
import hydra.DistributedConnectionMgr;
import hydra.DistributedSystemHelper;
import hydra.GsRandom;
import hydra.HydraRuntimeException;
import hydra.HydraVector;
import hydra.Log;
import hydra.Prms;
import hydra.RemoteTestModule;
import hydra.SchedulingOrder;
import hydra.StopSchedulingOrder;
import hydra.TestConfig;
import hydra.blackboard.SharedCounters;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.Vector;
import objects.ObjectHelper;
import tx.EntryValidator;
import tx.OpList;
import tx.Operation;
import tx.RegionValidator;
import util.BaseValueHolder;
import util.CacheUtil;
import util.NameBB;
import util.NameFactory;
import util.RandomValues;
import util.RegionDefPrms;
import util.RegionDefinition;
import util.TestException;
import util.TestHelper;
import util.TestHelperPrms;
import util.ValueHolder;

public class AsyncMsgTest {
    protected static AsyncMsgTest asyncTest = null;
    static GsRandom randGen = TestConfig.tab().getRandGen();
    public RandomValues randomValues = null;
    protected int maxKeys;
    int modValInitializer = 0;
    boolean isSerialExecution;
    boolean verifyConflationBehavior;
    protected int concurrentLeaderTid;
    protected int numPeerThreadsInTest;
    public static final String SLEEP_KEY = "SleepKey";
    public static final String DIST_ACK_REGION = "distAckRegion";
    public static final int NO_MIRRORING_RESTRICTION = 0;
    public static final int NO_MIRRORING = 1;
    public static final int NO_MIRRORING_KV = 2;
    public static final String REGION_NAME = "AsyncRegion";
    public static int numUpdatesThisRound = 0;
    public static int EQUAL = 1;
    public static int EQUIVALENT = 2;

    public static void createLocatorTask() {
        DistributedSystemHelper.createLocator();
    }

    public static void startLocatorAndAdminDSTask() {
        DistributedSystemHelper.startLocatorAndAdminDS();
    }

    public static void HydraTask_initialize() {
        Log.getLogWriter().info("In HydraTask_initialize");
        if (asyncTest == null) {
            asyncTest = new AsyncMsgTest();
            asyncTest.initialize();
        }
    }

    public void initialize() {
        this.randomValues = new RandomValues();
        this.isSerialExecution = TestConfig.tab().booleanAt(Prms.serialExecution);
        this.verifyConflationBehavior = TestConfig.tab().booleanAt(AsyncMsgPrms.verifyConflationBehavior, false);
        this.numPeerThreadsInTest = TestHelper.getNumThreads() - 1;
    }

    public static synchronized void HydraTask_createRegionForest() {
        Cache c = CacheUtil.createCache();
        if (asyncTest == null) {
            asyncTest = new AsyncMsgTest();
            asyncTest.initialize();
            asyncTest.createRegionHierarchy();
            AsyncMsgTest.createDistAckRegion();
        }
        asyncTest.summarizeRegionHier();
    }

    public static void HydraTask_doOperationsWithPrimedQueue() {
        Log.getLogWriter().info("In HydraTask_doOperationsWithPrimedQueue");
        if (asyncTest == null) {
            asyncTest = new AsyncMsgTest();
            asyncTest.initialize();
        }
        asyncTest.primeQueue();
        asyncTest.doOperations();
    }

    public static void HydraTask_doUpdatesWithPrimedQueue() {
        Log.getLogWriter().info("In HydraTask_doUpdatesWithPrimedQueue");
        if (asyncTest == null) {
            asyncTest = new AsyncMsgTest();
            asyncTest.initialize();
        }
        Region aRegion = asyncTest.primeQueue();
        asyncTest.doUpdates(aRegion);
    }

    public static void HydraTask_doOperations() {
        Log.getLogWriter().info("In HydraTask_doOperations");
        if (asyncTest == null) {
            asyncTest = new AsyncMsgTest();
            asyncTest.initialize();
        }
        try {
            asyncTest.doOperations();
        }
        catch (Exception e) {
            AsyncMsgTest.handlePossibleSlowReceiverException(e);
        }
    }

    public static synchronized void HydraTask_checkForConflation() {
        Log.getLogWriter().info("In HydraTask_checkForConflation");
        if (asyncTest == null) {
            asyncTest = new AsyncMsgTest();
            asyncTest.initialize();
        }
        asyncTest.checkForConflation();
    }

    private void checkForConflation() {
        if (!this.queuedMessagesConflated()) {
            throw new TestException("TuningRequired: AsyncConflatedMsgs is 0");
        }
    }

    public static synchronized void HydraTask_initProducer() {
        if (asyncTest == null) {
            asyncTest = new AsyncMsgTest();
            asyncTest.initialize();
            RegionDefinition regDef = RegionDefinition.createRegionDefinition(RegionDefPrms.regionSpecs, "producer");
            regDef.createRootRegion(CacheUtil.createCache(), REGION_NAME, null, new Loader(), null);
            AsyncMsgTest.createDistAckRegion();
        }
    }

    public static synchronized void HydraTask_initConsumer() {
        if (asyncTest == null) {
            asyncTest = new AsyncMsgTest();
            asyncTest.initialize();
            RegionDefinition regDef = RegionDefinition.createRegionDefinition(RegionDefPrms.regionSpecs, "consumer");
            regDef.createRootRegion(CacheUtil.createCache(), REGION_NAME, new BurstListener(), null, null);
            AsyncMsgTest.createDistAckRegion();
        }
    }

    public static synchronized void HydraTask_initProducerConsumer() {
        if (asyncTest == null) {
            asyncTest = new AsyncMsgTest();
            asyncTest.initialize();
            RegionDefinition regDef = RegionDefinition.createRegionDefinition(RegionDefPrms.regionSpecs, "producerConsumer");
            regDef.createRootRegion(CacheUtil.createCache(), REGION_NAME, new BurstListener(), new Loader(), null);
            asyncTest.createDistAckRegion();
        }
    }

    public static void HydraTask_doProducer() {
        try {
            asyncTest.doProducer();
        }
        catch (SchedulingOrder e) {
            throw e;
        }
        catch (Exception e) {
            AsyncMsgTest.handlePossibleSlowReceiverException(e);
        }
    }

    public static void HydraTask_doConsumer() {
        try {
            asyncTest.doConsumer();
        }
        catch (SchedulingOrder e) {
            throw e;
        }
        catch (Exception e) {
            AsyncMsgTest.handlePossibleSlowReceiverException(e);
        }
    }

    public static void HydraTask_doControlledOperations() {
        try {
            asyncTest.doControlledOperations();
            AsyncMsgTest.waitForEventsByPut();
        }
        catch (Exception e) {
            AsyncMsgTest.handlePossibleSlowReceiverException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void HydraTask_verifyQueuedMessages() {
        Class<AsyncMsgTest> clazz = AsyncMsgTest.class;
        synchronized (AsyncMsgTest.class) {
            if (asyncTest == null) {
                asyncTest = new AsyncMsgTest();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            try {
                asyncTest.verifyQueuedMessages();
            }
            catch (Exception e) {
                AsyncMsgTest.handlePossibleSlowReceiverException(e);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void HydraTask_verifyNoAsyncBufferWrites() {
        Class<AsyncMsgTest> clazz = AsyncMsgTest.class;
        synchronized (AsyncMsgTest.class) {
            if (asyncTest == null) {
                asyncTest = new AsyncMsgTest();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            asyncTest.verifyNoAsyncBufferWrites();
            return;
        }
    }

    public static synchronized void HydraTask_createDistAckRegion() {
        try {
            CacheUtil.createCache();
            Region distAckRegion = CacheUtil.getRegion(DIST_ACK_REGION);
            if (distAckRegion == null) {
                AsyncMsgTest.createDistAckRegion();
            }
        }
        catch (Exception e) {
            AsyncMsgTest.handlePossibleSlowReceiverException(e);
        }
    }

    public static void HydraTask_waitForEventsByPut() {
        try {
            AsyncMsgTest.waitForEventsByPut();
        }
        catch (Exception e) {
            AsyncMsgTest.handlePossibleSlowReceiverException(e);
        }
    }

    public static void HydraTask_verifyNonBlocking() {
        if (AsyncMsgBB.getBB().getSharedMap().containsKey("SlowReceiverDetectedKey")) {
            Log.getLogWriter().info("Returning because a slow receiver forced disconnect has been detected");
            return;
        }
        InitImageTest.HydraTask_verifyNonBlocking();
    }

    public static void HydraTask_verifyEventCounters() {
        if (AsyncMsgBB.getBB().getSharedMap().containsKey("SlowReceiverDetectedKey")) {
            Log.getLogWriter().info("Returning because a slow receiver forced disconnect has been detected");
            return;
        }
        InitImageTest.HydraTask_verifyEventCounters();
    }

    public static void HydraTask_asyncMsgVerifyRegionContents() {
        if (AsyncMsgBB.getBB().getSharedMap().containsKey("SlowReceiverDetectedKey")) {
            Log.getLogWriter().info("Returning because a slow receiver forced disconnect has been detected");
            return;
        }
        InitImageTest.HydraTask_verifyRegionContents();
    }

    public static void logExecutionNumber() {
        long exeNum = AsyncMsgBB.getBB().getSharedCounters().incrementAndRead(AsyncMsgBB.ExecutionNumber);
        Log.getLogWriter().info("Beginning task with execution number " + exeNum);
    }

    public static void createDistAckRegion() {
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.DISTRIBUTED_ACK);
        factory.setMirrorType(MirrorType.KEYS_VALUES);
        RegionAttributes ratts = factory.createRegionAttributes();
        Region distAckRegion = CacheUtil.createRegion(DIST_ACK_REGION, ratts);
        Log.getLogWriter().info("Created Region " + TestHelper.regionToString(distAckRegion, true));
    }

    public void createRegionHierarchy() {
        CacheListener aListener = AsyncMsgPrms.getCacheListener();
        CacheLoader aLoader = this.getCacheLoader();
        CacheWriter cacheWriter = this.getCacheWriter();
        int numRoots = TestConfig.tab().intAt(AsyncMsgPrms.numRootRegions);
        int breadth = TestConfig.tab().intAt(AsyncMsgPrms.numSubRegions);
        int depth = TestConfig.tab().intAt(AsyncMsgPrms.regionDepth);
        Cache c = CacheUtil.createCache();
        Vector roots = new Vector();
        Object r = null;
        for (int i = 0; i < numRoots; ++i) {
            String rootName = "root" + (i + 1);
            RegionDefinition regDef = RegionDefinition.createRegionDefinition();
            Region rootRegion = regDef.createRootRegion(c, rootName, aListener, aLoader, cacheWriter);
            Log.getLogWriter().info("Created root region " + rootName);
            this.recordRegionDefInBB(rootRegion.getFullPath(), regDef);
            this.createEntries(rootRegion);
            this.createSubRegions(rootRegion, breadth, depth, "Region");
        }
    }

    private void createSubRegions(Region r, int numChildren, int levelsLeft, String parentName) {
        CacheListener aListener = AsyncMsgPrms.getCacheListener();
        CacheLoader aLoader = this.getCacheLoader();
        CacheWriter cacheWriter = this.getCacheWriter();
        boolean randomlyEnableAsyncConflation = TestConfig.tab().booleanAt(AsyncMsgPrms.randomEnableAsyncConflation, false);
        for (int i = 1; i <= numChildren; ++i) {
            String currentName = parentName + "-" + i;
            Region child = null;
            try {
                RegionDefinition regDef = RegionDefinition.createRegionDefinition();
                if (randomlyEnableAsyncConflation) {
                    int randInt = randGen.nextInt(0, 100);
                    boolean enableAsyncConflation = randInt < 50;
                    regDef.setAsyncConflation(true);
                }
                RegionAttributes regionAttrs = regDef.getRegionAttributes(aListener, aLoader, cacheWriter);
                child = r.createSubregion(currentName, regionAttrs);
                Log.getLogWriter().info("Created subregion " + TestHelper.regionToString(child, true));
                this.recordRegionDefInBB(child.getFullPath(), regDef);
            }
            catch (RegionExistsException e) {
                child = r.getSubregion(currentName);
                Log.getLogWriter().info("Got subregion " + TestHelper.regionToString(child, true));
            }
            catch (TimeoutException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            this.createEntries(child);
            if (levelsLeft <= 1) continue;
            this.createSubRegions(child, numChildren, levelsLeft - 1, currentName);
        }
    }

    private void createEntries(Region aRegion) {
        this.maxKeys = TestConfig.tab().intAt(AsyncMsgPrms.maxKeys, 10);
        long startKey = 0L;
        for (int i = 0; i < this.maxKeys; ++i) {
            String key = NameFactory.getObjectNameForCounter(startKey + (long)i);
            NameBB.getBB().getSharedCounters().setIfLarger(NameBB.POSITIVE_NAME_COUNTER, startKey + (long)i);
            ValueHolder val = new ValueHolder((Object)key, this.randomValues, new Integer(this.modValInitializer));
            ++this.modValInitializer;
            try {
                aRegion.create((Object)key, (Object)val);
            }
            catch (RegionDestroyedException e) {
                if (this.isSerialExecution) {
                    throw e;
                }
                Log.getLogWriter().info("Created " + i + " keys in " + aRegion.getFullPath() + " before getting " + (Object)((Object)e) + "; continuing test");
                break;
            }
            catch (EntryExistsException e) {
                Log.getLogWriter().fine("Created via distribution in region <" + aRegion.getFullPath() + "> " + key + " = " + ((Object)val).toString());
                continue;
            }
            catch (CacheRuntimeException ce) {
                throw new TestException("Cannot create key " + key + " CacheException(" + (Object)((Object)ce) + ")");
            }
            Log.getLogWriter().fine("Created in region <" + aRegion.getFullPath() + "> " + key + " = " + ((Object)val).toString());
        }
    }

    public Region getRandomRegion(boolean allowRootRegion) {
        return this.getRandomRegion(allowRootRegion, CacheUtil.getCache().getRegion(DIST_ACK_REGION), 0);
    }

    public Region getRandomRegionNoMirroring(boolean allowRootRegion) {
        return this.getRandomRegion(allowRootRegion, CacheUtil.getCache().getRegion(DIST_ACK_REGION), 1);
    }

    public Region getRandomRegionNoMirroringKV(boolean allowRootRegion) {
        return this.getRandomRegion(allowRootRegion, CacheUtil.getCache().getRegion(DIST_ACK_REGION), 2);
    }

    public Region getRandomRegion(boolean allowRootRegion, Region excludeRegion, int restriction) {
        int i;
        Object[] rootRegionArr = CacheUtil.getCache().rootRegions().toArray();
        if (rootRegionArr.length == 0) {
            return null;
        }
        ArrayList<Object> regionList = new ArrayList<Object>();
        if (allowRootRegion) {
            for (i = 0; i < rootRegionArr.length; ++i) {
                regionList.add(rootRegionArr[i]);
            }
        }
        for (i = 0; i < rootRegionArr.length; ++i) {
            Region rootRegion = (Region)rootRegionArr[i];
            Object[] regionArr = this.getSubregions(rootRegion, true).toArray();
            for (int j = 0; j < regionArr.length; ++j) {
                regionList.add(regionArr[j]);
            }
        }
        if (regionList.size() == 0) {
            return null;
        }
        int randInt = TestConfig.tab().getRandGen().nextInt(0, regionList.size() - 1);
        Region aRegion = (Region)regionList.get(randInt);
        if (restriction != 0 || excludeRegion != null) {
            boolean done;
            int startIndex = randInt;
            do {
                done = true;
                try {
                    if (restriction == 1) {
                        done = !this.isHierMirrored(aRegion);
                    } else if (restriction == 2) {
                        boolean bl = done = !this.isHierMirroredKV(aRegion);
                    }
                    if (excludeRegion != null && aRegion.getFullPath().equals(excludeRegion.getFullPath())) {
                        done = false;
                    }
                }
                catch (RegionDestroyedException e) {
                    done = false;
                }
                if (done) break;
                if (++randInt == regionList.size()) {
                    randInt = 0;
                }
                if (randInt == startIndex) {
                    return null;
                }
                aRegion = (Region)regionList.get(randInt);
            } while (!done);
        }
        return aRegion;
    }

    public void dispAllKeys() {
        Cache c = CacheUtil.getCache();
        Set roots = c.rootRegions();
        for (Region aRegion : roots) {
            Set subRegions = this.getSubregions(aRegion, true);
            for (Region sRegion : subRegions) {
                Set keys = sRegion.keys();
                for (String key : keys) {
                    BaseValueHolder value = null;
                    try {
                        value = (BaseValueHolder)sRegion.get((Object)key);
                    }
                    catch (Exception e) {
                        throw new HydraRuntimeException("Error in get(key)", e);
                    }
                    if (value != null) {
                        Log.getLogWriter().info("Key(" + key + ") = {" + value.getMyValue() + ", " + value.getModVal() + "}");
                        continue;
                    }
                    throw new HydraRuntimeException("Key(" + key + ") has value null");
                }
            }
        }
    }

    public void summarizeRegionHier() {
        StringBuffer aStr = new StringBuffer();
        Cache c = CacheUtil.getCache();
        Set roots = c.rootRegions();
        if (roots.size() == 0) {
            Log.getLogWriter().info("No region roots");
            return;
        }
        for (Region root : roots) {
            aStr.append(root.getFullPath() + " (" + root.getAttributes().getScope() + "): " + root.keys().size() + " keys\n");
            class RegionComparator
            implements Comparator {
                RegionComparator() {
                }

                public int compare(Object o1, Object o2) {
                    return ((Region)o1).getFullPath().compareTo(((Region)o2).getFullPath());
                }

                @Override
                public boolean equals(Object anObj) {
                    return ((Region)this).getFullPath().equals(((Region)anObj).getFullPath());
                }
            }
            TreeSet aSet = new TreeSet(new RegionComparator());
            aSet.addAll(this.getSubregions(root, true));
            for (Region aRegion : aSet) {
                String regionName = aRegion.getFullPath();
                try {
                    TreeSet keySet = new TreeSet(aRegion.keys());
                    aStr.append("   " + regionName + " (" + aRegion.getAttributes().getScope() + "): " + keySet.size() + " keys\n");
                    if (keySet.size() <= 0) continue;
                    Iterator keyIt = keySet.iterator();
                    aStr.append("      ");
                    while (keyIt.hasNext()) {
                        aStr.append(keyIt.next() + " ");
                    }
                    aStr.append("\n");
                }
                catch (RegionDestroyedException e) {
                    aStr.append("   " + regionName + " is destroyed\n");
                }
            }
        }
        Log.getLogWriter().info(aStr.toString());
    }

    public void doUpdates(Region aRegion) {
        int numOps = TestConfig.tab().intAt(AsyncMsgPrms.numOps);
        SharedCounters sc = AsyncMsgBB.getBB().getSharedCounters();
        sc.zero(AsyncMsgBB.OPLIST_READY_FOR_VALIDATION);
        AsyncMsgBB.getBB().getSharedMap().put(AsyncMsgBB.conflationEnabled, new Boolean(aRegion.getAttributes().getEnableAsyncConflation()));
        Log.getLogWriter().info("enableAsyncConflation for region " + aRegion.getFullPath() + " = " + aRegion.getAttributes().getEnableAsyncConflation());
        AsyncMsgTest.logExecutionNumber();
        OpList opList = new OpList();
        Object key = this.getRandomKey(aRegion);
        for (int i = 0; i < numOps; ++i) {
            Operation op = null;
            op = this.updateEntry(aRegion, key);
            if (op == null) continue;
            opList.add(op);
        }
        AsyncMsgBB.getBB().getSharedMap().put(AsyncMsgBB.OpListKey, opList);
        Log.getLogWriter().info(" OpList written to BB with key = " + AsyncMsgBB.OpListKey + " OpList = " + opList);
        if (this.isSerialExecution) {
            AsyncMsgTest.waitForEventsByPut();
        }
        sc.increment(AsyncMsgBB.OPLIST_READY_FOR_VALIDATION);
        Log.getLogWriter().info(" asyncMessagesQueued = " + this.messagesQueued());
        Log.getLogWriter().info(" queuedMessagesConflated = " + this.queuedMessagesConflated());
    }

    public OpList doOperations() {
        HydraVector operations = TestConfig.tab().vecAt(AsyncMsgPrms.operations);
        int numOps = TestConfig.tab().intAt(AsyncMsgPrms.numOps);
        SharedCounters sc = AsyncMsgBB.getBB().getSharedCounters();
        sc.zero(AsyncMsgBB.OPLIST_READY_FOR_VALIDATION);
        AsyncMsgTest.logExecutionNumber();
        OpList opList = this.doOperations(operations, numOps);
        AsyncMsgBB.getBB().getSharedMap().put(AsyncMsgBB.OpListKey, opList);
        Log.getLogWriter().info(" OpList written to BB with key = " + AsyncMsgBB.OpListKey + " OpList = " + opList);
        if (this.isSerialExecution) {
            AsyncMsgTest.waitForEventsByPut();
        }
        sc.increment(AsyncMsgBB.OPLIST_READY_FOR_VALIDATION);
        Log.getLogWriter().info(" asyncMessagesQueued = " + this.messagesQueued());
        Log.getLogWriter().info(" queuedMessagesConflated = " + this.queuedMessagesConflated());
        return opList;
    }

    public OpList doOperations(Vector operations, int numOperationsToDo) {
        Log.getLogWriter().info("Executing " + numOperationsToDo + " random operations...");
        long TIME_LIMIT_MS = 60000L;
        long timeOfLastOp = System.currentTimeMillis();
        OpList opList = new OpList();
        int numOpsCompleted = 0;
        while (numOpsCompleted < numOperationsToDo) {
            Region aRegion;
            Object[] rootRegionArr;
            Operation op = null;
            String operation = (String)operations.get(TestConfig.tab().getRandGen().nextInt(0, operations.size() - 1));
            if (!operation.equals("cache-close") && !operation.equals("region-create") && ((rootRegionArr = CacheUtil.getCache().rootRegions().toArray()).length == 0 || rootRegionArr.length == 1 && ((Region)rootRegionArr[0]).getName().equals(DIST_ACK_REGION))) {
                if (operations.indexOf("region-create") < 0) {
                    throw new TestException("No regions are available and no create region operation is specified");
                }
                Log.getLogWriter().info("In doOperations, forcing region create because no regions are present");
                operation = "region-create";
            }
            Log.getLogWriter().info("Operation is " + operation);
            if (operation.equalsIgnoreCase("entry-create")) {
                op = this.createEntry(this.getRandomRegion(true));
            } else if (operation.equalsIgnoreCase("entry-update")) {
                aRegion = this.getRandomRegion(true);
                op = this.updateEntry(aRegion, this.getRandomKey(aRegion));
            } else if (operation.equalsIgnoreCase("entry-destroy")) {
                aRegion = this.getRandomRegion(true);
                op = this.destroyEntry(false, aRegion, this.getRandomKey(aRegion));
            } else if (operation.equalsIgnoreCase("entry-localDestroy")) {
                aRegion = this.getRandomRegionNoMirroring(true);
                if (aRegion != null) {
                    op = this.destroyEntry(true, aRegion, this.getRandomKey(aRegion));
                }
            } else if (operation.equalsIgnoreCase("entry-inval")) {
                aRegion = this.getRandomRegion(true);
                op = this.invalEntry(false, aRegion, this.getRandomKey(aRegion));
            } else if (operation.equalsIgnoreCase("entry-localInval")) {
                aRegion = this.getRandomRegionNoMirroringKV(true);
                if (aRegion != null) {
                    op = this.invalEntry(true, aRegion, this.getRandomKey(aRegion));
                }
            } else if (operation.equalsIgnoreCase("entry-getWithNewKey")) {
                aRegion = this.getRandomRegion(true);
                op = this.getEntryWithNewKey(aRegion);
            } else if (operation.equalsIgnoreCase("entry-getWithExistingKey")) {
                aRegion = this.getRandomRegion(true);
                op = this.getEntryWithExistingKey(aRegion);
            } else if (operation.equalsIgnoreCase("entry-getWithPreviousKey")) {
                aRegion = this.getRandomRegion(true);
                op = this.getEntryWithPreviousKey(aRegion);
            } else if (operation.equalsIgnoreCase("region-create")) {
                op = this.createRegion();
            } else if (operation.equalsIgnoreCase("region-destroy")) {
                op = this.destroyRegion(false, this.getRandomRegion(true));
            } else if (operation.equalsIgnoreCase("region-localDestroy")) {
                aRegion = this.getRandomRegionNoMirroring(true);
                if (aRegion != null) {
                    op = this.destroyRegion(true, aRegion);
                }
            } else if (operation.equalsIgnoreCase("region-inval")) {
                aRegion = this.getRandomRegion(true);
                op = this.invalRegion(false, this.getRandomRegion(true));
            } else if (operation.equalsIgnoreCase("region-localInval")) {
                aRegion = this.getRandomRegionNoMirroringKV(true);
                if (aRegion != null) {
                    op = this.invalRegion(true, aRegion);
                }
            } else if (operation.equalsIgnoreCase("cache-close")) {
                op = this.closeCache();
            } else {
                throw new TestException("Unknown operation " + operation);
            }
            if (op == null) {
                if (System.currentTimeMillis() - timeOfLastOp <= 60000L) continue;
                throw new TestException("Could not execute a successful operation in 60000 millis; possible test config problem");
            }
            opList.add(op);
            ++numOpsCompleted;
            timeOfLastOp = System.currentTimeMillis();
        }
        return opList;
    }

    public Operation createEntry(Region aRegion) {
        String key = NameFactory.getNextPositiveObjectName();
        BaseValueHolder vh = this.getNewValue(key);
        try {
            Log.getLogWriter().info("createEntry: putting key " + key + ", object " + vh.toString() + " in region " + aRegion.getFullPath());
            aRegion.put((Object)key, (Object)vh);
            Log.getLogWriter().info("createEntry: done putting key " + key + ", object " + vh.toString() + " in region " + aRegion.getFullPath());
        }
        catch (RegionDestroyedException e) {
            if (this.isSerialExecution) {
                throw e;
            }
            return null;
        }
        return new Operation(aRegion.getFullPath(), key, "entry-create", null, vh.modVal);
    }

    public Operation updateEntry(Region aRegion, Object key) {
        if (key == null) {
            Log.getLogWriter().info("Could not update a key in " + aRegion.getFullPath() + " because no keys are available");
            return null;
        }
        BaseValueHolder vh = null;
        Log.getLogWriter().info("updateEntry: Getting value to prepare for update for key " + key + " in region " + aRegion.getFullPath());
        Object oldValue = DiskRegUtil.getValueInVM(aRegion, key);
        if (oldValue instanceof BaseValueHolder) {
            vh = (BaseValueHolder)oldValue;
            oldValue = ((BaseValueHolder)oldValue).modVal;
        } else {
            vh = this.getNewValue(key);
        }
        Log.getLogWriter().info("updateEntry: Value to update is " + vh + " for key " + key + " in region " + aRegion.getFullPath());
        vh = (BaseValueHolder)CopyHelper.copy((Object)vh);
        vh.modVal = new Integer(vh.modVal + 1);
        try {
            Log.getLogWriter().info("updateEntry: Putting new value " + vh + " for key " + key + " in region " + aRegion.getFullPath());
            aRegion.put(key, (Object)vh);
            Log.getLogWriter().info("updateEntry: Done putting new value " + vh + " for key " + key + " in region " + aRegion.getFullPath());
        }
        catch (RegionDestroyedException e) {
            if (this.isSerialExecution) {
                throw e;
            }
            return null;
        }
        return new Operation(aRegion.getFullPath(), key, "entry-update", oldValue, vh.modVal);
    }

    public Operation destroyEntry(boolean isLocalDestroy, Region aRegion, Object key) {
        if (key == null) {
            Log.getLogWriter().info("Could not destroy an entry in " + aRegion.getFullPath() + " because no keys are available");
            return null;
        }
        try {
            Object oldValue = DiskRegUtil.getValueInVM(aRegion, key);
            if (oldValue instanceof BaseValueHolder) {
                oldValue = ((BaseValueHolder)oldValue).modVal;
            }
            if (isLocalDestroy) {
                Log.getLogWriter().info("destroyEntry: locally destroying key " + key + " in region " + aRegion.getFullPath());
                aRegion.localDestroy(key);
                Log.getLogWriter().info("destroyEntry: done locally destroying key " + key + " in region " + aRegion.getFullPath());
                return new Operation(aRegion.getFullPath(), key, "entry-localDestroy", oldValue, null);
            }
            Log.getLogWriter().info("destroyEntry: destroying key " + key + " in region " + aRegion.getFullPath());
            aRegion.destroy(key);
            Log.getLogWriter().info("destroyEntry: done destroying key " + key + " in region " + aRegion.getFullPath());
            return new Operation(aRegion.getFullPath(), key, "entry-destroy", oldValue, null);
        }
        catch (RegionDestroyedException e) {
            if (this.isSerialExecution) {
                throw e;
            }
            return null;
        }
        catch (TimeoutException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (EntryNotFoundException e) {
            if (this.isSerialExecution) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            return null;
        }
        catch (CacheWriterException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
    }

    public Operation invalEntry(boolean isLocalInval, Region aRegion, Object key) {
        if (key == null) {
            Log.getLogWriter().info("Could not invalidate an entry in " + aRegion.getFullPath() + " because no keys are available");
            return null;
        }
        try {
            Object oldValue = DiskRegUtil.getValueInVM(aRegion, key);
            if (oldValue instanceof BaseValueHolder) {
                oldValue = ((BaseValueHolder)oldValue).modVal;
            }
            if (isLocalInval) {
                Log.getLogWriter().info("invalEntry: locally invalidating key " + key + " in region " + aRegion.getFullPath());
                aRegion.localInvalidate(key);
                Log.getLogWriter().info("invalEntry: done locally invalidating key " + key + " in region " + aRegion.getFullPath());
                Object newValue = DiskRegUtil.getValueInVM(aRegion, key);
                return new Operation(aRegion.getFullPath(), key, "entry-localInval", oldValue, newValue);
            }
            Log.getLogWriter().info("invalEntry: invalidating key " + key + " in region " + aRegion.getFullPath());
            aRegion.invalidate(key);
            Log.getLogWriter().info("invalEntry: done invalidating key " + key + " in region " + aRegion.getFullPath());
            Object newValue = DiskRegUtil.getValueInVM(aRegion, key);
            return new Operation(aRegion.getFullPath(), key, "entry-inval", oldValue, newValue);
        }
        catch (RegionDestroyedException e) {
            if (this.isSerialExecution) {
                throw e;
            }
            return null;
        }
        catch (TimeoutException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (EntryNotFoundException e) {
            if (this.isSerialExecution) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            return null;
        }
    }

    public Operation getEntryWithExistingKey(Region aRegion) {
        Object key = this.getRandomKey(aRegion);
        if (key == null) {
            Log.getLogWriter().info("Could not get with an existing key " + aRegion.getFullPath() + " because no keys are available");
            return null;
        }
        try {
            Object oldValue = DiskRegUtil.getValueInVM(aRegion, key);
            Log.getLogWriter().info("getEntryWithExistingKey: getting value for key " + key + " in region " + aRegion.getFullPath());
            if (oldValue instanceof BaseValueHolder) {
                oldValue = ((BaseValueHolder)oldValue).modVal;
            }
            Object value = aRegion.get(key);
            BaseValueHolder vh = (BaseValueHolder)value;
            Log.getLogWriter().info("getEntryWithExistingKey: got value for key " + key + ": " + vh + " in region " + aRegion.getFullPath());
            if (vh == null) {
                return new Operation(aRegion.getFullPath(), key, "entry-getWithExistingKey", oldValue, null);
            }
            return new Operation(aRegion.getFullPath(), key, "entry-getWithExistingKey", oldValue, vh.modVal);
        }
        catch (RegionDestroyedException e) {
            if (this.isSerialExecution) {
                throw e;
            }
            return null;
        }
        catch (CacheLoaderException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (TimeoutException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
    }

    public Operation getEntryWithPreviousKey(Region aRegion) {
        long keysUsed = NameFactory.getPositiveNameCounter();
        String key = NameFactory.getObjectNameForCounter(TestConfig.tab().getRandGen().nextInt(1, (int)keysUsed));
        try {
            Object oldValue = DiskRegUtil.getValueInVM(aRegion, key);
            if (oldValue instanceof BaseValueHolder) {
                oldValue = ((BaseValueHolder)oldValue).modVal;
            }
            Log.getLogWriter().info("getEntryWithPreviousKey: getting value for key " + key + " in region " + aRegion.getFullPath());
            Object value = aRegion.get((Object)key);
            BaseValueHolder vh = (BaseValueHolder)value;
            Log.getLogWriter().info("getEntryWithPreviousKey: got value for key " + key + ": " + vh + " in region " + aRegion.getFullPath());
            if (vh == null) {
                return new Operation(aRegion.getFullPath(), key, "entry-getWithPreviousKey", oldValue, null);
            }
            return new Operation(aRegion.getFullPath(), key, "entry-getWithPreviousKey", oldValue, vh.modVal);
        }
        catch (RegionDestroyedException e) {
            if (this.isSerialExecution) {
                throw e;
            }
            return null;
        }
        catch (CacheLoaderException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (TimeoutException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
    }

    public Operation getEntryWithNewKey(Region aRegion) {
        String key = NameFactory.getNextPositiveObjectName();
        try {
            Object oldValue = DiskRegUtil.getValueInVM(aRegion, key);
            Log.getLogWriter().info("getEntryWithNewKey: getting value for key " + key + " in region " + aRegion.getFullPath());
            BaseValueHolder vh = (BaseValueHolder)aRegion.get((Object)key);
            Log.getLogWriter().info("getEntryWithNewKey: got value for key " + key + ": " + vh + " in region " + aRegion.getFullPath());
            if (vh == null) {
                return new Operation(aRegion.getFullPath(), key, "entry-getWithNewKey", oldValue, null);
            }
            return new Operation(aRegion.getFullPath(), key, "entry-getWithNewKey", oldValue, vh.modVal);
        }
        catch (RegionDestroyedException e) {
            if (this.isSerialExecution) {
                throw e;
            }
            return null;
        }
        catch (CacheLoaderException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (TimeoutException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
    }

    public Operation putEntry(Region aRegion, Object key, BaseValueHolder value, String opName) {
        Object oldValue = DiskRegUtil.getValueInVM(aRegion, key);
        if (oldValue instanceof BaseValueHolder) {
            oldValue = ((BaseValueHolder)oldValue).modVal;
        }
        try {
            Log.getLogWriter().info("putEntry: putting key " + key + ", object " + value + " in region " + aRegion.getFullPath());
            aRegion.put(key, (Object)value);
            Log.getLogWriter().info("putEntry: done putting key " + key + ", object " + value + " in region " + aRegion.getFullPath());
        }
        catch (RegionDestroyedException e) {
            if (this.isSerialExecution) {
                throw e;
            }
            return null;
        }
        catch (CacheRuntimeException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        return new Operation(aRegion.getFullPath(), key, opName, oldValue, value.modVal);
    }

    public Operation getEntry(Region aRegion, Object key, String opName) {
        try {
            Object oldValue = DiskRegUtil.getValueInVM(aRegion, key);
            Log.getLogWriter().info("getEntry: getting value for key " + key + " in region " + aRegion.getFullPath());
            BaseValueHolder vh = (BaseValueHolder)aRegion.get(key);
            Log.getLogWriter().info("getEntry: got value for key " + key + ": " + vh + " in region " + aRegion.getFullPath());
            if (vh == null) {
                return new Operation(aRegion.getFullPath(), key, opName, oldValue, null);
            }
            return new Operation(aRegion.getFullPath(), key, opName, oldValue, vh.modVal);
        }
        catch (RegionDestroyedException e) {
            if (this.isSerialExecution) {
                throw e;
            }
            return null;
        }
        catch (CacheLoaderException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (TimeoutException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
    }

    public Operation invalRegion(boolean isLocalInval, Region aRegion) {
        try {
            if (isLocalInval) {
                Log.getLogWriter().info("invalRegion: locally invalidating region " + aRegion.getFullPath());
                aRegion.localInvalidateRegion();
                Log.getLogWriter().info("invalRegion: done locally invalidating region " + aRegion.getFullPath());
                return new Operation(aRegion.getFullPath(), null, "region-localInval", null, null);
            }
            Log.getLogWriter().info("invalRegion: invalidating region " + aRegion.getFullPath());
            aRegion.invalidateRegion();
            Log.getLogWriter().info("invalRegion: done invalidating region " + aRegion.getFullPath());
            return new Operation(aRegion.getFullPath(), null, "region-inval", null, null);
        }
        catch (RegionDestroyedException e) {
            if (this.isSerialExecution) {
                throw e;
            }
            return null;
        }
        catch (TimeoutException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
    }

    public Operation destroyRegion(boolean isLocalDestroy, Region aRegion) {
        if (aRegion == null) {
            return null;
        }
        try {
            this.recordDestroyedRegion(aRegion);
            if (isLocalDestroy) {
                Log.getLogWriter().info("destroyRegion: locally destroying region " + aRegion.getFullPath());
                aRegion.localDestroyRegion();
                Log.getLogWriter().info("destroyRegion: done locally destroying region " + aRegion.getFullPath());
                return new Operation(aRegion.getFullPath(), null, "region-localDestroy", null, null);
            }
            Log.getLogWriter().info("destroyRegion: destroying region " + aRegion.getFullPath());
            aRegion.destroyRegion();
            Log.getLogWriter().info("destroyRegion: done destroying region " + aRegion.getFullPath());
            return new Operation(aRegion.getFullPath(), null, "region-destroy", null, null);
        }
        catch (RegionDestroyedException e) {
            if (this.isSerialExecution) {
                throw e;
            }
            return null;
        }
        catch (CacheWriterException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (TimeoutException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
    }

    public Operation createRegion() {
        ArrayList list = (ArrayList)AsyncMsgBB.getBB().getSharedMap().get(AsyncMsgBB.DestroyedRegionsKey);
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                String regionPath = (String)list.get(i);
                Object[] tmp = this.createRegionWithPath(regionPath, false);
                Region aRegion = (Region)tmp[0];
                boolean regionCreated = (Boolean)tmp[1];
                if (!regionCreated) continue;
                return new Operation(regionPath, null, "region-create", null, null);
            }
        } else {
            Map aMap = this.getRegionDefMap();
            for (String regionPath : aMap.keySet()) {
                Object value = aMap.get(regionPath);
                if (!(value instanceof RegionDefinition)) continue;
                Object[] tmp = this.createRegionWithPath(regionPath, false);
                Region aRegion = (Region)tmp[0];
                boolean regionCreated = (Boolean)tmp[1];
                if (!regionCreated) continue;
                return new Operation(regionPath, null, "region-create", null, null);
            }
        }
        return null;
    }

    public Operation closeCache() {
        CacheUtil.closeCache();
        return new Operation(null, null, "cache-close", null, null);
    }

    public Object getRandomKey(Region aRegion) {
        return this.getRandomKey(aRegion, null);
    }

    public Object getRandomKey(Region aRegion, Object excludeKey) {
        if (aRegion == null) {
            throw new TestException("aRegion is " + aRegion);
        }
        Set aSet = null;
        try {
            aSet = aRegion.keys();
        }
        catch (RegionDestroyedException e) {
            if (this.isSerialExecution) {
                throw e;
            }
            return null;
        }
        HashSet<String> validKeys = new HashSet<String>();
        for (String key : aSet) {
            if (!(key instanceof String) || !key.startsWith("Object_")) continue;
            validKeys.add(key);
        }
        Object[] keyArr = validKeys.toArray();
        if (keyArr.length == 0) {
            Log.getLogWriter().info("Could not get a random key from " + aRegion.getFullPath() + " because the region has no keys");
            return null;
        }
        int randInt = TestConfig.tab().getRandGen().nextInt(0, keyArr.length - 1);
        Object key = keyArr[randInt];
        if (key.equals(excludeKey)) {
            if (keyArr.length == 1) {
                return null;
            }
            if (++randInt == keyArr.length) {
                randInt = 0;
            }
            key = keyArr[randInt];
        }
        return key;
    }

    public CacheLoader getCacheLoader() {
        return null;
    }

    public CacheWriter getCacheWriter() {
        return null;
    }

    public BaseValueHolder getNewValue(Object key) {
        return new ValueHolder(key, this.randomValues, new Integer(this.modValInitializer++));
    }

    public Object[] createRegionWithPath(String regionName, boolean fill) {
        Region aRegion;
        StringTokenizer st;
        String currentRegionName;
        Cache theCache;
        boolean regionCreated;
        block18: {
            regionCreated = false;
            theCache = CacheUtil.getCache();
            aRegion = theCache.getRegion(currentRegionName = (st = new StringTokenizer(regionName, "/", false)).nextToken());
            if (aRegion == null) {
                try {
                    RegionDefinition regDef = this.getRegionDefFromBB("/" + currentRegionName);
                    RegionAttributes attr = regDef.getRegionAttributes(AsyncMsgPrms.getCacheListener(), this.getCacheLoader(), this.getCacheWriter());
                    aRegion = theCache.createVMRegion(currentRegionName, attr);
                    Log.getLogWriter().info("Created root region " + aRegion.getFullPath());
                    if (fill) {
                        this.createEntries(aRegion);
                    }
                    regionCreated = true;
                }
                catch (TimeoutException e) {
                    throw new TestException(TestHelper.getStackTrace(e));
                }
                catch (RegionExistsException e) {
                    if (this.isSerialExecution) {
                        throw new TestException("Test error; unexpected " + TestHelper.getStackTrace(e));
                    }
                    aRegion = CacheUtil.getRegion(currentRegionName);
                    if (aRegion != null) break block18;
                    return new Object[]{null, new Boolean(false)};
                }
            }
        }
        Region previousRegion = aRegion;
        while (st.hasMoreTokens()) {
            block19: {
                currentRegionName = st.nextToken();
                String regionPath = previousRegion.getFullPath() + "/" + currentRegionName;
                try {
                    aRegion = theCache.getRegion(regionPath);
                }
                catch (RegionDestroyedException e) {
                    if (this.isSerialExecution) {
                        throw e;
                    }
                    return new Object[]{null, new Boolean(false)};
                }
                if (aRegion == null) {
                    try {
                        RegionDefinition regDef = this.getRegionDefFromBB(regionPath);
                        RegionAttributes attr = regDef.getRegionAttributes(AsyncMsgPrms.getCacheListener(), this.getCacheLoader(), this.getCacheWriter());
                        Log.getLogWriter().info("Attempting to create region " + currentRegionName + " with " + regDef);
                        aRegion = previousRegion.createSubregion(currentRegionName, attr);
                        Log.getLogWriter().info("Created region " + aRegion.getFullPath());
                        if (fill) {
                            this.createEntries(aRegion);
                        }
                        regionCreated = true;
                    }
                    catch (RegionDestroyedException e) {
                        if (this.isSerialExecution) {
                            throw e;
                        }
                        return new Object[]{null, new Boolean(false)};
                    }
                    catch (TimeoutException e) {
                        throw new TestException(TestHelper.getStackTrace(e));
                    }
                    catch (RegionExistsException e) {
                        if (this.isSerialExecution) {
                            throw new TestException("Test error; unexpected " + TestHelper.getStackTrace(e));
                        }
                        aRegion = CacheUtil.getRegion(regionPath);
                        if (aRegion != null) break block19;
                        return new Object[]{null, new Boolean(false)};
                    }
                }
            }
            previousRegion = aRegion;
        }
        return new Object[]{aRegion, new Boolean(regionCreated)};
    }

    public void clearDestroyedRegions() {
        AsyncMsgBB.getBB().getSharedMap().put(AsyncMsgBB.DestroyedRegionsKey, new ArrayList());
        Log.getLogWriter().info("Cleared destroyed region list from blackboard");
    }

    public void recordDestroyedRegion(Region aRegion) {
        if (!this.isSerialExecution) {
            return;
        }
        ArrayList<String> list = (ArrayList<String>)AsyncMsgBB.getBB().getSharedMap().get(AsyncMsgBB.DestroyedRegionsKey);
        if (list == null) {
            list = new ArrayList<String>();
        }
        list.add(aRegion.getFullPath());
        Set regionSet = aRegion.subregions(true);
        for (Region currRegion : regionSet) {
            list.add(currRegion.getFullPath());
        }
        AsyncMsgBB.getBB().getSharedMap().put(AsyncMsgBB.DestroyedRegionsKey, list);
        Log.getLogWriter().info("AsyncMsgBB.DestroyedRegionsKey = " + list);
    }

    public void createDestroyedRegionsFromBB(boolean fill) {
        if (!this.isSerialExecution) {
            throw new TestException("Do not call this from concurrent tests as DestroyedRegionsKey is not maintained");
        }
        ArrayList list = (ArrayList)AsyncMsgBB.getBB().getSharedMap().get(AsyncMsgBB.DestroyedRegionsKey);
        if (list == null) {
            list = new ArrayList();
        }
        Log.getLogWriter().info("In createDestroyedRegionsFromBB with destroyed regions " + list);
        for (int i = 0; i < list.size(); ++i) {
            String regionPath = (String)list.get(i);
            this.createRegionWithPath(regionPath, fill);
        }
        Log.getLogWriter().info("Done in createDestroyedRegionsFromBB");
    }

    public void createAllDestroyedRegions(boolean fill) {
        Map aMap = this.getRegionDefMap();
        Iterator it = aMap.keySet().iterator();
        Log.getLogWriter().info("In createAllDestroyedRegions");
        while (it.hasNext()) {
            String key = (String)it.next();
            Object value = aMap.get(key);
            if (!(value instanceof RegionDefinition)) continue;
            this.createRegionWithPath(key, fill);
        }
        Log.getLogWriter().info("Done in createAllDestroyedRegions");
    }

    public boolean isHierMirrored(Region aRegion) {
        boolean isMirrored = aRegion.getAttributes().getMirrorType().isMirrored();
        if (isMirrored) {
            return true;
        }
        Object[] regionArr = this.getSubregions(aRegion, true).toArray();
        for (int j = 0; j < regionArr.length; ++j) {
            Region subR = (Region)regionArr[j];
            if (!subR.getAttributes().getMirrorType().isMirrored()) continue;
            return true;
        }
        return false;
    }

    public boolean isHierMirroredKV(Region aRegion) {
        boolean isMirrored = aRegion.getAttributes().getMirrorType().isKeysValues();
        if (isMirrored) {
            return true;
        }
        Object[] regionArr = this.getSubregions(aRegion, true).toArray();
        for (int j = 0; j < regionArr.length; ++j) {
            Region subR = (Region)regionArr[j];
            if (!subR.getAttributes().getMirrorType().isKeysValues()) continue;
            return true;
        }
        return false;
    }

    public Set getSubregions(Region aRegion, boolean recursive) {
        try {
            Set regionSet = aRegion.subregions(recursive);
            return regionSet;
        }
        catch (RegionDestroyedException e) {
            String errorRegionName;
            if (this.isSerialExecution) {
                throw e;
            }
            String regionName = aRegion.getFullPath();
            if (!regionName.equals(errorRegionName = e.getRegionFullPath())) {
                throw e;
            }
            return new HashSet();
        }
    }

    public Map getRegionDefMap() {
        Map aMap = (Map)AsyncMsgBB.getBB().getSharedMap().get(AsyncMsgBB.RegDefForPIDKey);
        if (aMap == null) {
            return new HashMap();
        }
        return aMap;
    }

    public void recordRegionDefInBB(String fullPathOfRegion, RegionDefinition regDef) {
        Map aMap = this.getRegionDefMap();
        aMap.put(fullPathOfRegion, regDef);
        AsyncMsgBB.getBB().getSharedMap().put(AsyncMsgBB.RegDefForPIDKey, aMap);
    }

    public RegionDefinition getRegionDefFromBB(String fullPathOfRegion) {
        Map aMap = this.getRegionDefMap();
        RegionDefinition regDef = (RegionDefinition)aMap.get(fullPathOfRegion);
        return regDef;
    }

    public static void HydraTask_verifyRegionContents() {
        Log.getLogWriter().info("In HydraTask_verifyRegionContents");
        if (asyncTest == null) {
            asyncTest = new AsyncMsgTest();
            asyncTest.initialize();
        }
        asyncTest.verifyRegionContents();
    }

    public void verifyRegionContents() {
        boolean isVisible = true;
        if (AsyncMsgBB.getBB().getSharedCounters().read(AsyncMsgBB.OPLIST_READY_FOR_VALIDATION) != 1L) {
            return;
        }
        long exeNum = AsyncMsgBB.getBB().getSharedCounters().read(AsyncMsgBB.ExecutionNumber);
        Log.getLogWriter().info("Beginning task with execution number " + exeNum);
        OpList opList = (OpList)AsyncMsgBB.getBB().getSharedMap().get(AsyncMsgBB.OpListKey);
        Log.getLogWriter().info("validate opList retrieved with key = " + AsyncMsgBB.OpListKey + " OpList = " + opList);
        if (this.verifyConflationBehavior) {
            int numOps = opList.numOps();
            int numEvents = numUpdatesThisRound;
            Boolean conflationEnabled = (Boolean)AsyncMsgBB.getBB().getSharedMap().get(AsyncMsgBB.conflationEnabled);
            if (numOps != numEvents && !conflationEnabled.booleanValue()) {
                throw new TestException("Expected " + opList.numOps() + " events, but actual number of events received by this VM = " + numUpdatesThisRound);
            }
            Log.getLogWriter().info("conflationEnabled = " + conflationEnabled + " numOps = " + numOps + " numEvents = " + numEvents);
            if (numOps < numEvents) {
                throw new TestException("Received " + numEvents + " events, but this is greater than the total number of operations performed, " + numOps);
            }
            AsyncMsgTest.clearNumUpdatesThisRound();
        }
        opList = opList.collapse();
        Log.getLogWriter().info("collapsed opList = " + opList);
        for (int i = 0; i < opList.numOps(); ++i) {
            Object actualValues;
            Object expectedValues;
            Operation op = opList.getOperation(i);
            if (op.isEntryOperation()) {
                expectedValues = EntryValidator.getExpected(op, isVisible);
                actualValues = EntryValidator.getActual(op);
                ((EntryValidator)expectedValues).compare((EntryValidator)actualValues);
                continue;
            }
            if (op.isRegionOperation()) {
                if (AsyncMsgTest.isRegionCreate(op)) continue;
                expectedValues = RegionValidator.getExpected(op, isVisible);
                actualValues = RegionValidator.getActual(op);
                ((RegionValidator)expectedValues).compare((RegionValidator)actualValues);
                continue;
            }
            if (op.getOpName().equalsIgnoreCase("cache-close")) continue;
            throw new TestException("Unknown operation " + op);
        }
        if (this.isSerialExecution) {
            this.createDestroyedRegionsFromBB(true);
        }
    }

    private static boolean isRegionCreate(Operation op) {
        boolean isRegionCreate = false;
        if (op.getOpName().equalsIgnoreCase("region-create")) {
            isRegionCreate = true;
        }
        return isRegionCreate;
    }

    public Region primeQueue() {
        Region aRegion;
        String key;
        int i;
        String dirKey = AsyncMsgBB.PrimeQDir + RemoteTestModule.getMyClientName();
        String primeQDir = (String)AsyncMsgBB.getBB().getSharedMap().get(dirKey);
        if (primeQDir != null) {
            String countKey = AsyncMsgBB.PrimeQCount + RemoteTestModule.getMyClientName();
            Integer primeQCount = (Integer)AsyncMsgBB.getBB().getSharedMap().get(countKey);
            Region aRegion2 = CacheUtil.getCache().getRegion(primeQDir);
            if (aRegion2 != null) {
                for (i = 0; i < primeQCount; ++i) {
                    key = (String)ObjectHelper.createName(i);
                    try {
                        aRegion2.destroy((Object)key);
                        continue;
                    }
                    catch (EntryNotFoundException e) {
                        break;
                    }
                    catch (CacheRuntimeException anException) {
                        throw new TestException(TestHelper.getStackTrace(anException));
                    }
                }
            }
        }
        if (this.isSerialExecution) {
            this.createDestroyedRegionsFromBB(true);
            this.clearDestroyedRegions();
        }
        if ((aRegion = this.getRandomRegion(true)) == null) {
            throw new TestException("primeQueue: no regions available.  Possible test config issue");
        }
        String objectType = TestConfig.tab().stringAt(AsyncMsgPrms.objectType, "objects.ArrayOfByte");
        Log.getLogWriter().info("primeQueue: creating entries of type " + objectType);
        Object val = null;
        i = 0;
        this.putSleepKey(aRegion, AsyncMsgPrms.getPrimeQueueSleepMs());
        this.putSleepKey(aRegion, 0);
        while (!this.messagesQueued()) {
            key = (String)ObjectHelper.createName(i);
            val = ObjectHelper.createObject(objectType, i++);
            try {
                Log.getLogWriter().fine("primeQ: putting key " + key + ", object " + val.toString() + " in region " + aRegion.getFullPath());
                aRegion.put((Object)key, val);
                Log.getLogWriter().fine("primeQ: done putting key " + key + ", object " + val.toString() + " in region " + aRegion.getFullPath());
            }
            catch (RegionDestroyedException e) {
                if (!this.isSerialExecution) continue;
                throw e;
            }
            catch (CacheRuntimeException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
        }
        Log.getLogWriter().info("Put " + i + " objects of type " + objectType + " to initiate queuing");
        dirKey = AsyncMsgBB.PrimeQDir + RemoteTestModule.getMyClientName();
        AsyncMsgBB.getBB().getSharedMap().put(dirKey, aRegion.getFullPath());
        String countKey = AsyncMsgBB.PrimeQCount + RemoteTestModule.getMyClientName();
        AsyncMsgBB.getBB().getSharedMap().put(countKey, new Integer(i));
        return aRegion;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected DMStats getDMStats() {
        DMStats dmStats = null;
        DistributedSystem ds = DistributedSystemHelper.getDistributedSystem();
        if (ds == null) {
            ds = DistributedConnectionMgr.getConnection();
        }
        if (ds != null) {
            DM dm = ((InternalDistributedSystem)ds).getDistributionManager();
            return dm.getStats();
        }
        Boolean slowReceiverDetected = (Boolean)AsyncMsgBB.getBB().getSharedMap().get("SlowReceiverDetectedKey");
        if (slowReceiverDetected == false) throw new TestException("DistributedSystem is null -- cannot access statistics");
        Log.getLogWriter().info("This VM cannot access the stats.  Probably forcefully disconnected from DS");
        return dmStats;
    }

    protected void verifyQueuedMessages() {
        DMStats dmStats = this.getDMStats();
        if (dmStats != null) {
            long queuedMessages = dmStats.getAsyncQueuedMsgs();
            Log.getLogWriter().info("asyncQueuedMsgs = " + queuedMessages);
            if (queuedMessages <= 0L) {
                throw new TestException("TuningRequired: AsyncQueuedMsgs is " + queuedMessages);
            }
        }
    }

    protected void verifyNoAsyncBufferWrites() {
        DMStats dmStats = this.getDMStats();
        if (dmStats != null) {
            long asyncWrites = dmStats.getAsyncSocketWrites();
            Log.getLogWriter().info("asyncSocketWrites = " + asyncWrites);
            if (asyncWrites > 0L) {
                throw new TestException("Did not expect asyncSocketWrites, but found " + asyncWrites + " asyncSocketWrites");
            }
        }
    }

    public boolean messagesQueued() {
        long queueSize;
        boolean queuedMessages = false;
        DMStats dmStats = this.getDMStats();
        if (dmStats != null && (queueSize = dmStats.getAsyncQueueSize()) > 0L) {
            Log.getLogWriter().info("asyncQueueSize = " + queueSize);
            queuedMessages = true;
        }
        return queuedMessages;
    }

    public boolean queuedMessagesConflated() {
        boolean messagesConflated = false;
        DMStats dmStats = this.getDMStats();
        if (dmStats != null) {
            long numConflatedMessages = dmStats.getAsyncConflatedMsgs();
            Log.getLogWriter().info("asyncConflatedMsgs = " + numConflatedMessages);
            if (numConflatedMessages > 0L) {
                messagesConflated = true;
            }
        }
        return messagesConflated;
    }

    public boolean queueSizeExceeded() {
        boolean queueSizeExceeded = false;
        DMStats dmStats = this.getDMStats();
        if (dmStats != null) {
            long sizeExceeded = dmStats.getAsyncQueueSizeExceeded();
            Log.getLogWriter().info("queueSizeExceeded = " + queueSizeExceeded);
            if (sizeExceeded > 0L) {
                queueSizeExceeded = true;
            }
        }
        return queueSizeExceeded;
    }

    public boolean queueTimeoutExceeded() {
        boolean queueTimeouts = false;
        DMStats dmStats = this.getDMStats();
        if (dmStats != null) {
            long timeouts = dmStats.getAsyncQueueTimeouts();
            Log.getLogWriter().info("asyncQueueTimeouts = " + timeouts);
            if (timeouts > 0L) {
                queueTimeouts = true;
            }
        }
        return queueTimeouts;
    }

    public void putSleepKey(Region aRegion, int sleepMs) {
        String key = SLEEP_KEY;
        Integer val = new Integer(sleepMs);
        try {
            Log.getLogWriter().info("putSleepKey: putting key " + key + ", value " + val + " in region " + aRegion.getFullPath());
            aRegion.put((Object)key, (Object)val);
            Log.getLogWriter().info("putSleepKey: done putting key " + key + ", value " + val + " in region " + aRegion.getFullPath());
        }
        catch (RegionDestroyedException e) {
            if (this.isSerialExecution) {
                throw e;
            }
        }
        catch (CacheRuntimeException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
    }

    protected void doProducer() {
        AsyncMsgBB.getBB().getSharedCounters().increment(AsyncMsgBB.ReadyToBegin);
        while (true) {
            try {
                TestHelper.waitForCounter(AsyncMsgBB.getBB(), "AsyncMsgBB.ReadyToBegin", AsyncMsgBB.ReadyToBegin, this.numPeerThreadsInTest, true, 10000L, 1000L);
            }
            catch (TestException e) {
                if (!AdminListener.slowReceiverAlertOccurred()) continue;
                throw new StopSchedulingOrder("a slow receiver alert was recognized");
            }
            break;
        }
        if (AsyncMsgBB.getBB().getSharedCounters().incrementAndRead(AsyncMsgBB.ConcurrentLeader) == 1L) {
            AsyncMsgTest.logExecutionNumber();
            this.concurrentLeaderTid = RemoteTestModule.getCurrentThread().getThreadId();
        }
        Log.getLogWriter().info("In doConcAsyncMsg, concurrentLeaderTid is " + this.concurrentLeaderTid);
        Log.getLogWriter().info("Zeroing ShapshotWritten, NoMoreEvents");
        AsyncMsgBB.getBB().getSharedCounters().zero(AsyncMsgBB.SnapshotWritten);
        AsyncMsgBB.getBB().getSharedCounters().zero(AsyncMsgBB.NoMoreEvents);
        this.doControlledOperations();
        Log.getLogWriter().info("Zeroing FinishedVerify");
        AsyncMsgBB.getBB().getSharedCounters().zero(AsyncMsgBB.FinishedVerify);
        AsyncMsgBB.getBB().getSharedCounters().increment(AsyncMsgBB.Pausing);
        while (true) {
            try {
                TestHelper.waitForCounter(AsyncMsgBB.getBB(), "AsyncMsgBB.Pausing", AsyncMsgBB.Pausing, this.numPeerThreadsInTest, true, 10000L, 5000L);
            }
            catch (TestException e) {
                if (!AdminListener.slowReceiverAlertOccurred()) continue;
                throw new StopSchedulingOrder("a slow receiver alert was recognized");
            }
            break;
        }
        Log.getLogWriter().info("Zeroing ReadyToBegin, ConcurrentLeader");
        AsyncMsgBB.getBB().getSharedCounters().zero(AsyncMsgBB.ReadyToBegin);
        AsyncMsgBB.getBB().getSharedCounters().zero(AsyncMsgBB.ConcurrentLeader);
        AsyncMsgTest.waitForEventsByPut();
        this.writeSnapshot();
        AsyncMsgBB.getBB().getSharedCounters().increment(AsyncMsgBB.FinishedVerify);
        while (true) {
            try {
                TestHelper.waitForCounter(AsyncMsgBB.getBB(), "AsyncMsgBB.FinishedVerify", AsyncMsgBB.FinishedVerify, this.numPeerThreadsInTest, true, 10000L, 5000L);
            }
            catch (TestException e) {
                if (!AdminListener.slowReceiverAlertOccurred()) continue;
                throw new StopSchedulingOrder("a slow receiver alert was recognized");
            }
            break;
        }
        Log.getLogWriter().info("Zeroing concurrentLeaderTid, Pausing");
        this.concurrentLeaderTid = -1;
        AsyncMsgBB.getBB().getSharedCounters().zero(AsyncMsgBB.Pausing);
        long counter = AsyncMsgBB.getBB().getSharedCounters().read(AsyncMsgBB.ExecutionNumber);
        int numExecutionsToTerminate = TestConfig.tab().intAt(AsyncMsgPrms.numExecutionsToTerminate);
        Log.getLogWriter().info("Determining termination, execution number is " + counter + " numExecutionsToTerminate is " + numExecutionsToTerminate);
        if (counter >= (long)numExecutionsToTerminate) {
            Log.getLogWriter().info("Getting ready to throw StopSchedulingOrder...");
            throw new StopSchedulingOrder("Num executions is " + counter);
        }
        if (AdminListener.slowReceiverAlertOccurred()) {
            throw new StopSchedulingOrder("a slow receiver alert was recognized");
        }
    }

    protected void doConsumer() {
        AsyncMsgBB.getBB().getSharedCounters().increment(AsyncMsgBB.ReadyToBegin);
        while (true) {
            try {
                TestHelper.waitForCounter(AsyncMsgBB.getBB(), "AsyncMsgBB.ReadyToBegin", AsyncMsgBB.ReadyToBegin, this.numPeerThreadsInTest, true, 10000L, 1000L);
            }
            catch (TestException e) {
                if (!AdminListener.slowReceiverAlertOccurred()) continue;
                throw new StopSchedulingOrder("a slow receiver alert was recognized");
            }
            break;
        }
        AsyncMsgBB.getBB().getSharedCounters().increment(AsyncMsgBB.Pausing);
        while (true) {
            try {
                TestHelper.waitForCounter(AsyncMsgBB.getBB(), "AsyncMsgBB.Pausing", AsyncMsgBB.Pausing, this.numPeerThreadsInTest, true, 10000L, 5000L);
            }
            catch (TestException e) {
                if (!AdminListener.slowReceiverAlertOccurred()) continue;
                throw new StopSchedulingOrder("a slow receiver alert was recognized");
            }
            break;
        }
        BurstListener.enableBurstBehavior(false);
        while (true) {
            try {
                TestHelper.waitForCounter(AsyncMsgBB.getBB(), "AsyncMsgBB.SnapshotWritten", AsyncMsgBB.SnapshotWritten, 1L, true, 10000L, 2000L);
            }
            catch (TestException e) {
                if (!AdminListener.slowReceiverAlertOccurred()) continue;
                throw new StopSchedulingOrder("a slow receiver alert was recognized");
            }
            break;
        }
        BurstListener.enableBurstBehavior(true);
        this.verifyFromSnapshot();
        AsyncMsgBB.getBB().getSharedCounters().increment(AsyncMsgBB.FinishedVerify);
        while (true) {
            try {
                TestHelper.waitForCounter(AsyncMsgBB.getBB(), "AsyncMsgBB.FinishedVerify", AsyncMsgBB.FinishedVerify, this.numPeerThreadsInTest, true, 10000L, 5000L);
            }
            catch (TestException e) {
                if (!AdminListener.slowReceiverAlertOccurred()) continue;
                throw new StopSchedulingOrder("a slow receiver alert was recognized");
            }
            break;
        }
        long counter = AsyncMsgBB.getBB().getSharedCounters().read(AsyncMsgBB.ExecutionNumber);
        int numExecutionsToTerminate = TestConfig.tab().intAt(AsyncMsgPrms.numExecutionsToTerminate);
        Log.getLogWriter().info("Determining termination, execution number is " + counter + " numExecutionsToTerminate is " + numExecutionsToTerminate);
        if (counter >= (long)numExecutionsToTerminate) {
            Log.getLogWriter().info("Getting ready to throw StopSchedulingOrder...");
            throw new StopSchedulingOrder("Num executions is " + counter);
        }
        if (AdminListener.slowReceiverAlertOccurred()) {
            throw new StopSchedulingOrder("a slow receiver alert was recognized");
        }
    }

    protected void waitForEventsByTime() {
        BurstListener.enableBurstBehavior(false);
        long startTime = System.currentTimeMillis();
        int NO_EVENTS_MILLIS = 20000;
        long currentTime = 0L;
        long lastInvocation = 0L;
        do {
            currentTime = System.currentTimeMillis();
            lastInvocation = BurstListener.getLastInvocationTime();
            Log.getLogWriter().info("Waiting for 20000 ms to elapse since last BurstListener invocation, last BurstListener occurred at " + lastInvocation + ", current time is " + currentTime + ", elapsed is " + (currentTime - lastInvocation));
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
        } while (currentTime - lastInvocation < 20000L);
        long endTime = System.currentTimeMillis();
        Log.getLogWriter().info("It took this thread " + (endTime - startTime) + " ms to observe " + 20000 + " ms without receiving an event");
        AsyncMsgBB.getBB().getSharedCounters().increment(AsyncMsgBB.NoMoreEvents);
        TestHelper.waitForCounter(AsyncMsgBB.getBB(), "AsyncMsgBB.NoMoreEvents", AsyncMsgBB.NoMoreEvents, this.numPeerThreadsInTest, true, -1L, 5000L);
        endTime = System.currentTimeMillis();
        Log.getLogWriter().info("It took all threads in this test " + (endTime - startTime) + " ms to observe " + 20000 + " ms without receiving an event");
        BurstListener.enableBurstBehavior(true);
    }

    public static void waitForEventsByPut() {
        Region aRegion = CacheUtil.getCache().getRegion(DIST_ACK_REGION);
        Log.getLogWriter().info("Waiting for events by putting into " + aRegion.getFullPath());
        String key = "ReadyForValidation";
        long startTime = System.currentTimeMillis();
        Log.getLogWriter().info("Putting " + key + " with value " + startTime + "  into " + aRegion.getFullPath());
        aRegion.put((Object)key, (Object)new Long(startTime));
        long endTime = System.currentTimeMillis();
        Log.getLogWriter().info("Done putting " + key + " with value " + startTime + " into " + aRegion.getFullPath() + ", put took " + (endTime - startTime) + " millis");
    }

    protected void doControlledOperations() {
        HydraVector operations = TestConfig.tab().vecAt(AsyncMsgPrms.operations);
        HydraVector lowerThresholdOperations = TestConfig.tab().vecAt(AsyncMsgPrms.lowerThresholdOperations);
        HydraVector upperThresholdOperations = TestConfig.tab().vecAt(AsyncMsgPrms.upperThresholdOperations);
        int lowerThreshold = TestConfig.tab().intAt(AsyncMsgPrms.lowerThreshold);
        int upperThreshold = TestConfig.tab().intAt(AsyncMsgPrms.upperThreshold);
        long minTaskGranularitySec = TestConfig.tab().longAt(TestHelperPrms.minTaskGranularitySec);
        long minTaskGranularityMS = minTaskGranularitySec * 1000L;
        Log.getLogWriter().info("Doing controlled operations for " + minTaskGranularitySec + " seconds");
        Region aRegion = CacheUtil.getRegion(REGION_NAME);
        if (aRegion == null) {
            throw new TestException("Region AsyncRegion is null, probably due to a forcible disconnect because of a slow receiver");
        }
        long startTime = System.currentTimeMillis();
        do {
            if (aRegion.keys().size() <= lowerThreshold) {
                this.doOperations(lowerThresholdOperations, 1);
                continue;
            }
            if (aRegion.keys().size() >= upperThreshold) {
                this.doOperations(upperThresholdOperations, 1);
                continue;
            }
            this.doOperations(operations, 1);
        } while (System.currentTimeMillis() - startTime < minTaskGranularityMS);
        Log.getLogWriter().info("Done doing controlled operations for " + minTaskGranularitySec + " seconds");
    }

    protected void writeSnapshot() {
        Region aRegion = CacheUtil.getRegion(REGION_NAME);
        int myTid = RemoteTestModule.getCurrentThread().getThreadId();
        Log.getLogWriter().info("In writeSnapshot, with myTid " + myTid + ", concurrentLeaderTid is " + this.concurrentLeaderTid);
        if (myTid == this.concurrentLeaderTid) {
            HashMap regionSnapshot = new HashMap();
            Log.getLogWriter().info("This thread is the concurrentLeader, creating region snapshot...");
            Set keySet = aRegion.keys();
            for (Object key : keySet) {
                Object value = null;
                if (aRegion.containsValueForKey(key)) {
                    try {
                        value = aRegion.get(key);
                    }
                    catch (TimeoutException e) {
                        throw new TestException(TestHelper.getStackTrace(e));
                    }
                    catch (CacheLoaderException e) {
                        throw new TestException(TestHelper.getStackTrace(e));
                    }
                }
                if (value instanceof BaseValueHolder) {
                    regionSnapshot.put(key, ((BaseValueHolder)value).myValue);
                    continue;
                }
                regionSnapshot.put(key, value);
            }
            Log.getLogWriter().info("Done creating region snapshot with " + regionSnapshot.size() + " entries");
            AsyncMsgBB.getBB().getSharedMap().put(AsyncMsgBB.RegionSnapshot, regionSnapshot);
            long snapshotWritten = AsyncMsgBB.getBB().getSharedCounters().incrementAndRead(AsyncMsgBB.SnapshotWritten);
            Log.getLogWriter().info("Incremented SnapshotWritten, now is " + snapshotWritten);
        }
    }

    protected void verifyFromSnapshot() {
        Region aRegion;
        int regionSize;
        StringBuffer aStr = new StringBuffer();
        Map regionSnapshot = (Map)AsyncMsgBB.getBB().getSharedMap().get(AsyncMsgBB.RegionSnapshot);
        int snapshotSize = regionSnapshot.size();
        if (snapshotSize != (regionSize = (aRegion = CacheUtil.getRegion(REGION_NAME)).keys().size())) {
            aStr.append("Expected region " + aRegion.getFullPath() + " to be size " + snapshotSize + ", but it is " + regionSize + "\n");
            if (snapshotSize < regionSize) {
                HashSet regionKeySet = new HashSet(aRegion.keys());
                Set snapShotKeySet = regionSnapshot.keySet();
                regionKeySet.removeAll(snapShotKeySet);
                for (Object key : regionKeySet) {
                    Region.Entry entry = aRegion.getEntry(key);
                    if (entry != null) {
                        Object value = entry.getValue();
                        aStr.append("   region contains key " + key + ", value " + TestHelper.toString(value) + ", but this is is not in the region snapshot (region snapshot.containsKey() is " + regionSnapshot.containsKey(key) + ")\n");
                        continue;
                    }
                    aStr.append("   Error in test; region should contain key " + key + ", but it could not be obtained");
                }
            }
        }
        Log.getLogWriter().info("Verifying from snapshot containing " + snapshotSize + " entries...");
        for (Map.Entry entry : regionSnapshot.entrySet()) {
            Object key = entry.getKey();
            Object expectedValue = entry.getValue();
            boolean containsKey = aRegion.containsKey(key);
            try {
                AsyncMsgTest.verifyContainsKey(aRegion, key, true);
            }
            catch (TestException e) {
                aStr.append(e.getMessage() + "\n");
            }
            boolean containsValueForKey = aRegion.containsValueForKey(key);
            try {
                AsyncMsgTest.verifyContainsValueForKey(aRegion, key, expectedValue != null);
            }
            catch (TestException e) {
                aStr.append(e.getMessage() + "\n");
            }
            if (!containsKey) continue;
            Region.Entry regionEntry = aRegion.getEntry(key);
            Object actualValue = regionEntry.getValue();
            try {
                AsyncMsgTest.verifyMyValue(aRegion, key, expectedValue, actualValue, EQUAL);
            }
            catch (TestException e) {
                aStr.append(e.getMessage() + "\n");
            }
        }
        if (aStr.length() > 0) {
            throw new TestException(aStr.toString());
        }
        Log.getLogWriter().info("Done verifying from snapshot containing " + snapshotSize + " entries...");
    }

    protected static void verifyMyValue(Region aRegion, Object key, Object expectedValue, Object valueToCheck, int compareStrategy) {
        if (valueToCheck == null) {
            if (expectedValue != null) {
                throw new TestException("For key " + key + ", expected myValue to be " + TestHelper.toString(expectedValue) + ", but it is " + TestHelper.toString(valueToCheck));
            }
        } else if (valueToCheck instanceof BaseValueHolder) {
            BaseValueHolder actualVH = (BaseValueHolder)valueToCheck;
            if (compareStrategy == EQUAL) {
                if (!actualVH.myValue.equals(expectedValue)) {
                    throw new TestException("For key " + key + ", expected ValueHolder.myValue to be " + TestHelper.toString(expectedValue) + ", but it is " + TestHelper.toString(valueToCheck));
                }
            } else if (compareStrategy == EQUIVALENT && actualVH.myValue.toString().equals(expectedValue.toString())) {
                throw new TestException("For key " + key + ", expected ValueHolder.myValue to be " + expectedValue + ", but it is " + actualVH.myValue);
            }
        } else {
            throw new TestException("Expected value for key " + key + " to be an instance of ValueHolder, but it is " + TestHelper.toString(valueToCheck));
        }
    }

    protected static void verifyContainsKey(Region aRegion, Object key, boolean expected) {
        boolean containsKey = aRegion.containsKey(key);
        if (containsKey != expected) {
            throw new TestException("Expected containsKey() for " + key + " to be " + expected + " in " + aRegion.getFullPath() + ", but it is " + containsKey);
        }
    }

    protected static void verifyContainsValueForKey(Region aRegion, Object key, boolean expected) {
        boolean containsValueForKey = aRegion.containsValueForKey(key);
        if (containsValueForKey != expected) {
            throw new TestException("Expected containsValueForKey() for " + key + " to be " + expected + " in " + aRegion.getFullPath() + ", but it is " + containsValueForKey);
        }
    }

    public static int incNumUpdatesThisRound() {
        return ++numUpdatesThisRound;
    }

    public static void clearNumUpdatesThisRound() {
        numUpdatesThisRound = 0;
    }

    public static void handlePossibleSlowReceiverException(Exception e) {
        Throwable causedBy;
        if ((e instanceof CancelException || e instanceof DistributedSystemDisconnectedException) && (causedBy = e.getCause()) instanceof ForcedDisconnectException) {
            AdminListener.waitForSlowReceiverAlert(60);
            AsyncMsgBB.checkForError();
            AsyncMsgBB.getBB().getSharedMap().put("SlowReceiverDetectedKey", new Boolean(true));
            throw new StopSchedulingOrder("Stopping tasks; slow receiver detected");
        }
        throw new TestException(TestHelper.getStackTrace(e));
    }
}

