/*
 * Decompiled with CFR 0.152.
 */
package batterytest;

import batterytest.BatteryTestConfig;
import batterytest.ConfigParser;
import batterytest.NativeClientConfigParser;
import com.gemstone.gemfire.LogWriter;
import hydra.FileUtil;
import hydra.HydraConfigException;
import hydra.HydraInternalException;
import hydra.Log;
import hydra.ProcessMgr;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.util.Vector;
import util.TestHelper;

public class NativeClientBatteryTest {
    private static LogWriter log;

    public static void main(String[] args) {
        try {
            NativeClientBatteryTest.runbattery(args);
        }
        catch (VirtualMachineError e) {
            throw e;
        }
        catch (Throwable t) {
            NativeClientBatteryTest.logError(TestHelper.getStackTrace(t));
        }
        System.exit(0);
    }

    public static void runbattery(String[] args) {
        String jtests = System.getProperty("CTESTS");
        String testFileName = System.getProperty("testFileName");
        if (jtests == null) {
            NativeClientBatteryTest.usage("Missing CTESTS");
            return;
        }
        if (testFileName == null) {
            NativeClientBatteryTest.usage("Missing testFileName");
            return;
        }
        String resultDir = System.getProperty("resultDir", System.getProperty("user.dir"));
        String logLevel = System.getProperty("logLevel", "info");
        log = Log.createLogWriter("batterytest", "batterytest", logLevel, true);
        log.info(ProcessMgr.processAndBuildInfoString());
        log.info("Batterytest PID is " + ProcessMgr.getProcessId());
        log.info("\nCTESTS = " + jtests + "\ntestFileName = " + testFileName + "\nresultDir = " + resultDir + "\nlogLevel = " + logLevel);
        log.info("Parsing batterytest input file: " + testFileName + "...");
        Vector tests = null;
        try {
            tests = ConfigParser.parseFile(testFileName);
            if (log.fineEnabled()) {
                for (int i = 0; i < tests.size(); ++i) {
                    log.fine("Test " + i + " = " + tests.get(i));
                }
            }
        }
        catch (FileNotFoundException e) {
            log.severe("Batterytest input file not found: " + testFileName, (Throwable)e);
            return;
        }
        log.info("Number of tests in " + testFileName + " is " + tests.size() + "...");
        String sep = File.separator;
        for (int j = 0; j < tests.size(); ++j) {
            BatteryTestConfig btc = (BatteryTestConfig)tests.elementAt(j);
            String relativetest = btc.getName();
            String test = null;
            test = FileUtil.exists(relativetest) ? FileUtil.absoluteFilenameFor(relativetest) : jtests + sep + relativetest;
            int index = test.indexOf(".xml");
            if (index == -1) {
                String s = "Unexpected file type: " + test;
                throw new HydraInternalException(s);
            }
            String propFileName = test.substring(0, index) + ".prop";
            btc.fillInWithDefaultsFrom(propFileName);
            btc.addProperty("perffmwk.comparisonKey", relativetest);
            String testxml = null;
            try {
                testxml = NativeClientConfigParser.parseFile(test, btc.getProperties());
            }
            catch (FileNotFoundException e) {
                String s = "Native client xml file not found: " + test;
                throw new HydraConfigException(s);
            }
            String relativetestdir = "";
            if (relativetest.indexOf("/") != -1) {
                relativetestdir = relativetest.substring(0, relativetest.lastIndexOf("/"));
            }
            String testdir = resultDir + sep + relativetestdir;
            FileUtil.mkdir(testdir);
            String testname = FileUtil.filenameFor(test);
            testname = testname.substring(0, testname.lastIndexOf(".")) + "_" + j;
            FileUtil.writeToFile(testdir + sep + testname + ".xml", testxml);
            btc.writePropertiesToFile(testdir + sep + testname + ".prop");
            FileUtil.appendToFile(resultDir + sep + "batterytest.list", relativetestdir + sep + testname + ".xml\n");
        }
        NativeClientBatteryTest.reportStatus(tests.size());
    }

    private static void reportStatus(int total) {
        StringBuffer msg = new StringBuffer(100);
        msg.append("\n").append("==== STATUS REPORT ====");
        msg.append("  Total: ").append(total);
        msg.append("  ====");
        log.info(msg.toString());
    }

    private static void usage(String s) {
        PrintStream out = System.out;
        out.println("\n** " + s + "\n");
        out.println("Usage: java ");
        out.println("  -DCTESTS=<path_to_test_classes> ");
        out.println("  -DtestFileName=<batterytest_input_file> ");
        out.println("  [-DlogLevel=<batterytest_log_level(default:info)>]");
        out.println("batterytest.NativeClientBatteryTest");
        out.println("");
    }

    private static void logError(String msg) {
        if (log == null) {
            System.err.println(msg);
        } else {
            log.severe(msg);
        }
    }
}

