/*
 * Decompiled with CFR 0.152.
 */
package batterytest.greplogs;

import batterytest.greplogs.ExpectedStrings;
import batterytest.greplogs.LogConsumer;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintStream;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;

public class GrepLogs {
    public PrintStream output = System.out;
    private boolean hydraMode = false;
    private int threshold = 0;
    private int errorLimit = 5000;
    private int repeatLimit = 5;
    private static String GFXD_UNITTEST_PREFIX = "snappydata-store-";
    private static String PARALLEL_SUFFIX = "-parallel";
    private String type = "";
    private File resultPath = null;
    private boolean skipLogMsgs = false;
    private final List testExpectStrs;
    private static final Pattern logFilePattern = Pattern.compile(".*\\.(?:log|out|txt)");
    private static final Pattern logFileIgnorePattern = Pattern.compile(".*(?:mergedLogs.txt|errors.txt|derby.log|batterytest.log|resultReport.txt)");

    public static void main(String[] args) throws GrepLogsException {
        GrepLogs grep = new GrepLogs(args);
        grep.process();
    }

    public void process() throws GrepLogsException {
        int count = this.grepForErrors();
        boolean failure = false;
        StringBuilder summary = new StringBuilder();
        if (count != 0) {
            if (count > this.errorLimit) {
                summary.append("ERROR COUNT LIMIT EXCEEDED and search had been stopped!!\n").append("FAILED: Search found a total of ").append(count).append(" suspect strings.\n");
                failure = true;
            } else if (count <= this.threshold) {
                summary.append("WARNING: Search found a total of ").append(count).append(" suspect strings (").append(this.threshold).append(") allowed.\n");
            } else {
                summary.append("FAILED: Search found a total of ").append(count).append(" suspect strings (").append(this.threshold).append(") allowed.\n");
                failure = true;
            }
            if (count < this.threshold) {
                summary.append("         Consider setting -threshold lower (congratulations!)\n");
            }
        } else {
            summary.append("OK: Search found no suspect strings (").append(this.threshold).append(" allowed).\n");
        }
        this.output.print(summary.toString());
        if (!this.hydraMode) {
            System.err.print(summary.toString());
        }
        if (failure) {
            throw new GrepLogsException("Suspect strings were found in the logs.");
        }
    }

    public GrepLogs(String[] cmdLine) throws GrepLogsException {
        for (int i = 0; i < cmdLine.length; ++i) {
            if (cmdLine[i].equals("-h")) {
                GrepLogs.usage();
                continue;
            }
            if (cmdLine[i].equals("-hydra")) {
                this.hydraMode = true;
                continue;
            }
            if (cmdLine[i].equals("-out")) {
                if (++i == cmdLine.length) {
                    GrepLogs.usage();
                }
                try {
                    File outFile = new File(cmdLine[i]);
                    File base = outFile.getParentFile();
                    if (base == null) {
                        base = new File(".");
                    }
                    if (!base.exists() && !base.mkdirs()) {
                        String msg = "Unable to create, " + base.getAbsolutePath();
                        throw new FileNotFoundException(msg);
                    }
                    this.output = new PrintStream(new FileOutputStream(outFile), true);
                    continue;
                }
                catch (FileNotFoundException e) {
                    String msg = "Unable to write to output file " + cmdLine[i];
                    if (!this.hydraMode) {
                        System.err.println(msg);
                    }
                    throw new GrepLogsException(msg);
                }
            }
            if (cmdLine[i].equals("-type")) {
                if (++i == cmdLine.length) {
                    GrepLogs.usage();
                }
                this.type = cmdLine[i];
                continue;
            }
            if (cmdLine[i].equals("-limit")) {
                if (++i == cmdLine.length) {
                    GrepLogs.usage();
                }
                this.errorLimit = Integer.parseInt(cmdLine[i]);
                continue;
            }
            if (cmdLine[i].equals("-repeats")) {
                if (++i == cmdLine.length) {
                    GrepLogs.usage();
                }
                this.repeatLimit = Integer.parseInt(cmdLine[i]);
                continue;
            }
            if (cmdLine[i].equals("-threshold")) {
                if (++i == cmdLine.length) {
                    GrepLogs.usage();
                }
                this.threshold = Integer.parseInt(cmdLine[i]);
                continue;
            }
            this.resultPath = new File(cmdLine[i]);
        }
        if (this.resultPath == null || !this.resultPath.exists()) {
            throw new IllegalArgumentException("results directory did not exist");
        }
        if (this.output == null) {
            throw new IllegalArgumentException("output file was not specified");
        }
        if (this.type.equals("")) {
            this.type = this.resultPath.getName();
            this.type = this.type.replace(GFXD_UNITTEST_PREFIX, "");
            if (this.type.endsWith(PARALLEL_SUFFIX)) {
                this.type = this.type.substring(0, this.type.length() - PARALLEL_SUFFIX.length());
            }
        }
        this.testExpectStrs = ExpectedStrings.create(this.type);
        this.skipLogMsgs = ExpectedStrings.skipLogMsgs(this.type);
    }

    public int grepForErrors() {
        int errorCount = 0;
        HashSet logs = new HashSet();
        this.findAllLogs(this.resultPath, logs);
        for (File log : logs) {
            if ((errorCount += this.examineLog(log)) <= this.errorLimit) continue;
            this.output.println("\n\nError count limit exceeded limit of " + this.errorLimit);
            this.output.println("Stopping grepLogs to prevent filling disk.");
            this.output.println("errorcntlimit=" + this.errorLimit);
            this.output.println("errors=" + errorCount);
            return errorCount;
        }
        return errorCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int examineLog(File log) {
        StringBuilder suspectString;
        int count = 0;
        LineNumberReader reader = null;
        try {
            reader = new LineNumberReader(new FileReader(log));
        }
        catch (FileNotFoundException fnfe) {
            if (!this.hydraMode) {
                System.err.println("ERROR: cannot open " + log.getAbsolutePath());
            }
            return count++;
        }
        LogConsumer consumer = new LogConsumer(this.skipLogMsgs, this.testExpectStrs, log.getAbsolutePath(), this.repeatLimit);
        StringBuilder buffer = new StringBuilder();
        String line = null;
        try {
            while (true) {
                if ((line = reader.readLine()) != null) {
                    suspectString = consumer.consume(line);
                    if (suspectString == null) continue;
                    buffer.append((CharSequence)suspectString);
                    if (++count != this.errorLimit) continue;
                    buffer.append("\n\nError count limit exceeded limit of ").append(this.errorLimit).append("\nStopping grepLogs to prevent filling disk.\n").append("errorcntlimit=").append(this.errorLimit).append("errors=").append(count).append("\n");
                    this.output.print(buffer.toString());
                    int n = count;
                    return n;
                    continue;
                }
                break;
            }
        }
        catch (IOException ioe) {
            if (!this.hydraMode) {
                System.err.println("ERROR: reading " + log.getAbsolutePath() + "near line " + reader.getLineNumber());
            }
            int n = count++;
            return n;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        suspectString = consumer.close();
        if (suspectString != null) {
            buffer.append((CharSequence)suspectString);
            ++count;
        }
        this.output.print(buffer.toString());
        return count;
    }

    private void findAllLogs(File search, Set logs) {
        if (search.isDirectory()) {
            File[] search2 = search.listFiles();
            if (search2 == null) {
                return;
            }
            for (int i = 0; i < search2.length; ++i) {
                this.findAllLogs(search2[i], logs);
            }
        } else {
            String path = search.getPath();
            if (logFilePattern.matcher(path).matches() && !logFileIgnorePattern.matcher(path).matches()) {
                logs.add(search);
            }
            return;
        }
    }

    private static void usage() throws GrepLogsException {
        System.err.println("Usage: java GrepLogs {<args>} <pathtoresults>/[dunit|java|query|smoke|moresmoke|perf]");
        System.err.println();
        System.err.println("-out <fname>     output file (default is stdout)");
        System.err.println("-threshold <num> number of strings to tolerate (default is 0)");
        System.err.println("-limit <num>     maximum number of errors");
        System.err.println("-repeats <num>   Stop counting after <num> hits");
        System.err.println("-type <str>      test type, one of:");
        System.err.println("   junit, dunit, java, query, smoke, moresmoke, perf");
        System.err.println("   battery.  Default based on directory name.");
        System.err.println("-hydra           Dont write to System.err");
        System.err.println("-h               this message");
        System.err.println();
        System.err.println("If the test type is unknown then batterytest type defaults will be used.");
        throw new GrepLogsException("Usage");
    }

    public static class GrepLogsException
    extends Exception {
        GrepLogsException(String msg) {
            super(msg);
        }
    }
}

