/*
 * Decompiled with CFR 0.152.
 */
package batterytest.greplogs;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LogConsumer {
    private final List expectedExceptions = new ArrayList();
    private boolean skipLogMsgs = false;
    private boolean infoMsgFlag = false;
    private int eatLines = 0;
    private boolean tmpErrFlag = false;
    private int tmpErrLines = 0;
    private boolean saveFlag = false;
    private int savelinenum = 0;
    private final List testExpectStrs;
    StringBuilder all = null;
    private int lineNumber;
    private final String fileName;
    HashMap individalErrorCount = new HashMap();
    private final int repeatLimit;
    private boolean ignoreGrepLines;
    private static final Pattern ExpectedExceptionPattern = Pattern.compile("<ExpectedException action=(add|remove)>(.*)</ExpectedException>");
    private static final Pattern IgnoreGrepLogsStartPattern = Pattern.compile("<IgnoreGrepLogsStart/>");
    private static final Pattern IgnoreGrepLogsEndPattern = Pattern.compile("<IgnoreGrepLogsStop/>");
    private static final Pattern logPattern = Pattern.compile("^\\[(?:error|severe|warning|info|fine)");
    private static final Pattern blankPattern = Pattern.compile("^\\s*$");
    private static final Pattern infoOrFinePattern = Pattern.compile("^\\[(?:info|fine)");
    private static final Pattern severeOrErrorPattern = Pattern.compile("^\\[(?:severe|error)");
    private static final Pattern causedByPattern = Pattern.compile("Caused by");
    private static final Pattern shortErrPattern = Pattern.compile("^\\[[^\\]]+\\](.*)$", 40);
    private static final Pattern wroteExceptionPattern = Pattern.compile("\\[fine.*Wrote exception:");
    private static final Pattern rmiWarnPattern = Pattern.compile("^WARNING: Failed to .*java.rmi.ConnectException: Connection refused to host: .*; nested exception is:");
    private static final Pattern javaLangErrorPattern = Pattern.compile("^java\\.lang\\.\\S+Error$");
    private static final Pattern exceptionPattern = Pattern.compile("Exception:");
    private static final Pattern exceptionPattern2 = Pattern.compile("( [\\w\\.]+Exception: (([\\S]+ ){0,6}))");
    private static final Pattern exceptionPattern3 = Pattern.compile("( [\\w\\.]+Exception)$");
    private static final Pattern exceptionPattern4 = Pattern.compile("^([^:]+: (([\\w\"]+ ){0,6}))");
    private static final Pattern misformatedI18nMessagePattern = Pattern.compile("[^\\d]\\{\\d+\\}");
    private static final Pattern rvvBitSetMessagePattern = Pattern.compile("RegionVersionVector.+bsv\\d+.+bs=\\{\\d+\\}");
    private static final Pattern joinOrderMessagePattern = Pattern.compile("^\\s*(Considering|Remembering) join order");
    private static int ERROR_BUFFER_LIMIT = 50;

    public LogConsumer(boolean skipLogMsgs, List testExpectStrs, String fileName, int repeatLimit) {
        this.skipLogMsgs = skipLogMsgs;
        this.testExpectStrs = testExpectStrs;
        this.fileName = fileName;
        this.repeatLimit = repeatLimit;
    }

    public StringBuilder consume(CharSequence line) {
        Matcher i;
        ++this.lineNumber;
        Matcher m = ExpectedExceptionPattern.matcher(line);
        if (m.find()) {
            if (m.group(1).equals("add")) {
                this.expectedExceptions.add(Pattern.compile(m.group(2)));
            } else {
                this.expectedExceptions.remove(Pattern.compile(m.group(2)));
            }
            return null;
        }
        if (this.ignoreGrepLines) {
            i = IgnoreGrepLogsEndPattern.matcher(line);
            if (i.find()) {
                this.ignoreGrepLines = false;
            }
            return null;
        }
        i = IgnoreGrepLogsStartPattern.matcher(line);
        if (i.find()) {
            this.ignoreGrepLines = true;
            return null;
        }
        if (this.skipLogMsgs) {
            if (this.infoMsgFlag) {
                if (logPattern.matcher(line).find()) {
                    this.infoMsgFlag = false;
                } else {
                    if (blankPattern.matcher(line).matches()) {
                        this.infoMsgFlag = false;
                        return null;
                    }
                    return null;
                }
            }
            if (infoOrFinePattern.matcher(line).find()) {
                this.infoMsgFlag = true;
                return null;
            }
        }
        if (this.eatLines != 0) {
            --this.eatLines;
            return null;
        }
        if (this.saveFlag || severeOrErrorPattern.matcher(line).find()) {
            if (!this.saveFlag) {
                this.saveFlag = true;
                this.tmpErrFlag = true;
                if (this.checkExpectedStrs(line, this.expectedExceptions)) {
                    this.saveFlag = false;
                    this.tmpErrFlag = false;
                    this.tmpErrLines = 0;
                }
                if (this.tmpErrFlag) {
                    this.tmpErrLines = 1;
                    this.all = new StringBuilder(line);
                    this.all.append("\n");
                    this.savelinenum = this.lineNumber;
                }
            } else {
                if (causedByPattern.matcher(line).find()) {
                    this.tmpErrFlag = false;
                    this.tmpErrLines = 0;
                    this.saveFlag = false;
                    StringBuilder buffer = new StringBuilder();
                    buffer.append("-----------------------------------------------------------------------\n");
                    buffer.append("Found suspect string in ").append(this.fileName).append(" at line ").append(this.savelinenum).append("\n\n").append(this.all.toString());
                    return buffer;
                }
                if (this.checkExpectedStrs(line, this.expectedExceptions)) {
                    this.tmpErrFlag = false;
                    this.tmpErrLines = 0;
                    this.saveFlag = false;
                }
                if (blankPattern.matcher(line).matches()) {
                    this.saveFlag = false;
                    m = shortErrPattern.matcher(this.all.toString());
                    if (m.matches()) {
                        String shortName = m.group(1);
                        Integer i2 = (Integer)this.individalErrorCount.get(shortName);
                        Integer occurances = new Integer(i2 == null ? 1 : i2 + 1);
                        this.individalErrorCount.put(shortName, occurances);
                        return this.enforceErrorLimit(occurances, this.all.toString(), this.savelinenum, this.fileName);
                    }
                    return this.enforceErrorLimit(1, this.all.toString(), this.lineNumber, this.fileName);
                }
                if (this.tmpErrFlag) {
                    if (this.tmpErrLines < ERROR_BUFFER_LIMIT) {
                        ++this.tmpErrLines;
                        this.all.append(line).append("\n");
                    }
                    if (this.tmpErrLines == ERROR_BUFFER_LIMIT) {
                        ++this.tmpErrLines;
                        this.all.append("GrepLogs: ERROR_BUFFER_LIMIT limit reached,").append(" the error was too long to display completely.\n");
                    }
                }
            }
        } else if (wroteExceptionPattern.matcher(line).find() || rmiWarnPattern.matcher(line).find()) {
            this.eatLines = 1;
        } else if (!(!exceptionPattern.matcher(line).find() && !javaLangErrorPattern.matcher(line).find() && (!misformatedI18nMessagePattern.matcher(line).find() || infoOrFinePattern.matcher(line).find() && rvvBitSetMessagePattern.matcher(line).find() && joinOrderMessagePattern.matcher(line).find()) || this.checkExpectedStrs(line, this.expectedExceptions))) {
            Matcher m2 = exceptionPattern2.matcher(line);
            Matcher m3 = exceptionPattern3.matcher(line);
            Matcher m4 = exceptionPattern4.matcher(line);
            String shortName = "";
            if (m2.find()) {
                shortName = m2.group(1);
            } else if (m3.find()) {
                shortName = m3.group(1);
            } else if (m4.find()) {
                shortName = m4.group(1);
            }
            Integer i3 = (Integer)this.individalErrorCount.get(shortName);
            Integer occurances = new Integer(i3 == null ? 1 : i3 + 1);
            this.individalErrorCount.put(shortName, occurances);
            return this.enforceErrorLimit(occurances, line + "\n", this.lineNumber, this.fileName);
        }
        return null;
    }

    public StringBuilder close() {
        if (this.saveFlag) {
            this.saveFlag = false;
            StringBuilder buffer = new StringBuilder();
            buffer.append("\n-----------------------------------------------------------------------\n").append("Found suspect string in ").append(this.fileName).append(" at line ").append(this.savelinenum).append("\n\n").append((CharSequence)this.all);
            return buffer;
        }
        return null;
    }

    private boolean checkExpectedStrs(CharSequence line, List expectedExceptions) {
        Pattern p;
        int i;
        for (i = 0; i < expectedExceptions.size(); ++i) {
            p = (Pattern)expectedExceptions.get(i);
            if (!p.matcher(line).find()) continue;
            return true;
        }
        for (i = 0; i < this.testExpectStrs.size(); ++i) {
            p = (Pattern)this.testExpectStrs.get(i);
            if (!p.matcher(line).find()) continue;
            return true;
        }
        return false;
    }

    private StringBuilder enforceErrorLimit(int hits, String line, int linenum, String filename) {
        if (hits <= this.repeatLimit) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("-----------------------------------------------------------------------\n").append("Found suspect string in ").append(filename).append(" at line ").append(linenum).append("\n\n").append(line).append("\n");
            return buffer;
        }
        if (hits == this.repeatLimit) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("\n\nHit occurrence limit of ").append(hits).append(" for this string.\n").append("Further reporting of this type of error will be suppressed.\n");
            return buffer;
        }
        return null;
    }
}

