/*
 * Decompiled with CFR 0.152.
 */
package batterytest.greplogs;

import batterytest.greplogs.ExpectedStrings;
import batterytest.greplogs.LogConsumer;
import com.gemstone.gemfire.InternalGemFireError;
import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.util.List;
import java.util.regex.Pattern;

public class SuspectGrepOutputStream
extends FilterOutputStream {
    private final LogConsumer suspectGrepper;
    private final String lineSeparator = System.getProperty("line.separator");
    private final Pattern newLinePattern = Pattern.compile(this.lineSeparator);
    CharBuffer charBuf = CharBuffer.allocate(8192);
    private final CharsetDecoder decoder;
    private StringBuilder suspectStrings;
    private StringBuilder currentLine;
    private ByteBuffer leftover;

    public SuspectGrepOutputStream(OutputStream out, String fileName, int repeatLimit, String type, Charset charset) {
        super(out);
        boolean skipLogMsgs = ExpectedStrings.skipLogMsgs(type);
        List testExpectStrs = ExpectedStrings.create(type);
        this.suspectGrepper = new LogConsumer(skipLogMsgs, testExpectStrs, fileName, repeatLimit);
        this.decoder = charset.newDecoder();
    }

    private void consumeLn(CharSequence x) {
        StringBuilder suspect = this.suspectGrepper.consume(x);
        if (suspect != null) {
            if (this.suspectStrings == null) {
                this.suspectStrings = new StringBuilder();
            }
            this.suspectStrings.append((CharSequence)suspect);
            this.suspectStrings.append("\n\toccurred at ").append(SuspectGrepOutputStream.getStackTrace(new Exception()));
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(int b) throws IOException {
        super.write(b);
        this.consumeBytes(new byte[]{(byte)b}, 0, 1);
    }

    @Override
    public void write(byte[] buf, int off, int len) throws IOException {
        this.out.write(buf, off, len);
        this.consumeBytes(buf, off, len);
    }

    private void consumeBytes(byte[] buf, int off, int len) {
        ByteBuffer bytesIn;
        this.charBuf.clear();
        if (this.leftover != null) {
            bytesIn = ByteBuffer.allocate(this.leftover.capacity() + len);
            bytesIn.put(this.leftover);
            bytesIn.put(buf, off, len);
            this.leftover = null;
        } else {
            bytesIn = ByteBuffer.wrap(buf, off, len);
        }
        CoderResult result = CoderResult.OVERFLOW;
        while (result == CoderResult.OVERFLOW) {
            result = this.decoder.decode(bytesIn, this.charBuf, false);
            if (result.isError()) {
                throw new InternalGemFireError("Unable to decode system out to check for suspect strings: " + result);
            }
            this.charBuf.flip();
            this.consumeString(this.charBuf.slice());
            if (!result.isUnderflow() || bytesIn.remaining() <= 0) continue;
            this.leftover = bytesIn.slice();
        }
    }

    private void consumeString(CharSequence sequence) {
        boolean endsWithLF = this.endsWithLF(sequence);
        String[] lines = this.newLinePattern.split(sequence);
        for (int i = 0; i < lines.length; ++i) {
            if (i == lines.length - 1 && !endsWithLF) {
                if (this.currentLine == null) {
                    this.currentLine = new StringBuilder();
                }
                this.currentLine.append(lines[i]);
                continue;
            }
            if (this.currentLine != null) {
                this.currentLine.append(lines[i]);
                this.consumeLn(this.currentLine);
                this.currentLine = null;
                continue;
            }
            this.consumeLn(lines[i]);
        }
    }

    private boolean endsWithLF(CharSequence sequence) {
        if (sequence.length() < this.lineSeparator.length()) {
            return false;
        }
        for (int i = 1; i <= this.lineSeparator.length(); ++i) {
            char seqChar;
            char lsChar = this.lineSeparator.charAt(this.lineSeparator.length() - i);
            if (lsChar == (seqChar = sequence.charAt(sequence.length() - i))) continue;
            return false;
        }
        return true;
    }

    public String getAndClearSuspects() {
        if (this.suspectStrings == null) {
            return null;
        }
        String result = this.suspectStrings.toString();
        this.suspectStrings = null;
        return result;
    }

    public static String getStackTrace(Throwable x) {
        if (x == null) {
            return null;
        }
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        PrintStream writer = new PrintStream(bout);
        x.printStackTrace(writer);
        String result = new String(bout.toByteArray());
        return result;
    }
}

