/*
 * Decompiled with CFR 0.152.
 */
package cacheLoader.hc;

import cacheLoader.hc.BridgeParms;
import cacheLoader.hc.DBParms;
import cacheLoader.hc.Util;
import com.gemstone.gemfire.cache.CacheLoader;
import com.gemstone.gemfire.cache.LoaderHelper;
import hydra.HydraRuntimeException;
import hydra.Log;
import hydra.MasterController;
import hydra.TestConfig;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import oracle.jdbc.pool.OracleDataSource;
import util.TestException;
import util.TestHelper;

public class DBCacheLoader
implements CacheLoader {
    private OracleDataSource cachedDS;

    public void init() {
        this.cachedDS = this.createConnectionPool();
    }

    private OracleDataSource createConnectionPool() {
        try {
            OracleDataSource ds = new OracleDataSource();
            ds.setConnectionCacheName("oraCache");
            ds.setConnectionCachingEnabled(true);
            ds.setURL(TestConfig.tab().stringAt(DBParms.jdbcUrl));
            ds.setUser(TestConfig.tab().stringAt(DBParms.rdbUser));
            ds.setPassword(TestConfig.tab().stringAt(DBParms.rdbPassword));
            Properties cacheProps = new Properties();
            cacheProps.setProperty("MinLimit", String.valueOf(TestConfig.tab().intAt(DBParms.poolMinLimit)));
            ds.setConnectionCacheProperties(cacheProps);
            return ds;
        }
        catch (Exception ex) {
            Log.getLogWriter().info("Unable to create connection pool: " + ex, (Throwable)ex);
            throw new HydraRuntimeException("Problem creating connection pool", ex);
        }
    }

    public Object load(LoaderHelper helper) {
        byte[] value;
        int sleepMs = DBParms.getSleepMs();
        int key = Integer.parseInt((String)helper.getKey());
        boolean logDetails = BridgeParms.getLogDetails();
        if (sleepMs > 0) {
            if (logDetails) {
                Log.getLogWriter().info("Sleeping for " + sleepMs + " ms instead of looking up key " + key);
            }
            MasterController.sleepForMs(sleepMs);
            value = Util.intTObytes(key);
        } else {
            try {
                if (logDetails) {
                    Log.getLogWriter().info("DBCacheLoader trying to getBlob for " + key);
                }
                Connection conn = this.cachedDS.getConnection();
                value = Util.getBlob(conn, key);
                conn.close();
            }
            catch (SQLException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
        }
        return value;
    }

    public void close() {
    }
}

