/*
 * Decompiled with CFR 0.152.
 */
package cacheLoader.hc;

import cacheLoader.hc.BridgeParms;
import cacheLoader.hc.DBParms;
import com.gemstone.gemfire.cache.Region;
import hydra.Log;
import hydra.TestConfig;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import oracle.jdbc.OracleResultSet;
import oracle.sql.BLOB;
import util.TestException;
import util.TestHelper;

public class Util {
    private static final String lb = "[";
    private static final String rb = "]";

    public static void registerDriver() {
        String driverName = TestConfig.tab().stringAt(DBParms.jdbcDriver);
        Log.getLogWriter().info("Registering " + driverName);
        try {
            DriverManager.registerDriver((Driver)Class.forName(driverName).newInstance());
        }
        catch (Exception e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
    }

    public static synchronized void reloadTableTask() {
        Util.registerDriver();
        Util utilWorker = new Util();
        utilWorker.reCreateTable();
        utilWorker.preLoadTable();
        utilWorker.dumpTable();
    }

    public void reCreateTable() {
        String tableName = DBParms.getTableName();
        String dropTable1 = "DROP TABLE " + tableName;
        String createTable1 = "CREATE TABLE " + tableName + " (key " + DBParms.getKeyColumnType() + ", value " + DBParms.getValueColumnType() + ")";
        String dropSeq = "DROP SEQUENCE KEY_SEQ";
        String createSeq = "CREATE SEQUENCE KEY_SEQ START WITH 1";
        try {
            Connection conn = Util.getUnpooledConnection();
            Statement stmt = conn.createStatement();
            Log.getLogWriter().info("Executing " + dropTable1);
            try {
                stmt.execute(dropTable1);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            Log.getLogWriter().info("Executing " + dropSeq);
            try {
                stmt.execute(dropSeq);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            conn.commit();
            Log.getLogWriter().info("Executing " + createTable1);
            stmt.execute(createTable1);
            Log.getLogWriter().info("Executing " + createSeq);
            stmt.execute(createSeq);
            conn.commit();
            stmt.close();
            conn.close();
        }
        catch (SQLException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
    }

    public void preLoadTable() {
        String tableName = DBParms.getTableName();
        boolean validate = BridgeParms.getValidate();
        try {
            Connection conn = Util.getUnpooledConnection();
            conn.setAutoCommit(false);
            PreparedStatement pstmt = conn.prepareStatement("INSERT INTO " + tableName + " VALUES (KEY_SEQ.NEXTVAL, ?)");
            int numPreload = TestConfig.tab().intAt(DBParms.numPreload);
            Log.getLogWriter().info("Inserting " + numPreload + " rows into " + tableName);
            for (int i = 0; i < numPreload; ++i) {
                if (validate) {
                    pstmt.setBytes(1, this.getKeyed_arrayOfBytes(i + 1));
                } else {
                    pstmt.setBytes(1, this.getRandom_arrayOfBytes());
                }
                pstmt.executeUpdate();
                conn.commit();
            }
            pstmt.close();
            conn.close();
        }
        catch (SQLException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
    }

    public static void getRandomBlobTask() {
        int numPreload = TestConfig.tab().intAt(DBParms.numPreload);
        int key = TestConfig.tab().getRandGen().nextInt(numPreload - 1) + 1;
        byte[] data = Util.getBlob(key);
        byte[] initialBytes = new byte[5];
        if (data.length == 0) {
            Log.getLogWriter().info("No blob found for " + key);
        } else {
            for (int i = 0; i < 5; ++i) {
                initialBytes[i] = data[i];
            }
            if (DBParms.getDriverLogging()) {
                Log.getLogWriter().info("Retrieved blob for " + key + " containing " + data.length + " bytes" + " beginning with " + initialBytes);
            }
        }
    }

    public static synchronized void HydraTask_dumpTable() {
        Util.registerDriver();
        Util utilWorker = new Util();
        utilWorker.dumpTable();
    }

    protected void dumpTable() {
        int numPreload = TestConfig.tab().intAt(DBParms.numPreload);
        for (int i = 1; i <= numPreload; ++i) {
            Util.getBlob(i);
        }
    }

    public static byte[] getBlob(int key) {
        byte[] data;
        try {
            Connection conn = Util.getUnpooledConnection();
            data = Util.getBlob(conn, key);
            conn.close();
        }
        catch (SQLException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        return data;
    }

    public static byte[] getBlob(Connection conn, int key) {
        byte[] data;
        block7: {
            String tableName = DBParms.getTableName();
            String selectBlob = "SELECT value FROM " + tableName + " WHERE key ='" + key + "'";
            try {
                Statement stmt = conn.createStatement();
                try {
                    if (DBParms.getDriverLogging()) {
                        Log.getLogWriter().info("getBlob executing " + selectBlob);
                    }
                    ResultSet rs = stmt.executeQuery(selectBlob);
                    rs.next();
                    BLOB blob = (BLOB)((OracleResultSet)rs).getBlob(1);
                    int len = (int)blob.length();
                    data = blob.getBytes(1L, len);
                    if (!DBParms.getDriverLogging()) break block7;
                    if (data.length == 0) {
                        Log.getLogWriter().info("No value found for " + key);
                        break block7;
                    }
                    StringBuffer aStr = new StringBuffer();
                    for (int j = 0; j < 4; ++j) {
                        aStr.append("   initialBytes[" + j + "] = " + data[j] + "\n");
                    }
                    Log.getLogWriter().info("Retrieved value for " + key + " containing " + len + " bytes" + " beginning with \n" + aStr.toString());
                }
                catch (SQLException e) {
                    data = new byte[]{};
                    Log.getLogWriter().info(TestHelper.getStackTrace(e));
                }
            }
            catch (SQLException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
        }
        return data;
    }

    public byte[] getRandom_arrayOfBytes() {
        int arraySize = TestConfig.tab().intAt(DBParms.numBytes);
        byte[] byteArr = new byte[arraySize];
        TestConfig.tab().getRandGen().nextBytes(byteArr);
        return byteArr;
    }

    public byte[] getKeyed_arrayOfBytes(int key) {
        int arraySize = TestConfig.tab().intAt(DBParms.numBytes);
        if (arraySize < 4) {
            throw new TestException("Cannot insert keyed byte value into " + arraySize + " length byte array");
        }
        byte[] byteArr = new byte[arraySize];
        TestConfig.tab().getRandGen().nextBytes(byteArr);
        byte[] keyBytes = Util.intTObytes(key);
        StringBuffer aStr = new StringBuffer();
        aStr.append("getKeyed_arrayOfBytes returns \n");
        for (int i = 0; i < 4; ++i) {
            byteArr[i] = keyBytes[i];
            aStr.append("   keyBytes[" + i + "] = " + keyBytes[i] + "\n");
        }
        if (DBParms.getDriverLogging()) {
            Log.getLogWriter().info(aStr.toString());
        }
        return byteArr;
    }

    public static Connection getUnpooledConnection() {
        try {
            String url = TestConfig.tab().stringAt(DBParms.jdbcUrl);
            String user = TestConfig.tab().stringAt(DBParms.rdbUser);
            String password = TestConfig.tab().stringAt(DBParms.rdbPassword);
            return DriverManager.getConnection(url, user, password);
        }
        catch (SQLException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
    }

    protected static String log(Region region, Object key) {
        return region.getFullPath() + lb + key + rb;
    }

    protected static String log(Region region, Object key, Object value) {
        return Util.log(region, key) + " = " + value;
    }

    protected static byte[] intTObytes(int i) {
        byte[] byteArray = new byte[]{(byte)((i & 0xFF000000) >>> 24), (byte)((i & 0xFF0000) >>> 16), (byte)((i & 0xFF00) >>> 8), (byte)(i & 0xFF)};
        return byteArray;
    }

    protected static int bytesTOint(byte[] byteArray) {
        int i = (byteArray[0] & 0xFF) << 24 | (byteArray[1] & 0xFF) << 16 | (byteArray[2] & 0xFF) << 8 | byteArray[3] & 0xFF;
        return i;
    }
}

