/*
 * Decompiled with CFR 0.152.
 */
package cacheLoader.smoke;

import cacheLoader.smoke.BB;
import cacheLoader.smoke.Loader;
import cacheLoader.smoke.ObjectListener;
import cacheLoader.smoke.TestParms;
import cacheLoader.smoke.Util;
import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.CacheLoader;
import com.gemstone.gemfire.cache.CacheWriter;
import com.gemstone.gemfire.cache.EntryNotFoundException;
import com.gemstone.gemfire.cache.ExpirationAction;
import com.gemstone.gemfire.cache.ExpirationAttributes;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.RegionExistsException;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.TimeoutException;
import hydra.HydraRuntimeException;
import hydra.HydraThreadLocal;
import hydra.Log;
import hydra.MasterController;
import hydra.Prms;
import hydra.RemoteTestModule;
import hydra.TestConfig;
import hydra.blackboard.SharedCounters;
import java.rmi.RemoteException;
import util.CacheBB;
import util.CacheUtil;
import util.TestHelper;

public class Client
extends Util {
    protected static HydraThreadLocal localClientInstance = new HydraThreadLocal();
    protected int tid;
    protected int threadReadTime;
    protected int threadNumTimedReads;
    protected int threadPutTime;
    protected int threadNumTimedPuts;

    public static void initClientTask() {
        Client clientInstance = new Client();
        localClientInstance.set(clientInstance);
        clientInstance.tid = RemoteTestModule.getCurrentThread().getThreadId();
        clientInstance.threadReadTime = 0;
        clientInstance.threadNumTimedReads = 0;
        clientInstance.threadPutTime = 0;
        clientInstance.threadNumTimedPuts = 0;
    }

    public static synchronized void defineCacheRegions() {
        Client.thisClient().defineCacheRegions(TestParms.getDefineCacheLoader());
    }

    public static synchronized void closeCacheTask() {
        Client.thisClient().closeCache();
    }

    public static synchronized void initializeDataTask() {
        Client.thisClient().initializeData();
    }

    public static void readTask() {
        for (int i = 0; i < TestParms.getReadIterations(); ++i) {
            Client.thisClient().read();
        }
    }

    public static void updateTask() {
        Client.thisClient().update();
    }

    public static void summarizeClientTask() {
        if (Client.thisClient().threadNumTimedReads > 0) {
            Log.getLogWriter().info("Average time for region.get(CachedData) calls in slave " + Client.thisClient().tid + " = " + (double)Client.thisClient().threadReadTime / ((double)Client.thisClient().threadNumTimedReads * 1.0) + " milliseconds (" + Client.thisClient().threadNumTimedReads + " data points)");
        }
        if (Client.thisClient().threadNumTimedPuts > 0) {
            Log.getLogWriter().info("Average time for region.put(MasterData) calls in slave " + Client.thisClient().tid + " = " + (double)Client.thisClient().threadPutTime / ((double)Client.thisClient().threadNumTimedPuts * 1.0) + " milliseconds (" + Client.thisClient().threadNumTimedPuts + " data points)");
        }
    }

    public static synchronized void verifyResultsTask() {
        Client.thisClient().verifyResults(true);
    }

    public static synchronized void verifyFinalResultsTask() {
        Client.thisClient().verifyResults(false);
    }

    private void defineCacheRegions(boolean defineCacheLoader) {
        if (CacheUtil.getCache() == null) {
            Log.getLogWriter().info("Creating the cache");
            Cache cache = CacheUtil.createCache();
            cache.setLockTimeout(TestParms.getLockTimeout());
            cache.setSearchTimeout(TestParms.getSearchTimeout());
            AttributesFactory factory = new AttributesFactory();
            factory.setScope(CacheBB.getBB().getScopeAttribute());
            factory.setRegionTimeToLive(ExpirationAttributes.DEFAULT);
            factory.setRegionIdleTimeout(ExpirationAttributes.DEFAULT);
            factory.setMirrorType(CacheBB.getBB().getMirrorAttribute());
            RegionAttributes regAttrs = factory.createRegionAttributes();
            Region parent = CacheUtil.createRegion("CacheLoaderTest", regAttrs);
            try {
                Region master = parent.createSubregion("MasterData", regAttrs);
            }
            catch (RegionExistsException ex) {
                String s = "Created the cache, defined  region CacheLoaderTest";
                Log.getLogWriter().info(s);
                s = "Assuming subregions have already been mapped into cache";
                Log.getLogWriter().info(s);
                return;
            }
            ExpirationAttributes ttl = new ExpirationAttributes(TestParms.getEntryTTLSec(), TestHelper.getExpirationAction(TestParms.getEntryTTLActionString()));
            factory.setEntryTimeToLive(ttl);
            ExpirationAttributes idle = new ExpirationAttributes(TestParms.getEntryIdleTimeoutSec(), TestHelper.getExpirationAction(TestParms.getEntryIdleTimeoutActionString()));
            factory.setEntryIdleTimeout(idle);
            factory.setStatisticsEnabled(true);
            ObjectListener objEventListnr = new ObjectListener();
            factory.setCacheListener((CacheListener)objEventListnr);
            factory.setCacheWriter((CacheWriter)objEventListnr);
            if (defineCacheLoader) {
                Loader cacheLoader = new Loader();
                factory.setCacheLoader((CacheLoader)cacheLoader);
            }
            try {
                parent.createSubregion("CachedData", factory.createRegionAttributes());
            }
            catch (CacheException ex) {
                String s = "Unable to create CachedData";
                throw new HydraRuntimeException(s, (Exception)((Object)ex));
            }
            String s = "Created the cache, defined region CacheLoaderTest and defined subregions MasterData and CachedData" + (defineCacheLoader ? " (set cacheLoader)" : "");
            Log.getLogWriter().info(s);
        }
    }

    private void closeCache() {
        Log.getLogWriter().info("Closing the cache");
        CacheUtil.closeCache();
        Log.getLogWriter().info("Closed the cache");
    }

    private void initializeData() {
        Region master = this.getRootRegion().getSubregion("MasterData");
        Region cached = this.getRootRegion().getSubregion("CachedData");
        Integer initValue = new Integer(0);
        try {
            master.put((Object)"Data", (Object)initValue);
            if (master.getEntry((Object)"Data") == null) {
                String s = "MasterData/Data not yet present";
                throw new HydraRuntimeException(s);
            }
        }
        catch (Exception ex) {
            throw new HydraRuntimeException("Unable to initialize MasterData/Data with value " + initValue, ex);
        }
        try {
            cached.create((Object)"Data", null);
            cached.get((Object)"Data");
            if (!cached.containsValueForKey((Object)"Data")) {
                throw new HydraRuntimeException("CachedData/Data value not yet present");
            }
        }
        catch (CacheException ex) {
            throw new HydraRuntimeException("Unable to define CachedData/Data", (Exception)((Object)ex));
        }
    }

    private void read() {
        Integer currentValue;
        Region cached = this.getRootRegion().getSubregion("CachedData");
        long t1 = 0L;
        long t2 = 0L;
        try {
            t1 = System.currentTimeMillis();
            currentValue = (Integer)cached.get((Object)"Data");
            t2 = System.currentTimeMillis();
        }
        catch (TimeoutException e) {
            Log.getLogWriter().info("Got timeout exception - dumping stacks, lock table");
            try {
                RemoteTestModule.Master.printClientProcessStacks();
                MasterController.sleepForMs(2500);
                System.out.flush();
                System.err.flush();
            }
            catch (RemoteException ex) {
                System.err.println("While trying to dump stacks, got: " + ex);
            }
            throw new HydraRuntimeException("Unable to read CachedData/Data", (Exception)((Object)e));
        }
        catch (Exception ex) {
            throw new HydraRuntimeException("Unable to read CachedData/Data", ex);
        }
        if (TestParms.getLogDetails()) {
            Log.getLogWriter().info("Read " + Util.log(cached, "Data", currentValue));
        }
        SharedCounters counters = BB.getInstance().getSharedCounters();
        counters.increment(BB.NUM_READ_CALLS);
        if (counters.read(BB.NUM_READ_CALLS) > 100L) {
            counters.increment(BB.NUM_TIMED_READ_CALLS);
            counters.add(BB.TIME_READ_CALLS, t2 - t1);
            Client.thisClient().threadReadTime = (int)((long)Client.thisClient().threadReadTime + (t2 - t1));
            ++Client.thisClient().threadNumTimedReads;
        }
    }

    private void update() {
        Integer currentValue;
        long t1 = 0L;
        long t2 = 0L;
        Region master = this.getRootRegion().getSubregion("MasterData");
        Region cached = this.getRootRegion().getSubregion("CachedData");
        try {
            currentValue = (Integer)master.get((Object)"Data");
        }
        catch (Exception ex) {
            throw new HydraRuntimeException("Unable to read MasterData/Data", ex);
        }
        if (TestParms.getLogDetails()) {
            Log.getLogWriter().info("Read " + Util.log(master, "Data", currentValue));
        }
        Integer newValue = new Integer(currentValue + 1);
        try {
            t1 = System.currentTimeMillis();
            master.put((Object)"Data", (Object)newValue);
            t2 = System.currentTimeMillis();
        }
        catch (Exception ex) {
            throw new HydraRuntimeException("Unable to update MasterData/Data with value " + newValue, ex);
        }
        if (TestParms.getLogDetails()) {
            Log.getLogWriter().info("Updated " + Util.log(master, "Data", newValue));
        }
        SharedCounters counters = BB.getInstance().getSharedCounters();
        counters.increment(BB.NUM_INVALIDATE_UPDATE_CALLS);
        if (counters.read(BB.NUM_INVALIDATE_UPDATE_CALLS) > 100L) {
            counters.increment(BB.NUM_TIMED_PUT_CALLS);
            counters.add(BB.TIME_PUT_CALLS, t2 - t1);
            Client.thisClient().threadPutTime = (int)((long)Client.thisClient().threadPutTime + (t2 - t1));
            ++Client.thisClient().threadNumTimedPuts;
        }
        try {
            cached.invalidate((Object)"Data");
        }
        catch (EntryNotFoundException ex) {
            if (TestHelper.getExpirationAction(TestParms.getEntryIdleTimeoutActionString()) == ExpirationAction.DESTROY || TestHelper.getExpirationAction(TestParms.getEntryTTLActionString()) == ExpirationAction.DESTROY) {
                return;
            }
            String s = "CachedData/Data not found for invalidate";
            throw new HydraRuntimeException(s, (Exception)((Object)ex));
        }
        if (TestParms.getLogDetails()) {
            Log.getLogWriter().info("Invalidated " + Util.log(cached, "Data"));
        }
    }

    private void verifyResults(boolean checkDataValue) {
        Region master = this.getRootRegion().getSubregion("MasterData");
        Log.getLogWriter().info("Checking " + Util.log(master, "Data"));
        SharedCounters counters = BB.getInstance().getSharedCounters();
        BB.getInstance().printSharedCounters();
        TestParms.logParms();
        long numUpdates = counters.read(BB.NUM_INVALIDATE_UPDATE_CALLS);
        long numInvalidateCallbacks = counters.read(BB.NUM_INVALIDATE_CALLBACKS);
        long numUnloadCallbacks = counters.read(BB.NUM_UNLOAD_CALLBACKS);
        long numLoads = counters.read(BB.NUM_LOAD_CALLS);
        int idleTime = TestParms.getEntryIdleTimeoutSec();
        int ttl = TestParms.getEntryTTLSec();
        int numVMs = TestConfig.getInstance().getTotalVMs();
        int numThreads = TestConfig.getInstance().getTotalThreads();
        if (idleTime == 0 && ttl == 0 && numUpdates * (long)numVMs != numInvalidateCallbacks) {
            Log.getLogWriter().info("Number of update/invalidate calls " + numUpdates + " times number of VMs " + numVMs + " not equal to number of invalidation callbacks " + numInvalidateCallbacks);
        }
        if (checkDataValue) {
            Integer finalValue;
            try {
                finalValue = (Integer)master.get((Object)"Data");
                Log.getLogWriter().info("finalValue = " + finalValue);
            }
            catch (Exception ex) {
                throw new HydraRuntimeException("Unable to read MasterData/Data", ex);
            }
            if ((long)finalValue.intValue() != numUpdates) {
                throw new HydraRuntimeException("Number of updates " + numUpdates + " does not equal final value " + Util.log(master, "Data", finalValue));
            }
        }
        if (idleTime == 0 && ttl == 0) {
            boolean mismatch = false;
            if (numLoads < numUpdates) {
                mismatch = true;
            } else {
                Scope scope = CacheBB.getBB().getScopeAttribute();
                if (scope.equals(Scope.GLOBAL)) {
                    if (numLoads > numUpdates + 1L) {
                        mismatch = true;
                    }
                } else if (numLoads > (numUpdates + 1L) * (long)numVMs) {
                    mismatch = true;
                }
            }
            if (mismatch) {
                Log.getLogWriter().info("Number of update/invalidate calls " + numUpdates + " not consistent with number of cacheLoader invocations " + numLoads);
            }
        }
        long numReads = counters.read(BB.NUM_READ_CALLS);
        long taskTime = TestConfig.tab().longAt(Prms.totalTaskTimeSec);
        long numReadsPerThread = numUpdates == 0L ? numReads / (long)numThreads : numReads / (long)(numThreads - 1);
        if (numReadsPerThread > 0L) {
            Log.getLogWriter().info("\n   number reads per thread = " + numReadsPerThread + "\n   taskTime = " + taskTime + "\n   read task start interval = " + taskTime / numReadsPerThread);
        }
        if (numUpdates > 0L) {
            Log.getLogWriter().info("\n   write task start interval = " + taskTime / numUpdates);
        }
        long timedReads = counters.read(BB.NUM_TIMED_READ_CALLS);
        long readTime = counters.read(BB.TIME_READ_CALLS);
        if (timedReads > 0L) {
            Log.getLogWriter().info("Average time for region.get(CachedData) calls = " + (double)readTime / ((double)timedReads * 1.0) + " milliseconds (" + timedReads + " data points)");
        }
        long timedPuts = counters.read(BB.NUM_TIMED_PUT_CALLS);
        long putTime = counters.read(BB.TIME_PUT_CALLS);
        if (timedPuts > 0L) {
            Log.getLogWriter().info("Average time for region.put(MasterData) calls = " + (double)putTime / ((double)timedPuts * 1.0) + " milliseconds (" + timedPuts + " data points)");
        }
        Log.getLogWriter().info("Checked " + Util.log(master, "Data"));
    }

    protected static Client thisClient() {
        Object lci = localClientInstance.get();
        if (lci == null) {
            return new Client();
        }
        return (Client)lci;
    }

    protected Region getRootRegion() {
        return CacheUtil.getRegion("CacheLoaderTest");
    }
}

