/*
 * Decompiled with CFR 0.152.
 */
package cacheServer.hct;

import hydra.CacheHelper;
import hydra.CacheServerHelper;
import hydra.ConfigPrms;
import hydra.GemFireDescription;
import hydra.HydraRuntimeException;
import hydra.Log;
import hydra.RemoteTestModule;
import hydra.TestConfig;

public class RandInterestPolicyTest
extends hct.RandInterestPolicyTest {
    private static final String cacheServerStr = "cacheserver";

    public static void InitTask_startCacheServer() {
        if (testInstance == null) {
            testInstance = new RandInterestPolicyTest();
            ((RandInterestPolicyTest)testInstance).startCacheServer();
        }
        RandInterestPolicyTest.testInstance.ownKeysIndex.set(new Integer(RemoteTestModule.getCurrentThread().getThreadId()));
    }

    protected void startCacheServer() {
        String xmlFileName;
        String serverName;
        String clientName;
        block2: {
            int myVmid = RemoteTestModule.getMyVmid();
            clientName = RemoteTestModule.getMyClientName();
            serverName = "vm_" + myVmid + "_" + clientName + "_" + cacheServerStr;
            xmlFileName = serverName + ".xml";
            try {
                CacheHelper.generateCacheXmlFile(ConfigPrms.getCacheConfig(), null, ConfigPrms.getRegionConfig(), null, ConfigPrms.getBridgeConfig(), null, ConfigPrms.getDiskStoreConfig(), null, xmlFileName);
            }
            catch (HydraRuntimeException e) {
                String errStr = e.toString();
                if (errStr.indexOf("Cache XML file was already created") >= 0) break block2;
                throw e;
            }
        }
        Log.getLogWriter().info("Starting up cacheServer " + serverName + " with cache.xml file " + xmlFileName);
        GemFireDescription gfd = TestConfig.getInstance().getClientDescription(clientName).getGemFireDescription();
        String offHeapMemorySize = gfd.getOffHeapMemorySize();
        String[] extraArgs = null;
        extraArgs = offHeapMemorySize != null ? new String[]{" off-heap-memory-size=" + offHeapMemorySize} : new String[]{};
        CacheServerHelper.startCacheServer(serverName, xmlFileName, extraArgs);
    }

    public static void HydraTask_stopCacheServer() {
        ((RandInterestPolicyTest)testInstance).stopCacheServer();
    }

    public void stopCacheServer() {
        int myVmid = RemoteTestModule.getMyVmid();
        String clientName = RemoteTestModule.getMyClientName();
        String serverName = "vm_" + myVmid + "_" + clientName + "_" + cacheServerStr;
        CacheServerHelper.stopCacheServer(serverName);
    }
}

