/*
 * Decompiled with CFR 0.152.
 */
package cacheperf;

import cacheperf.CachePerfBlackboard;
import cacheperf.CachePerfClientVersion;
import cacheperf.CachePerfException;
import cacheperf.CachePerfPrms;
import cacheperf.CachePerfStats;
import cacheperf.ScrambledZipfianGenerator;
import cacheperf.TaskSyncBlackboard;
import cacheperf.ZipfianGenerator;
import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.admin.AdminDistributedSystem;
import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.CacheTransactionManager;
import com.gemstone.gemfire.cache.DiskStore;
import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.EntryNotFoundException;
import com.gemstone.gemfire.cache.InterestResultPolicy;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.RegionEvent;
import com.gemstone.gemfire.cache.client.Pool;
import com.gemstone.gemfire.cache.client.PoolFactory;
import com.gemstone.gemfire.cache.client.internal.PoolImpl;
import com.gemstone.gemfire.cache.control.RebalanceFactory;
import com.gemstone.gemfire.cache.control.RebalanceOperation;
import com.gemstone.gemfire.cache.control.RebalanceResults;
import com.gemstone.gemfire.cache.query.IndexExistsException;
import com.gemstone.gemfire.cache.query.IndexNameConflictException;
import com.gemstone.gemfire.cache.query.IndexType;
import com.gemstone.gemfire.cache.query.Query;
import com.gemstone.gemfire.cache.query.QueryException;
import com.gemstone.gemfire.cache.query.SelectResults;
import com.gemstone.gemfire.cache.query.Struct;
import com.gemstone.gemfire.cache.util.CacheListenerAdapter;
import com.gemstone.gemfire.cache.util.Gateway;
import com.gemstone.gemfire.cache.util.GatewayHub;
import com.gemstone.gemfire.cache.wan.GatewaySender;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.NanoTimer;
import com.gemstone.gemfire.internal.cache.RegionQueue;
import com.gemstone.gemfire.internal.cache.wan.AbstractGatewaySender;
import distcache.DistCache;
import distcache.DistCacheException;
import distcache.DistCacheFactory;
import distcache.DistCachePrms;
import distcache.gemfire.GemFireCachePrms;
import distcache.gemfire.GemFireCacheTestImpl;
import distcache.hashmap.HashMapCacheImpl;
import hydra.BasePrms;
import hydra.CacheDescription;
import hydra.CacheHelper;
import hydra.ClientDescription;
import hydra.ClientVmInfo;
import hydra.ClientVmMgr;
import hydra.ClientVmNotFoundException;
import hydra.ConfigPrms;
import hydra.DistributedSystemHelper;
import hydra.EdgeHelper;
import hydra.FileUtil;
import hydra.GatewayHubHelper;
import hydra.GatewayReceiverHelper;
import hydra.GatewaySenderHelper;
import hydra.GsRandom;
import hydra.HydraConfigException;
import hydra.HydraInternalException;
import hydra.HydraRuntimeException;
import hydra.HydraThreadGroup;
import hydra.HydraThreadLocal;
import hydra.Log;
import hydra.MasterController;
import hydra.MethExecutor;
import hydra.PoolHelper;
import hydra.ProcessMgr;
import hydra.RegionDescription;
import hydra.RegionHelper;
import hydra.RemoteTestModule;
import hydra.StopSchedulingTaskOnClientOrder;
import hydra.TestConfig;
import hydra.TestTask;
import hydra.blackboard.AnyCyclicBarrier;
import hydra.blackboard.SharedCounters;
import hydra.blackboard.SharedMap;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import objects.BatchString;
import objects.BatchStringPrms;
import objects.ObjectHelper;
import perffmwk.HistogramStats;
import perffmwk.HistogramStatsPrms;
import perffmwk.PerfStatMgr;
import perffmwk.TrimInterval;
import util.AdminHelper;
import util.StopStartVMs;
import util.TestException;
import util.TestHelper;

public class CachePerfClient {
    private static final Object closeCacheLock = new Object();
    protected static final int DATASTORECACHEOPENS = 100;
    protected static final int ACCESSORCACHEOPENS = 101;
    protected static final int CACHEOPENS = 0;
    protected static final int CREATES = 1;
    protected static final int CREATEKEYS = 2;
    protected static final int PUTS = 3;
    protected static final int GETS = 4;
    protected static final int PUTSCOMPARISON = 5;
    protected static final int GETSCOMPARISON = 6;
    protected static final int DESTROYS = 7;
    protected static final int CREATEGETS = 8;
    protected static final int PUTGETS = 9;
    protected static final int USECASE12_UPDATES = 10;
    protected static final int COMBINEDPUTGETS = 11;
    protected static final int REGISTERINTERESTS = 12;
    protected static final int OPS = 13;
    protected static final int CONNECTS = 14;
    protected static final int QUERIES = 15;
    protected static final int LOCKS = 16;
    protected static final int UPDATES = 17;
    protected static final int EXTRA_PUTS = 18;
    protected static final int EXTRA_GETS = 19;
    protected static final int SLEEP = 20;
    protected static final String OPS_NAME = "operations";
    protected static final String DATASTORECACHEOPENS_NAME = "dataStoreCacheOpens";
    protected static final String ACCESSORCACHEOPENS_NAME = "accessorCacheOpens";
    protected static final String CACHEOPENS_NAME = "cacheOpens";
    protected static final String SLEEP_NAME = "sleep";
    protected static final String CREATES_NAME = "creates";
    protected static final String CREATEKEYS_NAME = "createKeys";
    protected static final String PUTS_NAME = "puts";
    protected static final String GETS_NAME = "gets";
    protected static final String PUTSCOMPARISON_NAME = "putsComparison";
    protected static final String GETSCOMPARISON_NAME = "getsComparison";
    protected static final String DESTROYS_NAME = "destroys";
    protected static final String CREATEGETS_NAME = "creategets";
    protected static final String PUTGETS_NAME = "putgets";
    protected static final String USECASE12_UPDATES_NAME = "useCase12Updates";
    protected static final String COMBINEDPUTGETS_NAME = "combinedputgets";
    protected static final String REGISTERINTERESTS_NAME = "registerInterests";
    protected static final String CONNECTS_NAME = "connects";
    protected static final String QUERIES_NAME = "queries";
    protected static final String LOCKS_NAME = "locks";
    protected static final String UPDATES_NAME = "updates";
    protected static final String EXTRA_PUTS_NAME = "extraPuts";
    protected static final String EXTRA_GETS_NAME = "extraGets";
    private static HydraThreadLocal localentrymap = new HydraThreadLocal();
    private static final int INTEREST_KEY = 0;
    private static final int INTEREST_LIST = 1;
    private static HydraThreadLocal cycleDistributedSystemConnectionProperties = new HydraThreadLocal();
    private static HydraThreadLocal cycleDistributedSystemConnectionCounters = new HydraThreadLocal();
    private static HydraThreadLocal cyclePoolFactory = new HydraThreadLocal();
    private static HydraThreadLocal cycleBridgeConnectionCache = new HydraThreadLocal();
    private static HydraThreadLocal cycleBridgeConnectionFactory = new HydraThreadLocal();
    public int trimInterval = -1;
    public int jid;
    public int tid;
    public int tgid;
    public int ttgid;
    public int sttgid;
    public int numWanSites;
    public int numThreads;
    public int iterationsSinceTxEnd;
    public List interestListBatch;
    public int batchCount;
    public long batchStartTime;
    public boolean hadFullSizeTx;
    public int trimIterations;
    public int workIterations;
    public int numOperations;
    public int batchSize;
    public int trimSeconds;
    public int workSeconds;
    public int batchSeconds;
    public int syncSleepMs;
    public int txSize;
    public int commitPercentage;
    public int keyAllocation;
    public int keyAllocationChunkSize;
    public int maxKeys;
    public int optimizationCount;
    public boolean isMainWorkload;
    public boolean allowNulls;
    public boolean validateObjects;
    public boolean invalidateAfterGet;
    public boolean invalidateLocally;
    public boolean destroyAfterGet;
    public boolean destroyLocally;
    public boolean sleepBeforeOp;
    public boolean useTransactions;
    public boolean allowConflicts;
    public boolean registerDurableInterest;
    public Method batchTerminator;
    public Method warmupTerminator;
    public Method taskTerminator;
    public Object[] terminatorArgs;
    public CachePerfPrms.Frequency warmupTerminatorFrequency;
    public CachePerfPrms.Frequency taskTerminatorFrequency;
    public TestTask task;
    public CachePerfStats statistics;
    public HistogramStats histogram;
    public Map trimIntervals;
    public DistCache cache;
    public CacheTransactionManager tm;
    public GsRandom rng;
    public Random keyGenerator;
    public boolean warmedUp;
    public int warmupCount;
    public long warmupTime;
    public int count;
    public long startTime;
    public int keyCount;
    public int currentKey;
    public String keyType;
    public long lastWarmupTerminatorTime;
    public long lastTaskTerminatorTime;
    public long numPseudoRandomKeys;
    public long currentSequenceNumber;
    public long currentNumPseudoRandomKeys;
    private static HydraThreadLocal localtask = new HydraThreadLocal();
    private static HydraThreadLocal localstatistics = new HydraThreadLocal();
    private static HydraThreadLocal localhistogram = new HydraThreadLocal();
    private static HydraThreadLocal localtrimintervals = new HydraThreadLocal();
    private static HydraThreadLocal localcache = new HydraThreadLocal();
    private static HydraThreadLocal localrng = new HydraThreadLocal();
    private static HydraThreadLocal localKeyGenerator = new HydraThreadLocal();
    private static HydraThreadLocal localwarmedup = new HydraThreadLocal();
    private static HydraThreadLocal localwarmupcount = new HydraThreadLocal();
    private static HydraThreadLocal localwarmuptime = new HydraThreadLocal();
    private static HydraThreadLocal localcount = new HydraThreadLocal();
    private static HydraThreadLocal localkeycount = new HydraThreadLocal();
    private static HydraThreadLocal localcurrentkey = new HydraThreadLocal();
    private static HydraThreadLocal localkeytype = new HydraThreadLocal();
    private static HydraThreadLocal locallastwarmupterminatortime = new HydraThreadLocal();
    private static HydraThreadLocal locallasttaskterminatortime = new HydraThreadLocal();
    private static HydraThreadLocal localstarttime = new HydraThreadLocal();
    private static HydraThreadLocal localtm = new HydraThreadLocal();
    private static HydraThreadLocal localstartingsequencenumber = new HydraThreadLocal();
    private static HydraThreadLocal localnumpseudorandomkeys = new HydraThreadLocal();
    private static HydraThreadLocal localcurrentsequencenum = new HydraThreadLocal();
    private static HydraThreadLocal localcurrentnumpseudorandomkeys = new HydraThreadLocal();
    private TestConfig tc;
    private static final int TERMINATION_NONE = 0;
    private static final int TERMINATION_BATCH = 1;
    private static final int TERMINATION_WARMUP = 2;
    private static final int TERMINATION_TASK = 3;

    protected String nameFor(int name) {
        switch (name) {
            case 13: {
                return OPS_NAME;
            }
            case 100: {
                return DATASTORECACHEOPENS_NAME;
            }
            case 20: {
                return SLEEP_NAME;
            }
            case 101: {
                return ACCESSORCACHEOPENS_NAME;
            }
            case 0: {
                return CACHEOPENS_NAME;
            }
            case 1: {
                return CREATES_NAME;
            }
            case 2: {
                return CREATEKEYS_NAME;
            }
            case 3: {
                return PUTS_NAME;
            }
            case 4: {
                return GETS_NAME;
            }
            case 8: {
                return CREATEGETS_NAME;
            }
            case 9: {
                return PUTGETS_NAME;
            }
            case 11: {
                return COMBINEDPUTGETS_NAME;
            }
            case 5: {
                return PUTSCOMPARISON_NAME;
            }
            case 6: {
                return GETSCOMPARISON_NAME;
            }
            case 7: {
                return DESTROYS_NAME;
            }
            case 10: {
                return USECASE12_UPDATES_NAME;
            }
            case 12: {
                return REGISTERINTERESTS_NAME;
            }
            case 14: {
                return CONNECTS_NAME;
            }
            case 15: {
                return QUERIES_NAME;
            }
            case 16: {
                return LOCKS_NAME;
            }
            case 17: {
                return UPDATES_NAME;
            }
            case 18: {
                return EXTRA_PUTS_NAME;
            }
            case 19: {
                return EXTRA_GETS_NAME;
            }
        }
        throw new CachePerfException("Unsupported trim interval: " + name);
    }

    public static void createAndStartLocatorTask() {
        DistributedSystemHelper.createLocator();
        int parties = CachePerfClient.numThreads();
        AnyCyclicBarrier barrier = AnyCyclicBarrier.lookup(parties, "locator");
        CachePerfClient.log().info("Waiting for " + parties + " to meet at locator barrier");
        barrier.await();
        DistributedSystemHelper.startLocatorAndAdminDS();
    }

    public static void restartLocatorTask() {
        DistributedSystemHelper.startLocatorAndAdminDS();
    }

    public static void createCacheTask() {
        CachePerfClient c = new CachePerfClient();
        c.initHydraThreadLocals();
        c.createCache();
        c.updateHydraThreadLocals();
    }

    protected void createCache() {
        if (this.cache == null) {
            CachePerfClient.log().info("Creating the cache");
            this.cache = DistCacheFactory.createInstance();
            this.cache.createCache();
            this.tm = (CacheTransactionManager)this.cache.getCacheTransactionManager();
            CachePerfClient.log().info("Created the cache");
        }
    }

    public static void createPoolTask() {
        String poolConfig = ConfigPrms.getPoolConfig();
        PoolHelper.createPool(poolConfig);
    }

    public static void openCacheTask() {
        CachePerfClient c = new CachePerfClient();
        c.initHydraThreadLocals();
        c.openCache();
        c.updateHydraThreadLocals();
    }

    private void openCache() {
        if (this.cache == null) {
            CachePerfClient.log().info("Opening the cache");
            this.cache = DistCacheFactory.createInstance();
            this.cache.open();
            this.tm = (CacheTransactionManager)this.cache.getCacheTransactionManager();
            if (DistCachePrms.getCacheVendor() == 0) {
                GemFireCacheTestImpl impl = (GemFireCacheTestImpl)this.cache;
                EdgeHelper.addThreadLocalConnection(impl.getRegion());
            }
            CachePerfClient.log().info("Opened the cache");
        }
    }

    public static void assignBucketsTask() throws InterruptedException {
        CachePerfClient c = new CachePerfClient();
        c.initialize();
        if (c.ttgid == 0) {
            c.assignBuckets();
        }
    }

    protected void assignBuckets() throws InterruptedException {
        Cache c = CacheHelper.getCache();
        if (c != null) {
            for (Region r : c.rootRegions()) {
                Log.getLogWriter().info("Creating buckets for region " + r.getName());
                CachePerfClientVersion.assignBucketsToPartitions(r);
                Log.getLogWriter().info("Created buckets for region " + r.getName());
            }
        }
    }

    public static void compactionTask() {
        CachePerfClient c = new CachePerfClient();
        c.initHydraThreadLocals();
        c.createCache();
        c.updateHydraThreadLocals();
        if (c.cache instanceof GemFireCacheTestImpl) {
            Region r = ((GemFireCacheTestImpl)c.cache).getRegion();
            DiskStore dStore = CacheHelper.getCache().findDiskStore(r.getAttributes().getDiskStoreName());
            boolean result = dStore.forceCompaction();
            if (!result) {
                throw new TestException("compaction returned " + result);
            }
        } else {
            String s = "Unknown cache for disk compaction";
            throw new HydraConfigException(s);
        }
    }

    public static void connectTask() {
        DistributedSystemHelper.connect();
    }

    public static void disconnectTask() {
        DistributedSystemHelper.disconnect();
    }

    public static void bounceTask() throws ClientVmNotFoundException {
        CachePerfClient c = new CachePerfClient();
        c.initHydraThreadLocals();
        c.bounce();
    }

    private void bounce() throws ClientVmNotFoundException {
        SharedCounters sc;
        long executions;
        int maxExecutions;
        Object tmp;
        if (CachePerfPrms.waitForTrimSignal()) {
            SharedCounters sc2 = TaskSyncBlackboard.getInstance().getSharedCounters();
            while (sc2.read(TaskSyncBlackboard.trimSignal) == 0L) {
                MasterController.sleepForMs(250);
            }
        }
        int sleepMs = CachePerfPrms.getSleepMs();
        int killType = CachePerfPrms.useMeanKill() ? -21 : -22;
        int restartWaitSec = CachePerfPrms.getRestartWaitSec();
        ClientVmInfo info = CachePerfClient.chooseVM();
        CachePerfClient.log().info("Sleeping " + sleepMs + " ms before bouncing " + info);
        MasterController.sleepForMs(sleepMs);
        if (CachePerfPrms.waitForRecovery() && (tmp = TaskSyncBlackboard.getInstance().getSharedMap().remove("recovery")) != null) {
            Log.getLogWriter().info("Cleared recovery key from map");
        }
        info = ClientVmMgr.stop("Stopping " + info, killType, -31, info);
        if (restartWaitSec == -1) {
            CachePerfClient.log().info("Skipping restart of " + info);
        } else {
            this.restart(info, restartWaitSec);
        }
        if (CachePerfPrms.waitForRecovery()) {
            this.waitForRecovery();
        }
        if ((maxExecutions = CachePerfPrms.getMaxExecutions()) > 0 && (executions = (sc = TaskSyncBlackboard.getInstance().getSharedCounters()).incrementAndRead(TaskSyncBlackboard.executions)) >= (long)maxExecutions) {
            sc.increment(TaskSyncBlackboard.signal);
            String s = "Completed " + executions + " bounces";
            throw new StopSchedulingTaskOnClientOrder(s);
        }
    }

    public static void restartTask() throws ClientVmNotFoundException {
        CachePerfClient c = new CachePerfClient();
        c.initialize(-1);
        c.initHydraThreadLocals();
        c.restart();
    }

    private void restart() throws ClientVmNotFoundException {
        ClientVmInfo info = CachePerfClient.chooseVM();
        this.restart(info, CachePerfPrms.getRestartWaitSec());
        if (CachePerfPrms.waitForRecovery()) {
            this.waitForRecovery();
        }
    }

    private void restart(ClientVmInfo info, int restartWaitSec) throws ClientVmNotFoundException {
        int restartWaitMs = restartWaitSec * 1000;
        CachePerfClient.log().info("Sleeping " + restartWaitMs + " ms before restarting " + info);
        MasterController.sleepForMs(restartWaitMs);
        info = ClientVmMgr.start("Restarting " + info, info);
    }

    private void waitForRecovery() {
        SharedMap map = TaskSyncBlackboard.getInstance().getSharedMap();
        CachePerfClient.log().info("Waiting for recovery");
        Long elapsed = null;
        while ((elapsed = (Long)map.get("recovery")) == null) {
            MasterController.sleepForMs(250);
        }
        this.statistics.endRecovery(elapsed, this.isMainWorkload, this.histogram);
        map.remove("recovery");
        CachePerfClient.log().info("Recovery complete");
    }

    private static ClientVmInfo chooseVM() {
        ClientVmInfo info = null;
        String clientName = CachePerfPrms.getClientNameToBounce();
        if (clientName == null) {
            Vector others = ClientVmMgr.getOtherClientVmids();
            GsRandom rng = TestConfig.tab().getRandGen();
            Integer vmid = (Integer)others.get(rng.nextInt(0, others.size() - 1));
            info = new ClientVmInfo(vmid);
        } else {
            info = new ClientVmInfo(null, clientName, null);
        }
        return info;
    }

    public static void shutDownDataHostTask() {
        CachePerfClient c = new CachePerfClient();
        c.initHydraThreadLocals();
        c.shutDownDataHost();
        c.updateHydraThreadLocals();
    }

    private void shutDownDataHost() {
        Log.getLogWriter().info("Shutting down datahost...");
        long start = this.statistics.startCacheClose();
        this.closeCache();
        this.statistics.endCacheClose(start, this.isMainWorkload, this.histogram);
        start = this.statistics.startDisconnect();
        this.closeStatistics();
        this.statistics.endDisconnect(start, this.isMainWorkload, this.histogram);
        Log.getLogWriter().info("Done shutting down datahost");
    }

    public static void restartDataHostTask() {
        CachePerfClient c = new CachePerfClient();
        c.initHydraThreadLocals();
        c.restartDataHost();
        c.updateHydraThreadLocals();
    }

    private void restartDataHost() {
        Log.getLogWriter().info("Restarting datahost...");
        long start = NanoTimer.getTime();
        this.openStatistics();
        this.statistics.endConnect(start, this.isMainWorkload, this.histogram);
        start = this.statistics.startCacheOpen();
        this.openCache();
        this.statistics.endCacheOpen(start, this.isMainWorkload, this.cache, this.histogram);
        Log.getLogWriter().info("Done restarting datahost");
    }

    public static void addDataHostTask() throws InterruptedException {
        CachePerfClient c = new CachePerfClient();
        c.initHydraThreadLocals();
        c.addDataHost();
        c.updateHydraThreadLocals();
        throw new StopSchedulingTaskOnClientOrder("Done adding datahost");
    }

    private void addDataHost() throws InterruptedException {
        SharedCounters sc = TaskSyncBlackboard.getInstance().getSharedCounters();
        if (CachePerfPrms.waitForTrimSignal()) {
            while (sc.read(TaskSyncBlackboard.trimSignal) == 0L) {
                MasterController.sleepForMs(500);
            }
        }
        this.ttgid = this.ttgid();
        while (sc.read(TaskSyncBlackboard.addDataHostSignal) != (long)this.ttgid) {
            MasterController.sleepForMs(500);
        }
        Log.getLogWriter().info("Starting datahost and rebalancing...");
        long start = NanoTimer.getTime();
        this.openStatistics();
        this.statistics.endConnect(start, this.isMainWorkload, this.histogram);
        start = this.statistics.startCacheOpen();
        this.openCache();
        this.statistics.endCacheOpen(start, this.isMainWorkload, this.cache, this.histogram);
        start = this.statistics.startRebalance();
        this.rebalance();
        this.statistics.endRebalance(start, this.isMainWorkload, this.histogram);
        Log.getLogWriter().info("Done starting datahost and rebalancing");
        sc.increment(TaskSyncBlackboard.addDataHostSignal);
        if (this.ttgid == CachePerfClient.numThreads() - 1) {
            sc.increment(TaskSyncBlackboard.signal);
        }
    }

    public static void rebalanceTask() throws InterruptedException {
        CachePerfClient c = new CachePerfClient();
        c.initHydraThreadLocals();
        c.doRebalance();
        c.updateHydraThreadLocals();
    }

    private void doRebalance() throws InterruptedException {
        Log.getLogWriter().info("Rebalancing...");
        long start = this.statistics.startRebalance();
        this.rebalance();
        this.statistics.endRebalance(start, this.isMainWorkload, this.histogram);
        Log.getLogWriter().info("Done rebalancing");
    }

    protected void rebalance() throws InterruptedException {
        RebalanceFactory rf = CacheHelper.getCache().getResourceManager().createRebalanceFactory();
        RebalanceOperation ro = rf.start();
        RebalanceResults results = ro.getResults();
        if (CachePerfClient.log().fineEnabled()) {
            CachePerfClient.log().fine("Rebalance results: " + results);
        }
    }

    public static void validateExpectedMembersTask() {
        CachePerfClient c = new CachePerfClient();
        c.initHydraThreadLocals();
        c.validateExpectedMembers();
        c.updateHydraThreadLocals();
    }

    private void validateExpectedMembers() {
        DistributedSystemHelper.connect();
        int expected = this.getExpectedMemberCount();
        int actual = 0;
        actual = this.getMemberCount();
        if (actual == expected) {
            CachePerfClient.log().info("Found expected number of members: " + expected);
            return;
        }
        String s = "Expected " + expected + " members, found " + actual;
        DistributedSystem ds = DistributedSystemHelper.getDistributedSystem();
        if (ds != null) {
            Set mbrs = DistributedSystemHelper.getMembers();
            StringBuffer b = new StringBuffer(1000);
            b.append(s);
            b.append(" [");
            Iterator it = mbrs.iterator();
            while (it.hasNext()) {
                b.append(String.valueOf(it.next()));
                if (!it.hasNext()) continue;
                b.append(", ");
            }
            b.append("]");
            s = b.toString();
        }
        throw new HydraRuntimeException(s);
    }

    private int getExpectedMemberCount() {
        String gemfireName = System.getProperty("gemfireName");
        String dsName = TestConfig.getInstance().getGemFireDescription(gemfireName).getDistributedSystem();
        if (dsName.equals("loner")) {
            return 1;
        }
        int count = 0;
        Map<String, ClientDescription> cds = TestConfig.getInstance().getClientDescriptions();
        for (ClientDescription cd : cds.values()) {
            if (!cd.getGemFireDescription().getDistributedSystem().equals(dsName)) continue;
            count += cd.getVmQuantity();
        }
        return count;
    }

    private int getMemberCount() {
        return DistributedSystemHelper.getMembers().size();
    }

    public static void timedOpenCacheTask() {
        CachePerfClient c = new CachePerfClient();
        c.initialize(0);
        c.timedOpenCache();
        c.updateHydraThreadLocals();
    }

    private void timedOpenCache() {
        if (this.cache == null) {
            CachePerfClient.log().info("Opening the cache");
            this.cache = DistCacheFactory.createInstance();
            this.cacheStartTrim(this.trimIntervals, this.trimInterval);
            long start = this.statistics.startCacheOpen();
            this.cache.open();
            this.statistics.endCacheOpen(start, this.isMainWorkload, this.cache, this.histogram);
            MasterController.sleepForMs(2000);
            this.cacheEndTrim(this.trimIntervals, this.trimInterval);
            if (DistCachePrms.getCacheVendor() == 0) {
                GemFireCacheTestImpl impl = (GemFireCacheTestImpl)this.cache;
                EdgeHelper.addThreadLocalConnection(impl.getRegion());
            }
            CachePerfClient.log().info("Opened the cache");
        }
    }

    public static void timedOpenDataStoreCacheTask() {
        CachePerfClient c = new CachePerfClient();
        c.initialize(100);
        c.timedOpenDataStoreCache();
        c.updateHydraThreadLocals();
    }

    private void timedOpenDataStoreCache() {
        if (this.cache == null) {
            DistributedSystem ds;
            CachePerfClient.log().info("Opening the cache");
            this.cacheStartTrim(this.trimIntervals, this.trimInterval);
            String cacheConfig = ConfigPrms.getCacheConfig();
            CacheDescription cd = CacheHelper.getCacheDescription(cacheConfig);
            String regionConfig = ConfigPrms.getRegionConfig();
            RegionDescription rd = RegionHelper.getRegionDescription(regionConfig);
            String regionName = GemFireCachePrms.getRegionName();
            if (regionName == null) {
                regionName = RegionHelper.getRegionDescription(regionConfig).getRegionName();
            }
            if ((ds = DistributedSystemHelper.getDistributedSystem()) == null) {
                ds = DistributedSystemHelper.connect();
            }
            CachePerfClient.log().info("Starting timer");
            long start = this.statistics.startCacheOpen();
            Cache cache = null;
            try {
                cache = CacheFactory.create((DistributedSystem)ds);
            }
            catch (CacheException e) {
                String s = "Unable to create cache using: " + ds;
                throw new HydraRuntimeException(s, (Exception)((Object)e));
            }
            cd.configure(cache);
            AttributesFactory factory = new AttributesFactory();
            rd.configure(factory, true);
            RegionAttributes attributes = factory.create();
            Region region = cache.createRegion(regionName, attributes);
            this.statistics.endCacheOpen(start, this.isMainWorkload, this.cache, this.histogram);
            CachePerfClient.log().info("Stopped timer");
            MasterController.sleepForMs(5000);
            this.cacheEndTrim(this.trimIntervals, this.trimInterval);
            CachePerfClient.log().info("Opened the cache");
        }
    }

    public static void timedOpenAccessorCacheTask() {
        CachePerfClient c = new CachePerfClient();
        c.initialize(101);
        c.timedOpenAccessorCache();
        c.updateHydraThreadLocals();
    }

    private void timedOpenAccessorCache() {
        if (this.cache == null) {
            DistributedSystem ds;
            CachePerfClient.log().info("Opening the cache");
            this.cacheStartTrim(this.trimIntervals, this.trimInterval);
            String cacheConfig = ConfigPrms.getCacheConfig();
            CacheDescription cd = CacheHelper.getCacheDescription(cacheConfig);
            String regionConfig = ConfigPrms.getRegionConfig();
            RegionDescription rd = RegionHelper.getRegionDescription(regionConfig);
            String regionName = GemFireCachePrms.getRegionName();
            if (regionName == null) {
                regionName = RegionHelper.getRegionDescription(regionConfig).getRegionName();
            }
            if ((ds = DistributedSystemHelper.getDistributedSystem()) == null) {
                ds = DistributedSystemHelper.connect();
            }
            CachePerfClient.log().info("Starting timer");
            long start = this.statistics.startCacheOpen();
            Cache cache = null;
            try {
                cache = CacheFactory.create((DistributedSystem)ds);
            }
            catch (CacheException e) {
                String s = "Unable to create cache using: " + ds;
                throw new HydraRuntimeException(s, (Exception)((Object)e));
            }
            cd.configure(cache);
            AttributesFactory factory = new AttributesFactory();
            rd.configure(factory, true);
            RegionAttributes attributes = factory.create();
            Region region = cache.createRegion(regionName, attributes);
            this.statistics.endCacheOpen(start, this.isMainWorkload, this.cache, this.histogram);
            CachePerfClient.log().info("Stopped timer");
            MasterController.sleepForMs(5000);
            this.cacheEndTrim(this.trimIntervals, this.trimInterval);
            CachePerfClient.log().info("Opened the cache");
        }
    }

    public static void createGatewayHubTask() {
        String gatewayHubConfig = ConfigPrms.getGatewayHubConfig();
        GatewayHubHelper.createGatewayHub(gatewayHubConfig);
    }

    public static void addGatewaysTask() {
        String gatewayConfig = ConfigPrms.getGatewayConfig();
        GatewayHubHelper.addGateways(gatewayConfig);
    }

    public static void addWBCLGatewayTask() {
        String gatewayConfig = ConfigPrms.getGatewayConfig();
        GatewayHubHelper.addWBCLGateway(gatewayConfig);
    }

    public static void startGatewayHubTask() {
        GatewayHubHelper.startGatewayHub();
    }

    public static void stopGatewayHubTask() {
        GatewayHubHelper.stopGatewayHub();
    }

    public static void createGatewaySenderIdsTask() {
        String senderConfig = ConfigPrms.getGatewaySenderConfig();
        GatewaySenderHelper.createGatewaySenderIds(senderConfig);
    }

    public static void initGatewaySenderTask() {
        String senderConfig = ConfigPrms.getGatewaySenderConfig();
        GatewaySenderHelper.createAndStartGatewaySenders(senderConfig);
    }

    public static void initGatewayReceiverTask() {
        String receiverConfig = ConfigPrms.getGatewayReceiverConfig();
        GatewayReceiverHelper.createAndStartGatewayReceivers(receiverConfig);
    }

    public static void stopGatewaySenderTask() {
        GatewaySenderHelper.stopGatewaySenders();
    }

    public static void stopGatewayReceiverTask() {
        GatewayReceiverHelper.stopGatewayReceivers();
    }

    public static void closeCacheTask() {
        CachePerfClient c = new CachePerfClient();
        c.initHydraThreadLocals();
        c.closeCache();
        c.updateHydraThreadLocals();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeCache() {
        Object object = closeCacheLock;
        synchronized (object) {
            Cache cache = CacheHelper.getCache();
            if (cache != null) {
                CachePerfClient.log().info("Closing the cache");
                if (DistCachePrms.getCacheVendor() == 0) {
                    Set rootRegions = cache.rootRegions();
                    for (Region r : rootRegions) {
                        EdgeHelper.removeThreadLocalConnection(r);
                    }
                }
                this.cache.close();
                this.cache = null;
                CachePerfClient.log().info("Closed the cache");
            }
        }
    }

    public static void openStatisticsTask() {
        CachePerfClient c = new CachePerfClient();
        c.initHydraThreadLocals();
        c.openStatistics();
        c.updateHydraThreadLocals();
    }

    private void openStatistics() {
        if (this.statistics == null) {
            this.statistics = CachePerfStats.getInstance();
            RemoteTestModule.openClockSkewStatistics();
        }
    }

    public static void closeStatisticsTask() {
        CachePerfClient c = new CachePerfClient();
        c.initHydraThreadLocals();
        c.closeStatistics();
        c.updateHydraThreadLocals();
    }

    protected void closeStatistics() {
        MasterController.sleepForMs(2000);
        if (this.statistics != null) {
            RemoteTestModule.closeClockSkewStatistics();
            this.statistics.close();
        }
    }

    public static void createDataTask() {
        CachePerfClient c = new CachePerfClient();
        c.initialize(1);
        c.createData();
    }

    protected void createData() {
        if (this.useTransactions) {
            this.begin();
        }
        do {
            int key = this.getNextKey();
            this.executeTaskTerminator();
            this.executeWarmupTerminator();
            this.create(key);
            ++this.batchCount;
            ++this.count;
            ++this.keyCount;
            ++this.iterationsSinceTxEnd;
        } while (!this.executeBatchTerminator());
    }

    protected void create(int i) {
        Object key = ObjectHelper.createName(this.keyType, i);
        String objectType = CachePerfPrms.getObjectType();
        Object val = ObjectHelper.createObject(objectType, i);
        long start = this.statistics.startCreate();
        this.cache.create(key, val);
        this.statistics.endCreate(start, this.isMainWorkload, this.histogram);
    }

    public static void createAllDataTask() {
        CachePerfClient c = new CachePerfClient();
        c.initialize(1);
        c.createAllData();
    }

    private void createAllData() {
        if (this.useTransactions) {
            this.begin();
        }
        Region r = ((GemFireCacheTestImpl)this.cache).getRegion();
        HashMap m = new HashMap();
        while (true) {
            int size = CachePerfPrms.getBulkOpMapSize();
            for (int i = 0; i < size; ++i) {
                int key = this.getNextKey();
                if (this.timeToExecuteTaskTerminator()) {
                    this.createAll(r, m);
                    this.terminateTask();
                    throw new HydraInternalException("Should not happen");
                }
                if (this.timeToExecuteWarmupTerminator()) {
                    this.createAll(r, m);
                    m.clear();
                    this.terminateWarmup();
                }
                this.createMapEntry(m, key);
                ++this.batchCount;
                ++this.count;
                ++this.keyCount;
                ++this.iterationsSinceTxEnd;
                if (!this.timeToExecuteBatchTerminator()) continue;
                this.createAll(r, m);
                this.terminateBatch();
                return;
            }
            this.createAll(r, m);
            m.clear();
        }
    }

    private void createAll(Region r, Map m) {
        boolean dummyBulkOps = CachePerfPrms.getDummyBulkOps();
        if (m.size() > 0) {
            long start = this.statistics.startCreate();
            if (dummyBulkOps) {
                for (Object key : m.keySet()) {
                    r.create(key, m.get(key));
                }
            } else {
                r.putAll(m);
            }
            this.statistics.endCreate(start, m.size(), this.isMainWorkload, this.histogram);
        }
    }

    public static void createKeysTask() {
        CachePerfClient c = new CachePerfClient();
        c.initialize(2);
        c.createKeys();
    }

    private void createKeys() {
        if (this.useTransactions) {
            this.begin();
        }
        do {
            int key = this.getNextKey();
            this.executeTaskTerminator();
            this.executeWarmupTerminator();
            this.createKey(key);
            ++this.batchCount;
            ++this.count;
            ++this.keyCount;
            ++this.iterationsSinceTxEnd;
        } while (!this.executeBatchTerminator());
    }

    private void createKey(int i) {
        Object key = ObjectHelper.createName(this.keyType, i);
        String objectType = CachePerfPrms.getObjectType();
        long start = this.statistics.startCreateKey();
        this.cache.createKey(key);
        this.statistics.endCreateKey(start, this.isMainWorkload, this.histogram);
    }

    public static void createEntryMapTask() {
        CachePerfClient c = new CachePerfClient();
        c.initialize();
        c.createEntryMap();
    }

    private void createEntryMap() {
        HashMap entryMap = (HashMap)localentrymap.get();
        if (entryMap == null) {
            entryMap = new HashMap();
            localentrymap.set(entryMap);
        }
        do {
            int key = this.getNextKey();
            this.executeTaskTerminator();
            this.executeWarmupTerminator();
            this.createMapEntry(entryMap, key);
            ++this.batchCount;
            ++this.count;
            ++this.keyCount;
            ++this.iterationsSinceTxEnd;
        } while (!this.executeBatchTerminator());
    }

    private void createMapEntry(Map entryMap, int i) {
        Object key = ObjectHelper.createName(this.keyType, i);
        String objectType = CachePerfPrms.getObjectType();
        Object val = ObjectHelper.createObject(objectType, i);
        entryMap.put(key, val);
        if (CachePerfClient.log().fineEnabled()) {
            CachePerfClient.log().fine("created map entry: " + key + "=" + val);
        }
    }

    public static void putAllEntryMapTask() {
        CachePerfClient c = new CachePerfClient();
        c.initialize(3);
        c.putAllEntryMap();
    }

    private void putAllEntryMap() {
        Region r = ((GemFireCacheTestImpl)this.cache).getRegion();
        Map m = (Map)localentrymap.get();
        if (this.useTransactions) {
            this.begin();
        }
        boolean batchDone = false;
        do {
            if (this.sleepBeforeOp) {
                MasterController.sleepForMs(CachePerfPrms.getSleepMs());
            }
            this.executeTaskTerminator();
            this.executeWarmupTerminator();
            this.putAll(r, m);
            ++this.batchCount;
            ++this.count;
            ++this.iterationsSinceTxEnd;
        } while (!(batchDone = this.executeBatchTerminator()));
    }

    private void putAll(Region r, Map m) {
        boolean dummyBulkOps = CachePerfPrms.getDummyBulkOps();
        if (m.size() > 0) {
            long start = this.statistics.startPut();
            if (dummyBulkOps) {
                for (Object key : m.keySet()) {
                    r.put(key, m.get(key));
                }
            } else {
                r.putAll(m);
            }
            this.statistics.endPutAll(start, m.size(), this.isMainWorkload, this.histogram);
        }
    }

    public static void putAllDataTask() {
        CachePerfClient c = new CachePerfClient();
        c.initialize(3);
        c.putAllData();
    }

    private void putAllData() {
        if (this.useTransactions) {
            this.begin();
        }
        Region r = ((GemFireCacheTestImpl)this.cache).getRegion();
        HashMap m = new HashMap();
        while (true) {
            int size = CachePerfPrms.getBulkOpMapSize();
            for (int i = 0; i < size; ++i) {
                int key = this.getNextKey();
                if (this.timeToExecuteTaskTerminator()) {
                    this.putAll(r, m);
                    this.terminateTask();
                    throw new HydraInternalException("Should not happen");
                }
                if (this.timeToExecuteWarmupTerminator()) {
                    this.putAll(r, m);
                    m.clear();
                    this.terminateWarmup();
                }
                this.createMapEntry(m, key);
                ++this.batchCount;
                ++this.count;
                ++this.keyCount;
                ++this.iterationsSinceTxEnd;
                if (!this.timeToExecuteBatchTerminator()) continue;
                this.putAll(r, m);
                this.terminateBatch();
                return;
            }
            this.putAll(r, m);
            m.clear();
        }
    }

    public static void getAllDataTask() {
        CachePerfClient c = new CachePerfClient();
        c.initialize(4);
        c.getAllData();
    }

    private void getAllData() {
        if (this.useTransactions) {
            this.begin();
        }
        Region r = ((GemFireCacheTestImpl)this.cache).getRegion();
        ArrayList l = new ArrayList();
        while (true) {
            Map result = null;
            int size = CachePerfPrms.getBulkOpMapSize();
            for (int i = 0; i < size; ++i) {
                int key = this.getNextKey();
                if (this.timeToExecuteTaskTerminator()) {
                    result = this.getAll(r, l);
                    this.terminateTask();
                    throw new HydraInternalException("Should not happen");
                }
                if (this.timeToExecuteWarmupTerminator()) {
                    result = this.getAll(r, l);
                    l.clear();
                    this.terminateWarmup();
                }
                this.createListEntry(l, key);
                ++this.batchCount;
                ++this.count;
                ++this.keyCount;
                ++this.iterationsSinceTxEnd;
                if (!this.timeToExecuteBatchTerminator()) continue;
                result = this.getAll(r, l);
                this.terminateBatch();
                return;
            }
            result = this.getAll(r, l);
            l.clear();
            if (result == null) continue;
            result.clear();
        }
    }

    private Map getAll(Region r, List l) {
        boolean dummyGetAll = CachePerfPrms.getDummyBulkOps();
        Map result = null;
        if (l.size() > 0) {
            long start = this.statistics.startGet();
            if (dummyGetAll) {
                result = new HashMap();
                for (Object key : l) {
                    result.put(key, r.get(key));
                }
            } else {
                result = r.getAll((Collection)l);
            }
            this.statistics.endGetAll(start, l.size(), this.isMainWorkload, this.histogram);
            for (Object key : result.keySet()) {
                Object val = result.get(key);
                if (val != null) continue;
                this.processNullValue(key);
            }
        }
        return result;
    }

    private void createListEntry(List entryList, int i) {
        Object key = ObjectHelper.createName(this.keyType, i);
        if (!entryList.contains(key)) {
            entryList.add(key);
        }
        if (CachePerfClient.log().fineEnabled()) {
            CachePerfClient.log().fine("created list entry: " + key);
        }
    }

    public static void putExtraDataTask() {
        CachePerfClient c = new CachePerfClient();
        c.initialize(18);
        c.putData();
    }

    public static void putDataTask() {
        CachePerfClient c = new CachePerfClient();
        c.initialize(3);
        c.putData();
    }

    private void putData() {
        if (this.useTransactions) {
            this.begin();
        }
        boolean batchDone = false;
        do {
            int n = 1;
            if (this.sleepBeforeOp) {
                MasterController.sleepForMs(CachePerfPrms.getSleepMs());
                n = CachePerfPrms.getSleepOpCount();
            }
            for (int j = 0; j < n; ++j) {
                int key = this.getNextKey();
                this.executeTaskTerminator();
                this.executeWarmupTerminator();
                this.put(key);
                this.batchCount += this.optimizationCount;
                ++this.count;
                ++this.keyCount;
                ++this.iterationsSinceTxEnd;
                batchDone = this.executeBatchTerminator();
            }
        } while (!batchDone);
    }

    protected void put(int i) {
        Object key = ObjectHelper.createName(this.keyType, i);
        String objectType = CachePerfPrms.getObjectType();
        Object val = ObjectHelper.createObject(objectType, i);
        long start = this.statistics.startPut();
        if (this.optimizationCount == 1) {
            this.cache.put(key, val);
        } else if (this.cache instanceof GemFireCacheTestImpl) {
            Region r = ((GemFireCacheTestImpl)this.cache).getRegion();
            for (int j = 0; j < this.optimizationCount; ++j) {
                r.put(key, val);
            }
        } else if (this.cache instanceof HashMapCacheImpl) {
            ConcurrentHashMap r = ((HashMapCacheImpl)this.cache).getMap();
            for (int j = 0; j < this.optimizationCount; ++j) {
                r.put(key, val);
            }
        } else {
            String s = "Cannot optimize loop for non-gemfire cache";
            throw new HydraConfigException(s);
        }
        this.statistics.endPut(start, this.optimizationCount, this.isMainWorkload, this.histogram);
    }

    public static void updateDataTask() {
        CachePerfClient c = new CachePerfClient();
        c.initialize(17);
        c.updateData();
    }

    private void updateData() {
        int numUpdates = CachePerfPrms.getNumUpdates();
        if (this.useTransactions) {
            this.begin();
        }
        boolean batchDone = false;
        do {
            int key = this.getNextKey();
            this.executeTaskTerminator();
            this.executeWarmupTerminator();
            this.update(key, numUpdates);
            this.batchCount += numUpdates;
            ++this.count;
            ++this.keyCount;
            ++this.iterationsSinceTxEnd;
        } while (!(batchDone = this.executeBatchTerminator()));
    }

    private void update(int i, int numUpdates) {
        Object key = ObjectHelper.createName(this.keyType, i);
        long start = this.statistics.startUpdate();
        Object val = this.cache.get(key);
        if (val == null) {
            String s = "Key has not been created: " + i;
            throw new HydraRuntimeException(s);
        }
        for (int n = 0; n < numUpdates; ++n) {
            ObjectHelper.update(val);
            this.cache.put(key, val);
        }
        this.statistics.endUpdate(start, numUpdates, this.isMainWorkload, this.histogram);
    }

    public static void getExtraDataTask() {
        CachePerfClient c = new CachePerfClient();
        c.initialize(19);
        c.getData();
    }

    public static void getDataTask() {
        CachePerfClient c = new CachePerfClient();
        c.initialize(4);
        c.getData();
    }

    protected void getData() {
        if (this.useTransactions) {
            this.begin();
        }
        do {
            int key = this.getNextKey();
            this.executeTaskTerminator();
            this.executeWarmupTerminator();
            if (this.sleepBeforeOp) {
                MasterController.sleepForMs(CachePerfPrms.getSleepMs());
            }
            this.get(key);
            this.batchCount += this.optimizationCount;
            ++this.count;
            ++this.keyCount;
            ++this.iterationsSinceTxEnd;
        } while (!this.executeBatchTerminator());
    }

    protected void get(int i) {
        Object key = ObjectHelper.createName(this.keyType, i);
        long start = this.statistics.startGet();
        Object val = null;
        if (this.optimizationCount == 1) {
            val = this.cache.get(key);
            if (this.invalidateAfterGet) {
                if (this.invalidateLocally) {
                    this.cache.localInvalidate(key);
                } else {
                    this.cache.invalidate(key);
                }
            } else if (this.destroyAfterGet) {
                if (this.destroyLocally) {
                    this.cache.localDestroy(key);
                } else {
                    this.cache.destroy(key);
                }
            }
        } else {
            Region r = null;
            if (this.cache instanceof GemFireCacheTestImpl) {
                r = ((GemFireCacheTestImpl)this.cache).getRegion();
                for (int j = 0; j < this.optimizationCount; ++j) {
                    val = r.get(key);
                    if (this.invalidateAfterGet) {
                        if (this.invalidateLocally) {
                            this.cache.localInvalidate(key);
                            continue;
                        }
                        this.cache.invalidate(key);
                        continue;
                    }
                    if (!this.destroyAfterGet) continue;
                    if (this.destroyLocally) {
                        this.cache.localDestroy(key);
                        continue;
                    }
                    this.cache.destroy(key);
                }
            } else {
                String s = "Cannot optimize loop for non-gemfire cache";
                throw new HydraConfigException(s);
            }
        }
        if (val == null) {
            this.processNullValue(key);
        } else if (this.validateObjects) {
            this.validate(i, val);
        }
        this.statistics.endGet(start, this.optimizationCount, this.isMainWorkload, this.histogram);
    }

    public static void mixCreateGetDataTask() {
        CachePerfClient c = new CachePerfClient();
        c.initialize(8);
        c.mixCreateGetData();
    }

    private void mixCreateGetData() {
        int putPercentage = CachePerfPrms.getPutPercentage();
        if (this.useTransactions) {
            this.begin();
        }
        do {
            int key = this.getNextKey();
            this.executeTaskTerminator();
            this.executeWarmupTerminator();
            if (this.sleepBeforeOp) {
                MasterController.sleepForMs(CachePerfPrms.getSleepMs());
            }
            this.mixCreateGet(key, putPercentage);
            ++this.batchCount;
            ++this.count;
            ++this.keyCount;
            ++this.iterationsSinceTxEnd;
        } while (!this.executeBatchTerminator());
    }

    private void mixCreateGet(int i, int putPercentage) {
        Object key = ObjectHelper.createName(this.keyType, i);
        int n = this.rng.nextInt(1, 100);
        if (n <= putPercentage) {
            String objectType = CachePerfPrms.getObjectType();
            Object val = ObjectHelper.createObject(objectType, i);
            long start = this.statistics.startCreate();
            this.cache.create(key, val);
            this.statistics.endCreate(start, this.isMainWorkload, this.histogram);
        } else {
            long start = this.statistics.startGet();
            Object val = this.cache.get(key);
            if (val == null) {
                this.processNullValue(key);
            } else if (this.validateObjects) {
                this.validate(i, val);
            }
            this.statistics.endGet(start, this.isMainWorkload, this.histogram);
        }
    }

    public static void mixPutGetDataTask() {
        CachePerfClient c = new CachePerfClient();
        c.initialize(9);
        c.mixPutGetData();
    }

    private void mixPutGetData() {
        int putPercentage = CachePerfPrms.getPutPercentage();
        if (this.useTransactions) {
            this.begin();
        }
        do {
            int key = this.getNextKey();
            this.executeTaskTerminator();
            this.executeWarmupTerminator();
            if (this.sleepBeforeOp) {
                MasterController.sleepForMs(CachePerfPrms.getSleepMs());
            }
            this.mixPutGet(key, putPercentage);
            this.batchCount += this.optimizationCount;
            ++this.count;
            ++this.keyCount;
            ++this.iterationsSinceTxEnd;
        } while (!this.executeBatchTerminator());
    }

    private void mixPutGet(int i, int putPercentage) {
        Object key = ObjectHelper.createName(this.keyType, i);
        int n = this.rng.nextInt(1, 100);
        if (n <= putPercentage) {
            String objectType = CachePerfPrms.getObjectType();
            Object val = ObjectHelper.createObject(objectType, i);
            long start = this.statistics.startPut();
            if (this.optimizationCount == 1) {
                this.cache.put(key, val);
            } else {
                Region r = null;
                if (this.cache instanceof GemFireCacheTestImpl) {
                    r = ((GemFireCacheTestImpl)this.cache).getRegion();
                    for (int j = 0; j < this.optimizationCount; ++j) {
                        r.put(key, val);
                    }
                } else {
                    String s = "Cannot optimize loop for non-gemfire cache";
                    throw new HydraConfigException(s);
                }
            }
            this.statistics.endPut(start, this.optimizationCount, this.isMainWorkload, this.histogram);
        } else {
            long start = this.statistics.startGet();
            Object val = null;
            if (this.optimizationCount == 1) {
                val = this.cache.get(key);
            } else {
                Region r = null;
                if (this.cache instanceof GemFireCacheTestImpl) {
                    r = ((GemFireCacheTestImpl)this.cache).getRegion();
                    for (int j = 0; j < this.optimizationCount; ++j) {
                        val = this.cache.get(key);
                    }
                } else {
                    String s = "Cannot optimize loop for non-gemfire cache";
                    throw new HydraConfigException(s);
                }
            }
            if (val == null) {
                this.processNullValue(key);
            } else if (this.validateObjects) {
                this.validate(i, val);
            }
            this.statistics.endGet(start, this.optimizationCount, this.isMainWorkload, this.histogram);
        }
    }

    public static void combinePutGetDataTask() {
        CachePerfClient c = new CachePerfClient();
        c.initialize(11);
        c.combinePutGetData();
    }

    private void combinePutGetData() {
        if (this.useTransactions) {
            this.begin();
        }
        do {
            int key = this.getNextKey();
            this.executeTaskTerminator();
            this.executeWarmupTerminator();
            if (this.sleepBeforeOp) {
                MasterController.sleepForMs(CachePerfPrms.getSleepMs());
            }
            this.combinePutGet(key);
            this.batchCount += this.optimizationCount;
            ++this.count;
            ++this.keyCount;
            ++this.iterationsSinceTxEnd;
        } while (!this.executeBatchTerminator());
    }

    private void combinePutGet(int i) {
        Object key = ObjectHelper.createName(this.keyType, i);
        String objectType = CachePerfPrms.getObjectType();
        Object val = ObjectHelper.createObject(objectType, i);
        long start = this.statistics.startCombinedPutGet();
        if (this.optimizationCount == 1) {
            this.cache.put(key, val);
            val = this.cache.get(key);
        } else {
            Region r = null;
            if (this.cache instanceof GemFireCacheTestImpl) {
                r = ((GemFireCacheTestImpl)this.cache).getRegion();
                for (int j = 0; j < this.optimizationCount; ++j) {
                    r.put(key, val);
                    val = r.get(key);
                }
            } else {
                String s = "Cannot optimize loop for non-gemfire cache";
                throw new HydraConfigException(s);
            }
        }
        if (val == null) {
            this.processNullValue(key);
        } else if (this.validateObjects) {
            this.validate(i, val);
        }
        this.statistics.endCombinedPutGet(start, this.optimizationCount, this.isMainWorkload, this.histogram);
    }

    public static void getRecentKeyDataTask() {
        CachePerfClient c = new CachePerfClient();
        c.initialize(4);
        c.getRecentKeyData();
    }

    private void getRecentKeyData() {
        int recentKeysPercentage = CachePerfPrms.recentKeysPercentage();
        if (this.useTransactions) {
            this.begin();
        }
        do {
            int key;
            int randInt;
            if ((randInt = this.batchCount % 100) <= recentKeysPercentage) {
                key = this.getRecentKey();
                if (key == -1) {
                    key = this.getNextKey();
                }
            } else {
                key = this.getNextKey();
            }
            this.executeTaskTerminator();
            this.executeWarmupTerminator();
            this.get(key);
            ++this.batchCount;
            ++this.count;
            ++this.keyCount;
            ++this.iterationsSinceTxEnd;
        } while (!this.executeBatchTerminator());
    }

    public static void putDataComparisonTask() {
        CachePerfClient c = new CachePerfClient();
        c.initialize(5);
        c.putData();
    }

    public static void getDataComparisonTask() {
        CachePerfClient c = new CachePerfClient();
        c.initialize(6);
        c.getData();
    }

    public static void readyForEventsTask() {
        CacheHelper.getCache().readyForEvents();
    }

    public static void registerInterestTask() {
        CachePerfClient c = new CachePerfClient();
        c.initialize(12);
        c.registerInterest();
    }

    private void registerInterest() {
        int interestBatchSize = CachePerfPrms.getInterestBatchSize();
        do {
            int key = this.getNextKey();
            this.executeTaskTerminator();
            this.executeWarmupTerminator();
            this.registerInterest(key, interestBatchSize);
            ++this.count;
            ++this.batchCount;
            ++this.keyCount;
        } while (!this.executeBatchTerminator());
    }

    protected void registerInterest(int i, int interestBatchSize) {
        Object key = ObjectHelper.createName(this.keyType, i);
        this.registerInterest(key, interestBatchSize);
    }

    protected void registerInterest(Object key, int interestBatchSize) {
        if (interestBatchSize > 1) {
            if (this.interestListBatch == null) {
                this.interestListBatch = new ArrayList();
            }
            this.interestListBatch.add(key);
            if (this.interestListBatch.size() == interestBatchSize) {
                this.registerInterest(1, this.interestListBatch);
            }
        } else {
            this.registerInterest(0, key);
        }
    }

    private void registerInterest(int type, Object keyOrList) {
        switch (type) {
            case 0: {
                if (keyOrList == null) break;
                this.registerInterest(keyOrList);
                break;
            }
            case 1: {
                if (keyOrList == null || ((List)keyOrList).size() <= 0) break;
                this.registerInterest(keyOrList);
                keyOrList = null;
                break;
            }
            default: {
                String s = "Unsupported interest object type: " + type;
                throw new HydraRuntimeException(s);
            }
        }
    }

    private void registerInterest(Object keyOrList) {
        if (this.cache instanceof GemFireCacheTestImpl) {
            long start = this.statistics.startRegisterInterest();
            ((GemFireCacheTestImpl)this.cache).registerInterest(keyOrList, this.registerDurableInterest);
            this.statistics.endRegisterInterest(start, this.isMainWorkload, this.histogram);
        }
    }

    public static void registerInterestRegexTask() {
        CachePerfClient c = new CachePerfClient();
        c.initialize(12);
        c.registerInterestRegex();
    }

    private void registerInterestRegex() {
        boolean logRegex = CachePerfPrms.logInterestRegex();
        int strBatchSize = BatchStringPrms.getBatchSize();
        if (this.maxKeys % strBatchSize != 0) {
            throw new HydraConfigException(BasePrms.nameForKey(BatchStringPrms.batchSize) + " does not evenly divide " + CachePerfPrms.nameForKey(CachePerfPrms.maxKeys));
        }
        int batches = this.maxKeys / strBatchSize;
        int batchNum = this.tid % batches;
        String regex = BatchString.getRegex(batchNum);
        if (this.cache instanceof GemFireCacheTestImpl) {
            if (logRegex) {
                CachePerfClient.log().info("Registering interest using regex \"" + regex + "\"");
            }
            long start = this.statistics.startRegisterInterest();
            ((GemFireCacheTestImpl)this.cache).registerInterestRegex(regex, this.registerDurableInterest);
            this.statistics.endRegisterInterest(start, this.isMainWorkload, this.histogram);
        }
    }

    public static void registerInterestRegexAllTask() {
        CachePerfClient c = new CachePerfClient();
        c.initialize(12);
        c.registerInterestRegexAll();
    }

    private void registerInterestRegexAll() {
        if (this.cache instanceof GemFireCacheTestImpl) {
            String regex = ".*";
            long start = this.statistics.startRegisterInterest();
            ((GemFireCacheTestImpl)this.cache).registerInterestRegex(regex, this.registerDurableInterest);
            this.statistics.endRegisterInterest(start, this.isMainWorkload, this.histogram);
        }
    }

    public static void cycleRegisterInterestRegexTask() {
        CachePerfClient c = new CachePerfClient();
        c.initialize(12);
        c.cycleRegisterInterestRegex();
    }

    private void cycleRegisterInterestRegex() {
        String regex = ".*";
        Region r = ((GemFireCacheTestImpl)this.cache).getRegion();
        InterestResultPolicy policy = GemFireCachePrms.getInterestResultPolicy();
        do {
            this.executeTaskTerminator();
            this.executeWarmupTerminator();
            this.cycleRegisterInterestRegex(r, regex, policy);
            ++this.batchCount;
            ++this.count;
        } while (!this.executeBatchTerminator());
    }

    private void cycleRegisterInterestRegex(Region r, String regex, InterestResultPolicy policy) {
        long start = this.statistics.startRegisterInterest();
        r.registerInterestRegex(regex, policy, this.registerDurableInterest);
        r.unregisterInterestRegex(regex);
        this.statistics.endRegisterInterest(start, this.isMainWorkload, this.histogram);
    }

    public static void destroyDataTask() {
        CachePerfClient c = new CachePerfClient();
        c.initialize(7);
        c.destroyData();
    }

    protected void destroyData() {
        if (this.useTransactions) {
            this.begin();
        }
        do {
            int key = this.getNextKey();
            this.executeTaskTerminator();
            this.executeWarmupTerminator();
            try {
                this.destroy(key);
                ++this.batchCount;
                ++this.count;
                ++this.keyCount;
                ++this.iterationsSinceTxEnd;
            }
            catch (DistCacheException e) {
                if (!(e.getCause() instanceof EntryNotFoundException)) {
                    throw e;
                }
                if (this.keyAllocation != 11) continue;
                throw e;
            }
        } while (!this.executeBatchTerminator());
    }

    protected void destroy(int i) {
        Object key = ObjectHelper.createName(this.keyType, i);
        long start = this.statistics.startDestroy();
        this.cache.destroy(key);
        this.statistics.endDestroy(start, this.isMainWorkload, this.histogram);
    }

    public static void signalTask() {
        CachePerfClient c = new CachePerfClient();
        c.initialize();
        c.signal();
    }

    private void signal() {
        TaskSyncBlackboard.getInstance().getSharedCounters().increment(TaskSyncBlackboard.signal);
    }

    public static void resetPseudoRandomUniqueKeysTask() {
        CachePerfClient c = new CachePerfClient();
        c.initialize(-1);
        c.initHydraThreadLocals();
        c.currentSequenceNumber = c.getStartingSequenceNumber();
        c.setCurrentSequenceNumber(c.currentSequenceNumber);
        c.currentNumPseudoRandomKeys = 0L;
        c.setCurrentNumPseudoRandomKeys(c.currentNumPseudoRandomKeys);
        CachePerfBlackboard.getInstance().getSharedCounters().zero(CachePerfBlackboard.counter);
    }

    public static void indexDataTask() {
        CachePerfClient c = new CachePerfClient();
        c.initialize();
        c.indexData();
    }

    protected void indexData() {
        String indexStr = CachePerfPrms.getQueryIndex();
        String fromClause = CachePerfPrms.getQueryFromClause();
        try {
            CacheHelper.getCache().getQueryService().createIndex("index", IndexType.FUNCTIONAL, indexStr, fromClause);
        }
        catch (IndexExistsException e) {
            CachePerfClient.log().info("index already created");
        }
        catch (IndexNameConflictException e) {
            CachePerfClient.log().info("index already created");
        }
        catch (QueryException e) {
            String s = "Problem creating index: " + indexStr + " " + fromClause;
            throw new HydraRuntimeException(s, (Exception)((Object)e));
        }
    }

    public static void queryRegionDataTask() {
        CachePerfClient c = new CachePerfClient();
        c.initialize(15);
        c.queryRegionData();
    }

    protected void queryRegionData() {
        String queryPredicate = CachePerfPrms.getQuery();
        String regionName = GemFireCachePrms.getRegionName();
        Region region = RegionHelper.getRegion(regionName);
        do {
            this.executeTaskTerminator();
            this.executeWarmupTerminator();
            this.queryRegion(region, queryPredicate);
            ++this.batchCount;
            ++this.count;
            ++this.keyCount;
            ++this.iterationsSinceTxEnd;
        } while (!this.executeBatchTerminator());
    }

    protected void queryRegion(Region region, String queryPredicate) {
        try {
            long start = this.statistics.startQuery();
            SelectResults results = region.query(queryPredicate);
            int numResults = results.size();
            this.statistics.endQuery(start, numResults, this.isMainWorkload, this.histogram);
            if (CachePerfClient.log().fineEnabled()) {
                CachePerfClient.log().fine("Query " + queryPredicate + " returned " + numResults);
                if (CachePerfClient.log().finerEnabled()) {
                    CachePerfClient.log().finer(this.getResultString(results));
                }
            }
        }
        catch (QueryException e) {
            String s = "Problem executing query: " + queryPredicate;
            throw new HydraRuntimeException(s, (Exception)((Object)e));
        }
    }

    public static void queryRangeRegionDataTask() {
        CachePerfClient c = new CachePerfClient();
        c.initialize(15);
        c.queryRangeRegionData();
    }

    protected void queryRangeRegionData() {
        GsRandom rng = new GsRandom(12L);
        String queryPredicate = CachePerfPrms.getQuery();
        long queryRangeMin = CachePerfPrms.getQueryRangeMin();
        long queryRangeMax = CachePerfPrms.getQueryRangeMax();
        long queryRangeSize = CachePerfPrms.getQueryRangeSize();
        String regionName = GemFireCachePrms.getRegionName();
        Region region = RegionHelper.getRegion(regionName);
        double random = -1.0;
        do {
            this.executeTaskTerminator();
            this.executeWarmupTerminator();
            String query = queryPredicate;
            long queryRangeStart = rng.nextLong(queryRangeMin, queryRangeMax);
            query = query.replaceAll("RANDOM_MIN", new Double(queryRangeStart).toString());
            query = query.replaceAll("RANDOM_MAX", new Double(queryRangeStart + queryRangeSize).toString());
            this.queryRangeRegion(region, query);
            ++this.batchCount;
            ++this.count;
            ++this.keyCount;
            ++this.iterationsSinceTxEnd;
        } while (!this.executeBatchTerminator());
    }

    protected void queryRangeRegion(Region region, String queryPredicate) {
        try {
            long start = this.statistics.startQuery();
            SelectResults results = region.query(queryPredicate);
            int numResults = results.size();
            this.statistics.endQuery(start, numResults, this.isMainWorkload, this.histogram);
            if (CachePerfClient.log().fineEnabled()) {
                CachePerfClient.log().fine("Query " + queryPredicate + " returned " + numResults);
                if (CachePerfClient.log().finerEnabled()) {
                    CachePerfClient.log().finer(this.getResultString(results));
                }
            }
        }
        catch (QueryException e) {
            String s = "Problem executing query: " + queryPredicate;
            throw new HydraRuntimeException(s, (Exception)((Object)e));
        }
    }

    public static void queryDataTask() {
        CachePerfClient c = new CachePerfClient();
        c.initialize(15);
        c.queryData();
    }

    protected void queryData() {
        String queryStr = CachePerfPrms.getQuery();
        Query query = CacheHelper.getCache().getQueryService().newQuery(queryStr);
        do {
            this.executeTaskTerminator();
            this.executeWarmupTerminator();
            this.query(query);
            ++this.batchCount;
            ++this.count;
            ++this.keyCount;
            ++this.iterationsSinceTxEnd;
        } while (!this.executeBatchTerminator());
    }

    protected void query(Query query) {
        try {
            long start = this.statistics.startQuery();
            SelectResults results = (SelectResults)query.execute();
            int numResults = results.size();
            this.statistics.endQuery(start, numResults, this.isMainWorkload, this.histogram);
            if (CachePerfClient.log().fineEnabled()) {
                CachePerfClient.log().fine("Query " + query + " returned " + numResults);
                if (CachePerfClient.log().finerEnabled()) {
                    CachePerfClient.log().finer(this.getResultString(results));
                }
            }
        }
        catch (QueryException e) {
            String s = "Problem executing query: " + query;
            throw new HydraRuntimeException(s, (Exception)((Object)e));
        }
    }

    protected String getResultString(SelectResults results) {
        StringBuffer buf = new StringBuffer();
        buf.append("Query returned " + results.size() + " results\n");
        for (Struct struct : results) {
            String[] fieldNames = struct.getStructType().getFieldNames();
            Object[] vals = struct.getFieldValues();
            for (int i = 0; i < fieldNames.length; ++i) {
                buf.append(fieldNames[i] + "=" + vals[i] + "\n");
            }
        }
        return buf.toString();
    }

    public static void statArchiverTask() {
        CachePerfClient c = new CachePerfClient();
        c.initialize(13);
        c.statArchiver();
    }

    private void statArchiver() {
        SharedCounters counters = TaskSyncBlackboard.getInstance().getSharedCounters();
        boolean batchDone = false;
        do {
            this.executeTaskTerminator();
            this.executeWarmupTerminator();
            this.archive(counters);
            ++this.batchCount;
            ++this.count;
        } while (!(batchDone = this.executeBatchTerminator()));
    }

    private void archive(SharedCounters counters) {
        MasterController.sleepForMs(1000);
        long ops = counters.read(TaskSyncBlackboard.ops);
        long opTime = counters.read(TaskSyncBlackboard.opTime);
        long opTime1 = counters.read(TaskSyncBlackboard.opTime1);
        long opTime2 = counters.read(TaskSyncBlackboard.opTime2);
        long opTime3 = counters.read(TaskSyncBlackboard.opTime3);
        this.statistics.setOps((int)ops);
        this.statistics.setOpTime(opTime);
        this.statistics.setOpTime1(opTime1);
        this.statistics.setOpTime2(opTime2);
        this.statistics.setOpTime3(opTime3);
    }

    public static void cycleDistributedSystemConnectionOnlyTask() throws CacheException {
        CachePerfClient c = new CachePerfClient();
        c.initialize(14);
        c.cycleDistributedSystemConnectionOnly();
    }

    private void cycleDistributedSystemConnectionOnly() throws CacheException {
        Properties p = (Properties)cycleDistributedSystemConnectionProperties.get();
        SharedCounters counters = (SharedCounters)cycleDistributedSystemConnectionCounters.get();
        if (p == null) {
            p = DistributedSystemHelper.getDistributedSystemProperties(null);
            counters = TaskSyncBlackboard.getInstance().getSharedCounters();
            cycleDistributedSystemConnectionProperties.set(p);
            cycleDistributedSystemConnectionCounters.set(counters);
        }
        int ms = CachePerfPrms.getSleepMs();
        boolean batchDone = false;
        do {
            this.executeTaskTerminator();
            this.executeWarmupTerminator();
            this.cycleDistributedSystemConnection(p, counters);
            ++this.batchCount;
            ++this.count;
            batchDone = this.executeBatchTerminator();
            MasterController.sleepForMs(ms);
        } while (!batchDone);
    }

    private void cycleDistributedSystemConnection(Properties p, SharedCounters counters) throws CacheException {
        long start;
        long start1 = start = NanoTimer.getTime();
        DistributedSystem ds = DistributedSystem.connect((Properties)p);
        long start2 = NanoTimer.getTime();
        long elapsed1 = start2 - start1;
        Cache c = CacheFactory.create((DistributedSystem)ds);
        c.close();
        long start3 = NanoTimer.getTime();
        long elapsed2 = start3 - start2;
        ds.disconnect();
        long end = NanoTimer.getTime();
        long elapsed3 = end - start3;
        long elapsed = end - start;
        counters.increment(TaskSyncBlackboard.ops);
        counters.add(TaskSyncBlackboard.opTime, elapsed);
        counters.add(TaskSyncBlackboard.opTime1, elapsed1);
        counters.add(TaskSyncBlackboard.opTime2, elapsed2);
        counters.add(TaskSyncBlackboard.opTime3, elapsed3);
        String fn = p.getProperty("log-file");
        if (fn != null) {
            FileUtil.deleteFile(fn);
        }
        if ((fn = p.getProperty("security-log-file")) != null) {
            FileUtil.deleteFile(fn);
        }
        if ((fn = p.getProperty("statistic-archive-file")) != null) {
            FileUtil.deleteFile(fn);
        }
    }

    public static void cycleDistributedSystemConnectionTask() throws CacheException {
        CachePerfClient c = new CachePerfClient();
        c.initialize(14);
        c.cycleDistributedSystemConnection();
    }

    private void cycleDistributedSystemConnection() throws CacheException {
        Properties p = (Properties)cycleDistributedSystemConnectionProperties.get();
        SharedCounters counters = (SharedCounters)cycleDistributedSystemConnectionCounters.get();
        if (p == null) {
            String cacheXmlFile = System.getProperty("user.dir") + "/" + System.getProperty("clientName") + ".xml";
            CacheHelper.generateCacheXmlFile(ConfigPrms.getCacheConfig(), ConfigPrms.getRegionConfig(), cacheXmlFile);
            DistributedSystemHelper.disconnect();
            p = DistributedSystemHelper.getDistributedSystemProperties(cacheXmlFile);
            counters = TaskSyncBlackboard.getInstance().getSharedCounters();
            cycleDistributedSystemConnectionProperties.set(p);
            cycleDistributedSystemConnectionCounters.set(counters);
        }
        int ms = CachePerfPrms.getSleepMs();
        boolean batchDone = false;
        do {
            this.executeTaskTerminator();
            this.executeWarmupTerminator();
            this.cycleDistributedSystemConnection(p, counters);
            ++this.batchCount;
            ++this.count;
            batchDone = this.executeBatchTerminator();
            MasterController.sleepForMs(ms);
        } while (!batchDone);
    }

    public static void cyclePoolAndRegionTask() throws CacheException {
        CachePerfClient c = new CachePerfClient();
        c.initialize(14);
        c.cyclePoolAndRegion();
    }

    private void cyclePoolAndRegion() throws CacheException {
        String poolConfig = ConfigPrms.getPoolConfig();
        Cache theCache = (Cache)cycleBridgeConnectionCache.get();
        AttributesFactory regionFactory = (AttributesFactory)cycleBridgeConnectionFactory.get();
        PoolFactory poolFactory = (PoolFactory)cyclePoolFactory.get();
        if (poolFactory == null) {
            DistributedSystem ds = DistributedSystemHelper.connect();
            theCache = CacheFactory.create((DistributedSystem)ds);
            this.openStatistics();
            poolFactory = PoolHelper.getPoolFactory(poolConfig);
            String regionConfig = ConfigPrms.getRegionConfig();
            regionFactory = RegionHelper.getAttributesFactory(regionConfig);
            cycleBridgeConnectionCache.set(theCache);
            cycleBridgeConnectionFactory.set(regionFactory);
            cyclePoolFactory.set(poolFactory);
        }
        int ms = CachePerfPrms.getSleepMs();
        boolean batchDone = false;
        do {
            this.executeTaskTerminator();
            this.executeWarmupTerminator();
            this.cyclePoolAndRegion(theCache, regionFactory, poolFactory, poolConfig);
            ++this.batchCount;
            ++this.count;
            batchDone = this.executeBatchTerminator();
            MasterController.sleepForMs(ms);
        } while (!batchDone);
    }

    private void cyclePoolAndRegion(Cache theCache, AttributesFactory regionFactory, PoolFactory poolFactory, String poolName) throws CacheException {
        long start = this.statistics.startConnect();
        Pool pool = poolFactory.create(poolName);
        ((PoolImpl)pool).acquireConnection();
        RegionAttributes ratts = regionFactory.create();
        Region theRegion = theCache.createRegion("RecycledRegion", ratts);
        theRegion.close();
        pool.destroy();
        this.statistics.endConnect(start, this.isMainWorkload, this.histogram);
    }

    public static void cyclePoolTask() throws CacheException {
        CachePerfClient c = new CachePerfClient();
        c.initialize(14);
        c.cyclePool();
    }

    private void cyclePool() throws CacheException {
        String poolConfig = ConfigPrms.getPoolConfig();
        PoolFactory factory = (PoolFactory)cyclePoolFactory.get();
        if (factory == null) {
            DistributedSystem ds = DistributedSystemHelper.connect();
            this.openStatistics();
            factory = PoolHelper.getPoolFactory(poolConfig);
            cyclePoolFactory.set(factory);
        }
        int ms = CachePerfPrms.getSleepMs();
        boolean batchDone = false;
        do {
            this.executeTaskTerminator();
            this.executeWarmupTerminator();
            this.cyclePool(factory, poolConfig);
            ++this.batchCount;
            ++this.count;
            batchDone = this.executeBatchTerminator();
            MasterController.sleepForMs(ms);
        } while (!batchDone);
    }

    private void cyclePool(PoolFactory factory, String poolName) throws CacheException {
        long start = this.statistics.startConnect();
        Pool pool = factory.create(poolName);
        ((PoolImpl)pool).acquireConnection();
        pool.destroy();
        this.statistics.endConnect(start, this.isMainWorkload, this.histogram);
    }

    public static void cycleDurableClientTask() throws CacheException, InterruptedException {
        CachePerfClient c = new CachePerfClient();
        c.initialize(14);
        c.cycleDurableClient();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cycleDurableClient() throws CacheException, InterruptedException {
        DistributedSystem ds = DistributedSystemHelper.getDistributedSystem();
        if (ds == null) {
            ds = DistributedSystemHelper.connect();
            this.openStatistics();
        }
        String regionConfig = ConfigPrms.getRegionConfig();
        String poolName = RegionHelper.getRegionDescription(regionConfig).getPoolDescription().getName();
        PoolFactory poolFactory = (PoolFactory)cyclePoolFactory.get();
        if (poolFactory == null) {
            poolFactory = PoolHelper.getPoolFactory(poolName);
            cyclePoolFactory.set(poolFactory);
        }
        AttributesFactory regionFactory = RegionHelper.getAttributesFactory(regionConfig);
        int ms = CachePerfPrms.getSleepMs();
        boolean batchDone = false;
        AnyCyclicBarrier barrier = AnyCyclicBarrier.lookup(TestHelper.getNumThreads(), "cachePerfBarrier");
        do {
            barrier.await();
            try {
                try {
                    this.executeTaskTerminator();
                }
                catch (StopSchedulingTaskOnClientOrder e) {
                    this.signal();
                    throw e;
                }
                this.executeWarmupTerminator();
                this.durableClientConnect(ds, poolFactory, poolName, regionFactory);
            }
            finally {
                barrier.await();
            }
            ++this.batchCount;
            ++this.count;
            batchDone = this.executeBatchTerminator();
            MasterController.sleepForMs(ms);
        } while (!batchDone);
    }

    private void durableClientConnect(DistributedSystem ds, PoolFactory poolFactory, String poolName, AttributesFactory regionFactory) throws CacheException, InterruptedException {
        final LinkedBlockingQueue queue = new LinkedBlockingQueue();
        CacheListenerAdapter listener = new CacheListenerAdapter(){
            AtomicInteger updateCount = new AtomicInteger();

            public void afterCreate(EntryEvent event) {
                this.updateCount.incrementAndGet();
            }

            public void afterUpdate(EntryEvent event) {
                this.updateCount.incrementAndGet();
            }

            public void afterRegionLive(RegionEvent event) {
                queue.add(new Integer(this.updateCount.get()));
            }
        };
        long start = this.statistics.startConnect();
        Cache theCache = CacheFactory.create((DistributedSystem)ds);
        Pool pool = poolFactory.create(poolName);
        regionFactory.addCacheListener((CacheListener)listener);
        RegionAttributes ratts = regionFactory.create();
        Region theRegion = theCache.createRegion("DefaultRegion", ratts);
        theRegion.registerInterestRegex(".*", true);
        theCache.readyForEvents();
        Integer updateCount = (Integer)queue.take();
        this.statistics.endConnect(start, false, this.histogram);
        this.statistics.incUpdateEvents(updateCount);
        this.statistics.setOpTime(this.statistics.getConnectTime());
        this.statistics.setOps(updateCount + this.statistics.getOps());
        theCache.close(true);
        pool.destroy();
    }

    public static void putDataAndSyncTask() throws InterruptedException {
        CachePerfClient.putDataTask();
        AnyCyclicBarrier barrier = AnyCyclicBarrier.lookup(TestHelper.getNumThreads(), "cachePerfBarrier");
        barrier.await();
        barrier.await();
    }

    public static void putDataGatewayTask() {
        CachePerfClient c = new CachePerfClient();
        c.initialize(3);
        c.putDataGateway();
    }

    private void putDataGateway() {
        if (this.useTransactions) {
            this.begin();
        }
        int gatewayQueueEntries = CachePerfPrms.getGatewayQueueEntries();
        boolean batchDone = false;
        do {
            this.executeTaskTerminator();
            this.executeWarmupTerminator();
            for (int i = 0; i < gatewayQueueEntries; ++i) {
                int key = this.getNextKey();
                this.put(key);
                ++this.batchCount;
                ++this.count;
                ++this.keyCount;
                ++this.iterationsSinceTxEnd;
            }
            this.waitForGatewayQueuesToDrain();
        } while (!(batchDone = this.executeBatchTerminator()));
    }

    private void waitForGatewayQueuesToDrain() {
        int size;
        long start = this.statistics.startGatewayQueueDrain();
        GatewayHub hub = GatewayHubHelper.getGatewayHub();
        List gateways = hub.getGateways();
        do {
            MasterController.sleepForMs(1);
            size = 0;
            for (Gateway gateway : gateways) {
                size += gateway.getQueueSize();
            }
        } while (size != 0);
        this.statistics.endGatewayQueueDrain(start, 1, this.isMainWorkload, this.histogram);
    }

    public static void putDataGWSenderTask() {
        CachePerfClient c = new CachePerfClient();
        c.initialize(3);
        c.putDataGWSender();
    }

    private void putDataGWSender() {
        if (this.useTransactions) {
            this.begin();
        }
        int gatewayQueueEntries = CachePerfPrms.getGatewayQueueEntries();
        boolean batchDone = false;
        do {
            this.executeTaskTerminator();
            this.executeWarmupTerminator();
            for (int i = 0; i < gatewayQueueEntries; ++i) {
                int key = this.getNextKey();
                this.put(key);
                ++this.batchCount;
                ++this.count;
                ++this.keyCount;
                ++this.iterationsSinceTxEnd;
            }
            this.waitForGWSenderQueuesToDrain();
        } while (!(batchDone = this.executeBatchTerminator()));
    }

    private void waitForGWSenderQueuesToDrain() {
        long start = this.statistics.startGatewayQueueDrain();
        Set<GatewaySender> senders = GatewaySenderHelper.getGatewaySenders();
        while (senders != null) {
            MasterController.sleepForMs(1);
            int size = 0;
            int totalBatchSize = 0;
            for (GatewaySender sender : senders) {
                totalBatchSize += sender.getBatchSize();
                Set rqs = ((AbstractGatewaySender)sender).getQueues();
                for (RegionQueue rq : rqs) {
                    size += rq.size();
                }
            }
            if (size > totalBatchSize) continue;
            break;
        }
        this.statistics.endGatewayQueueDrain(start, 1, this.isMainWorkload, this.histogram);
    }

    public static void cycleGatewayHubConnectionTask() throws CacheException {
        CachePerfClient c = new CachePerfClient();
        c.initialize(14);
        c.cycleGatewayHubConnection();
    }

    private void cycleGatewayHubConnection() {
        GatewayHub hub = GatewayHubHelper.getGatewayHub();
        int ms = CachePerfPrms.getSleepMs();
        boolean batchDone = false;
        do {
            this.executeTaskTerminator();
            this.executeWarmupTerminator();
            this.cycleGatewayHub(hub, ms);
            ++this.batchCount;
            ++this.count;
        } while (!(batchDone = this.executeBatchTerminator()));
    }

    private void cycleGatewayHub(GatewayHub hub, int throttle) {
        long start = this.statistics.startConnect();
        try {
            hub.start();
        }
        catch (IOException e) {
            String s = "Problem starting gateway hub " + hub;
            throw new HydraRuntimeException(s, e);
        }
        this.statistics.endConnect(start, this.isMainWorkload, this.histogram);
        MasterController.sleepForMs(throttle);
        hub.stop();
    }

    public static void cycleLockTask() {
        CachePerfClient c = new CachePerfClient();
        c.initialize(16);
        c.cycleLock();
    }

    private void cycleLock() {
        if (this.useTransactions) {
            this.begin();
        }
        do {
            int key = this.getNextKey();
            this.executeTaskTerminator();
            this.executeWarmupTerminator();
            this.cycleLock(key);
            this.batchCount += this.optimizationCount;
            ++this.count;
            ++this.keyCount;
            ++this.iterationsSinceTxEnd;
        } while (!this.executeBatchTerminator());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cycleLock(int i) {
        Region r = ((GemFireCacheTestImpl)this.cache).getRegion();
        Object key = ObjectHelper.createName(this.keyType, i);
        Lock entryLock = r.getDistributedLock(key);
        long start = this.statistics.startLock();
        for (int j = 0; j < this.optimizationCount; ++j) {
            entryLock.lock();
            entryLock.unlock();
        }
        this.statistics.endLock(start, this.optimizationCount, this.isMainWorkload, this.histogram);
    }

    public static void reportTrimIntervalsTask() {
        CachePerfClient c = new CachePerfClient();
        c.initHydraThreadLocals();
        c.reportTrimIntervals();
    }

    private void reportTrimIntervals() {
        Map trimIntervals = this.getTrimIntervals();
        if (trimIntervals.size() > 0) {
            PerfStatMgr.getInstance().reportTrimIntervals(trimIntervals);
        }
    }

    public static void reportExtendedTrimIntervalsTask() {
        CachePerfClient c = new CachePerfClient();
        c.initHydraThreadLocals();
        c.reportExtendedTrimIntervals();
    }

    private void reportExtendedTrimIntervals() {
        Map trimIntervals = this.getTrimIntervals();
        if (trimIntervals.size() > 0) {
            PerfStatMgr.getInstance().reportExtendedTrimIntervals(trimIntervals);
        }
    }

    public static void validateMaxKeysRegionEntriesTask() {
        CachePerfClient c = new CachePerfClient();
        c.initialize();
        c.validateMaxKeysRegionEntries();
    }

    private void validateMaxKeysRegionEntries() {
        int sz = this.cache.size();
        if (sz != this.maxKeys) {
            if (DistributionManager.VERBOSE && this.cache instanceof GemFireCacheTestImpl) {
                for (Region.Entry re : ((GemFireCacheTestImpl)this.cache).getRegion().entrySet()) {
                    Log.getLogWriter().info("(region dump) key = " + re.getKey());
                }
            }
            throw new CachePerfException("Expected region with " + this.maxKeys + " entries but found " + sz);
        }
        CachePerfClient.log().info("Got the expected number of region entries: " + sz);
    }

    public static void doGC() throws CacheException {
        Log.getLogWriter().info("Calling System.gc()");
        System.gc();
        Log.getLogWriter().info("Done calling System.gc()");
    }

    public void processNullValue(Object key) {
        if (!this.allowNulls) {
            String s = "Got null at key=" + key + ", maxKeys=" + this.maxKeys;
            throw new HydraRuntimeException(s);
        }
        this.statistics.incNulls();
    }

    protected int getNextKey() {
        int key;
        switch (this.keyAllocation) {
            case 0: {
                key = 0;
                break;
            }
            case 1: {
                key = this.keyCount;
                break;
            }
            case 2: {
                key = this.keyCount % this.maxKeys;
                break;
            }
            case 3: {
                key = this.rng.nextInt(0, this.maxKeys - 1);
                break;
            }
            case 4: {
                if (this.currentKey == -1) {
                    this.checkSufficientKeys();
                    key = this.ttgid;
                    break;
                }
                key = this.currentKey;
                break;
            }
            case 5: {
                if (this.currentKey == -1) {
                    this.checkSufficientKeys();
                    key = this.ttgid;
                    break;
                }
                key = this.currentKey + this.numThreads;
                break;
            }
            case 6: {
                if (this.currentKey == -1) {
                    this.checkSufficientKeys();
                    key = this.ttgid;
                } else {
                    key = this.currentKey + this.numThreads;
                }
                if (key < this.maxKeys) break;
                key = this.ttgid;
                break;
            }
            case 7: {
                if (this.currentKey == -1) {
                    this.checkSufficientKeys();
                }
                int numKeys = (int)Math.ceil(this.maxKeys / this.numThreads);
                if (this.ttgid >= this.maxKeys % this.numThreads) {
                    --numKeys;
                }
                key = this.ttgid + this.numThreads * this.rng.nextInt(0, numKeys);
                break;
            }
            case 8: {
                if (this.currentKey == -1) {
                    this.checkSufficientKeys();
                    key = this.ttgid * this.keyAllocationChunkSize;
                    break;
                }
                if ((this.currentKey + 1) % this.keyAllocationChunkSize == 0) {
                    key = this.currentKey + 1 + (this.numThreads - 1) * this.keyAllocationChunkSize;
                    break;
                }
                key = this.currentKey + 1;
                break;
            }
            case 9: {
                if (this.currentKey == -1) {
                    this.checkSufficientKeys();
                    if (this.maxKeys % this.keyAllocationChunkSize != 0) {
                        String s = BasePrms.nameForKey(CachePerfPrms.keyAllocationChunkSize) + "=" + this.keyAllocationChunkSize + " does not evenly divide " + BasePrms.nameForKey(CachePerfPrms.maxKeys) + "=" + this.maxKeys;
                        throw new HydraConfigException(s);
                    }
                }
                if (this.iterationsSinceTxEnd == 0) {
                    this.currentKey = -1;
                }
                if ((this.currentKey + 1) % this.keyAllocationChunkSize == 0) {
                    int numChunks = this.maxKeys / this.keyAllocationChunkSize;
                    int numChunksPerThread = (int)Math.ceil(numChunks / this.numThreads);
                    if (this.ttgid >= numChunks % this.numThreads) {
                        --numChunksPerThread;
                    }
                    int chunk = this.ttgid + this.numThreads * this.rng.nextInt(0, numChunksPerThread);
                    key = chunk * this.keyAllocationChunkSize;
                    break;
                }
                key = this.currentKey + 1;
                break;
            }
            case 10: {
                if (this.currentKey == -1) {
                    this.checkSufficientKeys();
                    key = this.ttgid;
                } else {
                    key = this.currentKey + this.numThreads;
                }
                if (key < this.maxKeys) break;
                key = (this.ttgid + (int)Math.ceil(this.count / this.numThreads)) % this.numThreads;
                break;
            }
            case 11: {
                Long aKey = this.getNextPseudoRandomUniqueKey();
                if (aKey == null) {
                    this.updateHydraThreadLocals();
                    throw new StopSchedulingTaskOnClientOrder();
                }
                key = (int)aKey.longValue();
                break;
            }
            case 12: {
                key = this.keyGenerator.nextInt();
                break;
            }
            case 13: {
                key = this.keyGenerator.nextInt();
                break;
            }
            default: {
                throw new HydraInternalException("Should not happen");
            }
        }
        this.currentKey = key;
        return key;
    }

    protected int getRecentKey() {
        int key;
        int maxRecentKeys = CachePerfPrms.maxRecentKeys();
        switch (this.keyAllocation) {
            case 0: {
                key = 0;
                break;
            }
            case 1: {
                throw new CachePerfException("Unsupported recent key for sameKeys");
            }
            case 2: {
                throw new CachePerfException("Unsupported recent key for sameKeysWrap");
            }
            case 3: {
                throw new CachePerfException("Unsupported recent key for sameKeysRandomWrap");
            }
            case 4: {
                throw new CachePerfException("Unsupported recent key for ownKey");
            }
            case 5: {
                int backNumKeys = this.rng.nextInt(0, maxRecentKeys - 1);
                key = Math.max(this.ttgid, this.currentKey - backNumKeys * this.numThreads);
                break;
            }
            case 6: {
                throw new CachePerfException("Unsupported recent key for ownKeysWrap");
            }
            case 7: {
                throw new CachePerfException("Unsupported recent key for ownKeysRandomWrap");
            }
            case 8: {
                throw new CachePerfException("Unsupported recent key for ownKeysChunked");
            }
            case 9: {
                throw new CachePerfException("Unsupported recent key for ownKeysChunkedRandomWrap");
            }
            case 10: {
                throw new CachePerfException("Unsupported recent key for disjointAsPossible");
            }
            default: {
                throw new HydraInternalException("Should not happen");
            }
        }
        return key;
    }

    private void checkSufficientKeys() {
        if (this.numThreads > this.maxKeys / this.keyAllocationChunkSize) {
            throw new HydraConfigException(this.maxKeys + " keys are not enough for " + this.numThreads + " threads to have their own keys (or chunk of keys)");
        }
    }

    private Long getNextPseudoRandomUniqueKey() {
        int maxKeyValue = this.maxKeys - 1;
        if (this.numPseudoRandomKeys == -1L) {
            long maxSeqNum = (int)Math.ceil((float)this.maxKeys / (float)this.numThreads);
            long startingSequenceNum = this.rng.nextLong(1L, maxSeqNum);
            this.setStartingSequenceNumber(startingSequenceNum);
            int percentage = CachePerfPrms.getKeyPercentage();
            long totalNumKeys = Math.round((double)this.maxKeys * ((double)percentage * 0.01));
            long numKeysPerThread = totalNumKeys / (long)this.numThreads;
            long remainder = totalNumKeys % (long)this.numThreads;
            long numKeysAvailToThisThread = maxSeqNum;
            if (remainder > 0L) {
                long counter;
                --numKeysAvailToThisThread;
                long keyForMaxSequenceNum = (long)this.ttgid + (maxSeqNum - 1L) * (long)this.numThreads;
                if (keyForMaxSequenceNum <= (long)maxKeyValue) {
                    ++numKeysAvailToThisThread;
                }
                if (numKeysAvailToThisThread > numKeysPerThread && (counter = CachePerfBlackboard.getInstance().getSharedCounters().incrementAndRead(CachePerfBlackboard.counter)) <= remainder) {
                    ++numKeysPerThread;
                }
            }
            this.setNumPseudoRandomKeys(numKeysPerThread);
            this.numPseudoRandomKeys = numKeysPerThread;
            this.setCurrentSequenceNumber(startingSequenceNum);
            this.currentSequenceNumber = startingSequenceNum;
            this.setCurrentNumPseudoRandomKeys(0L);
            this.currentNumPseudoRandomKeys = 0L;
        }
        if (this.currentNumPseudoRandomKeys >= this.numPseudoRandomKeys) {
            return null;
        }
        long key = (long)this.ttgid + (this.currentSequenceNumber - 1L) * (long)this.numThreads;
        if (key > (long)maxKeyValue) {
            this.currentSequenceNumber = 1L;
            key = this.ttgid;
        }
        ++this.currentNumPseudoRandomKeys;
        ++this.currentSequenceNumber;
        return new Long(key);
    }

    protected boolean executeBatchTerminator() {
        if (this.timeToExecuteBatchTerminator()) {
            this.terminateBatch();
            return true;
        }
        return false;
    }

    protected boolean timeToExecuteBatchTerminator() {
        if (this.batchTerminator != null) {
            Object o = this.executeTerminator(this.batchTerminator);
            if (((Boolean)o).booleanValue()) {
                return true;
            }
            this.checkForTxEnd(0);
        }
        return false;
    }

    protected void terminateBatch() {
        this.registerInterest(1, this.interestListBatch);
        this.checkForTxEnd(1);
        this.cacheEndTrim(this.trimIntervals, this.trimInterval);
        this.updateHydraThreadLocals();
        DistributedSystem.releaseThreadsSockets();
    }

    protected void executeWarmupTerminator() {
        if (this.timeToExecuteWarmupTerminator()) {
            this.terminateWarmup();
        }
    }

    protected boolean timeToExecuteWarmupTerminator() {
        boolean check;
        if (this.warmupTerminator != null && !this.warmedUp && (check = this.checkFrequency(this.lastWarmupTerminatorTime, this.warmupTerminatorFrequency))) {
            Object o = this.executeTerminator(this.warmupTerminator);
            if (((Boolean)o).booleanValue()) {
                return true;
            }
            this.lastWarmupTerminatorTime = System.currentTimeMillis();
        }
        return false;
    }

    protected void terminateWarmup() {
        this.registerInterest(1, this.interestListBatch);
        this.checkForTxEnd(2);
        this.warmedUp = true;
        this.warmupCount = this.count;
        this.warmupTime = System.currentTimeMillis() - this.startTime;
        this.sync();
        if (this.useTransactions) {
            this.begin();
        }
        this.cacheStartTrim(this.trimIntervals, this.trimInterval);
    }

    protected void executeTaskTerminator() {
        if (this.timeToExecuteTaskTerminator()) {
            this.terminateTask();
        }
    }

    protected boolean timeToExecuteTaskTerminator() {
        boolean check;
        if (this.taskTerminator != null && (check = this.checkFrequency(this.lastTaskTerminatorTime, this.taskTerminatorFrequency))) {
            Object o = this.executeTerminator(this.taskTerminator);
            if (((Boolean)o).booleanValue()) {
                return true;
            }
            this.lastTaskTerminatorTime = System.currentTimeMillis();
        }
        return false;
    }

    protected void terminateTask() {
        if (this.warmupTerminator != null && !this.warmedUp) {
            String s = "Task terminator " + this.taskTerminator + " ran before warmup terminator " + this.warmupTerminator;
            throw new HydraConfigException(s);
        }
        this.registerInterest(1, this.interestListBatch);
        this.checkForTxEnd(3);
        this.cacheEndTrim(this.trimIntervals, this.trimInterval);
        this.updateHydraThreadLocals();
        throw new StopSchedulingTaskOnClientOrder();
    }

    protected Method getMethod(String className, String methodName) {
        if (methodName == null || methodName.equals("null")) {
            return null;
        }
        try {
            Class<?> cls = Class.forName(className);
            Class[] prmTypes = new Class[]{CachePerfClient.class};
            return MethExecutor.getMethod(cls, methodName, prmTypes);
        }
        catch (ClassNotFoundException e) {
            throw new HydraConfigException(className + " not found", e);
        }
        catch (NoSuchMethodException e) {
            throw new HydraConfigException(className + "." + methodName + "(CachePerfClient) not found", e);
        }
    }

    protected boolean checkFrequency(long lastCheckTime, CachePerfPrms.Frequency f) {
        boolean check;
        block0 : switch (f.type) {
            case 0: {
                check = this.count % this.batchSize == 0;
                break;
            }
            case 1: {
                switch (f.frequency) {
                    case 0: {
                        check = false;
                        break block0;
                    }
                    case 1: {
                        check = true;
                        break block0;
                    }
                }
                check = this.count % f.frequency == 0;
                break;
            }
            case 2: {
                switch (f.frequency) {
                    case 0: {
                        check = true;
                        break block0;
                    }
                }
                long now = System.currentTimeMillis();
                return lastCheckTime + (long)(f.frequency * 1000) <= now;
            }
            default: {
                throw new HydraRuntimeException("Should not happen");
            }
        }
        return check;
    }

    protected Object executeTerminator(Method m) {
        try {
            return m.invoke(null, this.terminatorArgs);
        }
        catch (ClassCastException e) {
            throw new HydraConfigException(m + " does not return a String", e);
        }
        catch (IllegalAccessException e) {
            throw new HydraConfigException(m + " cannot be accessed", e);
        }
        catch (InvocationTargetException e) {
            throw new HydraConfigException(m + " cannot be invoked. " + "Exception is " + TestHelper.getStackTrace(e.getTargetException()), e);
        }
    }

    public static synchronized void stopOtherVMs() throws ClientVmNotFoundException {
        boolean useShutDownAllMembers = CachePerfPrms.useShutDownAllMembers();
        ArrayList<ClientVmInfo> stopVMs = null;
        if (useShutDownAllMembers) {
            AdminDistributedSystem adminDS = AdminHelper.getAdminDistributedSystem();
            stopVMs = (ArrayList<ClientVmInfo>)StopStartVMs.shutDownAllMembers(adminDS)[0];
        } else {
            List allVMs = StopStartVMs.getAllVMs();
            if (allVMs.size() == 0) {
                throw new TestException("allVMs is empty; need to add init task for StopStartVMs.StopStart_initTask");
            }
            stopVMs = new ArrayList<ClientVmInfo>();
            for (ClientVmInfo info : allVMs) {
                if (info.getClientName().indexOf("locator") >= 0 || info.getVmid() == RemoteTestModule.getMyVmid()) continue;
                stopVMs.add(info);
            }
            ArrayList<String> stopModeList = new ArrayList<String>();
            while (stopModeList.size() < stopVMs.size()) {
                stopModeList.add("nice_exit");
            }
            StopStartVMs.stopVMs(stopVMs, stopModeList);
        }
        if (CachePerfPrms.restartVMs()) {
            StopStartVMs.startVMs(stopVMs);
        }
    }

    protected void cacheStartTrim(Map intervals, int name) {
        TrimInterval interval = this.getTrimInterval(intervals, name);
        TrimInterval mainInterval = this.getTrimInterval(intervals, 13);
        if (interval != null || mainInterval != null) {
            long now = System.currentTimeMillis();
            if (interval != null) {
                interval.setStart(now);
            }
            if (mainInterval != null) {
                mainInterval.setStart(now);
            }
        }
    }

    protected void cacheEndTrim(Map intervals, int name) {
        TrimInterval interval = this.getTrimInterval(intervals, name);
        TrimInterval mainInterval = this.getTrimInterval(intervals, 13);
        if (interval != null || mainInterval != null) {
            long now = System.currentTimeMillis();
            if (interval != null) {
                interval.setEnd(now);
            }
            if (mainInterval != null) {
                mainInterval.setEnd(now);
            }
        }
    }

    protected TrimInterval getTrimInterval(Map intervals, int name) {
        if (name != -1) {
            return (TrimInterval)intervals.get(this.nameFor(name));
        }
        return null;
    }

    protected void sync() {
        CachePerfClient.log().info("syncing");
        Vector threadGroupNames = this.task.getThreadGroupNames();
        for (String threadGroupName : threadGroupNames) {
            HydraThreadGroup threadGroup = this.tc().getThreadGroup(threadGroupName);
            int totalThreads = threadGroup.getTotalThreads();
            SharedCounters counters = TaskSyncBlackboard.getInstance().getSharedCounters();
            String fieldName = null;
            Field field = null;
            try {
                fieldName = this.task.getSelector();
                field = TaskSyncBlackboard.class.getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException e) {
                throw new CachePerfException("Need to add field " + fieldName + " to cacheperf.TaskSyncBlackboard", e);
            }
            int counter = -1;
            try {
                counter = (Integer)field.get(null);
            }
            catch (IllegalAccessException e) {
                throw new CachePerfException("Unable to access field " + fieldName + " in TaskSyncBlackboard", e);
            }
            if (CachePerfClient.log().fineEnabled()) {
                CachePerfClient.log().fine("Waiting for " + totalThreads + " threads" + " at barrier for " + fieldName + " (" + counter + ")");
            }
            long threadCount = counters.incrementAndRead(counter);
            while (threadCount < (long)totalThreads) {
                MasterController.sleepForMs(1000);
                threadCount = counters.read(counter);
            }
        }
        if (this.syncSleepMs > 0) {
            CachePerfClient.log().info("Sleeping after sync for " + this.syncSleepMs + " millis");
            MasterController.sleepForMs(this.syncSleepMs);
        }
        CachePerfClient.log().info("done syncing");
    }

    public static void sleepTask() {
        MasterController.sleepForMs(CachePerfPrms.getSleepMs());
    }

    public static void dumpHeapTask() {
        CachePerfClient c = new CachePerfClient();
        c.initLocalVariables(-1);
        c.dumpHeap();
    }

    private void dumpHeap() {
        if (this.ttgid == 0) {
            CachePerfClient.log().severe(ProcessMgr.fgexec("sh heapdumprun.sh", 600));
        }
    }

    public static void sleepTaskWithTrim() {
        CachePerfClient c = new CachePerfClient();
        c.initialize(20);
        c.cacheStartTrim(c.trimIntervals, c.trimInterval);
        MasterController.sleepForMs(CachePerfPrms.getSleepMs());
        c.cacheEndTrim(c.trimIntervals, c.trimInterval);
        c.updateHydraThreadLocals();
    }

    public static void clearTask() {
        CachePerfClient c = new CachePerfClient();
        c.initialize();
        if (!(c.cache instanceof GemFireCacheTestImpl)) {
            String s = "clear() not supported for " + c.cache;
            throw new HydraConfigException(s);
        }
        Region r = ((GemFireCacheTestImpl)c.cache).getRegion();
        r.clear();
    }

    public static void startJProbeTask() {
    }

    public static void stopJProbeTask() {
    }

    public void validate(int index, Object obj) {
        if (CachePerfClient.log().fineEnabled()) {
            if (obj == null) {
                CachePerfClient.log().fine("Validating null:" + index + "=" + obj);
            } else {
                CachePerfClient.log().fine("Validating " + obj.getClass().getName() + ":" + index + "=" + obj);
            }
        }
        ObjectHelper.validate(index, obj);
        if (CachePerfClient.log().fineEnabled()) {
            if (obj == null) {
                CachePerfClient.log().fine("Validated null:" + index + "=" + obj);
            } else {
                CachePerfClient.log().fine("Validated " + obj.getClass().getName() + ":" + index + "=" + obj);
            }
        }
    }

    protected void initialize() {
        this.initialize(-1);
    }

    protected void initialize(int trimInterval) {
        this.initLocalVariables(trimInterval);
        this.initLocalParameters();
        this.initHydraThreadLocals();
        this.initBatchVariables();
    }

    protected void initLocalVariables(int trimInterval) {
        this.trimInterval = trimInterval;
        this.jid = this.jid();
        this.tid = this.tid();
        this.tgid = this.tgid();
        this.ttgid = this.ttgid();
        this.sttgid = this.sttgid();
        this.numWanSites = this.numWanSites();
        this.numThreads = CachePerfClient.numThreads();
        Assert.assertTrue((this.numThreads > 0 ? 1 : 0) != 0, (Object)("Have " + this.numThreads + " threads"));
        this.iterationsSinceTxEnd = 0;
    }

    protected void initBatchVariables() {
        this.batchCount = 0;
        this.batchStartTime = System.currentTimeMillis();
        this.hadFullSizeTx = false;
    }

    protected void initLocalParameters() {
        this.isMainWorkload = CachePerfPrms.isMainWorkload();
        this.trimIterations = CachePerfPrms.getTrimIterations();
        this.workIterations = CachePerfPrms.getWorkIterations();
        this.numOperations = CachePerfPrms.getNumOperations();
        this.batchSize = CachePerfPrms.getBatchSize();
        this.trimSeconds = CachePerfPrms.getTrimSeconds();
        this.workSeconds = CachePerfPrms.getWorkSeconds();
        this.batchSeconds = CachePerfPrms.getBatchSeconds();
        this.syncSleepMs = CachePerfPrms.syncSleepMs();
        this.commitPercentage = CachePerfPrms.getCommitPercentage();
        this.txSize = CachePerfPrms.getTxSize();
        this.keyAllocation = CachePerfPrms.getKeyAllocation();
        this.keyAllocationChunkSize = CachePerfPrms.getKeyAllocationChunkSize();
        this.maxKeys = CachePerfPrms.getMaxKeys();
        if (CachePerfClient.log().fineEnabled()) {
            if (this.workIterations != -1) {
                CachePerfClient.log().fine("trimIterations=" + this.trimIterations + " workIterations=" + this.workIterations + " batchSize=" + this.batchSize);
            } else if (this.workSeconds != -1) {
                CachePerfClient.log().fine("trimSeconds=" + this.trimSeconds + " workSeconds=" + this.workSeconds + " batchSeconds=" + this.batchSeconds);
            }
            CachePerfClient.log().fine("maxKeys=" + this.maxKeys);
        }
        this.optimizationCount = CachePerfPrms.getOptimizationCount();
        this.allowNulls = CachePerfPrms.allowNulls();
        this.validateObjects = CachePerfPrms.validateObjects();
        this.invalidateAfterGet = CachePerfPrms.invalidateAfterGet();
        this.invalidateLocally = CachePerfPrms.invalidateLocally();
        this.destroyAfterGet = CachePerfPrms.destroyAfterGet();
        this.destroyLocally = CachePerfPrms.destroyLocally();
        this.sleepBeforeOp = CachePerfPrms.sleepBeforeOp();
        this.useTransactions = CachePerfPrms.useTransactions();
        this.allowConflicts = CachePerfPrms.allowConflicts();
        this.registerDurableInterest = CachePerfPrms.registerDurableInterest();
        this.batchTerminator = this.getMethod(CachePerfPrms.getBatchTerminatorClass(), CachePerfPrms.getBatchTerminatorMethod());
        this.warmupTerminator = this.getMethod(CachePerfPrms.getWarmupTerminatorClass(), CachePerfPrms.getWarmupTerminatorMethod());
        this.taskTerminator = this.getMethod(CachePerfPrms.getTaskTerminatorClass(), CachePerfPrms.getTaskTerminatorMethod());
        this.terminatorArgs = new Object[]{this};
        this.warmupTerminatorFrequency = CachePerfPrms.getWarmupTerminatorFrequency();
        this.taskTerminatorFrequency = CachePerfPrms.getTaskTerminatorFrequency();
    }

    protected void initHydraThreadLocals() {
        String key;
        this.task = this.getTask();
        this.trimIntervals = this.getTrimIntervals();
        if (this.trimInterval != -1 && !this.trimIntervals.containsKey(key = this.nameFor(this.trimInterval))) {
            this.trimIntervals.put(key, new TrimInterval());
        }
        if (this.isMainWorkload && !this.trimIntervals.containsKey(key = this.nameFor(13))) {
            this.trimIntervals.put(key, new TrimInterval());
        }
        this.rng = this.getRNG();
        this.keyGenerator = this.getKeyGenerator();
        this.statistics = this.getStatistics();
        this.histogram = this.getHistogram();
        this.cache = this.getCache();
        this.tm = this.getTxMgr();
        TestTask task = RemoteTestModule.getCurrentThread().getCurrentTask();
        if (DistCachePrms.getCacheVendor() == 0) {
            EdgeHelper.restoreThreadLocalConnections();
        }
        this.warmedUp = this.getWarmedUp();
        this.warmupCount = this.getWarmUpCount();
        this.warmupTime = this.getWarmUpTime();
        this.count = this.getCount();
        this.keyCount = this.getKeyCount();
        this.currentKey = this.getCurrentKey();
        this.keyType = this.getKeyType();
        this.lastWarmupTerminatorTime = this.getLastWarmupTerminatorTime();
        this.lastTaskTerminatorTime = this.getLastTaskTerminatorTime();
        this.startTime = this.getStartTime();
        this.numPseudoRandomKeys = this.getNumPseudoRandomKeys();
        this.currentSequenceNumber = this.getCurrentSequenceNumber();
        this.currentNumPseudoRandomKeys = this.getCurrentNumPseudoRandomKeys();
    }

    protected void resetHydraThreadLocals(boolean resetKeys) {
        localwarmedup.set(null);
        localwarmupcount.set(null);
        localwarmuptime.set(null);
        localcount.set(null);
        if (resetKeys) {
            localkeycount.set(null);
            localcurrentkey.set(null);
        }
        locallastwarmupterminatortime.set(null);
        locallasttaskterminatortime.set(null);
        localstarttime.set(null);
        HistogramStats h = (HistogramStats)localhistogram.get();
        if (h != null) {
            h.close();
            localhistogram.set(null);
        }
    }

    protected void updateHydraThreadLocals() {
        this.setStatistics(this.statistics);
        this.setHistogram(this.histogram);
        this.setCache(this.cache);
        this.setTxMgr(this.tm);
        TestTask task = RemoteTestModule.getCurrentThread().getCurrentTask();
        if (DistCachePrms.getCacheVendor() == 0) {
            EdgeHelper.saveThreadLocalConnections();
        }
        this.setWarmedUp(this.warmedUp);
        this.setWarmUpCount(this.warmupCount);
        this.setWarmUpTime(this.warmupTime);
        this.setCount(this.count);
        this.setKeyCount(this.keyCount);
        this.setCurrentKey(this.currentKey);
        this.setKeyType(this.keyType);
        this.setLastWarmupTerminatorTime(this.lastWarmupTerminatorTime);
        this.setLastTaskTerminatorTime(this.lastTaskTerminatorTime);
        this.setStartTime(this.startTime);
        this.setCurrentSequenceNumber(this.currentSequenceNumber);
        this.setCurrentNumPseudoRandomKeys(this.currentNumPseudoRandomKeys);
    }

    protected TestTask getTask() {
        TestTask oldTask = (TestTask)localtask.get();
        TestTask newTask = RemoteTestModule.getCurrentThread().getCurrentTask();
        if (oldTask == null) {
            localtask.set(newTask);
        } else if (!oldTask.equals(newTask)) {
            localtask.set(newTask);
            boolean resetKeysAfter = CachePerfPrms.resetKeysAfterTaskEnds(oldTask);
            boolean resetKeysBefore = CachePerfPrms.resetKeysBeforeTaskStarts(newTask);
            this.resetHydraThreadLocals(resetKeysAfter || resetKeysBefore);
        }
        return newTask;
    }

    protected CachePerfStats getStatistics() {
        CachePerfStats stats = (CachePerfStats)localstatistics.get();
        return stats;
    }

    protected void setStatistics(CachePerfStats stats) {
        localstatistics.set(stats);
    }

    protected HistogramStats getHistogram() {
        HistogramStats h = (HistogramStats)localhistogram.get();
        if (h == null && HistogramStatsPrms.enable()) {
            if (this.trimInterval != -1) {
                String instanceName = this.nameFor(this.trimInterval);
                CachePerfClient.log().info("Opening histogram for " + instanceName);
                h = HistogramStats.getInstance(instanceName);
                CachePerfClient.log().info("Opened histogram for " + instanceName);
            }
            localhistogram.set(h);
        }
        return h;
    }

    protected void setHistogram(HistogramStats h) {
        localhistogram.set(h);
    }

    protected Map getTrimIntervals() {
        HashMap trims = (HashMap)localtrimintervals.get();
        if (trims == null) {
            trims = new HashMap();
            localtrimintervals.set(trims);
        }
        return trims;
    }

    protected DistCache getCache() {
        DistCache c = (DistCache)localcache.get();
        return c;
    }

    protected void setCache(DistCache c) {
        localcache.set(c);
    }

    protected CacheTransactionManager getTxMgr() {
        CacheTransactionManager tm = (CacheTransactionManager)localtm.get();
        return tm;
    }

    protected void setTxMgr(CacheTransactionManager tm) {
        localtm.set(tm);
    }

    protected boolean getWarmedUp() {
        Boolean b = (Boolean)localwarmedup.get();
        if (b == null) {
            b = Boolean.FALSE;
            localwarmedup.set(b);
        }
        return b;
    }

    protected void setWarmedUp(boolean b) {
        localwarmedup.set(b);
    }

    protected int getWarmUpCount() {
        Integer i = (Integer)localwarmupcount.get();
        if (i == null) {
            i = new Integer(-1);
            localwarmupcount.set(i);
        }
        return i;
    }

    protected void setWarmUpCount(int i) {
        localwarmupcount.set(new Integer(i));
    }

    protected long getWarmUpTime() {
        Long t = (Long)localwarmuptime.get();
        if (t == null) {
            t = new Long(System.currentTimeMillis());
            localwarmuptime.set(t);
        }
        return t;
    }

    protected void setWarmUpTime(long i) {
        localwarmuptime.set(new Long(i));
    }

    protected int getCount() {
        Integer n = (Integer)localcount.get();
        if (n == null) {
            n = new Integer(0);
            localcount.set(n);
        }
        return n;
    }

    protected void setCount(int n) {
        localcount.set(new Integer(n));
    }

    protected int getKeyCount() {
        Integer n = (Integer)localkeycount.get();
        if (n == null) {
            n = new Integer(0);
            localkeycount.set(n);
        }
        return n;
    }

    protected void setKeyCount(int n) {
        localkeycount.set(new Integer(n));
    }

    protected int getCurrentKey() {
        Integer n = (Integer)localcurrentkey.get();
        if (n == null) {
            n = new Integer(-1);
            localcurrentkey.set(n);
        }
        return n;
    }

    protected void setCurrentKey(int n) {
        localcurrentkey.set(new Integer(n));
    }

    protected String getKeyType() {
        String t = (String)localkeytype.get();
        if (t == null) {
            t = CachePerfPrms.getKeyType();
            localkeytype.set(t);
        }
        return t;
    }

    protected void setKeyType(String t) {
        localkeytype.set(t);
    }

    protected long getLastWarmupTerminatorTime() {
        Long t = (Long)locallastwarmupterminatortime.get();
        if (t == null) {
            t = new Long(System.currentTimeMillis());
            locallastwarmupterminatortime.set(t);
        }
        return t;
    }

    protected void setLastWarmupTerminatorTime(long t) {
        locallastwarmupterminatortime.set(new Long(t));
    }

    protected long getLastTaskTerminatorTime() {
        Long t = (Long)locallasttaskterminatortime.get();
        if (t == null) {
            t = new Long(System.currentTimeMillis());
            locallasttaskterminatortime.set(t);
        }
        return t;
    }

    protected void setLastTaskTerminatorTime(long t) {
        locallasttaskterminatortime.set(new Long(t));
    }

    protected long getStartTime() {
        Long t = (Long)localstarttime.get();
        if (t == null) {
            t = new Long(System.currentTimeMillis());
            localstarttime.set(t);
        }
        return t;
    }

    protected void setStartTime(long t) {
        localstarttime.set(new Long(t));
    }

    protected GsRandom getRNG() {
        GsRandom r = (GsRandom)localrng.get();
        if (r == null) {
            r = this.tc().getParameters().getRandGen();
            localrng.set(r);
        }
        return r;
    }

    protected Random getKeyGenerator() {
        Random keyGenerator = (Random)localKeyGenerator.get();
        if (keyGenerator == null) {
            if (this.keyAllocation == 12) {
                keyGenerator = new ZipfianGenerator(this.maxKeys);
            } else if (this.keyAllocation == 13) {
                keyGenerator = new ScrambledZipfianGenerator(this.maxKeys);
            }
            localKeyGenerator.set(keyGenerator);
        }
        return keyGenerator;
    }

    protected long getStartingSequenceNumber() {
        Long n = (Long)localstartingsequencenumber.get();
        if (n == null) {
            n = new Long(-1L);
            localstartingsequencenumber.set(n);
        }
        return n;
    }

    protected void setStartingSequenceNumber(long i) {
        localstartingsequencenumber.set(new Long(i));
    }

    protected long getNumPseudoRandomKeys() {
        Long n = (Long)localnumpseudorandomkeys.get();
        if (n == null) {
            n = new Long(-1L);
            localnumpseudorandomkeys.set(n);
        }
        return n;
    }

    protected void setNumPseudoRandomKeys(long i) {
        localnumpseudorandomkeys.set(new Long(i));
    }

    protected long getCurrentSequenceNumber() {
        Long n = (Long)localcurrentsequencenum.get();
        if (n == null) {
            n = new Long(-1L);
            localcurrentsequencenum.set(n);
        }
        return n;
    }

    protected void setCurrentSequenceNumber(long i) {
        localcurrentsequencenum.set(new Long(i));
    }

    protected long getCurrentNumPseudoRandomKeys() {
        Long n = (Long)localcurrentnumpseudorandomkeys.get();
        if (n == null) {
            n = new Long(-1L);
            localcurrentnumpseudorandomkeys.set(n);
        }
        return n;
    }

    protected void setCurrentNumPseudoRandomKeys(long i) {
        localcurrentnumpseudorandomkeys.set(new Long(i));
    }

    protected int jid() {
        if (CachePerfClient.log().fineEnabled()) {
            CachePerfClient.log().fine("jid=" + this.tid() % RemoteTestModule.getMyNumThreads());
        }
        return this.tid() % RemoteTestModule.getMyNumThreads();
    }

    protected int tid() {
        return RemoteTestModule.getCurrentThread().getThreadId();
    }

    protected int tgid() {
        return RemoteTestModule.getCurrentThread().getThreadGroupId();
    }

    protected int ttgid() {
        TestTask task = RemoteTestModule.getCurrentThread().getCurrentTask();
        String tgname = RemoteTestModule.getCurrentThread().getThreadGroupName();
        return task.getTaskThreadGroupId(tgname, this.tgid());
    }

    protected int sttgid() {
        List<List<String>> mappings = RemoteTestModule.getClientMapping();
        if (mappings == null) {
            String s = "Client mapping not found";
            throw new HydraRuntimeException(s);
        }
        String clientName = System.getProperty("clientName");
        String[] arr = clientName.split("_");
        if (arr.length != 3) {
            if (CachePerfClient.log().fineEnabled()) {
                CachePerfClient.log().fine("sttgid: single site, using ttgid=" + this.ttgid());
            }
            return this.ttgid();
        }
        String localsite = arr[1];
        String localthreadname = Thread.currentThread().getName();
        Vector threadgroups = RemoteTestModule.getCurrentThread().getCurrentTask().getThreadGroupNames();
        if (CachePerfClient.log().fineEnabled()) {
            CachePerfClient.log().fine("sttgid: matching " + localthreadname + " for site=" + localsite + " from threadgroups=" + threadgroups);
        }
        int count = 0;
        for (List<String> mapping : mappings) {
            String threadgroup = mapping.get(0);
            String threadname = mapping.get(1);
            if (CachePerfClient.log().fineEnabled()) {
                CachePerfClient.log().fine("sttgid: candidate threadgroup=" + threadgroup + " threadname= " + threadname);
            }
            if (threadgroups.contains(threadgroup)) {
                String[] carr = threadname.split("_");
                if (carr.length == 8) {
                    if (localthreadname.startsWith(threadname)) {
                        if (CachePerfClient.log().fineEnabled()) {
                            CachePerfClient.log().fine("sttgid: returning match for " + localthreadname + " as " + count);
                        }
                        return count;
                    }
                    String site = carr[5];
                    if (site.equals(localsite)) {
                        ++count;
                        if (!CachePerfClient.log().fineEnabled()) continue;
                        CachePerfClient.log().fine("sttgid: counting match " + count + "=" + threadname);
                        continue;
                    }
                    if (!CachePerfClient.log().fineEnabled()) continue;
                    CachePerfClient.log().fine("sttgid: candidate rejected=" + mapping + " invalid site=" + site);
                    continue;
                }
                String s = "Unexpected array size from " + threadname;
                throw new HydraRuntimeException(s);
            }
            if (!CachePerfClient.log().fineEnabled()) continue;
            CachePerfClient.log().fine("sttgid: candidate rejected=" + mapping + " invalid threadgroup=" + threadgroup);
        }
        String s = "Should not happen";
        throw new HydraInternalException(s);
    }

    protected int numWanSites() {
        int maxSite = CachePerfPrms.getNumWanSites();
        if (maxSite != 0) {
            return maxSite;
        }
        Vector clientNames = TestConfig.getInstance().getClientNames();
        for (String clientName : clientNames) {
            int site;
            String[] arr = clientName.split("_");
            if (arr.length != 3) {
                return 1;
            }
            try {
                site = Integer.parseInt(arr[1]);
            }
            catch (NumberFormatException e) {
                String s = clientName + " is not in the form <name>_<wanSiteNumber>_<itemNumber>";
                throw new HydraRuntimeException(s, e);
            }
            maxSite = Math.max(site, maxSite);
        }
        if (maxSite == 0) {
            String s = "Should not happen";
            throw new HydraInternalException(s);
        }
        return maxSite;
    }

    public static int numThreads() {
        TestTask task = RemoteTestModule.getCurrentThread().getCurrentTask();
        int t = task.getTotalThreads();
        return t;
    }

    protected static LogWriter log() {
        return Log.getLogWriter();
    }

    protected TestConfig tc() {
        if (this.tc == null) {
            this.tc = TestConfig.getInstance();
        }
        return this.tc;
    }

    protected void checkForTxEnd(int terminationType) {
        if (this.useTransactions) {
            switch (terminationType) {
                case 0: {
                    if (this.iterationsSinceTxEnd >= this.txSize) {
                        this.iterationsSinceTxEnd = 0;
                        this.endTx();
                        this.begin();
                    }
                    this.hadFullSizeTx = true;
                    break;
                }
                case 1: {
                    if (!this.hadFullSizeTx) {
                        String t = "Batch ended before a transaction using " + this.txSize + " operations had occurred.  Reconfigure either the" + " batch granularity or the transaction size.";
                        throw new HydraConfigException(t);
                    }
                    this.iterationsSinceTxEnd = 0;
                    this.endTx();
                    this.hadFullSizeTx = false;
                    break;
                }
                case 2: {
                    this.endTx();
                    break;
                }
                case 3: {
                    this.iterationsSinceTxEnd = 0;
                    this.endTx();
                    break;
                }
                default: {
                    String s = "Illegal termination type: " + terminationType;
                    throw new HydraInternalException(s);
                }
            }
        }
    }

    protected void begin() {
        this.tm.begin();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void endTx() {
        int n = this.rng.nextInt(1, 100);
        if (n <= this.commitPercentage) {
            try {
                this.tm.commit();
                return;
            }
            catch (RuntimeException e) {
                if (!e.getClass().getName().contains("ConflictException")) throw e;
                if (this.allowConflicts) return;
                throw new TestException("Detected ConflictException " + e, e);
            }
        } else {
            this.tm.rollback();
        }
    }
}

