/*
 * Decompiled with CFR 0.152.
 */
package cacheperf;

import cacheperf.CachePerfClient;
import hydra.BasePrms;
import hydra.HydraConfigException;
import hydra.HydraVector;
import hydra.Log;
import hydra.RemoteTestModule;
import hydra.TestTask;
import java.util.Iterator;

public class CachePerfPrms
extends BasePrms {
    private static final String CACHE_PERF_NONE = "none";
    public static Long isMainWorkload;
    public static Long trimSeconds;
    public static Long workSeconds;
    public static Long batchSeconds;
    public static Long trimIterations;
    public static Long workIterations;
    public static Long batchSize;
    public static Long txSize;
    public static Long numOperations;
    public static Long keyType;
    private static final String DEFAULT_KEY_ALLOCATION = "sameKeysWrap";
    public static Long keyAllocation;
    public static final int SAME_KEY = 0;
    public static final int SAME_KEYS = 1;
    public static final int SAME_KEYS_WRAP = 2;
    public static final int SAME_KEYS_RANDOM_WRAP = 3;
    public static final int OWN_KEY = 4;
    public static final int OWN_KEYS = 5;
    public static final int OWN_KEYS_WRAP = 6;
    public static final int OWN_KEYS_RANDOM_WRAP = 7;
    public static final int OWN_KEYS_CHUNKED = 8;
    public static final int OWN_KEYS_CHUNKED_RANDOM_WRAP = 9;
    public static final int DISJOINT_AS_POSSIBLE = 10;
    public static final int PSEUDO_RANDOM_UNIQUE = 11;
    public static final int ZIPFIAN = 12;
    public static final int SCRAMBLED_ZIPFIAN = 13;
    public static Long keyAllocationChunkSize;
    public static Long maxKeys;
    public static Long resetKeysAfterTaskEnds;
    public static Long resetKeysBeforeTaskStarts;
    public static Long objectType;
    public static Long allowNulls;
    public static Long validateObjects;
    public static Long invalidateAfterGet;
    public static Long invalidateLocally;
    public static Long destroyAfterGet;
    public static Long destroyLocally;
    public static Long sleepBeforeOp;
    public static Long sleepMs;
    public static Long sleepOpCount;
    public static Long gatewayQueueEntries;
    public static Long bulkOpMapSize;
    public static Long dummyBulkOps;
    public static Long interestBatchSize;
    public static Long logInterestRegex;
    public static Long registerDurableInterest;
    public static Long keepDurableInterest;
    public static Long restartVMs;
    private static final String DEFAULT_CLASS = "cacheperf.Terminators";
    public static Long batchTerminatorClass;
    public static Long batchTerminatorMethod;
    public static Long warmupTerminatorClass;
    public static Long warmupTerminatorMethod;
    public static Long warmupTerminatorFrequency;
    public static Long taskTerminatorClass;
    public static Long taskTerminatorMethod;
    public static Long taskTerminatorFrequency;
    public static final int PER_TASK = 0;
    public static final int PER_ITERATION = 1;
    public static final int PER_SECOND = 2;
    public static Long hitsAndMisses;
    public static Long hitPercentage;
    public static Long putPercentage;
    public static Long LRUEvictions;
    public static Long LRUEvictionsMinWaitSec;
    public static Long LRUEvictionsMaxWaitSec;
    public static Long numDestroys;
    public static Long numDestroysMinWaitSec;
    public static Long numDestroysMaxWaitSec;
    public static Long numUpdates;
    public static Long recentKeysPercentage;
    public static Long maxRecentKeys;
    public static Long syncSleepMs;
    public static Long useTransactions;
    public static Long allowConflicts;
    public static Long commitPercentage;
    public static Long maxExecutions;
    public static Long restartWaitSec;
    public static Long useMeanKill;
    public static Long clientNameToBounce;
    public static Long waitForRecovery;
    public static Long waitForTrimSignal;
    public static Long useShutDownAllMembers;
    public static Long query;
    public static Long queryIndex;
    public static Long queryFromClause;
    public static Long queryRangeMin;
    public static Long queryRangeMax;
    public static Long queryRangeSize;
    public static Long numWanSites;
    public static Long keyPercentage;
    public static Long optimizationCount;

    public static boolean isMainWorkload() {
        Long key = isMainWorkload;
        return CachePerfPrms.tasktab().booleanAt(key, CachePerfPrms.tab().booleanAt(key, false));
    }

    public static int getTrimSeconds() {
        Long key = trimSeconds;
        int val = CachePerfPrms.tasktab().intAt(key, CachePerfPrms.tab().intAt(key, -1));
        return val;
    }

    public static int getWorkSeconds() {
        Long key = workSeconds;
        int val = CachePerfPrms.tasktab().intAt(key, CachePerfPrms.tab().intAt(key, -1));
        return val;
    }

    public static int getBatchSeconds() {
        Long key = batchSeconds;
        int val = CachePerfPrms.tasktab().intAt(key, CachePerfPrms.tab().intAt(key, -1));
        return val;
    }

    public static int getTrimIterations() {
        Long key = trimIterations;
        int val = CachePerfPrms.tasktab().intAt(key, CachePerfPrms.tab().intAt(key, -1));
        return val == -1 ? val : CachePerfPrms.scale(val);
    }

    public static int getWorkIterations() {
        Long key = workIterations;
        int val = CachePerfPrms.tasktab().intAt(key, CachePerfPrms.tab().intAt(key, -1));
        return val == -1 ? val : CachePerfPrms.scale(val);
    }

    public static int getBatchSize() {
        Long key = batchSize;
        int val = CachePerfPrms.tasktab().intAt(key, CachePerfPrms.tab().intAt(key, -1));
        return val == -1 ? val : CachePerfPrms.scale(val);
    }

    public static int getTxSize() {
        Long key = txSize;
        int val = CachePerfPrms.tasktab().intAt(key, CachePerfPrms.tab().intAt(key, 1));
        return val;
    }

    private static int scale(int val) {
        if (val > 0) {
            int numThreads = CachePerfClient.numThreads();
            if (numThreads == 0) {
                CachePerfPrms.croak(val);
            }
            int n = (int)Math.ceil(val / numThreads);
            int rem = val % numThreads;
            RemoteTestModule mod = RemoteTestModule.getCurrentThread();
            int ttgid = mod.getCurrentTask().getTaskThreadGroupId(mod.getThreadGroupName(), mod.getThreadGroupId());
            return ttgid < rem ? n + 1 : n;
        }
        return val;
    }

    private static void croak(int val) {
        RemoteTestModule mod = RemoteTestModule.getCurrentThread();
        Log.getLogWriter().info("HEY ERROR: I am scaling " + val + " and got 0 numThreads. " + " I am in thread group " + mod.getThreadGroupName() + " and have thread group id " + mod.getThreadGroupId());
    }

    public static int getNumOperations() {
        Long key = numOperations;
        return CachePerfPrms.tasktab().intAt(key, CachePerfPrms.tab().intAt(key, -1));
    }

    public static String getKeyType() {
        Long key = keyType;
        return CachePerfPrms.tab().stringAt(key, "java.lang.String");
    }

    public static int getKeyAllocation() {
        Long key = keyAllocation;
        String val = CachePerfPrms.tasktab().stringAt(key, CachePerfPrms.tab().stringAt(key, DEFAULT_KEY_ALLOCATION));
        if (val.equalsIgnoreCase("sameKey")) {
            return 0;
        }
        if (val.equalsIgnoreCase("sameKeys")) {
            return 1;
        }
        if (val.equalsIgnoreCase(DEFAULT_KEY_ALLOCATION)) {
            return 2;
        }
        if (val.equalsIgnoreCase("sameKeysRandomWrap")) {
            return 3;
        }
        if (val.equalsIgnoreCase("ownKey")) {
            return 4;
        }
        if (val.equalsIgnoreCase("ownKeys")) {
            return 5;
        }
        if (val.equalsIgnoreCase("ownKeysWrap")) {
            return 6;
        }
        if (val.equalsIgnoreCase("ownKeysRandomWrap")) {
            return 7;
        }
        if (val.equalsIgnoreCase("ownKeysChunked")) {
            return 8;
        }
        if (val.equalsIgnoreCase("ownKeysChunkedRandomWrap")) {
            return 9;
        }
        if (val.equalsIgnoreCase("disjointAsPossible")) {
            return 10;
        }
        if (val.equalsIgnoreCase("pseudoRandomUnique")) {
            return 11;
        }
        if (val.equalsIgnoreCase("zipfian")) {
            return 12;
        }
        if (val.equalsIgnoreCase("scrambledZipfian")) {
            return 13;
        }
        throw new HydraConfigException("Illegal value for " + CachePerfPrms.nameForKey(key) + ": " + val);
    }

    public static int getKeyAllocationChunkSize() {
        Long key = keyAllocationChunkSize;
        return CachePerfPrms.tasktab().intAt(key, CachePerfPrms.tab().intAt(key, 1));
    }

    public static int getMaxKeys() {
        Long key = maxKeys;
        int val = CachePerfPrms.tasktab().intAt(key, CachePerfPrms.tab().intAt(key));
        if (val > 0) {
            return val;
        }
        throw new HydraConfigException("Illegal value for " + CachePerfPrms.nameForKey(key) + ": " + val);
    }

    public static boolean resetKeysAfterTaskEnds(TestTask task) {
        Long key = resetKeysAfterTaskEnds;
        return task.getTaskAttributes().booleanAt(key, CachePerfPrms.tab().booleanAt(key, true));
    }

    public static boolean resetKeysBeforeTaskStarts(TestTask task) {
        Long key = resetKeysBeforeTaskStarts;
        return task.getTaskAttributes().booleanAt(key, CachePerfPrms.tab().booleanAt(key, true));
    }

    public static String getObjectType() {
        Long key = objectType;
        return CachePerfPrms.tasktab().stringAt(key, CachePerfPrms.tab().stringAt(key, "objects.SizedString"));
    }

    public static boolean allowNulls() {
        Long key = allowNulls;
        return CachePerfPrms.tasktab().booleanAt(key, CachePerfPrms.tab().booleanAt(key, false));
    }

    public static boolean validateObjects() {
        Long key = validateObjects;
        return CachePerfPrms.tasktab().booleanAt(key, CachePerfPrms.tab().booleanAt(key, false));
    }

    public static boolean invalidateAfterGet() {
        Long key = invalidateAfterGet;
        return CachePerfPrms.tasktab().booleanAt(key, CachePerfPrms.tab().booleanAt(key, false));
    }

    public static boolean invalidateLocally() {
        Long key = invalidateLocally;
        return CachePerfPrms.tasktab().booleanAt(key, CachePerfPrms.tab().booleanAt(key, true));
    }

    public static boolean destroyAfterGet() {
        Long key = destroyAfterGet;
        return CachePerfPrms.tasktab().booleanAt(key, CachePerfPrms.tab().booleanAt(key, false));
    }

    public static boolean destroyLocally() {
        Long key = destroyLocally;
        return CachePerfPrms.tasktab().booleanAt(key, CachePerfPrms.tab().booleanAt(key, true));
    }

    public static boolean sleepBeforeOp() {
        Long key = sleepBeforeOp;
        return CachePerfPrms.tasktab().booleanAt(key, CachePerfPrms.tab().booleanAt(key, false));
    }

    public static int getSleepMs() {
        Long key = sleepMs;
        int val = CachePerfPrms.tasktab().intAt(key, CachePerfPrms.tab().intAt(key, 0));
        if (val < 0) {
            throw new HydraConfigException("Illegal value for " + CachePerfPrms.nameForKey(key) + ": " + val);
        }
        return val;
    }

    public static int getSleepOpCount() {
        Long key = sleepOpCount;
        int val = CachePerfPrms.tasktab().intAt(key, CachePerfPrms.tab().intAt(key, 1));
        if (val < 1) {
            throw new HydraConfigException("Illegal value for " + CachePerfPrms.nameForKey(key) + ": " + val);
        }
        return val;
    }

    public static int getGatewayQueueEntries() {
        Long key = gatewayQueueEntries;
        double val = CachePerfPrms.tab().doubleAt(key, 1.0);
        if (val <= 0.0) {
            String s = BasePrms.nameForKey(key) + " must be greater than 0";
            throw new HydraConfigException(s);
        }
        return (int)Math.round(val);
    }

    public static int getBulkOpMapSize() {
        Long key = bulkOpMapSize;
        int val = CachePerfPrms.tab().intAt(key, 1);
        if (val <= 0) {
            String s = BasePrms.nameForKey(key) + " must be greater than 0";
            throw new HydraConfigException(s);
        }
        return val;
    }

    public static boolean getDummyBulkOps() {
        Long key = dummyBulkOps;
        return CachePerfPrms.tasktab().booleanAt(key, CachePerfPrms.tab().booleanAt(key, false));
    }

    public static int getInterestBatchSize() {
        Long key = interestBatchSize;
        int val = CachePerfPrms.tab().intAt(key, 1);
        if (val <= 0) {
            String s = BasePrms.nameForKey(key) + " must be greater than 0";
            throw new HydraConfigException(s);
        }
        return val;
    }

    public static boolean logInterestRegex() {
        Long key = logInterestRegex;
        return CachePerfPrms.tasktab().booleanAt(key, CachePerfPrms.tab().booleanAt(key, false));
    }

    public static boolean registerDurableInterest() {
        Long key = registerDurableInterest;
        return CachePerfPrms.tasktab().booleanAt(key, CachePerfPrms.tab().booleanAt(key, false));
    }

    public static boolean getKeepDurableInterest() {
        Long key = keepDurableInterest;
        return CachePerfPrms.tasktab().booleanAt(key, CachePerfPrms.tab().booleanAt(key, false));
    }

    public static boolean restartVMs() {
        Long key = restartVMs;
        return CachePerfPrms.tasktab().booleanAt(key, CachePerfPrms.tab().booleanAt(key, true));
    }

    public static String getBatchTerminatorClass() {
        Long key = batchTerminatorClass;
        return CachePerfPrms.tasktab().stringAt(key, CachePerfPrms.tab().stringAt(key, DEFAULT_CLASS));
    }

    public static String getBatchTerminatorMethod() {
        return CachePerfPrms.getTerminatorMethod(batchTerminatorMethod, "terminateOnBatchSize");
    }

    public static String getWarmupTerminatorClass() {
        Long key = warmupTerminatorClass;
        return CachePerfPrms.tasktab().stringAt(key, CachePerfPrms.tab().stringAt(key, DEFAULT_CLASS));
    }

    public static String getWarmupTerminatorMethod() {
        return CachePerfPrms.getTerminatorMethod(warmupTerminatorMethod, "terminateOnTrimIterations");
    }

    public static Frequency getWarmupTerminatorFrequency() {
        HydraVector v = new HydraVector();
        v.add("1");
        v.add("iterations");
        return CachePerfPrms.getFrequency(warmupTerminatorFrequency, v);
    }

    public static String getTaskTerminatorClass() {
        Long key = taskTerminatorClass;
        return CachePerfPrms.tasktab().stringAt(key, CachePerfPrms.tab().stringAt(key, DEFAULT_CLASS));
    }

    public static String getTaskTerminatorMethod() {
        return CachePerfPrms.getTerminatorMethod(taskTerminatorMethod, "terminateOnTotalIterations");
    }

    private static String getTerminatorMethod(Long key, String dfault) {
        String val = CachePerfPrms.tasktab().stringAt(key, CachePerfPrms.tab().stringAt(key, dfault));
        return val == null || val.equalsIgnoreCase(CACHE_PERF_NONE) ? null : val;
    }

    public static Frequency getTaskTerminatorFrequency() {
        HydraVector v = new HydraVector();
        v.add("1");
        v.add("iterations");
        return CachePerfPrms.getFrequency(taskTerminatorFrequency, v);
    }

    private static Frequency getFrequency(Long key, HydraVector dfault) {
        HydraVector val = CachePerfPrms.tasktab().vecAt(key, CachePerfPrms.tab().vecAt(key, dfault));
        if (val.size() == 1) {
            String type = (String)val.elementAt(0);
            if (type.equalsIgnoreCase("task")) {
                return new Frequency(0, 0);
            }
            throw new HydraConfigException("Illegal value for " + CachePerfPrms.nameForKey(key) + ": " + val);
        }
        if (val.size() == 2) {
            int n;
            try {
                n = new Integer((String)val.elementAt(0));
            }
            catch (NumberFormatException e) {
                throw new HydraConfigException("Illegal value for " + CachePerfPrms.nameForKey(key) + ": " + val, e);
            }
            if (n < 0) {
                throw new HydraConfigException("Illegal value for " + CachePerfPrms.nameForKey(key) + ": " + val);
            }
            String type = ((String)val.elementAt(1)).toLowerCase();
            if (type.equals("iterations")) {
                return new Frequency(1, n);
            }
            if (type.equals("seconds")) {
                return new Frequency(2, n);
            }
            throw new HydraConfigException("Illegal value for " + CachePerfPrms.nameForKey(key) + ": " + val);
        }
        throw new HydraConfigException("Illegal value for " + CachePerfPrms.nameForKey(key) + ": " + val);
    }

    public static int getPutPercentage() {
        Long key = putPercentage;
        int val = CachePerfPrms.tasktab().intAt(key, CachePerfPrms.tab().intAt(key, 50));
        if (val < 0 || val > 100) {
            throw new HydraConfigException("Illegal value for " + CachePerfPrms.nameForKey(key) + ": " + val);
        }
        return val;
    }

    public static int LRUEvictions() {
        return CachePerfPrms.tasktab().intAt(LRUEvictions, CachePerfPrms.tab().intAt(LRUEvictions, 0));
    }

    public static int LRUEvictionsMinWaitSec() {
        return CachePerfPrms.tasktab().intAt(LRUEvictionsMinWaitSec, CachePerfPrms.tab().intAt(LRUEvictionsMinWaitSec, 0));
    }

    public static int LRUEvictionsMaxWaitSec() {
        return CachePerfPrms.tasktab().intAt(LRUEvictionsMaxWaitSec, CachePerfPrms.tab().intAt(LRUEvictionsMaxWaitSec, 0));
    }

    public static int numDestroys() {
        return CachePerfPrms.tasktab().intAt(numDestroys, CachePerfPrms.tab().intAt(numDestroys, 0));
    }

    public static int numDestroysMinWaitSec() {
        return CachePerfPrms.tasktab().intAt(numDestroysMinWaitSec, CachePerfPrms.tab().intAt(numDestroysMinWaitSec, 0));
    }

    public static int numDestroysMaxWaitSec() {
        return CachePerfPrms.tasktab().intAt(numDestroysMaxWaitSec, CachePerfPrms.tab().intAt(numDestroysMaxWaitSec, 0));
    }

    public static int getNumUpdates() {
        Long key = numUpdates;
        return CachePerfPrms.tasktab().intAt(key, CachePerfPrms.tab().intAt(key, 1));
    }

    public static int recentKeysPercentage() {
        return CachePerfPrms.tasktab().intAt(recentKeysPercentage, CachePerfPrms.tab().intAt(recentKeysPercentage, 0));
    }

    public static int maxRecentKeys() {
        return CachePerfPrms.tasktab().intAt(maxRecentKeys, CachePerfPrms.tab().intAt(maxRecentKeys, 0));
    }

    public static int syncSleepMs() {
        return CachePerfPrms.tasktab().intAt(syncSleepMs, CachePerfPrms.tab().intAt(syncSleepMs, 0));
    }

    public static boolean useTransactions() {
        Long key = useTransactions;
        return CachePerfPrms.tasktab().booleanAt(key, CachePerfPrms.tab().booleanAt(key, false));
    }

    public static boolean allowConflicts() {
        Long key = allowConflicts;
        return CachePerfPrms.tasktab().booleanAt(key, CachePerfPrms.tab().booleanAt(key, false));
    }

    public static int getCommitPercentage() {
        Long key = commitPercentage;
        int val = CachePerfPrms.tasktab().intAt(key, CachePerfPrms.tab().intAt(key, 100));
        if (val < 0 || val > 100) {
            throw new HydraConfigException("Illegal value for " + CachePerfPrms.nameForKey(key) + ": " + val);
        }
        return val;
    }

    public static int getMaxExecutions() {
        Long key = maxExecutions;
        int val = CachePerfPrms.tasktab().intAt(key, CachePerfPrms.tab().intAt(key, 0));
        if (val < 0) {
            String s = "Illegal value for " + CachePerfPrms.nameForKey(key) + ": " + val;
            throw new HydraConfigException(s);
        }
        return val;
    }

    public static int getRestartWaitSec() {
        Long key = restartWaitSec;
        int val = CachePerfPrms.tasktab().intAt(key, CachePerfPrms.tab().intAt(key, 0));
        if (val < 0 && val != -1) {
            String s = "Illegal value for " + CachePerfPrms.nameForKey(key) + ": " + val;
            throw new HydraConfigException(s);
        }
        return val;
    }

    public static boolean useMeanKill() {
        Long key = useMeanKill;
        return CachePerfPrms.tasktab().booleanAt(key, CachePerfPrms.tab().booleanAt(key, false));
    }

    public static String getClientNameToBounce() {
        Long key = clientNameToBounce;
        return CachePerfPrms.tasktab().stringAt(key, CachePerfPrms.tab().stringAt(key, null));
    }

    public static boolean waitForRecovery() {
        Long key = waitForRecovery;
        return CachePerfPrms.tasktab().booleanAt(key, CachePerfPrms.tab().booleanAt(key, false));
    }

    public static boolean waitForTrimSignal() {
        Long key = waitForTrimSignal;
        return CachePerfPrms.tasktab().booleanAt(key, CachePerfPrms.tab().booleanAt(key, false));
    }

    public static boolean useShutDownAllMembers() {
        Long key = useShutDownAllMembers;
        return CachePerfPrms.tasktab().booleanAt(key, CachePerfPrms.tab().booleanAt(key, false));
    }

    public static String getQuery() {
        Long key = query;
        return CachePerfPrms.getPlusEqualsString(key);
    }

    public static String getQueryIndex() {
        Long key = queryIndex;
        return CachePerfPrms.getPlusEqualsString(key);
    }

    public static String getQueryFromClause() {
        Long key = queryFromClause;
        return CachePerfPrms.getPlusEqualsString(key);
    }

    private static String getPlusEqualsString(Long key) {
        HydraVector v = CachePerfPrms.tab().vecAt(key, null);
        if (v == null) {
            return null;
        }
        String s = "";
        Iterator i = v.iterator();
        while (i.hasNext()) {
            s = s + (String)i.next();
        }
        return s;
    }

    public static long getQueryRangeMin() {
        Long key = queryRangeMin;
        long val = CachePerfPrms.tasktab().longAt(key, CachePerfPrms.tab().longAt(key, 0L));
        if ((double)val < 0.0) {
            String s = "Illegal value for " + CachePerfPrms.nameForKey(key) + ": " + val;
            throw new HydraConfigException(s);
        }
        return val;
    }

    public static long getQueryRangeMax() {
        Long key = queryRangeMax;
        long val = CachePerfPrms.tasktab().longAt(key, CachePerfPrms.tab().longAt(key, 0L));
        if ((double)val < 0.0) {
            String s = "Illegal value for " + CachePerfPrms.nameForKey(key) + ": " + val;
            throw new HydraConfigException(s);
        }
        return val;
    }

    public static long getQueryRangeSize() {
        Long key = queryRangeSize;
        long val = CachePerfPrms.tasktab().longAt(key, CachePerfPrms.tab().longAt(key, 0L));
        if ((double)val < 0.0) {
            String s = "Illegal value for " + CachePerfPrms.nameForKey(key) + ": " + val;
            throw new HydraConfigException(s);
        }
        return val;
    }

    public static int getNumWanSites() {
        Long key = numWanSites;
        int val = CachePerfPrms.tasktab().intAt(key, CachePerfPrms.tab().intAt(key, 0));
        if (val < 0) {
            String s = "Illegal value for " + CachePerfPrms.nameForKey(key) + ": " + val;
            throw new HydraConfigException(s);
        }
        return val;
    }

    public static int getKeyPercentage() {
        Long key = keyPercentage;
        int val = CachePerfPrms.tasktab().intAt(key, CachePerfPrms.tab().intAt(key, 0));
        if ((double)val < 0.0) {
            String s = "Illegal value for " + CachePerfPrms.nameForKey(key) + ": " + val;
            throw new HydraConfigException(s);
        }
        return val;
    }

    public static int getOptimizationCount() {
        Long key = optimizationCount;
        int val = CachePerfPrms.tasktab().intAt(key, CachePerfPrms.tab().intAt(key, 1));
        if (val <= 0) {
            String s = "Illegal value for " + CachePerfPrms.nameForKey(key) + ": " + val;
            throw new HydraConfigException(s);
        }
        return val;
    }

    public static void main(String[] args) {
        CachePerfPrms.dumpKeys();
    }

    static {
        CachePerfPrms.setValues(CachePerfPrms.class);
    }

    public static class Frequency {
        public int type;
        public int frequency;

        public Frequency(int type, int frequency) {
            this.type = type;
            this.frequency = frequency;
        }
    }
}

