/*
 * Decompiled with CFR 0.152.
 */
package cacheperf;

import com.gemstone.gemfire.Statistics;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.internal.cache.DiskRegion;
import com.gemstone.gemfire.internal.cache.DiskRegionStats;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import distcache.DistCache;
import distcache.gemfire.GemFireCacheTestImpl;
import hydra.CacheHelper;
import java.util.Set;

public class CachePerfStatsVersion {
    private static void incLocalRecoveryTime(long amount, Statistics stats) {
        stats.incLong("localRecoveryTime", amount);
    }

    private static void incRemoteRecoveryTime(long amount, Statistics stats) {
        stats.incLong("remoteRecoveryTime", amount);
    }

    public static void endDiskRecovery(long elapsed, DistCache theCache, Statistics stats) {
        if (theCache instanceof GemFireCacheTestImpl) {
            Cache gfCache = CacheHelper.getCache();
            Set aSet = gfCache.rootRegions();
            for (Region aRegion : aSet) {
                DiskRegion dr = ((LocalRegion)aRegion).getDiskRegion();
                if (dr == null) continue;
                DiskRegionStats diskStats = dr.getStats();
                long localInit = diskStats.getLocalInitializations();
                long remoteInit = diskStats.getRemoteInitializations();
                if (localInit > 0L) {
                    CachePerfStatsVersion.incLocalRecoveryTime(elapsed, stats);
                }
                if (remoteInit <= 0L) continue;
                CachePerfStatsVersion.incRemoteRecoveryTime(elapsed, stats);
            }
        }
    }
}

